/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor.leRobot;

import com.jerolba.carpet.CarpetWriter;
import com.jerolba.carpet.ColumnNamingStrategy;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.logProcessor.leRobot.LeRobotDatasetEpisodeStatistics;
import us.ihmc.avatar.logProcessor.leRobot.LeRobotEpisodeRecord;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.euclid.YoPose3D;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class LeRobotDatasetDataWriter {
    private final List<LeRobotEpisodeRecord> records = new ArrayList<LeRobotEpisodeRecord>();
    private final SideDependentList<EndEffectorVariables> endEffectorVariables = new SideDependentList();
    private final long episodeIndex;
    private final long datasetLengthSoFar;

    public LeRobotDatasetDataWriter(long episodeIndex, long datasetLengthSoFar, YoRegistry yoRegistry) {
        this.episodeIndex = episodeIndex;
        this.datasetLengthSoFar = datasetLengthSoFar;
        for (RobotSide side : RobotSide.values) {
            this.endEffectorVariables.put((Enum)side, (Object)new EndEffectorVariables(LeRobotDatasetDataWriter.findYoPose(side, "Current", yoRegistry), LeRobotDatasetDataWriter.findYoPose(side, "Desired", yoRegistry)));
        }
    }

    public static YoPose3D findYoPose(RobotSide side, String qualifier, YoRegistry yoRegistry) {
        String highLevelController = "root.main.DRCControllerThread.DRCMomentumBasedController.HumanoidHighLevelControllerManager.";
        String wbcc = highLevelController + "HighLevelHumanoidControllerFactory.WholeBodyControllerCoreFactory.WholeBodyControllerCore.";
        String feedbackController = wbcc + "WholeBodyFeedbackController.FeedbackControllerToolbox.";
        YoVariable yoVariable = yoRegistry.findVariable("%s%s_GRIPPER_YAW_LINK%sPositionX".formatted(feedbackController, side.name(), qualifier));
        if (yoVariable instanceof YoDouble) {
            YoDouble xVariable = (YoDouble)yoVariable;
            yoVariable = yoRegistry.findVariable("%s%s_GRIPPER_YAW_LINK%sPositionY".formatted(feedbackController, side.name(), qualifier));
            if (yoVariable instanceof YoDouble) {
                YoDouble yVariable = (YoDouble)yoVariable;
                yoVariable = yoRegistry.findVariable("%s%s_GRIPPER_YAW_LINK%sPositionZ".formatted(feedbackController, side.name(), qualifier));
                if (yoVariable instanceof YoDouble) {
                    YoDouble zVariable = (YoDouble)yoVariable;
                    yoVariable = yoRegistry.findVariable("%s%s_GRIPPER_YAW_LINK%sOrientationQx".formatted(feedbackController, side.name(), qualifier));
                    if (yoVariable instanceof YoDouble) {
                        YoDouble qxVariable = (YoDouble)yoVariable;
                        yoVariable = yoRegistry.findVariable("%s%s_GRIPPER_YAW_LINK%sOrientationQy".formatted(feedbackController, side.name(), qualifier));
                        if (yoVariable instanceof YoDouble) {
                            YoDouble qyVariable = (YoDouble)yoVariable;
                            yoVariable = yoRegistry.findVariable("%s%s_GRIPPER_YAW_LINK%sOrientationQz".formatted(feedbackController, side.name(), qualifier));
                            if (yoVariable instanceof YoDouble) {
                                YoDouble qzVariable = (YoDouble)yoVariable;
                                yoVariable = yoRegistry.findVariable("%s%s_GRIPPER_YAW_LINK%sOrientationQs".formatted(feedbackController, side.name(), qualifier));
                                if (yoVariable instanceof YoDouble) {
                                    YoDouble qsVariable = (YoDouble)yoVariable;
                                    return new YoPose3D(new YoPoint3D(xVariable, yVariable, zVariable), new YoQuaternion(qxVariable, qyVariable, qzVariable, qsVariable));
                                }
                            }
                        }
                    }
                }
            }
        }
        LogTools.error((String)"Could not find YoPose3D");
        return null;
    }

    public LeRobotEpisodeRecord addFrame(long timestampMicros, long frameIndex, LeRobotDatasetEpisodeStatistics statistics, int ihmcLogPosition) {
        ArrayList<Float> state = new ArrayList<Float>();
        ArrayList<Float> action = new ArrayList<Float>();
        for (RobotSide side : RobotSide.values) {
            state.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).current().getPosition().getX32()));
            state.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).current().getPosition().getY32()));
            state.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).current().getPosition().getZ32()));
            state.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).current().getOrientation().getX32()));
            state.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).current().getOrientation().getY32()));
            state.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).current().getOrientation().getZ32()));
            state.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).current().getOrientation().getS32()));
            action.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).desired().getPosition().getX32()));
            action.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).desired().getPosition().getY32()));
            action.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).desired().getPosition().getZ32()));
            action.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).desired().getOrientation().getX32()));
            action.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).desired().getOrientation().getY32()));
            action.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).desired().getOrientation().getZ32()));
            action.add(Float.valueOf(((EndEffectorVariables)this.endEffectorVariables.get((Enum)side)).desired().getOrientation().getS32()));
        }
        float timestamp = (float)timestampMicros / 1000000.0f;
        int taskIndex = 0;
        boolean isLastFrame = false;
        LeRobotEpisodeRecord record = new LeRobotEpisodeRecord(state, action, this.episodeIndex, frameIndex, timestamp, ihmcLogPosition, isLastFrame, this.datasetLengthSoFar + frameIndex, taskIndex);
        statistics.processParquetRecord(record);
        this.records.add(record);
        return record;
    }

    public void writeFile(Path parquetPath) {
        LeRobotEpisodeRecord last = this.records.get(this.records.size() - 1);
        this.records.set(this.records.size() - 1, new LeRobotEpisodeRecord(last.state(), last.action(), last.episodeIndex(), last.frameIndex(), last.timestamp(), last.ihmcLogPosition(), true, last.index(), last.taskIndex()));
        LeRobotDatasetDataWriter.writeParquetFile(parquetPath, this.records);
    }

    public static void writeParquetFile(Path parquetPath, List<LeRobotEpisodeRecord> records) {
        try {
            OutputStream outputStream = Files.newOutputStream(parquetPath, new OpenOption[0]);
            CarpetWriter writer = new CarpetWriter.Builder(outputStream, LeRobotEpisodeRecord.class).withColumnNamingStrategy(ColumnNamingStrategy.SNAKE_CASE).build();
            for (LeRobotEpisodeRecord record : records) {
                writer.write((Object)record);
            }
            writer.close();
            outputStream.close();
        }
        catch (Exception e) {
            LogTools.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    record EndEffectorVariables(YoPose3D current, YoPose3D desired) {
    }
}

