/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor.diagnostic;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.logProcessor.LogDataProcessorFunction;
import us.ihmc.avatar.logProcessor.LogDataProcessorHelper;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.diagnostic.DelayEstimatorBetweenTwoSignals;
import us.ihmc.sensorProcessing.diagnostic.DiagnosticUpdatable;
import us.ihmc.sensorProcessing.diagnostic.OneDoFJointFourierAnalysis;
import us.ihmc.sensorProcessing.diagnostic.OrientationAngularVelocityConsistencyChecker;
import us.ihmc.sensorProcessing.diagnostic.PositionVelocity1DConsistencyChecker;
import us.ihmc.sensorProcessing.diagnostic.PositionVelocity3DConsistencyChecker;
import us.ihmc.wholeBodyController.diagnostics.DiagnosticParameters;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.variable.YoDouble;

public class DiagnosticAnalysisProcessor
implements LogDataProcessorFunction {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final LogDataProcessorHelper logDataProcessorHelper;
    private final List<DiagnosticUpdatable> diagnosticUpdatables = new ArrayList<DiagnosticUpdatable>();
    private final FullHumanoidRobotModel fullRobotModel;
    private final YoVariableHolder logYoVariableHolder;
    private final double dt;
    private DiagnosticParameters diagnosticParameters;
    private boolean firstTick = true;

    public DiagnosticAnalysisProcessor(LogDataProcessorHelper logDataProcessorHelper, DRCRobotModel drcRobotModel) {
        this.logDataProcessorHelper = logDataProcessorHelper;
        this.diagnosticParameters = drcRobotModel.getDiagnoticParameters();
        this.fullRobotModel = logDataProcessorHelper.getFullRobotModel();
        this.dt = drcRobotModel.getEstimatorDT();
        this.logYoVariableHolder = logDataProcessorHelper.getLogYoVariableHolder();
    }

    public void addJointFourierAnalyses(String qd_prefix, String qd_suffix, String tau_prefix, String tau_suffix, String tau_d_prefix, String tau_d_suffix) {
        OneDoFJointBasics[] oneDoFJoints = this.fullRobotModel.getOneDoFJoints();
        double fftObservationWindow = this.diagnosticParameters.getFFTObservationWindow();
        for (OneDoFJointBasics joint : oneDoFJoints) {
            String jointName = joint.getName();
            YoDouble qd = (YoDouble)this.logYoVariableHolder.findVariable(qd_prefix + jointName + qd_suffix);
            YoDouble tau = (YoDouble)this.logYoVariableHolder.findVariable(tau_prefix + jointName + tau_suffix);
            YoDouble tau_d = (YoDouble)this.logYoVariableHolder.findVariable(tau_d_prefix + jointName + tau_d_suffix);
            if (qd == null) {
                System.err.println("Could not find the find the velocity variable for the joint: " + jointName);
                continue;
            }
            if (tau == null) {
                System.err.println("Could not find the find the tau variable for the joint: " + jointName);
                continue;
            }
            if (tau_d == null) {
                System.err.println("Could not find the find the tau desired variable for the joint: " + jointName);
                continue;
            }
            OneDoFJointFourierAnalysis online1dSignalFrequencyAnalysis = new OneDoFJointFourierAnalysis(joint, fftObservationWindow, this.dt, qd, tau, tau_d, this.registry);
            this.diagnosticUpdatables.add((DiagnosticUpdatable)online1dSignalFrequencyAnalysis);
        }
    }

    public void addJointConsistencyCheckers() {
        OneDoFJointBasics[] oneDoFJoints;
        for (OneDoFJointBasics joint : oneDoFJoints = this.fullRobotModel.getOneDoFJoints()) {
            String jointName = joint.getName();
            YoDouble rawJointPosition = (YoDouble)this.logYoVariableHolder.findVariable("raw_q_" + jointName);
            YoDouble rawJointVelocity = (YoDouble)this.logYoVariableHolder.findVariable("raw_qd_" + jointName);
            YoDouble processedJointPosition = (YoDouble)this.logYoVariableHolder.findVariable("q_" + jointName);
            YoDouble processedJointVelocity = (YoDouble)this.logYoVariableHolder.findVariable("qd_" + jointName);
            if (rawJointPosition == null) {
                System.err.println("Could not find the find the raw position variable for the joint: " + jointName);
                continue;
            }
            if (rawJointVelocity == null) {
                System.err.println("Could not find the find the raw velocity variable for the joint: " + jointName);
                continue;
            }
            if (processedJointPosition == null) {
                System.err.println("Could not find the find the processed position variable for the joint: " + jointName);
                continue;
            }
            if (processedJointVelocity == null) {
                System.err.println("Could not find the find the processed velocity variable for the joint: " + jointName);
                continue;
            }
            this.diagnosticUpdatables.add((DiagnosticUpdatable)new PositionVelocity1DConsistencyChecker(jointName, rawJointPosition, rawJointVelocity, processedJointPosition, processedJointVelocity, this.dt, this.registry));
        }
    }

    public void addIMUConsistencyCheckers(String q_prefix, String q_suffix, String qd_prefix, String qd_suffix, boolean performAnalysisInBodyFrame) {
        IMUDefinition[] imuDefinitions;
        for (IMUDefinition imuDefinition : imuDefinitions = this.fullRobotModel.getIMUDefinitions()) {
            String imuName = imuDefinition.getName();
            MovingReferenceFrame bodyFrame = imuDefinition.getRigidBody().getBodyFixedFrame();
            ReferenceFrame imuFrame = imuDefinition.getIMUFrame();
            YoFrameQuaternion q = this.logDataProcessorHelper.findYoFrameQuaternion(q_prefix, imuName + q_suffix, ReferenceFrame.getWorldFrame());
            YoFrameVector3D qd = this.logDataProcessorHelper.findYoFrameVector(qd_prefix, imuName + qd_suffix, imuFrame);
            if (q == null) {
                System.err.println("Could not find the find the position variable for the IMU: " + imuName);
                continue;
            }
            if (qd == null) {
                System.err.println("Could not find the find the velocity variable for the IMU: " + imuName);
                continue;
            }
            MovingReferenceFrame referenceFrameUsedForComparison = performAnalysisInBodyFrame ? bodyFrame : imuFrame;
            this.diagnosticUpdatables.add((DiagnosticUpdatable)new OrientationAngularVelocityConsistencyChecker(imuName, q, qd, (ReferenceFrame)referenceFrameUsedForComparison, this.dt, this.registry));
        }
    }

    public void addForceTrackingDelayEstimators(String tau_prefix, String tau_suffix, String tau_d_prefix, String tau_d_suffix) {
        OneDoFJointBasics[] oneDoFJoints;
        for (OneDoFJointBasics joint : oneDoFJoints = this.fullRobotModel.getOneDoFJoints()) {
            String jointName = joint.getName();
            YoDouble tau = (YoDouble)this.logYoVariableHolder.findVariable(tau_prefix + jointName + tau_suffix);
            YoDouble tau_d = (YoDouble)this.logYoVariableHolder.findVariable(tau_d_prefix + jointName + tau_d_suffix);
            if (tau == null) {
                System.err.println("Could not find the find the tau variable for the joint: " + jointName);
                continue;
            }
            if (tau_d == null) {
                System.err.println("Could not find the find the tau desired variable for the joint: " + jointName);
                continue;
            }
            this.diagnosticUpdatables.add((DiagnosticUpdatable)new DelayEstimatorBetweenTwoSignals(jointName + "ForceTracking", tau_d, tau, this.dt, this.registry));
        }
    }

    public void addCenterOfMassConsistencyChecker() {
        YoFramePoint3D com = this.logDataProcessorHelper.findYoFramePoint("estimatedCenterOfMassPosition", ReferenceFrame.getWorldFrame());
        YoFrameVector3D comVelocity = this.logDataProcessorHelper.findYoFrameVector("estimatedCenterOfMassVelocity", ReferenceFrame.getWorldFrame());
        if (com == null) {
            System.err.println("Could not find the YoFramePoint for the center of mass position");
            return;
        }
        if (comVelocity == null) {
            System.err.println("Could not find the YoFrameVector for the center of mass velocity");
            return;
        }
        this.diagnosticUpdatables.add((DiagnosticUpdatable)new PositionVelocity3DConsistencyChecker("centerOfMass", com, comVelocity, this.dt, this.registry));
    }

    @Override
    public void processDataAtControllerRate() {
    }

    @Override
    public void processDataAtStateEstimatorRate() {
        if (this.firstTick) {
            for (DiagnosticUpdatable diagnosticUpdatable : this.diagnosticUpdatables) {
                diagnosticUpdatable.enable();
            }
            this.firstTick = false;
        }
        this.logDataProcessorHelper.update();
        for (DiagnosticUpdatable diagnosticUpdatable : this.diagnosticUpdatables) {
            diagnosticUpdatable.update();
        }
    }

    @Override
    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    @Override
    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return null;
    }
}

