/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import us.ihmc.avatar.logProcessor.SCS2LogFootstep;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.variable.YoInteger;

public class SCS2LogWalk {
    private long walkStartTick = -1L;
    private final Point2D walkStart = new Point2D();
    private final ArrayList<ICPErrorEntry> icpErrors = new ArrayList();
    private final ArrayList<SCS2LogFootstep> footsteps = new ArrayList();
    private final SideDependentList<ArrayList<FootStateChange>> footStateChanges = new SideDependentList(new ArrayList(), new ArrayList());
    private final SideDependentList<ArrayList<FootSwing>> footSwings = new SideDependentList(new ArrayList(), new ArrayList());
    private final ArrayList<DoubleSupportDuration> doubleSupportDurations = new ArrayList();
    private final TDoubleArrayList times = new TDoubleArrayList();
    private final RecyclingArrayList<Pose3D> pelvisPoses = new RecyclingArrayList(Pose3D::new);
    private final SideDependentList<RecyclingArrayList<Pose3D>> handPoses = new SideDependentList((Object)new RecyclingArrayList(Pose3D::new), (Object)new RecyclingArrayList(Pose3D::new));
    private final RecyclingArrayList<Point2D> coms = new RecyclingArrayList(Point2D::new);
    private final RecyclingArrayList<Point2D> icps = new RecyclingArrayList(Point2D::new);
    private boolean endedWithFall = false;
    private int initialWorkingCounterMismatch = -1;
    private int workingCounterMismatch = 0;

    public void update(double currentTime, long tick, YoInteger yoWorkingCounterMismatch) {
        if (this.initialWorkingCounterMismatch < 0) {
            this.initialWorkingCounterMismatch = yoWorkingCounterMismatch.getIntegerValue();
        }
        this.workingCounterMismatch = yoWorkingCounterMismatch.getIntegerValue() - this.initialWorkingCounterMismatch;
    }

    public void setWalkStartTick(long walkStartTick) {
        this.walkStartTick = walkStartTick;
    }

    public long getWalkStartTick() {
        return this.walkStartTick;
    }

    public Point2D getWalkStart() {
        return this.walkStart;
    }

    public ArrayList<ICPErrorEntry> getICPErrors() {
        return this.icpErrors;
    }

    public ArrayList<SCS2LogFootstep> getFootsteps() {
        return this.footsteps;
    }

    public SideDependentList<ArrayList<FootStateChange>> getFootStateChanges() {
        return this.footStateChanges;
    }

    public SideDependentList<ArrayList<FootSwing>> getFootSwings() {
        return this.footSwings;
    }

    public ArrayList<DoubleSupportDuration> getDoubleSupportDurations() {
        return this.doubleSupportDurations;
    }

    public boolean isEndedWithFall() {
        return this.endedWithFall;
    }

    public void setEndedWithFall(boolean endedWithFall) {
        this.endedWithFall = endedWithFall;
    }

    public TDoubleArrayList getTimes() {
        return this.times;
    }

    public RecyclingArrayList<Pose3D> getPelvisPoses() {
        return this.pelvisPoses;
    }

    public SideDependentList<RecyclingArrayList<Pose3D>> getHandPoses() {
        return this.handPoses;
    }

    public RecyclingArrayList<Point2D> getComs() {
        return this.coms;
    }

    public RecyclingArrayList<Point2D> getIcps() {
        return this.icps;
    }

    public int getInitialWorkingCounterMismatch() {
        return this.initialWorkingCounterMismatch;
    }

    public record DoubleSupportDuration(double completeTime, double supportDuration, double desiredTransferDuration) {
    }

    public record FootSwing(double completeTime, double swingDuration, double desiredSwingDuration) {
    }

    public record FootStateChange(double time, FootControlModule.ConstraintType state) {
    }

    public record ICPErrorEntry(double time, Vector2D icpError) {
    }
}

