/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Consumer;
import us.ihmc.avatar.logProcessor.SCS2LogFootstep;
import us.ihmc.avatar.logProcessor.SCS2LogLocomotionData;
import us.ihmc.avatar.logProcessor.SCS2LogOverheadSVGPlot;
import us.ihmc.avatar.logProcessor.SCS2LogWalk;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.scs2.session.log.LogSession;
import us.ihmc.tools.io.JSONFileTools;

public class SCS2LogProcessor {
    private Path logPath;
    private Path jsonPath;
    private int numberOfEntries = -1;
    private int currentLogPosition;
    private boolean processingLog = false;
    private boolean requestStopProcessing = false;
    private SCS2LogLocomotionData locomotionData;
    private int numberOfWalksStat = -1;
    private int numberOfFallsStat = -1;
    private int numberOfFootstepsStat = -1;
    private int numberOfComsStat = -1;
    private int workingCounterMismatchStat = -1;

    public SCS2LogProcessor() {
        this(System.getProperty("log.path") == null ? null : Paths.get(System.getProperty("log.path"), new String[0]));
        if (this.logPath == null) {
            LogTools.error((String)"Must pass -Dlog.path=/path/to/log");
        }
    }

    public SCS2LogProcessor(Path logPath) {
        this.logPath = logPath;
        if (logPath == null || !Files.exists(logPath, new LinkOption[0]) || !Files.exists(logPath.resolve("robotData.log"), new LinkOption[0])) {
            LogTools.error((String)"Log path not valid: %s".formatted(logPath));
            this.logPath = null;
            return;
        }
        this.jsonPath = logPath.resolve("statistics.json");
        this.loadStats();
    }

    private void runLogSession(Consumer<LogSession> logSessionConsumer) {
        this.processingLog = true;
        try {
            LogSession logSession = new LogSession(this.logPath.toFile(), null);
            logSession.startSessionThread();
            ThreadTools.park((double)0.1);
            this.numberOfEntries = logSession.getLogDataReader().getNumberOfEntries();
            LogTools.info((String)"numberOfEntries: %d".formatted(this.numberOfEntries));
            logSessionConsumer.accept(logSession);
            ThreadTools.park((double)0.1);
            logSession.stopSessionThread();
            logSession.shutdownSession();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.processingLog = false;
        }
    }

    public void processLogAsync() {
        this.processLogAsync(this::processLog);
    }

    public void gatherStatsAsync() {
        this.processLogAsync(logSession -> this.writeJSON(true));
    }

    public void processLogAsync(Consumer<LogSession> logSessionConsumer) {
        ThreadTools.startAsDaemon(() -> this.runLogSession(logSessionConsumer), (String)"SCS2LogDataProcessorThread");
    }

    private void processLog(LogSession logSession) {
        this.locomotionData = new SCS2LogLocomotionData();
        this.locomotionData.setup(logSession);
        this.requestStopProcessing = false;
        for (int i = 0; i < this.numberOfEntries && !this.requestStopProcessing; ++i) {
            this.currentLogPosition = logSession.getLogDataReader().getCurrentLogPosition();
            logSession.runTick();
        }
        this.locomotionData.requestStopProcessing();
        if (!this.requestStopProcessing) {
            this.writeJSON(false);
            this.loadStats();
            new SCS2LogOverheadSVGPlot(this.logPath, this.locomotionData).drawSVG();
            String logFolderName = this.logPath.getFileName().toString();
            boolean rightPullLever = logFolderName.contains("RightPullLever");
            boolean leftPushBar = logFolderName.contains("LeftPushBar");
            boolean rightPushKnob = logFolderName.contains("RightPushKnob");
            boolean rightPullHandle = logFolderName.contains("RightPullHandle");
            boolean leftPushBarDisturbed = logFolderName.contains("LeftPushBarDisturbed");
            if (rightPullLever || leftPushBar || rightPushKnob || rightPullHandle || leftPushBarDisturbed) {
                SCS2LogFootstep closestStepToDoorFrame = null;
                double heelToFrame = Double.NaN;
                SCS2LogWalk firstWalk = this.locomotionData.getLogWalks().get(0);
                if (rightPullLever) {
                    closestStepToDoorFrame = firstWalk.getFootsteps().get(11);
                    heelToFrame = 0.194;
                } else if (leftPushBar) {
                    closestStepToDoorFrame = firstWalk.getFootsteps().get(8);
                    heelToFrame = -0.038;
                } else if (rightPushKnob) {
                    closestStepToDoorFrame = firstWalk.getFootsteps().get(5);
                    heelToFrame = 0.0;
                } else if (rightPullHandle) {
                    closestStepToDoorFrame = firstWalk.getFootsteps().get(11);
                    heelToFrame = 0.123;
                } else if (leftPushBarDisturbed) {
                    closestStepToDoorFrame = firstWalk.getFootsteps().get(8);
                    heelToFrame = -0.038;
                }
                double[] polygon = closestStepToDoorFrame.getPolygon();
                Point2D pointA = new Point2D(polygon[0], polygon[4]);
                Point2D pointB = new Point2D(polygon[1], polygon[5]);
                Point2D pointC = new Point2D(polygon[2], polygon[6]);
                Point2D pointD = new Point2D(polygon[3], polygon[7]);
                Point2D midAB = new Point2D((Tuple2DReadOnly)pointA);
                midAB.add((Tuple2DReadOnly)pointB);
                midAB.scale(0.5);
                Point2D midCD = new Point2D((Tuple2DReadOnly)pointC);
                midCD.add((Tuple2DReadOnly)pointD);
                midCD.scale(0.5);
                double distanceAB = pointA.distance((Point2DReadOnly)pointB);
                double distanceCD = pointC.distance((Point2DReadOnly)pointD);
                boolean toeAB = distanceAB < distanceCD;
                Point2D frontMid = toeAB ? midAB : midCD;
                Point2D backMid = toeAB ? midCD : midAB;
                double toeWidth = toeAB ? distanceAB : distanceCD;
                double heelWidth = toeAB ? distanceCD : distanceAB;
                LogTools.info((String)"Toe width: {}", (Object)toeWidth);
                LogTools.info((String)"Heel width: {}", (Object)heelWidth);
                LogTools.info((String)"Foot length {}", (Object)frontMid.distance((Point2DReadOnly)backMid));
                Vector2D backToFront = new Vector2D();
                backToFront.sub((Tuple2DReadOnly)frontMid, (Tuple2DReadOnly)backMid);
                Vector3D backToFront3D = new Vector3D(backToFront.getX(), backToFront.getY(), 0.0);
                RotationMatrix footOrientation = new RotationMatrix();
                EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.X, (Vector3DReadOnly)backToFront3D, (Orientation3DBasics)footOrientation);
                LogTools.info((String)"Foot yaw: {}", (Object)Math.toDegrees(footOrientation.getYaw()));
                Point3D heelPosition = new Point3D(backMid.getX(), backMid.getY(), 0.0);
                ReferenceFrame heelFrame = ReferenceFrameMissingTools.constructFrameWithUnchangingTransformToParent((ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)footOrientation, (Tuple3DReadOnly)heelPosition));
                this.writeCSV(logFolderName, "FootstepTimes", "Index,Time", writer -> {
                    for (SCS2LogWalk logWalk : this.locomotionData.getLogWalks()) {
                        for (int i = 0; i < logWalk.getFootsteps().size(); ++i) {
                            writer.write("%d,%f".formatted(i, logWalk.getFootsteps().get(i).getTime()));
                            writer.newLine();
                        }
                    }
                });
                this.writeCSV(logFolderName, "FootstepStateTimings", "Side,State,Time", writer -> {
                    for (SCS2LogWalk logWalk : this.locomotionData.getLogWalks()) {
                        for (RobotSide side : logWalk.getFootStateChanges().sides()) {
                            ArrayList footStateChanges = (ArrayList)logWalk.getFootStateChanges().get((Enum)side);
                            for (SCS2LogWalk.FootStateChange footStateChange : footStateChanges) {
                                writer.write("%s,%.5f,%d,%s".formatted(side.getLowerCaseName(), footStateChange.time(), footStateChange.state().ordinal(), footStateChange.state().name()));
                                writer.newLine();
                            }
                        }
                    }
                });
                this.writeCSV(logFolderName, "FootstepSwings", "CompletionTime,Duration,Desired", writer -> {
                    for (SCS2LogWalk logWalk : this.locomotionData.getLogWalks()) {
                        ArrayList<SCS2LogWalk.FootSwing> timeSorted = new ArrayList<SCS2LogWalk.FootSwing>();
                        for (RobotSide side : logWalk.getFootSwings().sides()) {
                            timeSorted.addAll((Collection)logWalk.getFootSwings().get((Enum)side));
                        }
                        timeSorted.sort(Comparator.comparingDouble(SCS2LogWalk.FootSwing::completeTime));
                        for (SCS2LogWalk.FootSwing footSwing : timeSorted) {
                            writer.write("%.5f,%.5f,%.5f".formatted(footSwing.completeTime(), footSwing.swingDuration(), footSwing.desiredSwingDuration()));
                            writer.newLine();
                        }
                    }
                });
                this.writeCSV(logFolderName, "DoubleSupportDurations", "CompletionTime,Duration,Desired", writer -> {
                    for (SCS2LogWalk logWalk : this.locomotionData.getLogWalks()) {
                        for (SCS2LogWalk.DoubleSupportDuration doubleSupportDuration : logWalk.getDoubleSupportDurations()) {
                            writer.write("%.5f,%.5f,%.5f".formatted(doubleSupportDuration.completeTime(), doubleSupportDuration.supportDuration(), doubleSupportDuration.desiredTransferDuration()));
                            writer.newLine();
                        }
                    }
                });
                this.writeCSV(logFolderName, "ICPError", "Time,ErrorX,ErrorY", writer -> {
                    for (SCS2LogWalk logWalk : this.locomotionData.getLogWalks()) {
                        for (SCS2LogWalk.ICPErrorEntry icpError : logWalk.getICPErrors()) {
                            writer.write("%.5f,%.5f,%.5f".formatted(icpError.time(), icpError.icpError().getX(), icpError.icpError().getY()));
                            writer.newLine();
                        }
                    }
                });
                for (RobotSide side : this.locomotionData.getHandFrames().sides()) {
                    try (BufferedWriter writer2 = Files.newBufferedWriter(this.logPath.resolve("%s_%sArmPoses.csv".formatted(logFolderName, side.getPascalCaseName())), new OpenOption[0]);){
                        writer2.write("Time,X,Y,Z,Yaw,Pitch,Roll");
                        writer2.newLine();
                        for (SCS2LogWalk logWalk : this.locomotionData.getLogWalks()) {
                            for (int i = 0; i < logWalk.getTimes().size(); ++i) {
                                writer2.write("%f,%f,%f,%f,%f,%f,%f".formatted(logWalk.getTimes().get(i), ((Pose3D)((RecyclingArrayList)logWalk.getHandPoses().get((Enum)side)).get(i)).getX(), ((Pose3D)((RecyclingArrayList)logWalk.getHandPoses().get((Enum)side)).get(i)).getY(), ((Pose3D)((RecyclingArrayList)logWalk.getHandPoses().get((Enum)side)).get(i)).getZ(), ((Pose3D)((RecyclingArrayList)logWalk.getHandPoses().get((Enum)side)).get(i)).getYaw(), ((Pose3D)((RecyclingArrayList)logWalk.getHandPoses().get((Enum)side)).get(i)).getPitch(), ((Pose3D)((RecyclingArrayList)logWalk.getHandPoses().get((Enum)side)).get(i)).getRoll()));
                                writer2.newLine();
                            }
                        }
                    }
                    catch (IOException e) {
                        LogTools.error((String)"Failed to write to CSV file.", (Object)e);
                    }
                }
                try (BufferedWriter writer3 = Files.newBufferedWriter(this.logPath.resolve(logFolderName + "_PelvisDoorProgress.csv"), new OpenOption[0]);){
                    writer3.write("Time,X");
                    writer3.newLine();
                    for (SCS2LogWalk logWalk : this.locomotionData.getLogWalks()) {
                        for (int i = 0; i < logWalk.getTimes().size(); ++i) {
                            FramePoint3D pelvisPose = new FramePoint3D(ReferenceFrame.getWorldFrame(), ((Pose3D)logWalk.getPelvisPoses().get(i)).getX(), ((Pose3D)logWalk.getPelvisPoses().get(i)).getY(), 0.0);
                            pelvisPose.changeFrame(heelFrame);
                            pelvisPose.addX(heelToFrame);
                            writer3.write("%s,%s".formatted(logWalk.getTimes().get(i), pelvisPose.getX()));
                            writer3.newLine();
                        }
                    }
                }
                catch (IOException e) {
                    LogTools.error((String)"Failed to write to CSV file.", (Object)e);
                }
            }
        }
        this.locomotionData = null;
    }

    private void writeCSV(String logFolderName, String fileName, String header, WriteFunction writeFunction) {
        try (BufferedWriter writer = Files.newBufferedWriter(this.logPath.resolve("%s_%s.csv".formatted(logFolderName, fileName)), new OpenOption[0]);){
            writer.write(header);
            writer.newLine();
            writeFunction.accept(writer);
        }
        catch (IOException e) {
            LogTools.error((String)"Failed to write to CSV file.", (Object)e);
        }
    }

    private void writeJSON(boolean numEntriesOnly) {
        LogTools.info((String)"Saving JSON to {}", (Object)this.jsonPath);
        JSONFileTools.save((Path)this.jsonPath, rootNode -> {
            rootNode.put("numberOfEntries", this.numberOfEntries);
            if (!numEntriesOnly) {
                this.locomotionData.writeJSON((ObjectNode)rootNode);
            }
        });
    }

    private void loadStats() {
        LogTools.info((String)"Loading JSON stats from {}", (Object)this.jsonPath);
        if (Files.exists(this.jsonPath, new LinkOption[0])) {
            JSONFileTools.load((Path)this.jsonPath, rootNode -> {
                this.numberOfEntries = rootNode.get("numberOfEntries").intValue();
                if (rootNode.has("numberOfWalks")) {
                    this.numberOfWalksStat = rootNode.get("numberOfWalks").intValue();
                }
                if (rootNode.has("numberOfFalls")) {
                    this.numberOfFallsStat = rootNode.get("numberOfFalls").intValue();
                }
                if (rootNode.has("numberOfFootsteps")) {
                    this.numberOfFootstepsStat = rootNode.get("numberOfFootsteps").intValue();
                }
                if (rootNode.has("numberOfComs")) {
                    this.numberOfComsStat = rootNode.get("numberOfComs").intValue();
                }
                if (rootNode.has("workingCounterMismatch")) {
                    this.workingCounterMismatchStat = rootNode.get("workingCounterMismatch").intValue();
                }
            });
        }
    }

    public void stopProcessing() {
        this.requestStopProcessing = true;
    }

    public int getLogCurrentTick() {
        return this.currentLogPosition;
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public boolean isLogValid() {
        return this.logPath != null;
    }

    public boolean isProcessingLog() {
        return this.processingLog;
    }

    public int getNumberOfWalksStat() {
        return this.locomotionData == null ? this.numberOfWalksStat : this.locomotionData.getLogWalks().size();
    }

    public int getNumberOfFallsStat() {
        return this.locomotionData == null ? this.numberOfFallsStat : this.locomotionData.getFalls();
    }

    public int getNumberOfFootstepsStat() {
        if (this.locomotionData == null) {
            return this.numberOfFootstepsStat;
        }
        return this.locomotionData.getNumberOfFootsteps();
    }

    public int getNumberOfComsStat() {
        return this.locomotionData == null ? this.numberOfComsStat : this.locomotionData.getNumberOfComs();
    }

    public int getWorkingCounterMismatchStat() {
        return this.locomotionData == null ? this.workingCounterMismatchStat : this.locomotionData.getWorkingCounterMismatch();
    }

    public static void main(String[] args) {
        SCS2LogProcessor logDataProcessor = new SCS2LogProcessor();
        logDataProcessor.runLogSession(logDataProcessor::processLog);
    }

    private static interface WriteFunction {
        public void accept(BufferedWriter var1) throws IOException;
    }
}

