/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.jfree.svg.SVGGraphics2D;
import org.jfree.svg.SVGHints;
import org.jfree.svg.SVGUnits;
import us.ihmc.avatar.logProcessor.SCS2LogFootstep;
import us.ihmc.avatar.logProcessor.SCS2LogLocomotionData;
import us.ihmc.avatar.logProcessor.SCS2LogWalk;
import us.ihmc.commonWalkingControlModules.desiredFootStep.FootstepListVisualizer;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.log.LogTools;

public class SCS2LogOverheadSVGPlot {
    private static final double DOCUMENT_SIZE = Double.parseDouble(System.getProperty("document.size", "15.0"));
    private final SCS2LogLocomotionData locomotionData;
    private final Path svgPath;
    private SVGGraphics2D svgGraphics2D;

    public SCS2LogOverheadSVGPlot(Path logPath, SCS2LogLocomotionData locomotionData) {
        this.locomotionData = locomotionData;
        this.svgPath = logPath.resolve(logPath.getFileName().toString() + "_OverheadPlot.svg");
    }

    public void drawSVG() {
        double documentSizeMillimeters = this.convertToMillimeters(DOCUMENT_SIZE);
        this.svgGraphics2D = new SVGGraphics2D(documentSizeMillimeters, documentSizeMillimeters, SVGUnits.MM);
        this.svgGraphics2D.setFontSizeUnits(SVGUnits.MM);
        this.svgGraphics2D.setRenderingHint((RenderingHints.Key)SVGHints.KEY_BEGIN_GROUP, (Object)"Legend");
        Point2D legendOrigin = new Point2D((Tuple2DReadOnly)this.locomotionData.getRobotStartLocation());
        legendOrigin.add(2.0, -2.0);
        this.drawText("Legend", legendOrigin.getX(), legendOrigin.getY());
        double verticalCaret = 0.1;
        double lineIndent = 0.7;
        double lineLength = 0.2;
        this.drawText("Center of Mass", legendOrigin.getX(), legendOrigin.getY() - verticalCaret);
        this.comStroke();
        this.drawLine(new Point2D[]{new Point2D(legendOrigin.getX() + lineIndent, legendOrigin.getY() - verticalCaret), new Point2D(legendOrigin.getX() + lineIndent + lineLength, legendOrigin.getY() - verticalCaret)});
        this.drawText("Capture Point", legendOrigin.getX(), legendOrigin.getY() - (verticalCaret += 0.1));
        this.icpStroke();
        this.drawLine(new Point2D[]{new Point2D(legendOrigin.getX() + lineIndent, legendOrigin.getY() - verticalCaret), new Point2D(legendOrigin.getX() + lineIndent + lineLength, legendOrigin.getY() - verticalCaret)});
        this.svgGraphics2D.setRenderingHint((RenderingHints.Key)SVGHints.KEY_END_GROUP, (Object)"Legend");
        int walk = 1;
        for (SCS2LogWalk logWalk : this.locomotionData.getLogWalks()) {
            String walkName = "Walk %d".formatted(walk);
            this.svgGraphics2D.setRenderingHint((RenderingHints.Key)SVGHints.KEY_BEGIN_GROUP, (Object)walkName);
            this.drawText(walkName, logWalk.getWalkStart().getX(), logWalk.getWalkStart().getY() + 0.3);
            String groupName = "Footsteps %d".formatted(walk);
            this.svgGraphics2D.setRenderingHint((RenderingHints.Key)SVGHints.KEY_BEGIN_GROUP, (Object)groupName);
            int footstepIndex = 0;
            for (SCS2LogFootstep footstep : logWalk.getFootsteps()) {
                Color color = (Color)FootstepListVisualizer.defaultFeetColors.get((Enum)footstep.getSide());
                this.svgGraphics2D.setColor(color);
                double[] polygon = footstep.getPolygon();
                LogTools.info((String)"Drawing step at {} {}", (Object)new Point2D(polygon[0], polygon[4]), (Object)new Point2D((double)this.metersToMMX(polygon[0]), (double)this.metersToMMY(polygon[4])));
                this.svgGraphics2D.drawPolygon(new int[]{this.metersToMMX(polygon[0]), this.metersToMMX(polygon[1]), this.metersToMMX(polygon[2]), this.metersToMMX(polygon[3])}, new int[]{this.metersToMMY(polygon[4]), this.metersToMMY(polygon[5]), this.metersToMMY(polygon[6]), this.metersToMMY(polygon[7])}, 4);
                Point2D center = new Point2D(polygon[0], polygon[4]);
                center.add(polygon[1], polygon[5]);
                center.add(polygon[2], polygon[6]);
                center.add(polygon[3], polygon[7]);
                center.scale(0.25);
                this.textStroke();
                this.svgGraphics2D.setColor(Color.GRAY);
                this.svgGraphics2D.setFont(new Font("Arial", 0, 10));
                this.svgGraphics2D.drawString("%d".formatted(footstepIndex), this.metersToMMX(center.getX() - 0.012), this.metersToMMY(center.getY() - 0.012));
                ++footstepIndex;
            }
            this.svgGraphics2D.setRenderingHint((RenderingHints.Key)SVGHints.KEY_END_GROUP, (Object)groupName);
            this.comStroke();
            this.plot((List<Point2D>)logWalk.getComs(), "Coms");
            this.icpStroke();
            this.plot((List<Point2D>)logWalk.getIcps(), "ICPs");
            if (logWalk.isEndedWithFall()) {
                Point2D fallLocation;
                if (logWalk.getFootsteps().isEmpty()) {
                    fallLocation = logWalk.getWalkStart();
                } else {
                    double[] lastStepPolygon = logWalk.getFootsteps().get(logWalk.getFootsteps().size() - 1).getPolygon();
                    fallLocation = new Point2D(lastStepPolygon[0], lastStepPolygon[4]);
                }
                this.drawText("Fall %d".formatted(walk), fallLocation.getX(), fallLocation.getY() + 0.3);
            }
            this.svgGraphics2D.setRenderingHint((RenderingHints.Key)SVGHints.KEY_END_GROUP, (Object)walkName);
            ++walk;
        }
        LogTools.info((String)"Saving SVG to {}", (Object)this.svgPath);
        try (FileWriter writer = new FileWriter(this.svgPath.toFile());){
            String svgDocument = this.svgGraphics2D.getSVGDocument();
            svgDocument = svgDocument.replace("<svg", "<svg viewBox=\"0 0 %f %f\"".formatted(documentSizeMillimeters, documentSizeMillimeters));
            writer.write(svgDocument);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void drawText(String text, double x, double y) {
        this.textStroke();
        this.svgGraphics2D.drawString(text, this.metersToMMX(x), this.metersToMMY(y));
    }

    private void textStroke() {
        this.svgGraphics2D.setColor(Color.BLACK);
        this.svgGraphics2D.setStroke((Stroke)new BasicStroke(5.0f));
        this.svgGraphics2D.setFont(new Font("Arial", 0, 20));
    }

    private void icpStroke() {
        this.svgGraphics2D.setColor(Color.BLUE);
        this.svgGraphics2D.setStroke((Stroke)new BasicStroke(2.5f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f));
    }

    private void comStroke() {
        this.svgGraphics2D.setColor(Color.BLACK);
        this.svgGraphics2D.setStroke((Stroke)new BasicStroke(2.5f));
    }

    private void drawLine(Point2D[] line) {
        this.svgGraphics2D.drawLine(this.metersToMMX(line[0].getX()), this.metersToMMY(line[0].getY()), this.metersToMMX(line[1].getX()), this.metersToMMY(line[1].getY()));
    }

    private void plot(List<Point2D> points, String name) {
        if (!points.isEmpty()) {
            int[] xs = new int[points.size()];
            int[] ys = new int[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                xs[i] = this.metersToMMX(points.get(i).getX());
                ys[i] = this.metersToMMY(points.get(i).getY());
            }
            this.svgGraphics2D.setRenderingHint((RenderingHints.Key)SVGHints.KEY_BEGIN_GROUP, (Object)name);
            this.svgGraphics2D.drawPolyline(xs, ys, xs.length);
            this.svgGraphics2D.setRenderingHint((RenderingHints.Key)SVGHints.KEY_END_GROUP, (Object)name);
        }
    }

    private int metersToMMX(double x) {
        double fromStart = x - this.locomotionData.getRobotStartLocation().getX();
        int halfDocumentMM = (int)this.convertToMillimeters(DOCUMENT_SIZE / 2.0);
        int mmFromStart = (int)this.convertToMillimeters(fromStart);
        return mmFromStart + halfDocumentMM;
    }

    private int metersToMMY(double y) {
        double fromStart = y - this.locomotionData.getRobotStartLocation().getY();
        int halfDocumentMM = (int)this.convertToMillimeters(DOCUMENT_SIZE / 2.0);
        int mmFromStart = (int)(-this.convertToMillimeters(fromStart));
        return mmFromStart + halfDocumentMM;
    }

    private long convertToMillimeters(double meters) {
        return (long)(meters * 1000.0);
    }
}

