/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import us.ihmc.avatar.logProcessor.SCS2LogEnum;
import us.ihmc.avatar.logProcessor.SCS2LogFootState;
import us.ihmc.avatar.logProcessor.SCS2LogJointTracker;
import us.ihmc.avatar.logProcessor.SCS2LogWalk;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.scs2.session.log.LogSession;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.euclid.YoPoint2D;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.euclid.YoPose3D;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.euclid.YoVector2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class SCS2LogLocomotionData {
    private double dt;
    private YoRegistry rootRegistry;
    private int initialWorkingCounterMismatch = -1;
    private YoInteger workingCounterMismatch;
    private YoBoolean isRobotFalling;
    private SCS2LogEnum<HighLevelControllerName> controllerState;
    private final Point2D robotStartLocation = new Point2D(Double.NaN, Double.NaN);
    private YoDouble controllerSwingDuration;
    private SideDependentList<YoDouble> controllerTransferDuration = new SideDependentList();
    private final SideDependentList<SCS2LogFootState> footStates = new SideDependentList();
    private final ArrayList<SCS2LogWalk> logWalks = new ArrayList();
    private final Point2D lastCenterOfMass = new Point2D(Double.NaN, Double.NaN);
    private YoPose3D pelvisPose;
    private YoPoint3D centerOfMass;
    private YoPoint2D capturePoint;
    private YoVector2D capturePointError;
    private final double plotTimeResolution = 0.1;
    private double lastCoMPlotTime = Double.NaN;
    private final SideDependentList<ArrayList<SCS2LogJointTracker>> armJointPositions = new SideDependentList(new ArrayList(), new ArrayList());
    private final SideDependentList<ReferenceFrame> handFrames = new SideDependentList();
    private final SideDependentList<ReferenceFrame> footFrames = new SideDependentList();
    private boolean requestStopProcessing = false;
    private Robot robot;
    private final SideDependentList<Boolean> isInSupport = new SideDependentList((Object)true, (Object)true);
    private double timeInDoubleSupport = Double.NaN;

    public void setup(LogSession logSession) {
        YoVariable yoVariable;
        String balanceManager;
        YoVariable zVariable;
        YoDouble yVariable;
        YoDouble xVariable;
        String momentumRateControl;
        YoVariable qyVariable;
        YoVariable yoVariable2;
        String highLevelController;
        YoVariable yoVariable3;
        this.rootRegistry = logSession.getRootRegistry();
        this.dt = logSession.getLogDataReader().getParser().getDt();
        YoVariable yoVariable4 = this.rootRegistry.findVariable("root.main.DRCEstimatorThread.NadiaEtherCATRealtimeThread.workingCounterMismatch");
        if (yoVariable4 instanceof YoInteger) {
            YoInteger yoInteger;
            this.workingCounterMismatch = yoInteger = (YoInteger)yoVariable4;
        }
        if ((yoVariable3 = this.rootRegistry.findVariable((highLevelController = "root.main.DRCControllerThread.DRCMomentumBasedController.HumanoidHighLevelControllerManager.") + "highLevelControllerNameCurrentState")) instanceof YoEnum) {
            YoEnum yoEnum = (YoEnum)yoVariable3;
            this.controllerState = new SCS2LogEnum<HighLevelControllerName>(yoEnum, HighLevelControllerName.class);
        }
        if ((yoVariable3 = this.rootRegistry.findVariable(highLevelController + "HighLevelHumanoidControllerToolbox.WalkingFailureDetectionControlModule.isRobotFalling")) instanceof YoBoolean) {
            YoBoolean yoBoolean;
            this.isRobotFalling = yoBoolean = (YoBoolean)yoVariable3;
        }
        if ((yoVariable2 = this.rootRegistry.findVariable("root.nadia.q_PELVIS_LINK_x")) instanceof YoDouble) {
            YoDouble xVariable2 = (YoDouble)yoVariable2;
            yoVariable2 = this.rootRegistry.findVariable("root.nadia.q_PELVIS_LINK_y");
            if (yoVariable2 instanceof YoDouble) {
                YoDouble yVariable2 = (YoDouble)yoVariable2;
                yoVariable2 = this.rootRegistry.findVariable("root.nadia.q_PELVIS_LINK_z");
                if (yoVariable2 instanceof YoDouble) {
                    YoDouble zVariable2 = (YoDouble)yoVariable2;
                    yoVariable2 = this.rootRegistry.findVariable("root.nadia.q_PELVIS_LINK_qx");
                    if (yoVariable2 instanceof YoDouble) {
                        YoDouble qxVariable = (YoDouble)yoVariable2;
                        yoVariable2 = this.rootRegistry.findVariable("root.nadia.q_PELVIS_LINK_qy");
                        if (yoVariable2 instanceof YoDouble) {
                            qyVariable = (YoDouble)yoVariable2;
                            yoVariable2 = this.rootRegistry.findVariable("root.nadia.q_PELVIS_LINK_qz");
                            if (yoVariable2 instanceof YoDouble) {
                                YoDouble qzVariable = (YoDouble)yoVariable2;
                                yoVariable2 = this.rootRegistry.findVariable("root.nadia.q_PELVIS_LINK_qs");
                                if (yoVariable2 instanceof YoDouble) {
                                    YoDouble qsVariable = (YoDouble)yoVariable2;
                                    this.pelvisPose = new YoPose3D(new YoPoint3D(xVariable2, yVariable2, zVariable2), new YoQuaternion(qxVariable, (YoDouble)qyVariable, qzVariable, qsVariable));
                                }
                            }
                        }
                    }
                }
            }
        }
        if ((qyVariable = this.rootRegistry.findVariable((momentumRateControl = highLevelController + "WalkingControllerState.LinearMomentumRateControlModule.") + "centerOfMassX")) instanceof YoDouble) {
            xVariable = (YoDouble)qyVariable;
            qyVariable = this.rootRegistry.findVariable(momentumRateControl + "centerOfMassY");
            if (qyVariable instanceof YoDouble) {
                yVariable = (YoDouble)qyVariable;
                qyVariable = this.rootRegistry.findVariable(momentumRateControl + "centerOfMassX");
                if (qyVariable instanceof YoDouble) {
                    zVariable = (YoDouble)qyVariable;
                    this.centerOfMass = new YoPoint3D(xVariable, yVariable, (YoDouble)zVariable);
                }
            }
        }
        if ((zVariable = this.rootRegistry.findVariable(momentumRateControl + "capturePointX")) instanceof YoDouble) {
            xVariable = (YoDouble)zVariable;
            zVariable = this.rootRegistry.findVariable(momentumRateControl + "capturePointY");
            if (zVariable instanceof YoDouble) {
                yVariable = (YoDouble)zVariable;
                this.capturePoint = new YoPoint2D(xVariable, yVariable);
            }
        }
        if ((zVariable = this.rootRegistry.findVariable(momentumRateControl + "ICPController.controllerICPErrorX")) instanceof YoDouble) {
            xVariable = (YoDouble)zVariable;
            zVariable = this.rootRegistry.findVariable(momentumRateControl + "ICPController.controllerICPErrorY");
            if (zVariable instanceof YoDouble) {
                yVariable = (YoDouble)zVariable;
                this.capturePointError = new YoVector2D(xVariable, yVariable);
            }
        }
        if ((zVariable = this.rootRegistry.findVariable((balanceManager = highLevelController + "HighLevelHumanoidControllerFactory.HighLevelControlManagerFactory.BalanceManager.") + "ErrorBasedStepAdjustmentController.controllerSwingDuration")) instanceof YoDouble) {
            YoDouble yoDouble;
            this.controllerSwingDuration = yoDouble = (YoDouble)zVariable;
        }
        String walkingController = highLevelController + "WalkingControllerState.WalkingHighLevelHumanoidController.";
        for (RobotSide side : RobotSide.values) {
            String currentTransferDuration = walkingController + "ToWalking%sSupport.CurrentTransferDuration".formatted(side.getPascalCaseName());
            yoVariable = this.rootRegistry.findVariable(currentTransferDuration);
            if (!(yoVariable instanceof YoDouble)) continue;
            YoDouble yoDouble = (YoDouble)yoVariable;
            this.controllerTransferDuration.put((Enum)side, (Object)yoDouble);
        }
        String feetManager = highLevelController + "HighLevelHumanoidControllerFactory.HighLevelControlManagerFactory.FeetManager.";
        for (RobotSide side : RobotSide.values) {
            yoVariable = this.rootRegistry.findVariable(feetManager + "%1$sFootControlModule.%1$sFootCurrentState".formatted(side.getLowerCaseName()));
            if (!(yoVariable instanceof YoEnum)) continue;
            YoEnum yoEnum = (YoEnum)yoVariable;
            this.footStates.set((Enum)side, (Object)new SCS2LogFootState(side, new SCS2LogEnum<FootControlModule.ConstraintType>(yoEnum, FootControlModule.ConstraintType.class), this.rootRegistry));
        }
        String sensorProcessing = "root.main.DRCEstimatorThread.NadiaSensorReader.SensorProcessing.";
        String[] armJointNames = new String[]{"SHOULDER_Y", "SHOULDER_X", "SHOULDER_Z", "ELBOW_Y", "WRIST_Z", "WRIST_X", "GRIPPER_Z"};
        for (RobotSide side : RobotSide.values) {
            for (String armJoint : armJointNames) {
                YoVariable yoVariable5 = this.rootRegistry.findVariable(sensorProcessing + "raw_q_%s_%s".formatted(side.getSideNameInAllCaps(), armJoint));
                if (!(yoVariable5 instanceof YoDouble)) continue;
                YoDouble yoDouble = (YoDouble)yoVariable5;
                ((ArrayList)this.armJointPositions.get((Enum)side)).add(new SCS2LogJointTracker(yoDouble));
            }
        }
        this.robot = (Robot)logSession.getRobots().get(0);
        for (RobotSide side : RobotSide.values) {
            SimRigidBodyBasics handLink = this.robot.getRigidBody("%s_GRIPPER_YAW_LINK".formatted(side.getSideNameInAllCaps()));
            if (handLink != null) {
                MovingReferenceFrame handFrame = handLink.getParentJoint().getFrameAfterJoint();
                this.handFrames.set((Enum)side, (Object)handFrame);
            }
            SimRigidBodyBasics footLink = this.robot.getRigidBody("%s_FOOT_LINK".formatted(side.getSideNameInAllCaps()));
            MovingReferenceFrame footFrame = footLink.getParentJoint().getFrameAfterJoint();
            this.footFrames.set((Enum)side, (Object)footFrame);
        }
        logSession.addAfterReadCallback(this::afterRead);
    }

    private void afterRead(double currentTime) {
        SCS2LogWalk logWalk;
        if (this.requestStopProcessing) {
            return;
        }
        long tick = (long)(currentTime / this.dt);
        if (this.initialWorkingCounterMismatch < 0) {
            this.initialWorkingCounterMismatch = this.workingCounterMismatch.getIntegerValue();
        }
        if (this.controllerState.changedTo(HighLevelControllerName.WALKING)) {
            logWalk = new SCS2LogWalk();
            this.logWalks.add(logWalk);
            logWalk.getWalkStart().set((Tuple3DReadOnly)this.centerOfMass);
            logWalk.setWalkStartTick(tick);
        }
        if (this.controllerState.changedFrom(HighLevelControllerName.WALKING) && this.controllerState.changedTo(HighLevelControllerName.FREEZE_STATE) && this.isRobotFalling.getBooleanValue()) {
            this.getCurrentLogWalk().setEndedWithFall(true);
        }
        this.controllerState.postUpdate();
        if (!this.logWalks.isEmpty() && this.controllerState.getValue() == HighLevelControllerName.WALKING) {
            logWalk = this.getCurrentLogWalk();
            logWalk.update(currentTime, tick, this.workingCounterMismatch);
            logWalk.getICPErrors().add(new SCS2LogWalk.ICPErrorEntry(currentTime, new Vector2D((Tuple2DReadOnly)this.capturePointError)));
            for (SCS2LogFootState footState : this.footStates.values()) {
                footState.afterRead(currentTime);
                FootControlModule.ConstraintType changedTo = (FootControlModule.ConstraintType)footState.getStateChanged().peek();
                logWalk.getFootsteps().addAll(footState.getFootsteps());
                footState.getFootsteps().clear();
                if (footState.getStateChanged().poll()) {
                    ((ArrayList)logWalk.getFootStateChanges().get((Enum)footState.getSide())).add(new SCS2LogWalk.FootStateChange(currentTime, (FootControlModule.ConstraintType)footState.getStateChanged().read()));
                }
                if (footState.getSwingCompleted().poll()) {
                    ((ArrayList)logWalk.getFootSwings().get((Enum)footState.getSide())).add(new SCS2LogWalk.FootSwing(currentTime, (Double)footState.getSwingCompleted().read(), this.controllerSwingDuration.getDoubleValue()));
                }
                if (changedTo == null) continue;
                this.isInSupport.put((Enum)footState.getSide(), (Object)(changedTo == FootControlModule.ConstraintType.FULL || changedTo == FootControlModule.ConstraintType.TOES ? 1 : 0));
                if (((Boolean)this.isInSupport.get((Enum)RobotSide.LEFT)).booleanValue() && ((Boolean)this.isInSupport.get((Enum)RobotSide.RIGHT)).booleanValue()) {
                    this.timeInDoubleSupport = currentTime;
                    continue;
                }
                double duration = currentTime - this.timeInDoubleSupport;
                logWalk.getDoubleSupportDurations().add(new SCS2LogWalk.DoubleSupportDuration(currentTime, duration, ((YoDouble)this.controllerTransferDuration.get((Enum)footState.getSide())).getDoubleValue()));
                this.timeInDoubleSupport = Double.NaN;
            }
            if (this.robotStartLocation.containsNaN()) {
                this.robotStartLocation.set(this.centerOfMass.getX(), this.centerOfMass.getY());
                LogTools.info((String)"Robot start location: {}", (Object)this.robotStartLocation);
            }
            if (this.lastCenterOfMass.containsNaN() || this.centerOfMass.distanceXY((Point2DReadOnly)this.lastCenterOfMass) > 0.001 && currentTime - this.lastCoMPlotTime > 0.1) {
                this.recordEntry(currentTime, logWalk);
            }
        }
    }

    private void recordEntry(double currentTime, SCS2LogWalk logWalk) {
        this.robot.updateFrames();
        logWalk.getTimes().add(currentTime);
        ((Pose3D)logWalk.getPelvisPoses().add()).set((Pose3DReadOnly)this.pelvisPose);
        for (RobotSide side : this.handFrames.sides()) {
            ((Pose3D)((RecyclingArrayList)logWalk.getHandPoses().get((Enum)side)).add()).set((RigidBodyTransformReadOnly)((ReferenceFrame)this.handFrames.get((Enum)side)).getTransformToDesiredFrame((ReferenceFrame)this.footFrames.get((Enum)side)));
        }
        ((Point2D)logWalk.getComs().add()).set((Tuple3DReadOnly)this.centerOfMass);
        ((Point2D)logWalk.getIcps().add()).set((Tuple2DReadOnly)this.capturePoint);
        this.lastCenterOfMass.set((Tuple3DReadOnly)this.centerOfMass);
        this.lastCoMPlotTime = currentTime;
    }

    public void writeJSON(ObjectNode rootNode) {
        rootNode.put("numberOfWalks", this.logWalks.size());
        rootNode.put("numberOfFalls", this.getFalls());
        rootNode.put("numberOfFootsteps", this.getNumberOfFootsteps());
        rootNode.put("numberOfComs", this.getNumberOfComs());
        rootNode.put("workingCounterMismatch", this.getWorkingCounterMismatch());
    }

    private SCS2LogWalk getCurrentLogWalk() {
        return this.logWalks.get(this.logWalks.size() - 1);
    }

    public void requestStopProcessing() {
        this.requestStopProcessing = true;
    }

    public Point2D getRobotStartLocation() {
        return this.robotStartLocation;
    }

    public int getNumberOfFootsteps() {
        int numberOfFootsteps = 0;
        for (SCS2LogWalk logWalk : this.logWalks) {
            numberOfFootsteps += logWalk.getFootsteps().size();
        }
        return numberOfFootsteps;
    }

    public int getNumberOfComs() {
        int numberOfComs = 0;
        for (SCS2LogWalk logWalk : this.logWalks) {
            numberOfComs += logWalk.getComs().size();
        }
        return numberOfComs;
    }

    public ArrayList<SCS2LogWalk> getLogWalks() {
        return this.logWalks;
    }

    public int getFalls() {
        int falls = 0;
        for (SCS2LogWalk logWalk : this.logWalks) {
            if (!logWalk.isEndedWithFall()) continue;
            ++falls;
        }
        return falls;
    }

    public int getWorkingCounterMismatch() {
        if (this.workingCounterMismatch == null) {
            return -1;
        }
        return this.workingCounterMismatch.getIntegerValue() - this.initialWorkingCounterMismatch;
    }

    public SideDependentList<ReferenceFrame> getHandFrames() {
        return this.handFrames;
    }
}

