/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor;

import java.util.ArrayList;
import us.ihmc.avatar.logProcessor.SCS2LogEnum;
import us.ihmc.avatar.logProcessor.SCS2LogFootstep;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commons.thread.TypedNotification;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class SCS2LogFootState {
    private final RobotSide side;
    private final SCS2LogEnum<FootControlModule.ConstraintType> yoFootState;
    private boolean newStep = false;
    private double fullSupportTime = Double.NaN;
    private final YoVariable footPolygon_0_x;
    private final YoVariable footPolygon_0_y;
    private final YoVariable footPolygon_1_x;
    private final YoVariable footPolygon_1_y;
    private final YoVariable footPolygon_2_x;
    private final YoVariable footPolygon_2_y;
    private final YoVariable footPolygon_3_x;
    private final YoVariable footPolygon_3_y;
    private final ArrayList<SCS2LogFootstep> footsteps = new ArrayList();
    private final TypedNotification<FootControlModule.ConstraintType> stateChanged = new TypedNotification();
    private final double comPlotProximityToFootsteps = 5.0;
    private double timeStartedSwing = Double.NaN;
    private final TypedNotification<Double> swingCompleted = new TypedNotification();

    public SCS2LogFootState(RobotSide side, SCS2LogEnum<FootControlModule.ConstraintType> yoFootState, YoRegistry rootRegistry) {
        this.side = side;
        this.yoFootState = yoFootState;
        String highLevelController = "root.main.DRCControllerThread.DRCMomentumBasedController.HumanoidHighLevelControllerManager.";
        String footPolygonPrefix = highLevelController + "HighLevelHumanoidControllerToolbox.BipedSupportPolygons.";
        this.footPolygon_0_x = rootRegistry.findVariable(footPolygonPrefix + "%sFootPolygon_0_x".formatted(side.getLowerCaseName()));
        this.footPolygon_0_y = rootRegistry.findVariable(footPolygonPrefix + "%sFootPolygon_0_y".formatted(side.getLowerCaseName()));
        this.footPolygon_1_x = rootRegistry.findVariable(footPolygonPrefix + "%sFootPolygon_1_x".formatted(side.getLowerCaseName()));
        this.footPolygon_1_y = rootRegistry.findVariable(footPolygonPrefix + "%sFootPolygon_1_y".formatted(side.getLowerCaseName()));
        this.footPolygon_2_x = rootRegistry.findVariable(footPolygonPrefix + "%sFootPolygon_2_x".formatted(side.getLowerCaseName()));
        this.footPolygon_2_y = rootRegistry.findVariable(footPolygonPrefix + "%sFootPolygon_2_y".formatted(side.getLowerCaseName()));
        this.footPolygon_3_x = rootRegistry.findVariable(footPolygonPrefix + "%sFootPolygon_3_x".formatted(side.getLowerCaseName()));
        this.footPolygon_3_y = rootRegistry.findVariable(footPolygonPrefix + "%sFootPolygon_3_y".formatted(side.getLowerCaseName()));
    }

    public void afterRead(double currentTime) {
        if (this.yoFootState.changed()) {
            this.stateChanged.set((Object)this.yoFootState.getValue());
        }
        if (this.yoFootState.changedTo(FootControlModule.ConstraintType.FULL)) {
            this.newStep = true;
            this.fullSupportTime = currentTime;
        }
        if (this.yoFootState.changedTo(FootControlModule.ConstraintType.SWING)) {
            this.timeStartedSwing = currentTime;
        }
        if (this.yoFootState.changedFrom(FootControlModule.ConstraintType.SWING)) {
            double swingDuration = currentTime - this.timeStartedSwing;
            this.swingCompleted.set((Object)swingDuration);
        }
        this.yoFootState.postUpdate();
        if (this.newStep && currentTime - this.fullSupportTime > 0.1) {
            LogTools.info((String)"%s step at %s".formatted(this.side.getPascalCaseName(), new Point2D(this.footPolygon_0_x.getValueAsDouble(), this.footPolygon_0_y.getValueAsDouble())));
            this.footsteps.add(new SCS2LogFootstep(currentTime, this.side, new double[]{this.footPolygon_0_x.getValueAsDouble(), this.footPolygon_1_x.getValueAsDouble(), this.footPolygon_2_x.getValueAsDouble(), this.footPolygon_3_x.getValueAsDouble(), this.footPolygon_0_y.getValueAsDouble(), this.footPolygon_1_y.getValueAsDouble(), this.footPolygon_2_y.getValueAsDouble(), this.footPolygon_3_y.getValueAsDouble()}));
            this.newStep = false;
        }
    }

    public RobotSide getSide() {
        return this.side;
    }

    public ArrayList<SCS2LogFootstep> getFootsteps() {
        return this.footsteps;
    }

    public TypedNotification<FootControlModule.ConstraintType> getStateChanged() {
        return this.stateChanged;
    }

    public TypedNotification<Double> getSwingCompleted() {
        return this.swingCompleted;
    }
}

