/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import us.ihmc.avatar.logProcessor.LogDataProcessorFunction;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.scripts.Script;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class LogDataProcessorWrapper
implements YoBufferProcessor,
Script {
    private final YoRegistry logDataProcessorRegistry = new YoRegistry("LogDataProcessor");
    private final List<LogDataProcessorFunction> logDataProcessorFunctions = new ArrayList<LogDataProcessorFunction>();
    private final List<YoVariable> varsToSave = new ArrayList<YoVariable>();
    private final LinkedHashMap<YoVariable, Double> yoVarsToDoublesMap = new LinkedHashMap();
    private final boolean haveFoundControllerTimerVariable;
    private boolean isControllerTick = true;
    private long lastControllerTimerCount = -1L;
    private final YoLong controllerTimerCount;

    public LogDataProcessorWrapper(SimulationConstructionSet scs) {
        scs.addYoRegistry(this.logDataProcessorRegistry);
        scs.addScript((Script)this);
        this.controllerTimerCount = (YoLong)scs.findVariable("controllerTimerCount");
        boolean bl = this.haveFoundControllerTimerVariable = this.controllerTimerCount != null;
        if (!this.haveFoundControllerTimerVariable) {
            System.err.println("Could not find controller timer variable, running processors at log data rate");
        }
    }

    public void initialize(YoVariableHolder yoVariableHolder) {
        this.saveYoVariablesAsDoubles();
    }

    public void process(int startIndex, int endIndex, int currentIndex) {
        this.updateIsControllerTick();
        this.retrieveYoVariablesFromDoubles();
        if (this.isControllerTick || !this.haveFoundControllerTimerVariable) {
            this.isControllerTick = false;
            this.processDataAtControllerRate();
        }
        this.processDataAtStateEstimatorRate();
        this.saveYoVariablesAsDoubles();
    }

    public void doScript(double t) {
        this.updateIsControllerTick();
        if (this.isControllerTick || !this.haveFoundControllerTimerVariable) {
            this.isControllerTick = false;
            this.processDataAtControllerRate();
        }
        this.processDataAtStateEstimatorRate();
    }

    private void updateIsControllerTick() {
        if (this.controllerTimerCount == null) {
            this.isControllerTick = true;
            return;
        }
        this.isControllerTick = this.controllerTimerCount.getLongValue() != this.lastControllerTimerCount;
        this.lastControllerTimerCount = this.controllerTimerCount.getLongValue();
    }

    private void processDataAtControllerRate() {
        for (int i = 0; i < this.logDataProcessorFunctions.size(); ++i) {
            this.logDataProcessorFunctions.get(i).processDataAtControllerRate();
        }
    }

    private void processDataAtStateEstimatorRate() {
        for (int i = 0; i < this.logDataProcessorFunctions.size(); ++i) {
            this.logDataProcessorFunctions.get(i).processDataAtStateEstimatorRate();
        }
    }

    public void addLogDataProcessor(LogDataProcessorFunction logDataProcessorFunction) {
        this.logDataProcessorFunctions.add(logDataProcessorFunction);
        this.logDataProcessorRegistry.addChild(logDataProcessorFunction.getYoVariableRegistry());
        this.varsToSave.addAll(logDataProcessorFunction.getYoVariableRegistry().collectSubtreeVariables());
    }

    public void saveYoVariablesAsDoubles() {
        for (int i = 0; i < this.varsToSave.size(); ++i) {
            YoVariable currentYoVariable = this.varsToSave.get(i);
            this.yoVarsToDoublesMap.put(currentYoVariable, currentYoVariable.getValueAsDouble());
        }
    }

    public void retrieveYoVariablesFromDoubles() {
        for (int i = 0; i < this.varsToSave.size(); ++i) {
            YoVariable currentYoVariable = this.varsToSave.get(i);
            Double previousValueAsDouble = this.yoVarsToDoublesMap.get(currentYoVariable);
            currentYoVariable.setValueFromDouble(previousValueAsDouble.doubleValue());
        }
    }
}

