/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor;

import java.util.ArrayList;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.logProcessor.LogDataRawSensorMap;
import us.ihmc.avatar.logProcessor.UpdatableHighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.PlaneContactWrenchProcessor;
import us.ihmc.commonWalkingControlModules.sensors.footSwitch.WrenchBasedFootSwitch;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.humanoidRobotics.model.CenterOfMassStateProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.frames.CommonLeggedReferenceFrames;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;
import us.ihmc.sensorProcessing.simulatedSensors.SDFPerfectSimulatedSensorReader;
import us.ihmc.sensorProcessing.stateEstimation.evaluation.FullInverseDynamicsStructure;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class LogDataProcessorHelper {
    private final FullHumanoidRobotModel fullRobotModel;
    private final FullInverseDynamicsStructure inverseDynamicsStructure;
    private final CenterOfMassStateProvider centerOfMassStateProvider;
    private final HumanoidReferenceFrames referenceFrames;
    private final SDFPerfectSimulatedSensorReader sensorReader;
    private final LogDataRawSensorMap rawSensorMap;
    private final SideDependentList<ContactableFoot> contactableFeet;
    private final SideDependentList<YoFramePoint2D> cops = new SideDependentList();
    private final SideDependentList<YoFramePoint2D> desiredCoPs = new SideDependentList();
    private final SideDependentList<YoEnum<?>> footStates = new SideDependentList();
    private final double controllerDT;
    private final WalkingControllerParameters walkingControllerParameters;
    private final SideDependentList<FootSwitchInterface> stateEstimatorFootSwitches;
    private final SimulationConstructionSet scs;
    private final UpdatableHighLevelHumanoidControllerToolbox controllerToolbox;
    private final ArrayList<Updatable> updatables = new ArrayList();
    private final YoDouble yoTime;

    public LogDataProcessorHelper(DRCRobotModel model, SimulationConstructionSet scs, FloatingRootJointRobot sdfRobot) {
        this.scs = scs;
        this.fullRobotModel = model.createFullRobotModel();
        this.centerOfMassStateProvider = CenterOfMassStateProvider.createJacobianBasedStateCalculator((RigidBodyReadOnly)this.fullRobotModel.getElevator(), (ReferenceFrame)ReferenceFrame.getWorldFrame());
        this.referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel);
        this.sensorReader = new SDFPerfectSimulatedSensorReader(sdfRobot, (FullRobotModel)this.fullRobotModel, (ReferenceFrames)this.referenceFrames);
        this.rawSensorMap = new LogDataRawSensorMap((FullRobotModel)this.fullRobotModel, (YoVariableHolder)scs);
        this.inverseDynamicsStructure = new FullInverseDynamicsStructure(this.fullRobotModel.getElevator(), this.fullRobotModel.getPelvis(), this.fullRobotModel.getRootJoint());
        this.controllerDT = model.getControllerDT();
        this.walkingControllerParameters = model.getWalkingControllerParameters();
        RobotContactPointParameters contactPointParameters = model.getContactPointParameters();
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
        contactableBodiesFactory.setFullRobotModel((FullLeggedRobotModel)this.fullRobotModel);
        contactableBodiesFactory.setReferenceFrames((CommonLeggedReferenceFrames)this.referenceFrames);
        this.contactableFeet = new SideDependentList(contactableBodiesFactory.createFootContactableFeet());
        contactableBodiesFactory.disposeFactory();
        for (RobotSide robotSide : RobotSide.values) {
            MovingReferenceFrame soleFrame = this.referenceFrames.getSoleFrame(robotSide);
            String side = robotSide.getCamelCaseNameForMiddleOfExpression();
            String bodyName = ((ContactableFoot)this.contactableFeet.get((Enum)robotSide)).getName();
            String copNamePrefix = bodyName + "StateEstimator";
            String copNamespace = copNamePrefix + WrenchBasedFootSwitch.class.getSimpleName();
            String copName = copNamePrefix + "ResolvedCoP";
            YoDouble copx = (YoDouble)scs.findVariable(copNamespace, copName + "X");
            YoDouble copy = (YoDouble)scs.findVariable(copNamespace, copName + "Y");
            if (copx != null && copy != null) {
                YoFramePoint2D cop = new YoFramePoint2D(copx, copy, (ReferenceFrame)soleFrame);
                this.cops.put((Enum)robotSide, (Object)cop);
            }
            String desiredCoPNamespace = PlaneContactWrenchProcessor.class.getSimpleName();
            String desiredCoPName = side + "SoleCoP2d";
            YoDouble desiredCoPx = (YoDouble)scs.findVariable(desiredCoPNamespace, desiredCoPName + "X");
            YoDouble desiredCoPy = (YoDouble)scs.findVariable(desiredCoPNamespace, desiredCoPName + "Y");
            YoFramePoint2D desiredCoP = new YoFramePoint2D(desiredCoPx, desiredCoPy, (ReferenceFrame)soleFrame);
            this.desiredCoPs.put((Enum)robotSide, (Object)desiredCoP);
            String sidePrefix = robotSide.getCamelCaseNameForStartOfExpression();
            String namePrefix = sidePrefix + "Foot";
            String footStateNamespace = sidePrefix + FootControlModule.class.getSimpleName();
            String footStateName = namePrefix + "State";
            YoEnum footState = (YoEnum)scs.findVariable(footStateNamespace, footStateName);
            this.footStates.put((Enum)robotSide, (Object)footState);
        }
        this.stateEstimatorFootSwitches = this.createStateEstimatorFootSwitches((YoVariableHolder)scs);
        double omega0 = this.walkingControllerParameters.getOmega0();
        double gravityZ = 9.81;
        String controllerTimeNamespace = null;
        this.yoTime = (YoDouble)scs.findVariable(controllerTimeNamespace, "controllerTime");
        this.controllerToolbox = new UpdatableHighLevelHumanoidControllerToolbox(scs, this.fullRobotModel, this.centerOfMassStateProvider, (CommonHumanoidReferenceFrames)this.referenceFrames, this.stateEstimatorFootSwitches, null, this.yoTime, gravityZ, omega0, this.contactableFeet, this.controllerDT, this.updatables, null, null, new JointBasics[0]);
    }

    private SideDependentList<FootSwitchInterface> createStateEstimatorFootSwitches(YoVariableHolder yoVariableHolder) {
        SideDependentList footSwitches = new SideDependentList();
        for (final RobotSide robotSide : RobotSide.values) {
            String namePrefix = ((ContactableFoot)this.contactableFeet.get((Enum)robotSide)).getName() + "StateEstimator";
            String namespaceEnding = namePrefix + WrenchBasedFootSwitch.class.getSimpleName();
            final YoBoolean hasFootHitGround = (YoBoolean)yoVariableHolder.findVariable(namespaceEnding, namePrefix + "FilteredFootHitGround");
            final YoBoolean forceMagnitudePastThreshold = (YoBoolean)yoVariableHolder.findVariable(namespaceEnding, namePrefix + "ForcePastThresh");
            final YoDouble footLoadPercentage = (YoDouble)yoVariableHolder.findVariable(namespaceEnding, namePrefix + "FootLoadPercentage");
            FootSwitchInterface footSwitch = new FootSwitchInterface(){

                public void reset() {
                }

                public boolean hasFootHitGroundSensitive() {
                    return forceMagnitudePastThreshold.getBooleanValue();
                }

                public boolean hasFootHitGroundFiltered() {
                    return hasFootHitGround.getBooleanValue();
                }

                public ReferenceFrame getMeasurementFrame() {
                    return null;
                }

                public double getFootLoadPercentage() {
                    return footLoadPercentage.getDoubleValue();
                }

                public WrenchReadOnly getMeasuredWrench() {
                    return null;
                }

                public FramePoint2DReadOnly getCenterOfPressure() {
                    return (FramePoint2DReadOnly)LogDataProcessorHelper.this.cops.get((Enum)robotSide);
                }
            };
            footSwitches.put((Enum)robotSide, (Object)footSwitch);
        }
        return footSwitches;
    }

    public void update() {
        this.sensorReader.read();
        this.controllerToolbox.update();
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    public FullInverseDynamicsStructure getInverseDynamicsStructure() {
        return this.inverseDynamicsStructure;
    }

    public HumanoidReferenceFrames getReferenceFrames() {
        return this.referenceFrames;
    }

    public LogDataRawSensorMap getRawSensorMap() {
        return this.rawSensorMap;
    }

    public SideDependentList<? extends ContactablePlaneBody> getContactableFeet() {
        return this.contactableFeet;
    }

    public SideDependentList<FootSwitchInterface> getStateEstimatorFootSwitches() {
        return this.stateEstimatorFootSwitches;
    }

    public FootControlModule.ConstraintType getCurrenFootState(RobotSide robotSide) {
        return FootControlModule.ConstraintType.valueOf((String)((YoEnum)this.footStates.get((Enum)robotSide)).getStringValue());
    }

    public void getMeasuredCoP(RobotSide robotSide, FramePoint2D copToPack) {
        copToPack.setIncludingFrame((FrameTuple2DReadOnly)this.cops.get((Enum)robotSide));
    }

    public void getDesiredCoP(RobotSide robotSide, FramePoint2D desiredCoPToPack) {
        desiredCoPToPack.setIncludingFrame((FrameTuple2DReadOnly)this.desiredCoPs.get((Enum)robotSide));
    }

    public double getControllerDT() {
        return this.controllerDT;
    }

    public WalkingControllerParameters getWalkingControllerParameters() {
        return this.walkingControllerParameters;
    }

    public YoVariableHolder getLogYoVariableHolder() {
        return this.scs;
    }

    public HighLevelHumanoidControllerToolbox getHighLevelHumanoidControllerToolbox() {
        return this.controllerToolbox;
    }

    public YoFramePoint3D findYoFramePoint(String pointPrefix, ReferenceFrame pointFrame) {
        return this.findYoFramePoint(pointPrefix, "", pointFrame);
    }

    public YoFramePoint3D findYoFramePoint(String pointPrefix, String pointSuffix, ReferenceFrame pointFrame) {
        YoDouble x = (YoDouble)this.scs.findVariable(YoGeometryNameTools.createXName((String)pointPrefix, (String)pointSuffix));
        YoDouble y = (YoDouble)this.scs.findVariable(YoGeometryNameTools.createYName((String)pointPrefix, (String)pointSuffix));
        YoDouble z = (YoDouble)this.scs.findVariable(YoGeometryNameTools.createZName((String)pointPrefix, (String)pointSuffix));
        if (x == null || y == null || z == null) {
            return null;
        }
        return new YoFramePoint3D(x, y, z, pointFrame);
    }

    public YoFrameVector3D findYoFrameVector(String vectorPrefix, ReferenceFrame vectorFrame) {
        return this.findYoFrameVector(vectorPrefix, "", vectorFrame);
    }

    public YoFrameVector3D findYoFrameVector(String vectorPrefix, String vectorSuffix, ReferenceFrame vectorFrame) {
        YoDouble x = (YoDouble)this.scs.findVariable(YoGeometryNameTools.createXName((String)vectorPrefix, (String)vectorSuffix));
        YoDouble y = (YoDouble)this.scs.findVariable(YoGeometryNameTools.createYName((String)vectorPrefix, (String)vectorSuffix));
        YoDouble z = (YoDouble)this.scs.findVariable(YoGeometryNameTools.createZName((String)vectorPrefix, (String)vectorSuffix));
        if (x == null || y == null || z == null) {
            return null;
        }
        return new YoFrameVector3D(x, y, z, vectorFrame);
    }

    public YoFrameQuaternion findYoFrameQuaternion(String quaternionPrefix, ReferenceFrame quaternionFrame) {
        return this.findYoFrameQuaternion(quaternionPrefix, "", quaternionFrame);
    }

    public YoFrameQuaternion findYoFrameQuaternion(String quaternionPrefix, String quaternionSuffix, ReferenceFrame quaternionFrame) {
        YoDouble qx = (YoDouble)this.scs.findVariable(YoGeometryNameTools.createQxName((String)quaternionPrefix, (String)quaternionSuffix));
        YoDouble qy = (YoDouble)this.scs.findVariable(YoGeometryNameTools.createQyName((String)quaternionPrefix, (String)quaternionSuffix));
        YoDouble qz = (YoDouble)this.scs.findVariable(YoGeometryNameTools.createQzName((String)quaternionPrefix, (String)quaternionSuffix));
        YoDouble qs = (YoDouble)this.scs.findVariable(YoGeometryNameTools.createQsName((String)quaternionPrefix, (String)quaternionSuffix));
        if (qx == null || qy == null || qz == null || qs == null) {
            return null;
        }
        return new YoFrameQuaternion(qx, qy, qz, qs, quaternionFrame);
    }
}

