/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor;

import gnu.trove.list.array.TDoubleArrayList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import us.ihmc.log.LogTools;

public class LogCSVProcessor {
    private final String LOG_PATH = Paths.get(System.getProperty("log.path"), new String[0]).toString();

    public LogCSVProcessor() {
        List<String> fileContents;
        Path filePath = Paths.get(this.LOG_PATH, new String[0]);
        try {
            fileContents = Files.readAllLines(filePath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        fileContents.remove(0);
        TDoubleArrayList controllerICPErrorXs = new TDoubleArrayList();
        TDoubleArrayList controllerICPErrorYs = new TDoubleArrayList();
        for (String line : fileContents) {
            String[] splitLine = line.split(",");
            controllerICPErrorXs.add(Double.parseDouble(splitLine[0]));
            controllerICPErrorYs.add(Double.parseDouble(splitLine[1]));
        }
        LogTools.info((String)"RMS controllerICPErrorXs: {}", (Object)this.calculateRMS(controllerICPErrorXs));
        LogTools.info((String)"RMS controllerICPErrorYs: {}", (Object)this.calculateRMS(controllerICPErrorYs));
    }

    public double calculateRMS(TDoubleArrayList values) {
        double sum = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            double value = values.get(i);
            sum += value * value;
        }
        double averageSquare = sum / (double)values.size();
        return Math.sqrt(averageSquare);
    }

    public static void main(String[] args) {
        new LogCSVProcessor();
    }
}

