/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.joystickBasedJavaFXController;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import us.ihmc.log.LogTools;

public class UserProfileManager<T> {
    public static final String fileExtension = ".ini";
    public static final String defaultWorkingDirectoryPath = System.getProperty("user.home") + "/.ihmc/joystick_step_app/";
    public static final String userProfilesFilename = "profiles.ini";
    private final T defaultParameters;
    private final File workingDirectory;
    private final PropertyMapParser<T> parser;
    private final PropertyMapExporter<T> exporter;

    public UserProfileManager(String workingDirectoryPath, T defaultParameters, PropertyMapParser<T> parser, PropertyMapExporter<T> exporter) {
        this.defaultParameters = defaultParameters;
        this.parser = parser;
        this.exporter = exporter;
        if (workingDirectoryPath == null) {
            workingDirectoryPath = defaultWorkingDirectoryPath;
        }
        this.workingDirectory = new File(workingDirectoryPath);
        this.workingDirectory.mkdirs();
    }

    public List<String> getUserProfileNames() {
        return UserProfileManager.readUserProfileNames(this.workingDirectory);
    }

    public T loadProfile(String profileName) {
        return UserProfileManager.loadProfileParameters(this.workingDirectory, profileName, this.defaultParameters, this.parser, this.exporter);
    }

    public void saveProfile(String profileName, T parameters) {
        UserProfileManager.saveProfileParameters(this.workingDirectory, profileName, parameters, this.exporter);
    }

    public void close(List<String> userProfileNames) {
        UserProfileManager.saveUserProfileNames(this.workingDirectory, userProfileNames);
        List<File> parameterFiles = Arrays.asList(this.workingDirectory.listFiles(filename -> !filename.getName().equals(userProfilesFilename)));
        for (File parameterFile : parameterFiles) {
            String profileName = parameterFile.getName().replaceAll(fileExtension, "");
            if (userProfileNames.contains(profileName)) continue;
            parameterFile.deleteOnExit();
        }
    }

    private static List<String> readUserProfileNames(File workingDirectory) {
        Scanner scanner;
        File userProfileNamesFile = new File(workingDirectory, userProfilesFilename);
        ArrayList<String> userProfileNameList = new ArrayList<String>();
        try {
            scanner = new Scanner(userProfileNamesFile);
        }
        catch (FileNotFoundException e) {
            LogTools.error((String)"User profiles file not found");
            return userProfileNameList;
        }
        scanner.useDelimiter(Pattern.compile("\n"));
        while (scanner.hasNext()) {
            String next = scanner.next();
            if ((next = next.replaceAll(" ", "").replaceAll("\r", "")).isEmpty()) continue;
            userProfileNameList.add(next);
        }
        scanner.close();
        return userProfileNameList;
    }

    private static void saveUserProfileNames(File workingDirectory, List<String> userProfileNames) {
        File userProfileNamesFile = new File(workingDirectory, userProfilesFilename);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(userProfileNamesFile);
            for (int i = 0; i < userProfileNames.size(); ++i) {
                if (i > 0) {
                    fileWriter.write("\n");
                }
                String userProfileName = userProfileNames.get(i);
                fileWriter.write(userProfileName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered problem saving profile names.", e);
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Encountered problem saving profile names.", e);
            }
        }
    }

    private static <T> T loadProfileParameters(File workingDirectory, String userProfileName, T defaultParameters, PropertyMapParser<T> parser, PropertyMapExporter<T> exporter) {
        T loadedParameters;
        if (userProfileName == null) {
            return defaultParameters;
        }
        File userParameterFile = UserProfileManager.createParameterFile(workingDirectory, userProfileName);
        if (!userParameterFile.exists()) {
            loadedParameters = defaultParameters;
            UserProfileManager.saveProfileParameters(workingDirectory, userProfileName, defaultParameters, exporter);
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(userParameterFile);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                Map<String, String> propertyMap = properties.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), key -> properties.getProperty((String)key)));
                loadedParameters = parser.parseFromPropertyMap(propertyMap, defaultParameters);
                fileInputStream.close();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Should not get there as the file existence has been verified already.", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Encountered problem loading " + userProfileName, e);
            }
        }
        return loadedParameters;
    }

    private static <T> void saveProfileParameters(File workingDirectory, String userProfileName, T parameters, PropertyMapExporter<T> exporter) {
        if (userProfileName == null || parameters == null) {
            return;
        }
        File userParameterFile = UserProfileManager.createParameterFile(workingDirectory, userProfileName);
        if (!userParameterFile.exists()) {
            try {
                userParameterFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Encountered problem saving " + userProfileName, e);
            }
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(userParameterFile);
            Properties properties = new Properties();
            exporter.exportAsProPertyMap(parameters).entrySet().forEach(entry -> properties.setProperty((String)entry.getKey(), (String)entry.getValue()));
            properties.store(fileWriter, "Paramters for the IHMC joystick stepping application");
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered problem saving " + userProfileName, e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Encountered problem saving " + userProfileName, e);
                }
            }
        }
    }

    private static File createParameterFile(File workingDirectory, String userProfileName) {
        return new File(workingDirectory, userProfileName + fileExtension);
    }

    public static interface PropertyMapParser<T> {
        public T parseFromPropertyMap(Map<String, String> var1, T var2);
    }

    public static interface PropertyMapExporter<T> {
        public Map<String, String> exportAsProPertyMap(T var1);
    }
}

