/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.joystickBasedJavaFXController;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.io.IOException;
import javafx.animation.AnimationTimer;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.AmbientLight;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.avatar.joystickBasedJavaFXController.HumanoidRobotKickMessenger;
import us.ihmc.avatar.joystickBasedJavaFXController.HumanoidRobotPunchMessenger;
import us.ihmc.avatar.joystickBasedJavaFXController.StepGeneratorJavaFXController;
import us.ihmc.avatar.joystickBasedJavaFXController.StepGeneratorJavaFXTopics;
import us.ihmc.avatar.joystickBasedJavaFXController.StepGeneratorParametersPaneController;
import us.ihmc.avatar.joystickBasedJavaFXController.XBoxOneJavaFXController;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.controllerAPI.RobotLowLevelMessenger;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.javaFXToolkit.cameraControllers.FocusBasedCameraMouseEventHandler;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.javafx.JavaFXRobotVisualizer;
import us.ihmc.messager.Messager;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.ui.JavaFXPlanarRegionsViewer;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Node;

public class JoystickBasedSteppingMainUI {
    private final Stage primaryStage;
    private final BorderPane mainPane;
    private final JavaFXRobotVisualizer robotVisualizer;
    private final StepGeneratorJavaFXController stepGeneratorJavaFXController;
    private final AnimationTimer cameraTracking;
    private final JavaFXMessager messager = new SharedMemoryJavaFXMessager(StepGeneratorJavaFXTopics.API);
    private final XBoxOneJavaFXController xBoxOneJavaFXController;
    private final JavaFXPlanarRegionsViewer planarRegionsViewer;
    @FXML
    private StepGeneratorParametersPaneController stepGeneratorParametersPaneController;

    public JoystickBasedSteppingMainUI(String robotName, Stage primaryStage, ROS2Node ros2Node, FullHumanoidRobotModelFactory fullRobotModelFactory, WalkingControllerParameters walkingControllerParameters, HumanoidRobotKickMessenger kickMessenger, HumanoidRobotPunchMessenger punchMessenger, RobotLowLevelMessenger lowLevelMessenger, SideDependentList<? extends ConvexPolygon2DReadOnly> footPolygons) throws Exception {
        this(robotName, primaryStage, ros2Node, null, fullRobotModelFactory, walkingControllerParameters, kickMessenger, punchMessenger, lowLevelMessenger, footPolygons);
    }

    public JoystickBasedSteppingMainUI(String robotName, Stage primaryStage, ROS2Node ros2Node, String workingDirectoryPath, FullHumanoidRobotModelFactory fullRobotModelFactory, WalkingControllerParameters walkingControllerParameters, HumanoidRobotKickMessenger kickMessenger, HumanoidRobotPunchMessenger punchMessenger, RobotLowLevelMessenger lowLevelMessenger, SideDependentList<? extends ConvexPolygon2DReadOnly> footPolygons) throws Exception {
        this.primaryStage = primaryStage;
        this.xBoxOneJavaFXController = new XBoxOneJavaFXController((Messager)this.messager);
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.getClass().getResource(this.getClass().getSimpleName() + ".fxml"));
        this.mainPane = (BorderPane)loader.load();
        View3DFactory view3dFactory = View3DFactory.createSubscene();
        this.setupSceneLighting(view3dFactory);
        FocusBasedCameraMouseEventHandler cameraController = view3dFactory.addCameraController(true);
        view3dFactory.addWorldCoordinateSystem(0.3);
        Pane subScene = view3dFactory.getSubSceneWrappedInsidePane();
        this.mainPane.setCenter((Node)subScene);
        this.robotVisualizer = new JavaFXRobotVisualizer(fullRobotModelFactory);
        ros2Node.createSubscription(HumanoidControllerAPI.getOutputTopic((String)robotName).withTypeName(RobotConfigurationData.class), s -> this.robotVisualizer.submitNewConfiguration((RobotConfigurationData)s.takeNextData()));
        view3dFactory.addNodeToView(this.robotVisualizer.getRootNode());
        this.planarRegionsViewer = new JavaFXPlanarRegionsViewer();
        ros2Node.createSubscription(REACommunicationProperties.outputTopic.withTypeName(PlanarRegionsListMessage.class), s -> this.planarRegionsViewer.submitPlanarRegions((PlanarRegionsListMessage)s.takeNextData()));
        view3dFactory.addNodeToView(this.planarRegionsViewer.getRootNode());
        final Translate rootJointOffset = new Translate();
        cameraController.prependTransform((Transform)rootJointOffset);
        this.cameraTracking = new AnimationTimer(){

            public void handle(long now) {
                FramePoint3D rootJointPosition = new FramePoint3D((ReferenceFrame)JoystickBasedSteppingMainUI.this.robotVisualizer.getFullRobotModel().getRootJoint().getFrameAfterJoint());
                rootJointPosition.changeFrame(ReferenceFrame.getWorldFrame());
                rootJointOffset.setX(rootJointPosition.getX());
                rootJointOffset.setY(rootJointPosition.getY());
                rootJointOffset.setZ(rootJointPosition.getZ());
            }
        };
        this.stepGeneratorJavaFXController = new StepGeneratorJavaFXController(robotName, this.messager, walkingControllerParameters, ros2Node, this.robotVisualizer, kickMessenger, punchMessenger, lowLevelMessenger, footPolygons);
        view3dFactory.addNodeToView(this.stepGeneratorJavaFXController.getRootNode());
        this.messager.startMessager();
        this.stepGeneratorParametersPaneController.initialize(this.messager, walkingControllerParameters, workingDirectoryPath);
        primaryStage.setTitle(this.getClass().getSimpleName());
        primaryStage.setScene(new Scene((Parent)this.mainPane, 800.0, 600.0));
        primaryStage.setOnCloseRequest(event -> this.stop());
        this.start();
    }

    public void createYoVariableServer(DataServerSettings settings, LogModelProvider modelProvider) {
        this.stepGeneratorJavaFXController.createYoVariableServer(settings, modelProvider);
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.robotVisualizer.getFullRobotModel();
    }

    private void setupSceneLighting(View3DFactory view3dFactory) {
        double ambientValue = 0.7;
        double pointValue = 0.2;
        double pointDistance = 1000.0;
        Color ambientColor = Color.color((double)ambientValue, (double)ambientValue, (double)ambientValue);
        view3dFactory.addNodeToView((Node)new AmbientLight(ambientColor));
        Color indoorColor = Color.color((double)pointValue, (double)pointValue, (double)pointValue);
        view3dFactory.addPointLight(pointDistance, pointDistance, pointDistance, indoorColor);
        view3dFactory.addPointLight(-pointDistance, pointDistance, pointDistance, indoorColor);
        view3dFactory.addPointLight(-pointDistance, -pointDistance, pointDistance, indoorColor);
        view3dFactory.addPointLight(pointDistance, -pointDistance, pointDistance, indoorColor);
    }

    public void setActiveSecondaryControlOption(StepGeneratorJavaFXController.SecondaryControlOption activeSecondaryControlOption) {
        this.stepGeneratorJavaFXController.setActiveSecondaryControlOption(activeSecondaryControlOption);
        this.stepGeneratorParametersPaneController.updateImageLayout(activeSecondaryControlOption);
    }

    public void start() throws IOException {
        this.primaryStage.show();
        this.robotVisualizer.start();
        this.stepGeneratorJavaFXController.start();
        this.cameraTracking.start();
        this.planarRegionsViewer.start();
    }

    public void stop() {
        try {
            this.messager.closeMessager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.xBoxOneJavaFXController.stop();
        this.robotVisualizer.stop();
        this.stepGeneratorJavaFXController.stop();
        this.stepGeneratorParametersPaneController.close();
        this.cameraTracking.stop();
        this.planarRegionsViewer.stop();
        ThreadTools.sleep((long)100L);
    }
}

