/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.joystickBasedJavaFXController;

import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import controller_msgs.msg.dds.FootstepStatusMessage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.avatar.joystickBasedJavaFXController.JoystickStepParametersProperty;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.ContinuousStepGenerator;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.DesiredTurningVelocityProvider;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.DesiredVelocityProvider;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootPoseProvider;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepMessenger;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.StopWalkingMessenger;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.footstepPlanning.graphSearch.collision.BoundingBoxCollisionDetector;
import us.ihmc.footstepPlanning.polygonSnapping.PlanarRegionsListPolygonSnapper;
import us.ihmc.footstepPlanning.simplePlanners.SnapAndWiggleSingleStep;
import us.ihmc.footstepPlanning.simplePlanners.SnapAndWiggleSingleStepParameters;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ContinuousStepController {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ContinuousStepGenerator continuousStepGenerator = new ContinuousStepGenerator(this.registry);
    private final YoDouble turningVelocity = new YoDouble("turningVelocity", this.registry);
    private final YoDouble forwardVelocity = new YoDouble("forwardVelocity", this.registry);
    private final YoDouble lateralVelocity = new YoDouble("lateralVelocity", this.registry);
    private final AtomicReference<FootstepDataListMessage> footstepsToSendReference = new AtomicReference<Object>(null);
    private final JoystickStepParametersProperty.JoystickStepParameters joystickStepParameters = new JoystickStepParametersProperty.JoystickStepParameters();
    private final YoBoolean isWalking = new YoBoolean("isWalking", this.registry);
    private final YoBoolean hasSuccessfullyStoppedWalking = new YoBoolean("hasSuccessfullyStoppedWalking", this.registry);
    private final YoBoolean isLeftFootInSupport = new YoBoolean("isLeftFootInSupport", this.registry);
    private final YoBoolean isRightFootInSupport = new YoBoolean("isRightFootInSupport", this.registry);
    private final SideDependentList<YoBoolean> isFootInSupport = new SideDependentList((Object)this.isLeftFootInSupport, (Object)this.isRightFootInSupport);
    private final BoundingBoxCollisionDetector collisionDetector;
    private final SteppingParameters steppingParameters;
    private final SnapAndWiggleSingleStepParameters snapAndWiggleParameters = new SnapAndWiggleSingleStepParameters();
    private final AtomicReference<PlanarRegionsList> planarRegionsList = new AtomicReference<Object>(null);
    private final SnapAndWiggleSingleStep snapAndWiggleSingleStep;
    private final SideDependentList<? extends ConvexPolygon2DReadOnly> footPolygons;
    private final ConvexPolygon2D footPolygonToWiggle = new ConvexPolygon2D();
    private boolean supportFootPosesInitialized = false;
    private final SideDependentList<FramePose3D> lastSupportFootPoses = new SideDependentList(null, null);
    private final AtomicReference<Boolean> walkingRequest = new AtomicReference<Object>(null);
    private StopWalkingMessenger stopWalkingMessenger;
    private FootPoseProvider footPoseProvider;
    private final ConvexPolygon2D footPolygon = new ConvexPolygon2D();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private final PlanarRegion tempRegion = new PlanarRegion();

    public ContinuousStepController(WalkingControllerParameters walkingControllerParameters) {
        this.steppingParameters = walkingControllerParameters.getSteppingParameters();
        this.snapAndWiggleParameters.setFootLength(walkingControllerParameters.getSteppingParameters().getFootLength());
        this.snapAndWiggleSingleStep = new SnapAndWiggleSingleStep(this.snapAndWiggleParameters);
        this.continuousStepGenerator.setNumberOfTicksBeforeSubmittingFootsteps(0);
        this.continuousStepGenerator.setNumberOfFootstepsToPlan(10);
        this.continuousStepGenerator.setWalkInputProvider((BooleanProvider)this.isWalking);
        this.continuousStepGenerator.setDesiredTurningVelocityProvider(new DesiredTurningVelocityProvider(){

            public double getTurningVelocity() {
                return ContinuousStepController.this.forwardVelocity.getValue() < -1.0E-10 ? -ContinuousStepController.this.turningVelocity.getValue() : ContinuousStepController.this.turningVelocity.getValue();
            }

            public boolean isUnitVelocity() {
                return true;
            }
        });
        this.continuousStepGenerator.setDesiredVelocityProvider(new DesiredVelocityProvider(){

            public Vector2DReadOnly getDesiredVelocity() {
                return new Vector2D(ContinuousStepController.this.forwardVelocity.getValue(), ContinuousStepController.this.lateralVelocity.getValue());
            }

            public boolean isUnitVelocity() {
                return true;
            }
        });
        this.continuousStepGenerator.configureWith(walkingControllerParameters);
        this.continuousStepGenerator.addFootstepAdjustment(this::adjustFootstep);
        this.continuousStepGenerator.setFootPoseProvider(robotSide -> (FramePose3DReadOnly)this.lastSupportFootPoses.get((Enum)robotSide));
        this.continuousStepGenerator.addFootstepValidityIndicator(this::isStepSnappable);
        this.continuousStepGenerator.addFootstepValidityIndicator(this::isSafeDistanceFromObstacle);
        this.continuousStepGenerator.addFootstepValidityIndicator(this::isSafeStepHeight);
        SteppingParameters steppingParameters = walkingControllerParameters.getSteppingParameters();
        double footLength = steppingParameters.getFootLength();
        double toeWidth = steppingParameters.getToeWidth();
        double footWidth = steppingParameters.getFootWidth();
        ConvexPolygon2D footPolygon = new ConvexPolygon2D();
        footPolygon.addVertex(footLength / 2.0, toeWidth / 2.0);
        footPolygon.addVertex(footLength / 2.0, -toeWidth / 2.0);
        footPolygon.addVertex(-footLength / 2.0, -footWidth / 2.0);
        footPolygon.addVertex(-footLength / 2.0, footWidth / 2.0);
        footPolygon.update();
        this.footPolygons = new SideDependentList((Object)footPolygon, (Object)footPolygon);
        double collisionBoxDepth = 0.65;
        double collisionBoxWidth = 1.15;
        double collisionBoxHeight = 1.0;
        this.collisionDetector = new BoundingBoxCollisionDetector();
        this.collisionDetector.setBoxDimensions(collisionBoxDepth, collisionBoxWidth, collisionBoxHeight);
    }

    public void setFootstepMessenger(FootstepMessenger footstepMessenger) {
        this.continuousStepGenerator.setFootstepMessenger(footstepMessenger);
    }

    public void setPauseWalkingPublisher(StopWalkingMessenger stopWalkingMessenger) {
        this.stopWalkingMessenger = stopWalkingMessenger;
        this.continuousStepGenerator.setStopWalkingMessenger(stopWalkingMessenger);
    }

    public void setFootPoseProviders(FootPoseProvider footPoseProvider) {
        this.footPoseProvider = footPoseProvider;
    }

    public void setContactState(boolean isLeftFootInSupport, boolean isRightFootInSupport) {
        this.isLeftFootInSupport.set(isLeftFootInSupport);
        this.isRightFootInSupport.set(isRightFootInSupport);
    }

    public void setJoystickStepParameters(JoystickStepParametersProperty.JoystickStepParameters parameters) {
        this.joystickStepParameters.set(parameters);
    }

    public JoystickStepParametersProperty.JoystickStepParameters getJoystickStepParameters() {
        return this.joystickStepParameters;
    }

    public boolean initialize() {
        if (this.supportFootPosesInitialized) {
            return true;
        }
        if (this.isLeftFootInSupport.getValue() && this.isRightFootInSupport.getValue()) {
            for (RobotSide robotSide : RobotSide.values) {
                if (this.footPoseProvider.getCurrentFootPose(robotSide) == null) {
                    return false;
                }
                FramePose3D footPose = new FramePose3D(this.footPoseProvider.getCurrentFootPose(robotSide));
                footPose.changeFrame(worldFrame);
                this.lastSupportFootPoses.put((Enum)robotSide, (Object)footPose);
            }
            this.supportFootPosesInitialized = true;
        }
        return this.supportFootPosesInitialized;
    }

    public void update() {
        if (!this.initialize()) {
            return;
        }
        for (RobotSide robotSide : RobotSide.values) {
            if (!((YoBoolean)this.isFootInSupport.get((Enum)robotSide)).getValue()) continue;
            FramePose3D footPose = new FramePose3D(this.footPoseProvider.getCurrentFootPose(robotSide));
            footPose.changeFrame(worldFrame);
            if (this.isWalking() && !(footPose.getZ() < ((FramePose3D)this.lastSupportFootPoses.get((Enum)robotSide)).getZ())) continue;
            this.lastSupportFootPoses.put((Enum)robotSide, (Object)footPose);
        }
        Boolean newWalkingRequest = this.walkingRequest.getAndSet(null);
        if (newWalkingRequest != null) {
            if (newWalkingRequest.booleanValue()) {
                this.startWalking(true);
            } else {
                this.stopWalking(true);
            }
        }
        this.continuousStepGenerator.setNumberOfFixedFootsteps(this.joystickStepParameters.getNumberOfFixedFootsteps());
        this.continuousStepGenerator.setFootstepTiming(this.joystickStepParameters.getSwingDuration(), this.joystickStepParameters.getTransferDuration());
        this.continuousStepGenerator.setStepTurningLimits(this.joystickStepParameters.getTurnMaxAngleInward(), this.joystickStepParameters.getTurnMaxAngleOutward());
        this.continuousStepGenerator.setStepWidths(this.joystickStepParameters.getDefaultStepWidth(), this.joystickStepParameters.getMinStepWidth(), this.joystickStepParameters.getMaxStepWidth());
        this.continuousStepGenerator.setMaxStepLength(this.joystickStepParameters.getMaxStepLength());
        this.continuousStepGenerator.update(Double.NaN);
        if (!this.isWalking.getValue()) {
            if (!this.hasSuccessfullyStoppedWalking.getValue()) {
                this.stopWalkingMessenger.submitStopWalkingRequest();
            } else {
                this.reset();
            }
        }
    }

    public void reset() {
        this.supportFootPosesInitialized = false;
        this.setContactState(false, false);
    }

    public boolean isInDoubleSupport() {
        return this.isLeftFootInSupport.getValue() && this.isRightFootInSupport.getValue();
    }

    public boolean isFootInSupport(RobotSide robotSide) {
        return ((YoBoolean)this.isFootInSupport.get((Enum)robotSide)).getValue();
    }

    public void submitWalkingRequest(Boolean request) {
        this.walkingRequest.set(request);
    }

    public void updateForwardVelocity(double alpha) {
        this.forwardVelocity.set(alpha);
    }

    public void updateLateralVelocity(double alpha) {
        this.lateralVelocity.set(alpha);
    }

    public void updateTurningVelocity(double alpha) {
        this.turningVelocity.set(alpha);
    }

    public void startWalking(boolean confirm) {
        if (confirm) {
            this.isWalking.set(true);
            this.hasSuccessfullyStoppedWalking.set(false);
        }
    }

    public void stopWalking(boolean confirm) {
        if (confirm) {
            this.isWalking.set(false);
            this.footstepsToSendReference.set(null);
        }
    }

    public void consumeFootstepStatus(FootstepStatusMessage footstepStatus) {
        this.continuousStepGenerator.consumeFootstepStatus(footstepStatus);
        if (footstepStatus.getFootstepStatus() == FootstepStatus.COMPLETED.toByte()) {
            this.lastSupportFootPoses.put((Enum)RobotSide.fromByte((byte)footstepStatus.getRobotSide()), (Object)new FramePose3D(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)footstepStatus.getActualFootPositionInWorld(), (Orientation3DReadOnly)footstepStatus.getActualFootOrientationInWorld()));
        }
    }

    public void consumePlanarRegionsListMessage(PlanarRegionsListMessage message) {
        if (message == null) {
            return;
        }
        PlanarRegionsList planarRegionsList = PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)message);
        this.snapAndWiggleSingleStep.setPlanarRegions(planarRegionsList);
        this.collisionDetector.setPlanarRegionsList(new PlanarRegionsList(planarRegionsList.getPlanarRegionsAsList().stream().filter(region -> region.getConvexHull().getArea() >= this.snapAndWiggleParameters.getMinPlanarRegionArea()).collect(Collectors.toList())));
        this.planarRegionsList.set(planarRegionsList);
    }

    public void updateControllerMotionStatus(RobotMotionStatus newStatus) {
        if (this.hasSuccessfullyStoppedWalking.getValue() || this.isWalking.getValue()) {
            return;
        }
        if (newStatus == null) {
            return;
        }
        if (newStatus != RobotMotionStatus.IN_MOTION) {
            this.hasSuccessfullyStoppedWalking.set(true);
        }
    }

    public boolean isWalking() {
        return this.isWalking.getValue();
    }

    public boolean hasSuccessfullyStoppedWalking() {
        return this.hasSuccessfullyStoppedWalking.getValue();
    }

    public void setupVisualization(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.continuousStepGenerator.setupVisualization(((ConvexPolygon2DReadOnly)this.footPolygons.get((Enum)RobotSide.LEFT)).getPolygonVerticesView(), ((ConvexPolygon2DReadOnly)this.footPolygons.get((Enum)RobotSide.RIGHT)).getPolygonVerticesView(), yoGraphicsListRegistry);
    }

    private boolean adjustFootstep(FramePose3DReadOnly stanceFootPose, FramePose2DReadOnly footstepPose, RobotSide footSide, FootstepDataMessage adjustedFootstep) {
        FramePose3D adjustedBasedOnStanceFoot = new FramePose3D();
        adjustedBasedOnStanceFoot.getPosition().set((FrameTuple2DReadOnly)footstepPose.getPosition());
        adjustedBasedOnStanceFoot.setZ(this.continuousStepGenerator.getCurrentSupportFootPose().getZ());
        adjustedBasedOnStanceFoot.getOrientation().set(footstepPose.getOrientation());
        if (this.planarRegionsList.get() != null) {
            FramePose3D wiggledPose = new FramePose3D((FramePose3DReadOnly)adjustedBasedOnStanceFoot);
            this.footPolygonToWiggle.set((Vertex2DSupplier)this.footPolygons.get((Enum)footSide));
            try {
                this.snapAndWiggleSingleStep.snapAndWiggle(wiggledPose, (ConvexPolygon2DReadOnly)this.footPolygonToWiggle, this.forwardVelocity.getValue() > 0.0);
                if (wiggledPose.containsNaN()) {
                    adjustedFootstep.getLocation().set((Tuple3DReadOnly)adjustedBasedOnStanceFoot.getPosition());
                    adjustedFootstep.getOrientation().set((QuaternionReadOnly)adjustedBasedOnStanceFoot.getOrientation());
                    return true;
                }
            }
            catch (SnapAndWiggleSingleStep.SnappingFailedException snappingFailedException) {
                // empty catch block
            }
            adjustedFootstep.getLocation().set((Tuple3DReadOnly)wiggledPose.getPosition());
            adjustedFootstep.getOrientation().set((QuaternionReadOnly)wiggledPose.getOrientation());
            return true;
        }
        adjustedFootstep.getLocation().set((Tuple3DReadOnly)adjustedBasedOnStanceFoot.getPosition());
        adjustedFootstep.getOrientation().set((QuaternionReadOnly)adjustedBasedOnStanceFoot.getOrientation());
        return true;
    }

    private boolean isSafeStepHeight(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        double heightChange = touchdownPose.getZ() - stancePose.getZ();
        return heightChange < this.steppingParameters.getMaxStepUp() && heightChange > -this.steppingParameters.getMaxStepDown();
    }

    private boolean isSafeDistanceFromObstacle(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        if (this.planarRegionsList.get() == null) {
            return true;
        }
        double halfStanceWidth = 0.5 * this.steppingParameters.getInPlaceWidth();
        double heightOffset = this.steppingParameters.getMaxStepUp();
        double soleYaw = touchdownPose.getYaw();
        double lateralOffset = swingSide.negateIfLeftSide(halfStanceWidth);
        double offsetX = -lateralOffset * Math.sin(soleYaw);
        double offsetY = lateralOffset * Math.cos(soleYaw);
        this.collisionDetector.setBoxPose(touchdownPose.getX() + offsetX, touchdownPose.getY() + offsetY, touchdownPose.getZ() + heightOffset, soleYaw);
        return !this.collisionDetector.checkForCollision().isCollisionDetected();
    }

    private boolean isStepSnappable(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        if (this.planarRegionsList.get() == null) {
            return true;
        }
        this.tempTransform.getTranslation().set(touchdownPose.getPosition().getX(), touchdownPose.getPosition().getY(), 0.0);
        this.tempTransform.getRotation().setToYawOrientation(touchdownPose.getYaw());
        this.footPolygon.set((Vertex2DSupplier)this.footPolygons.get((Enum)swingSide));
        this.footPolygon.applyTransform((Transform)this.tempTransform, false);
        PlanarRegionsList planarRegionsList = this.planarRegionsList.get();
        return PlanarRegionsListPolygonSnapper.snapPolygonToPlanarRegionsList((ConvexPolygon2DReadOnly)this.footPolygon, (PlanarRegionsList)planarRegionsList, (double)Double.POSITIVE_INFINITY, (PlanarRegion)this.tempRegion) != null;
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }
}

