/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.inverseKinematics;

import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.MultiBodySystemMissingTools;
import us.ihmc.robotics.kinematics.DdoglegInverseKinematicsCalculator;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.screwTheory.GeometricJacobian;

public class DDogLegArmIKSolver {
    private static final int INVERSE_KINEMATICS_CALCULATIONS_PER_UPDATE = 5;
    private final FullHumanoidRobotModel desiredRobot;
    private final ReferenceFrame handControlDesiredFrame;
    private final GeometricJacobian actualArmJacobian;
    private final GeometricJacobian workArmJacobian;
    private final GeometricJacobian desiredArmJacobian;
    private final DdoglegInverseKinematicsCalculator inverseKinematicsCalculator;
    private final Point3D handCenterOfMassInControlFrame;
    private final FramePose3D desiredHandCoMPose = new FramePose3D();
    private final FramePose3D lastDesiredHandCoMPose = new FramePose3D();
    private boolean ikFoundASolution = false;

    public DDogLegArmIKSolver(RobotSide side, DRCRobotModel robotModel, FullHumanoidRobotModel actualRobot, FullHumanoidRobotModel desiredRobot, ReferenceFrame handControlDesiredFrame) {
        this.desiredRobot = desiredRobot;
        this.handControlDesiredFrame = handControlDesiredFrame;
        this.handCenterOfMassInControlFrame = FullRobotModelUtils.getHandCenterOfMassInControlFrame((FullHumanoidRobotModel)actualRobot, (RobotSide)side, (RigidBodyTransform)robotModel.getJointMap().getHandControlFrameToWristTransform(side));
        FullHumanoidRobotModel workingRobot = robotModel.createFullRobotModel();
        this.actualArmJacobian = new GeometricJacobian(actualRobot.getChest(), actualRobot.getHand(side), (ReferenceFrame)actualRobot.getHand(side).getBodyFixedFrame());
        this.desiredArmJacobian = new GeometricJacobian(desiredRobot.getChest(), desiredRobot.getHand(side), (ReferenceFrame)desiredRobot.getHand(side).getBodyFixedFrame());
        this.workArmJacobian = new GeometricJacobian(workingRobot.getChest(), workingRobot.getHand(side), (ReferenceFrame)workingRobot.getHand(side).getBodyFixedFrame());
        double convergeTolerance = 4.0E-6;
        double parameterChangePenalty = 0.1;
        double positionCost = 1.0;
        double orientationCost = 0.2;
        int maxIterations = 500;
        boolean solveOrientation = true;
        double toleranceForPositionError = 0.005;
        double toleranceForOrientationError = 0.02;
        this.inverseKinematicsCalculator = new DdoglegInverseKinematicsCalculator(this.workArmJacobian, positionCost, orientationCost, maxIterations, solveOrientation, convergeTolerance, toleranceForPositionError, toleranceForOrientationError, parameterChangePenalty);
    }

    public void update() {
        this.desiredArmJacobian.compute();
        this.actualArmJacobian.compute();
        this.desiredHandCoMPose.setToZero(this.handControlDesiredFrame);
        this.desiredHandCoMPose.getPosition().add((Tuple3DReadOnly)this.handCenterOfMassInControlFrame);
        this.desiredHandCoMPose.changeFrame((ReferenceFrame)this.desiredRobot.getChest().getBodyFixedFrame());
    }

    public boolean getDesiredHandControlPoseChanged() {
        boolean desiredHandControlPoseChanged = !this.desiredHandCoMPose.geometricallyEquals((EuclidFrameGeometry)this.lastDesiredHandCoMPose, 1.0E-4);
        this.lastDesiredHandCoMPose.setIncludingFrame((FramePose3DReadOnly)this.desiredHandCoMPose);
        return desiredHandControlPoseChanged;
    }

    public void copyActualToWork() {
        MultiBodySystemMissingTools.copyOneDoFJointsConfiguration((JointBasics[])this.actualArmJacobian.getJointsInOrder(), (JointBasics[])this.workArmJacobian.getJointsInOrder());
    }

    public void solve() {
        this.workArmJacobian.compute();
        this.ikFoundASolution = false;
        for (int i = 0; i < 5 && !this.ikFoundASolution; ++i) {
            this.ikFoundASolution = this.inverseKinematicsCalculator.solve((RigidBodyTransformReadOnly)this.desiredHandCoMPose);
        }
    }

    public void copyWorkToDesired() {
        MultiBodySystemMissingTools.copyOneDoFJointsConfiguration((JointBasics[])this.workArmJacobian.getJointsInOrder(), (JointBasics[])this.desiredArmJacobian.getJointsInOrder());
    }

    public void setDesiredToCurrent() {
        MultiBodySystemMissingTools.copyOneDoFJointsConfiguration((JointBasics[])this.actualArmJacobian.getJointsInOrder(), (JointBasics[])this.desiredArmJacobian.getJointsInOrder());
    }
}

