/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.inverseKinematics;

import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.DefaultPIDSE3Gains;
import us.ihmc.robotics.geometry.FramePose3DChangedTracker;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;

public class ArmIKSolverControlledBody {
    public static final double DEFAULT_POSITION_GAIN = 1200.0;
    public static final double DEFAULT_POSITION_WEIGHT = 20.0;
    public static final double DEFAULT_ORIENTATION_GAIN = 100.0;
    public static final double DEFAULT_ORIENTATION_WEIGHT = 1.0;
    private final RigidBodyBasics workRootBody;
    private final RigidBodyBasics workBody;
    private final SpatialFeedbackControlCommand spatialFeedbackControlCommand = new SpatialFeedbackControlCommand();
    private final SpatialVelocityCommand spatialVelocityCommand = new SpatialVelocityCommand();
    private final DefaultPIDSE3Gains gains = new DefaultPIDSE3Gains();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    private final WeightMatrix6D weightMatrix = new WeightMatrix6D();
    private final FramePose3D bodyControlDesiredPose = new FramePose3D();
    private final FramePose3D lastBodyControlDesiredPose = new FramePose3D();
    private final RigidBodyTransform bodyControlDesiredPoseToRootCoMTransform = new RigidBodyTransform();
    private final SpatialVectorReadOnly zeroVector6D = new SpatialVector();
    private final FramePose3D bodyControlFramePose = new FramePose3D();
    private final FrameVector3D bodyDesiredAngularVelocity = new FrameVector3D();
    private final FrameVector3D bodyDesiredLinearVelocity = new FrameVector3D();
    private final FramePose3DChangedTracker controlPoseChangedTracker = new FramePose3DChangedTracker((FramePose3DReadOnly)this.bodyControlDesiredPose);

    public static ArmIKSolverControlledBody createHand(RigidBodyBasics workRootBody, FullHumanoidRobotModel sourceFullRobotModel, HumanoidJointNameMap jointNameMap, RobotSide side) {
        return new ArmIKSolverControlledBody(workRootBody, sourceFullRobotModel.getHandControlFrame(side), sourceFullRobotModel.getHand(side), jointNameMap.getHandName(side));
    }

    public static ArmIKSolverControlledBody createFoot(RigidBodyBasics workRootBody, FullHumanoidRobotModel sourceFullRobotModel, HumanoidJointNameMap jointNameMap, RobotSide side) {
        return new ArmIKSolverControlledBody(workRootBody, sourceFullRobotModel.getSoleFrame((Enum)side), sourceFullRobotModel.getFoot((Enum)side), jointNameMap.getFootName(side));
    }

    public static ArmIKSolverControlledBody createChest(RigidBodyBasics workRootBody, FullHumanoidRobotModel sourceFullRobotModel, HumanoidJointNameMap jointNameMap) {
        return new ArmIKSolverControlledBody(workRootBody, sourceFullRobotModel.getChest().getParentJoint().getFrameAfterJoint(), sourceFullRobotModel.getChest(), jointNameMap.getChestName());
    }

    public static ArmIKSolverControlledBody createPelvis(RigidBodyBasics workRootBody, FullHumanoidRobotModel sourceFullRobotModel, HumanoidJointNameMap jointNameMap) {
        return new ArmIKSolverControlledBody(workRootBody, sourceFullRobotModel.getPelvis().getParentJoint().getFrameAfterJoint(), sourceFullRobotModel.getPelvis(), jointNameMap.getPelvisName());
    }

    private ArmIKSolverControlledBody(RigidBodyBasics workRootBody, MovingReferenceFrame sourceBodyControlFrame, RigidBodyBasics sourceBody, String controlledBodyName) {
        this.workRootBody = workRootBody;
        this.workBody = MultiBodySystemTools.findRigidBody((RigidBodyBasics)workRootBody, (String)controlledBodyName);
        FramePose3D sourceControlFramePose = new FramePose3D((ReferenceFrame)sourceBodyControlFrame);
        sourceControlFramePose.changeFrame((ReferenceFrame)sourceBody.getBodyFixedFrame());
        this.bodyControlFramePose.setIncludingFrame((ReferenceFrame)this.workBody.getBodyFixedFrame(), (Pose3DReadOnly)sourceControlFramePose);
        this.gains.setPositionProportionalGains(1200.0);
        this.gains.setOrientationProportionalGains(100.0);
        this.weightMatrix.setLinearWeights(20.0, 20.0, 20.0);
        this.weightMatrix.setAngularWeights(1.0, 1.0, 1.0);
        this.selectionMatrix.resetSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDesiredPose(ReferenceFrame rootBodyFrame, ReferenceFrame bodyControlDesiredFrame) {
        FramePose3D framePose3D = this.bodyControlDesiredPose;
        synchronized (framePose3D) {
            this.bodyControlDesiredPose.setToZero(bodyControlDesiredFrame);
            this.bodyControlDesiredPose.changeFrame(rootBodyFrame);
            this.bodyControlDesiredPose.get((RigidBodyTransformBasics)this.bodyControlDesiredPoseToRootCoMTransform);
            this.workRootBody.getBodyFixedFrame().getTransformToParent().transform((RigidBodyTransformBasics)this.bodyControlDesiredPoseToRootCoMTransform);
            this.bodyControlDesiredPose.setToZero(ReferenceFrame.getWorldFrame());
            this.bodyControlDesiredPose.set((RigidBodyTransformReadOnly)this.bodyControlDesiredPoseToRootCoMTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDesiredVelocity(FrameVector3DReadOnly bodyDesiredAngularVelocityReadOnly, FrameVector3DReadOnly bodyDesiredLinearVelocityReadOnly) {
        FrameVector3D frameVector3D = this.bodyDesiredAngularVelocity;
        synchronized (frameVector3D) {
            this.bodyDesiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)bodyDesiredAngularVelocityReadOnly);
            this.bodyDesiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)bodyDesiredLinearVelocityReadOnly);
            this.bodyDesiredAngularVelocity.changeFrame((ReferenceFrame)this.workBody.getBodyFixedFrame());
            this.bodyDesiredLinearVelocity.changeFrame((ReferenceFrame)this.workBody.getBodyFixedFrame());
        }
    }

    public boolean getDesiredBodyControlPoseChanged() {
        return this.controlPoseChangedTracker.hasChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpatialFeedbackControlCommand buildSpatialFeedbackControlCommand() {
        this.spatialFeedbackControlCommand.set(this.workRootBody, this.workBody);
        this.spatialFeedbackControlCommand.setGains((PIDSE3GainsReadOnly)this.gains);
        this.spatialFeedbackControlCommand.setSelectionMatrix(this.selectionMatrix);
        this.spatialFeedbackControlCommand.setWeightMatrixForSolver(this.weightMatrix);
        FramePose3D framePose3D = this.bodyControlDesiredPose;
        synchronized (framePose3D) {
            this.spatialFeedbackControlCommand.setInverseKinematics((FramePose3DReadOnly)this.bodyControlDesiredPose, this.zeroVector6D);
        }
        this.spatialFeedbackControlCommand.setControlFrameFixedInEndEffector((FramePose3DReadOnly)this.bodyControlFramePose);
        return this.spatialFeedbackControlCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpatialVelocityCommand buildSpatialVelocityCommand() {
        this.spatialVelocityCommand.set(this.workRootBody, this.workBody);
        this.spatialVelocityCommand.setSelectionMatrix(this.selectionMatrix);
        this.spatialVelocityCommand.setWeightMatrix(this.weightMatrix);
        FrameVector3D frameVector3D = this.bodyDesiredAngularVelocity;
        synchronized (frameVector3D) {
            this.spatialVelocityCommand.setSpatialVelocity((ReferenceFrame)this.workBody.getBodyFixedFrame(), (FrameVector3DReadOnly)this.bodyDesiredAngularVelocity, (FrameVector3DReadOnly)this.bodyDesiredLinearVelocity);
        }
        return this.spatialVelocityCommand;
    }

    public RigidBodyBasics getWorkBody() {
        return this.workBody;
    }

    public void reset() {
        this.controlPoseChangedTracker.markAsChanged();
    }
}

