/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.inverseKinematics;

import us.ihmc.avatar.inverseKinematics.ArmIKSolverControlledBody;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsSolutionQualityCalculator;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxOptimizationSettings;
import us.ihmc.commonWalkingControlModules.configurations.JointPrivilegedConfigurationParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerDataHolderReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerTemplate;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCore;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandInterface;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutput;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointTorqueMinimizationWeightCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointTorqueSoftLimitWeightCalculator;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.MultiBodySystemMissingTools;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ArmIKSolver {
    public static final double CONTROL_DT = 0.001;
    public static final double GRAVITY = 9.81;
    public static final double GOOD_QUALITY_MAX = 1.0;
    private static final int INVERSE_KINEMATICS_CALCULATIONS_PER_UPDATE = 70;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final RigidBodyBasics workChest;
    private final ArmIKSolverControlledBody hand;
    private final KinematicsToolboxOptimizationSettings optimizationSettings = new KinematicsToolboxOptimizationSettings();
    private final InverseKinematicsOptimizationSettingsCommand activeOptimizationSettings = new InverseKinematicsOptimizationSettingsCommand();
    private final WholeBodyControllerCore controllerCore;
    private final ControllerCoreCommand controllerCoreCommand = new ControllerCoreCommand();
    private final OneDoFJointBasics[] sourceOneDoFJoints;
    private final OneDoFJointBasics[] workingOneDoFJoints;
    private final KinematicsSolutionQualityCalculator solutionQualityCalculator = new KinematicsSolutionQualityCalculator();
    private final FeedbackControllerDataHolderReadOnly feedbackControllerDataHolder;
    private double quality;

    public ArmIKSolver(RobotSide side, HumanoidJointNameMap jointNameMap, FullHumanoidRobotModel sourceFullRobotModel) {
        ArmJointName[] armJointNames = jointNameMap.getArmJointNames(side);
        this.sourceOneDoFJoints = FullRobotModelUtils.getArmJoints((FullHumanoidRobotModel)sourceFullRobotModel, (RobotSide)side, (ArmJointName[])armJointNames);
        OneDoFJointBasics sourceFirstArmJoint = sourceFullRobotModel.getArmJoint(side, jointNameMap.getArmJointNames()[0]);
        this.workChest = MultiBodySystemMissingTools.getDetachedCopyOfSubtree((RigidBodyBasics)sourceFullRobotModel.getChest(), (ReferenceFrame)ReferenceFrame.getWorldFrame(), (OneDoFJointBasics)sourceFirstArmJoint, (String)sourceFullRobotModel.getHand(side).getName());
        this.hand = ArmIKSolverControlledBody.createHand(this.workChest, sourceFullRobotModel, jointNameMap, side);
        this.hand.getWorkBody().getChildrenJoints().clear();
        this.workingOneDoFJoints = (OneDoFJointBasics[])MultiBodySystemMissingTools.getSubtreeJointArray(OneDoFJointBasics.class, (RigidBodyReadOnly)this.workChest);
        FloatingJointBasics rootSixDoFJoint = null;
        ReferenceFrame centerOfMassFrame = null;
        YoGraphicsListRegistry yoGraphicsListRegistry = null;
        WholeBodyControlCoreToolbox toolbox = new WholeBodyControlCoreToolbox(0.001, 9.81, rootSixDoFJoint, (JointBasics[])this.workingOneDoFJoints, centerOfMassFrame, (ControllerCoreOptimizationSettings)this.optimizationSettings, yoGraphicsListRegistry, this.registry);
        JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters = new JointPrivilegedConfigurationParameters();
        toolbox.setJointPrivilegedConfigurationParameters(jointPrivilegedConfigurationParameters);
        JointTorqueSoftLimitWeightCalculator jointTorqueMinimizationWeightCalculator = new JointTorqueSoftLimitWeightCalculator(toolbox.getJointIndexHandler());
        jointTorqueMinimizationWeightCalculator.setParameters(0.0, 0.001, 0.1);
        toolbox.setupForInverseKinematicsSolver((JointTorqueMinimizationWeightCalculator)jointTorqueMinimizationWeightCalculator);
        FeedbackControllerTemplate controllerCoreTemplate = new FeedbackControllerTemplate();
        controllerCoreTemplate.setAllowDynamicControllerConstruction(true);
        JointDesiredOutputList lowLevelControllerOutput = new JointDesiredOutputList((OneDoFJointReadOnly[])this.workingOneDoFJoints);
        this.controllerCore = new WholeBodyControllerCore(toolbox, controllerCoreTemplate, lowLevelControllerOutput, this.registry);
        this.feedbackControllerDataHolder = this.controllerCore.getWholeBodyFeedbackControllerDataHolder();
        this.controllerCoreCommand.setControllerCoreMode(WholeBodyControllerCoreMode.INVERSE_KINEMATICS);
    }

    public void copySourceToWork() {
        MultiBodySystemMissingTools.copyOneDoFJointsConfiguration((JointBasics[])this.sourceOneDoFJoints, (JointBasics[])this.workingOneDoFJoints);
    }

    public void update(ReferenceFrame chestFrame, ReferenceFrame handControlDesiredFrame) {
        this.hand.updateDesiredPose(chestFrame, handControlDesiredFrame);
    }

    public boolean getDesiredHandControlPoseChanged() {
        return this.hand.getDesiredBodyControlPoseChanged();
    }

    public void solve() {
        this.copySourceToWork();
        this.workChest.updateFramesRecursively();
        SpatialFeedbackControlCommand spatialFeedbackControlCommand = this.hand.buildSpatialFeedbackControlCommand();
        for (int i = 0; i < 70; ++i) {
            this.controllerCoreCommand.clear();
            this.controllerCoreCommand.addInverseKinematicsCommand((InverseKinematicsCommand)this.activeOptimizationSettings);
            this.controllerCoreCommand.addFeedbackControlCommand((FeedbackControlCommand)spatialFeedbackControlCommand);
            this.controllerCore.compute((ControllerCoreCommandInterface)this.controllerCoreCommand);
            ControllerCoreOutput controllerCoreOutput = this.controllerCore.getControllerCoreOutput();
            JointDesiredOutputListBasics output = controllerCoreOutput.getLowLevelOneDoFJointDesiredDataHolder();
            boolean jointIsMoving = false;
            for (int j = 0; j < this.workingOneDoFJoints.length; ++j) {
                double integratedPosition;
                if (!output.hasDataForJoint((OneDoFJointReadOnly)this.workingOneDoFJoints[j])) continue;
                JointDesiredOutputReadOnly jointDesiredOutput = output.getJointDesiredOutput((OneDoFJointReadOnly)this.workingOneDoFJoints[j]);
                double desiredVelocity = jointDesiredOutput.getDesiredVelocity();
                if (Math.abs(desiredVelocity) > 0.001) {
                    jointIsMoving = true;
                }
                if (AngleTools.computeAngleDifferenceMinusPiToPi((double)(integratedPosition = this.workingOneDoFJoints[j].getQ() + 0.001 * desiredVelocity), (double)jointDesiredOutput.getDesiredPosition()) > Math.toRadians(45.0)) {
                    integratedPosition = jointDesiredOutput.getDesiredPosition();
                }
                this.workingOneDoFJoints[j].setQ(integratedPosition);
                this.workingOneDoFJoints[j].setQd(desiredVelocity);
                if (!jointDesiredOutput.hasDesiredTorque()) continue;
                this.workingOneDoFJoints[j].setTau(jointDesiredOutput.getDesiredTorque());
            }
            if (!jointIsMoving) break;
            this.workChest.updateFramesRecursively();
        }
        double totalRobotMass = 0.0;
        this.quality = this.solutionQualityCalculator.calculateSolutionQuality(this.feedbackControllerDataHolder, totalRobotMass, 1.0);
        if (this.quality > 1.0) {
            LogTools.debug((String)"Bad quality solution: {} Try upping the gains, giving more iteration, or setting a more acheivable goal.", (Object)this.quality);
        }
    }

    public void solve(FrameVector3DReadOnly desiredAngularVelocity, FrameVector3DReadOnly desiredLinearVelocity) {
        this.solve();
        this.hand.updateDesiredVelocity(desiredAngularVelocity, desiredLinearVelocity);
        SpatialVelocityCommand spatialVelocityCommand = this.hand.buildSpatialVelocityCommand();
        this.controllerCoreCommand.clear();
        this.controllerCoreCommand.addInverseKinematicsCommand((InverseKinematicsCommand)this.activeOptimizationSettings);
        this.controllerCoreCommand.addInverseKinematicsCommand((InverseKinematicsCommand)spatialVelocityCommand);
        this.controllerCore.compute((ControllerCoreCommandInterface)this.controllerCoreCommand);
        ControllerCoreOutput controllerCoreOutput = this.controllerCore.getControllerCoreOutput();
        JointDesiredOutputListBasics output = controllerCoreOutput.getLowLevelOneDoFJointDesiredDataHolder();
        for (int j = 0; j < this.workingOneDoFJoints.length; ++j) {
            if (!output.hasDataForJoint((OneDoFJointReadOnly)this.workingOneDoFJoints[j])) continue;
            JointDesiredOutputReadOnly jointDesiredOutput = output.getJointDesiredOutput((OneDoFJointReadOnly)this.workingOneDoFJoints[j]);
            double desiredVelocity = jointDesiredOutput.getDesiredVelocity();
            this.workingOneDoFJoints[j].setQd(desiredVelocity);
            if (!jointDesiredOutput.hasDesiredTorque()) continue;
            this.workingOneDoFJoints[j].setTau(jointDesiredOutput.getDesiredTorque());
        }
    }

    public double getQuality() {
        return this.quality;
    }

    public OneDoFJointBasics[] getSolutionOneDoFJoints() {
        return this.workingOneDoFJoints;
    }

    public void reset() {
        this.hand.reset();
    }
}

