/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.initialSetup;

import java.util.HashMap;
import java.util.Map;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.OneDoFJointState;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;

public class HumanoidRobotInitialSetup
implements RobotInitialSetup<HumanoidFloatingRootJointRobot> {
    protected double initialYaw = 0.0;
    protected double initialGroundHeight = 0.0;
    protected final Vector3D additionalOffset = new Vector3D();
    protected final Point3D rootJointPosition = new Point3D();
    protected final Quaternion rootJointOrientation = new Quaternion();
    protected final Vector3D rootJointAngularVelocityInBody = new Vector3D();
    protected final Vector3D rootJointLinearVelocityInWorld = new Vector3D();
    protected final Map<String, Double> jointPositions = new HashMap<String, Double>();
    protected final HumanoidJointNameMap jointMap;

    public HumanoidRobotInitialSetup(HumanoidJointNameMap jointMap) {
        this.jointMap = jointMap;
    }

    public void setJoint(RobotSide robotSide, LegJointName legJointName, double q) {
        String jointName = this.jointMap.getLegJointName(robotSide, legJointName);
        if (jointName != null) {
            this.setJoint(jointName, q);
        }
    }

    public void setJoint(RobotSide robotSide, ArmJointName armJointName, double q) {
        String jointName = this.jointMap.getArmJointName(robotSide, armJointName);
        if (jointName != null) {
            this.setJoint(jointName, q);
        }
    }

    public void setJoint(SpineJointName spineJointName, double q) {
        String jointName = this.jointMap.getSpineJointName(spineJointName);
        if (jointName != null) {
            this.setJoint(jointName, q);
        }
    }

    public void setJoint(NeckJointName neckJointName, double q) {
        String jointName = this.jointMap.getNeckJointName(neckJointName);
        if (jointName != null) {
            this.setJoint(jointName, q);
        }
    }

    public void setJoint(String jointName, double q) {
        this.jointPositions.put(jointName, q);
    }

    public double getHeightOfPelvisAboveLowestSoleZ(RobotDefinition robotDefinition) {
        RigidBodyBasics rootBody = robotDefinition.newInstance(ReferenceFrameTools.constructARootFrame((String)"temp"));
        this.initializeRobot(rootBody, false);
        rootBody.updateFramesRecursively();
        double pelvisToLowestSoleZ = Double.NEGATIVE_INFINITY;
        RigidBodyTransform tempAnkleFrameToTempRootFrame = new RigidBodyTransform();
        RigidBodyTransform tempSoleFrameToTempRootFrame = new RigidBodyTransform();
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot = MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)this.jointMap.getFootName(robotSide));
            if (foot == null) continue;
            tempAnkleFrameToTempRootFrame.set(foot.getParentJoint().getFrameAfterJoint().getTransformToRoot());
            tempSoleFrameToTempRootFrame.set(tempAnkleFrameToTempRootFrame);
            tempSoleFrameToTempRootFrame.multiply((RigidBodyTransformReadOnly)this.jointMap.getSoleToParentFrameTransform((Enum)robotSide));
            double pelvisToSoleZ = -tempSoleFrameToTempRootFrame.getTranslationZ();
            pelvisToLowestSoleZ = Math.max(pelvisToSoleZ, pelvisToLowestSoleZ);
        }
        return pelvisToLowestSoleZ;
    }

    public void setRootJointHeightSuchThatLowestSoleIsAtZero(RobotDefinition robotDefinition) {
        double farthestSoleToPelvisDistance = this.getHeightOfPelvisAboveLowestSoleZ(robotDefinition);
        if (Double.isFinite(farthestSoleToPelvisDistance)) {
            this.rootJointPosition.setZ(farthestSoleToPelvisDistance);
        }
    }

    @Override
    public void initializeRobot(HumanoidFloatingRootJointRobot robot) {
        for (OneDegreeOfFreedomJoint joint : robot.getOneDegreeOfFreedomJoints()) {
            Double jointPosition = this.getJointPosition(joint.getName());
            if (jointPosition == null) continue;
            joint.setQ(jointPosition.doubleValue());
        }
        robot.getRootJoint().getPosition().set((Tuple3DReadOnly)this.rootJointPosition);
        robot.getRootJoint().getPosition().add((Tuple3DReadOnly)this.additionalOffset);
        robot.getRootJoint().getPosition().addZ(this.initialGroundHeight);
        robot.getRootJoint().setOrientation((Orientation3DReadOnly)this.rootJointOrientation);
        robot.getRootJoint().getOrientation().prependYawRotation(this.initialYaw);
        robot.getRootJoint().setVelocity((Tuple3DReadOnly)this.rootJointLinearVelocityInWorld);
        robot.getRootJoint().setAngularVelocityInBody((Vector3DReadOnly)this.rootJointAngularVelocityInBody);
        robot.update();
    }

    @Override
    public void initializeFullRobotModel(FullHumanoidRobotModel fullRobotModel) {
        this.initializeRobot(fullRobotModel.getElevator());
    }

    @Override
    public void initializeRobot(RigidBodyBasics rootBody) {
        this.initializeRobot(rootBody, true);
    }

    private void initializeRobot(RigidBodyBasics rootBody, boolean applyRootJointPose) {
        Pose3DBasics jointPose;
        FloatingJointBasics floatingJoint;
        JointBasics rootJoint;
        for (JointBasics joint : rootBody.childrenSubtreeIterable()) {
            Double jointPosition;
            if (!(joint instanceof OneDoFJointBasics) || (jointPosition = this.getJointPosition(joint.getName())) == null) continue;
            ((OneDoFJointBasics)joint).setQ(jointPosition.doubleValue());
        }
        if (applyRootJointPose && rootBody.getChildrenJoints().size() == 1 && (rootJoint = (JointBasics)rootBody.getChildrenJoints().get(0)) instanceof FloatingJointBasics) {
            floatingJoint = (FloatingJointBasics)rootJoint;
            jointPose = floatingJoint.getJointPose();
            jointPose.getPosition().set((Tuple3DReadOnly)this.rootJointPosition);
            jointPose.getPosition().add((Tuple3DReadOnly)this.additionalOffset);
            jointPose.getPosition().addZ(this.initialGroundHeight);
            jointPose.getOrientation().set((QuaternionReadOnly)this.rootJointOrientation);
            jointPose.getOrientation().prependYawRotation(this.initialYaw);
        }
        if (rootBody.getChildrenJoints().size() == 1 && (rootJoint = (JointBasics)rootBody.getChildrenJoints().get(0)) instanceof FloatingJointBasics) {
            floatingJoint = (FloatingJointBasics)rootJoint;
            jointPose = floatingJoint.getJointPose();
            FixedFrameTwistBasics jointTwist = floatingJoint.getJointTwist();
            jointTwist.getAngularPart().set((Tuple3DReadOnly)this.rootJointAngularVelocityInBody);
            jointPose.getOrientation().inverseTransform((Tuple3DReadOnly)this.rootJointLinearVelocityInWorld, (Tuple3DBasics)jointTwist.getLinearPart());
        }
    }

    @Override
    public void initializeRobotDefinition(RobotDefinition robotDefinition) {
        SixDoFJointDefinition rootJoint = robotDefinition.getFloatingRootJointDefinition();
        if (rootJoint != null) {
            Point3D position = new Point3D((Tuple3DReadOnly)this.rootJointPosition);
            position.add((Tuple3DReadOnly)this.additionalOffset);
            position.addZ(this.initialGroundHeight);
            Quaternion orientation = new Quaternion((QuaternionReadOnly)this.rootJointOrientation);
            orientation.prependYawRotation(this.initialYaw);
            SixDoFJointState rootJointState = new SixDoFJointState((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position);
            rootJointState.setVelocity(EuclidCoreTools.zeroVector3D, EuclidCoreTools.zeroVector3D);
            rootJointState.setAcceleration(EuclidCoreTools.zeroVector3D, EuclidCoreTools.zeroVector3D);
            rootJoint.setInitialJointState(rootJointState);
        }
        robotDefinition.forEachOneDoFJointDefinition(jointDefinition -> {
            Double jointPosition = this.getJointPosition(jointDefinition.getName());
            if (jointPosition != null) {
                jointDefinition.setInitialJointState(new OneDoFJointState(jointPosition.doubleValue(), 0.0, 0.0));
            } else {
                jointDefinition.setInitialJointState(new OneDoFJointState(0.0, 0.0, 0.0));
            }
        });
    }

    @Override
    public void setInitialYaw(double yaw) {
        this.initialYaw = yaw;
    }

    @Override
    public double getInitialYaw() {
        return this.initialYaw;
    }

    @Override
    public void setInitialGroundHeight(double groundHeight) {
        this.initialGroundHeight = groundHeight;
    }

    @Override
    public double getInitialGroundHeight() {
        return this.initialGroundHeight;
    }

    @Override
    public void setOffset(Tuple3DReadOnly additionalOffset) {
        this.additionalOffset.set(additionalOffset);
    }

    public Vector3D getOffset() {
        return this.additionalOffset;
    }

    public Double getJointPosition(String jointName) {
        return this.jointPositions.get(jointName);
    }

    public boolean hasJointPosition(String jointName) {
        return this.jointPositions.containsKey(jointName);
    }

    public Map<String, Double> getJointPositions() {
        return this.jointPositions;
    }

    public Point3D getRootJointPosition() {
        return this.rootJointPosition;
    }

    public Quaternion getRootJointOrientation() {
        return this.rootJointOrientation;
    }

    public Vector3D getRootJointAngularVelocityInBody() {
        return this.rootJointAngularVelocityInBody;
    }

    public Vector3D getRootJointLinearVelocityInWorld() {
        return this.rootJointLinearVelocityInWorld;
    }

    public HumanoidJointNameMap getJointMap() {
        return this.jointMap;
    }
}

