/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.initialSetup;

import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationconstructionset.DynamicIntegrationMethod;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.LinearGroundContactModel;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;
import us.ihmc.wholeBodyController.RobotContactPointParameters;

public class DRCSCSInitialSetup {
    private static final boolean SHOW_WORLD_COORDINATE_FRAME = false;
    private final double simulateDT;
    private int recordFrequency = 50;
    private boolean drawGroundProfile = false;
    private boolean enableGroundSlipping = false;
    private double groundAlphaStick = Double.NaN;
    private double groundAlphaSlip = Double.NaN;
    private int simulationDataBufferSize = 16000;
    private Vector3D gravity = new Vector3D(0.0, 0.0, -9.81);
    private boolean runMultiThreaded = true;
    private boolean usePerfectSensors = false;
    private boolean initializeEstimatorToActual = false;
    private final GroundProfile3D groundProfile3D;
    private DynamicIntegrationMethod dynamicIntegrationMethod = DynamicIntegrationMethod.EULER_DOUBLE_STEPS;

    public DRCSCSInitialSetup(GroundProfile3D groundProfile, double simulateDT) {
        this.groundProfile3D = groundProfile;
        this.simulateDT = simulateDT;
    }

    public DRCSCSInitialSetup(CommonAvatarEnvironmentInterface commonAvatarEnvironmentInterface, double simulateDT) {
        TerrainObject3D terrainObject3D = commonAvatarEnvironmentInterface.getTerrainObject3D();
        this.groundProfile3D = terrainObject3D;
        this.simulateDT = simulateDT;
    }

    public void setRunMultiThreaded(boolean runMultiThreaded) {
        this.runMultiThreaded = runMultiThreaded;
    }

    public boolean getRunMultiThreaded() {
        return this.runMultiThreaded;
    }

    public void initializeRobot(Robot robot, DRCRobotModel robotModel, YoGraphicsListRegistry yoGraphicsListRegistry) {
        robot.setGravity((Vector3DReadOnly)this.gravity);
        LinearGroundContactModel groundContactModel = new LinearGroundContactModel(robot, robot.getRobotsYoRegistry());
        RobotContactPointParameters.GroundContactModelParameters groundContactModelParameters = robotModel.getContactPointParameters().getGroundContactModelParameters(this.simulateDT);
        groundContactModel.setZStiffness(groundContactModelParameters.getZStiffness());
        groundContactModel.setZDamping(groundContactModelParameters.getZDamping());
        groundContactModel.setXYStiffness(groundContactModelParameters.getXYStiffness());
        groundContactModel.setXYDamping(groundContactModelParameters.getXYDamping());
        if (this.enableGroundSlipping) {
            groundContactModel.enableSlipping();
        }
        if (Double.isFinite(this.groundAlphaStick) && Double.isFinite(this.groundAlphaSlip)) {
            groundContactModel.setAlphaStickSlip(this.groundAlphaStick, this.groundAlphaSlip);
        }
        if (this.groundProfile3D != null) {
            groundContactModel.setGroundProfile3D(this.groundProfile3D);
        }
        robot.setGroundContactModel((GroundContactModel)groundContactModel);
    }

    public DynamicIntegrationMethod getDynamicIntegrationMethod() {
        return this.dynamicIntegrationMethod;
    }

    public void setDynamicIntegrationMethod(DynamicIntegrationMethod dynamicIntegrationMethod) {
        this.dynamicIntegrationMethod = dynamicIntegrationMethod;
    }

    public double getDT() {
        return this.simulateDT;
    }

    public int getSimulationDataBufferSize() {
        return this.simulationDataBufferSize;
    }

    public void disableGroundSlipping() {
        this.enableGroundSlipping = false;
        this.groundAlphaStick = Double.NaN;
        this.groundAlphaSlip = Double.NaN;
    }

    public void enableGroundSlipping(double alphaStick, double alphaSlip) {
        this.enableGroundSlipping = true;
        this.groundAlphaStick = alphaStick;
        this.groundAlphaSlip = alphaSlip;
    }

    private Graphics3DObject createGroundLinkGraphicsFromGroundProfile(GroundProfile3D groundProfile) {
        Graphics3DObject texturedGroundLinkGraphics = new Graphics3DObject();
        HeightMapWithNormals heightMap = null;
        if (groundProfile != null) {
            heightMap = groundProfile.getHeightMapIfAvailable();
        }
        texturedGroundLinkGraphics.addHeightMap((HeightMap)heightMap, 300, 300, YoAppearance.DarkGreen());
        return texturedGroundLinkGraphics;
    }

    public void initializeSimulation(SimulationConstructionSet scs) {
        scs.setDT(this.simulateDT, this.recordFrequency);
        if (this.drawGroundProfile) {
            scs.addStaticLinkGraphics(this.createGroundLinkGraphicsFromGroundProfile(this.groundProfile3D));
        }
        scs.getDataBuffer().fillBuffer();
    }

    public void setSimulationDataBufferSize(int simulationDataBufferSize) {
        this.simulationDataBufferSize = simulationDataBufferSize;
    }

    public void setRecordFrequency(int recordFrequency) {
        this.recordFrequency = recordFrequency;
    }

    public void setTimePerRecordTick(double timePerRecordTick) {
        int recordFrequency = (int)Math.round(timePerRecordTick / this.simulateDT);
        if (recordFrequency < 1) {
            recordFrequency = 1;
        }
        this.setRecordFrequency(recordFrequency);
    }

    public int getRecordFrequency() {
        return this.recordFrequency;
    }

    public Vector3D getGravity() {
        return this.gravity;
    }

    public boolean getInitializeEstimatorToActual() {
        return this.initializeEstimatorToActual;
    }

    public void setInitializeEstimatorToActual(boolean initializeEstimatorToActual) {
        this.initializeEstimatorToActual = initializeEstimatorToActual;
    }

    public boolean usePerfectSensors() {
        return this.usePerfectSensors;
    }

    public void setUsePerfectSensors(boolean usePerfectSensors) {
        this.usePerfectSensors = usePerfectSensors;
    }

    public GroundProfile3D getGroundProfile3D() {
        return this.groundProfile3D;
    }

    public HeightMap getHeightMap() {
        HeightMapWithNormals ret = null;
        if (this.groundProfile3D != null) {
            ret = this.groundProfile3D.getHeightMapIfAvailable();
        }
        return ret;
    }

    public boolean getDrawGroundProfile() {
        return this.drawGroundProfile;
    }

    public void setDrawGroundProfile(boolean drawGroundProfile) {
        this.drawGroundProfile = drawGroundProfile;
    }

    public void setGravity(Vector3D gravity) {
        this.gravity = new Vector3D((Tuple3DReadOnly)gravity);
    }
}

