/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.handControl.packetsAndConsumers;

import controller_msgs.msg.dds.HandJointAnglePacket;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import us.ihmc.avatar.handControl.packetsAndConsumers.HandSensorData;
import us.ihmc.concurrent.Builder;
import us.ihmc.concurrent.ConcurrentCopier;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.ros2.ROS2Publisher;

public class HandJointAngleCommunicator {
    private final int WORKER_SLEEP_TIME_MILLIS = 500;
    private final ConcurrentCopier<HandJointAnglePacket> packetCopier;
    private double[] fingers;
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicBoolean calibrated = new AtomicBoolean();
    private final RobotSide side;
    private final ScheduledExecutorService executor;
    private final ROS2Publisher<HandJointAnglePacket> publisher;
    public static final Builder<HandJointAnglePacket> builder = new Builder<HandJointAnglePacket>(){

        public HandJointAnglePacket newInstance() {
            return new HandJointAnglePacket();
        }
    };

    public HandJointAngleCommunicator(RobotSide side, ROS2Publisher<HandJointAnglePacket> publisher) {
        this.side = side;
        this.publisher = publisher;
        this.packetCopier = new ConcurrentCopier(builder);
        this.executor = this.startWriterThread();
    }

    private ScheduledExecutorService startWriterThread() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                HandJointAnglePacket copyForReading = (HandJointAnglePacket)HandJointAngleCommunicator.this.packetCopier.getCopyForReading();
                if (copyForReading != null && HandJointAngleCommunicator.this.publisher != null) {
                    HandJointAngleCommunicator.this.publisher.publish((Object)copyForReading);
                }
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
        return executor;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getDescription() {
        return this.getName();
    }

    public void updateHandAngles(HandSensorData sensorDataFromHand) {
        this.fingers = sensorDataFromHand.getFingerJointAngles(this.side);
        this.calibrated.set(sensorDataFromHand.isCalibrated());
        this.connected.set(sensorDataFromHand.isConnected());
    }

    public void write() {
        if (this.fingers == null) {
            return;
        }
        HandJointAnglePacket packet = (HandJointAnglePacket)this.packetCopier.getCopyForWriting();
        if (packet == null) {
            return;
        }
        packet.setRobotSide(this.side.toByte());
        packet.setConnected(this.connected.get());
        packet.setCalibrated(this.calibrated.get());
        packet.getJointAngles().reset();
        packet.getJointAngles().add(this.fingers);
        this.packetCopier.commit();
    }

    public void setHandDisconnected() {
        this.connected.set(true);
    }

    public void cleanup() {
        this.executor.shutdown();
    }
}

