/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.factory;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.AvatarSimulatedHandControlThread;
import us.ihmc.avatar.factory.HumanoidRobotControlTask;
import us.ihmc.avatar.factory.SimulatedHandOutputWriter;
import us.ihmc.avatar.factory.SimulatedHandSensorReader;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.robotics.time.ThreadTimer;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.yoVariables.variable.YoLong;

public class SimulatedHandControlTask
extends HumanoidRobotControlTask {
    private final SimulatedHandSensorReader handSensorReader;
    private final AvatarSimulatedHandControlThread handControlThread;
    private final SimulatedHandOutputWriter handOutputWriter;
    private final long divisor;
    private final ThreadTimer timer;
    private final YoLong ticksBehindScheduled;
    private final List<Runnable> postControllerCallback = new ArrayList<Runnable>();
    private final List<Runnable> schedulerThreadRunnables = new ArrayList<Runnable>();
    private boolean controllerRan = false;

    public SimulatedHandControlTask(SimulatedHandSensorReader handSensorReader, AvatarSimulatedHandControlThread handControllerThread, SimulatedHandOutputWriter handOutputWriter, long divisor, double schedulerDt) {
        super(divisor);
        this.handSensorReader = handSensorReader;
        this.handOutputWriter = handOutputWriter;
        this.divisor = divisor;
        this.handControlThread = handControllerThread;
        String prefix = "HandController";
        this.timer = new ThreadTimer(prefix, schedulerDt * (double)divisor, handControllerThread.getYoVariableRegistry());
        this.ticksBehindScheduled = new YoLong(prefix + "TicksBehindScheduled", handControllerThread.getYoVariableRegistry());
    }

    protected void execute() {
        this.timer.start();
        long schedulerTick = this.handControlThread.getHumanoidRobotContextData().getSchedulerTick();
        this.ticksBehindScheduled.set(schedulerTick - this.timer.getTickCount() * this.divisor);
        this.handControlThread.run();
        SimulatedHandControlTask.runAll(this.postControllerCallback);
        this.controllerRan = this.handControlThread.hasControllerRan();
        this.timer.stop();
    }

    protected void updateMasterContext(HumanoidRobotContextData masterContext) {
        if (!this.controllerRan) {
            return;
        }
        SimulatedHandControlTask.runAll(this.schedulerThreadRunnables);
        this.handOutputWriter.write((JointDesiredOutputListReadOnly)this.handControlThread.getHumanoidRobotContextData().getJointDesiredOutputList());
    }

    protected void updateLocalContext(HumanoidRobotContextData masterContext) {
        this.handControlThread.getHumanoidRobotContextData().setTimestamp(masterContext.getTimestamp());
        this.handControlThread.getHumanoidRobotContextData().setSchedulerTick(masterContext.getSchedulerTick());
        this.handSensorReader.read(this.handControlThread.getHumanoidRobotContextData().getSensorDataContext());
        this.handControlThread.getHumanoidRobotContextData().setEstimatorRan(masterContext.getEstimatorRan());
        this.handControlThread.getHumanoidRobotContextData().setControllerRan(masterContext.getControllerRan());
    }

    @Override
    public void addCallbackPostTask(Runnable runnable) {
        this.postControllerCallback.add(runnable);
    }

    @Override
    public void addRunnableOnSchedulerThread(Runnable runnable) {
        this.schedulerThreadRunnables.add(runnable);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.handControlThread.cleanup();
    }
}

