/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.factory;

import gnu.trove.map.TObjectDoubleMap;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import ihmc_common_msgs.msg.dds.StampedPosePacket;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.avatar.AvatarControllerThread;
import us.ihmc.avatar.AvatarEstimatorThread;
import us.ihmc.avatar.AvatarEstimatorThreadFactory;
import us.ihmc.avatar.AvatarSimulatedHandControlThread;
import us.ihmc.avatar.AvatarStepGeneratorThread;
import us.ihmc.avatar.BarrierSchedulerTools;
import us.ihmc.avatar.ControllerTask;
import us.ihmc.avatar.EstimatorTask;
import us.ihmc.avatar.HumanoidSteppingPluginEnvironmentalConstraints;
import us.ihmc.avatar.SimulationRobotVisualizer;
import us.ihmc.avatar.StepGeneratorTask;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.SimulatedDRCRobotTimeProvider;
import us.ihmc.avatar.drcRobot.shapeContactSettings.DRCRobotModelShapeCollisionSettings;
import us.ihmc.avatar.factory.AvatarSimulation;
import us.ihmc.avatar.factory.BarrierScheduledRobotController;
import us.ihmc.avatar.factory.DisposableRobotController;
import us.ihmc.avatar.factory.HumanoidRobotControlTask;
import us.ihmc.avatar.factory.SimulatedHandControlTask;
import us.ihmc.avatar.factory.SimulatedHandOutputWriter;
import us.ihmc.avatar.factory.SimulatedHandSensorReader;
import us.ihmc.avatar.factory.SingleThreadedRobotController;
import us.ihmc.avatar.initialSetup.DRCGuiInitialSetup;
import us.ihmc.avatar.initialSetup.DRCSCSInitialSetup;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.avatar.logging.IntraprocessYoVariableLogger;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextDataFactory;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepAdjustment;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.HeadingAndVelocityEvaluationScriptParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.ComponentBasedFootstepDataMessageGeneratorFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.HumanoidSteppingPluginFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.JoystickBasedSteppingPluginFactory;
import us.ihmc.communication.StateEstimatorAPI;
import us.ihmc.communication.packets.Packet;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.BarrierScheduler;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.subscribers.PelvisPoseCorrectionCommunicator;
import us.ihmc.humanoidRobotics.communication.subscribers.PelvisPoseCorrectionCommunicatorInterface;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.CrossFourBarJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBufferBuilder;
import us.ihmc.robotDataVisualizer.visualizer.SCSVisualizer;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPDGains;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputWriter;
import us.ihmc.sensorProcessing.parameters.AvatarRobotLidarParameters;
import us.ihmc.sensorProcessing.simulatedSensors.DRCPerfectSensorReaderFactory;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReader;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReaderFactory;
import us.ihmc.sensorProcessing.simulatedSensors.SimulatedSensorHolderAndReaderFromRobotFactory;
import us.ihmc.sensorProcessing.stateEstimation.SensorProcessingConfiguration;
import us.ihmc.sensorProcessing.stateEstimation.StateEstimatorParameters;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationToolkit.controllers.ActualCMPComputer;
import us.ihmc.simulationToolkit.controllers.PIDLidarTorqueController;
import us.ihmc.simulationToolkit.controllers.PassiveJointController;
import us.ihmc.simulationToolkit.controllers.SimulatedRobotCenterOfMassVisualizer;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJointHolder;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.gui.tools.SimulationOverheadPlotterFactory;
import us.ihmc.simulationconstructionset.physics.CollisionHandler;
import us.ihmc.simulationconstructionset.physics.collision.DefaultCollisionHandler;
import us.ihmc.simulationconstructionset.physics.collision.HybridImpulseSpringDamperCollisionHandler;
import us.ihmc.simulationconstructionset.physics.collision.simple.CollisionManager;
import us.ihmc.simulationconstructionset.util.AdditionalPanelTools;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.tools.factories.FactoryTools;
import us.ihmc.tools.factories.OptionalFactoryField;
import us.ihmc.tools.factories.RequiredFactoryField;
import us.ihmc.tools.gui.AWTTools;
import us.ihmc.wholeBodyController.DRCOutputProcessor;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.registry.YoRegistry;

public class AvatarSimulationFactory {
    private final RequiredFactoryField<DRCRobotModel> robotModel = new RequiredFactoryField("robotModel");
    private final RequiredFactoryField<HighLevelHumanoidControllerFactory> highLevelHumanoidControllerFactory = new RequiredFactoryField("highLevelHumanoidControllerFactory");
    private final RequiredFactoryField<CommonAvatarEnvironmentInterface> commonAvatarEnvironment = new RequiredFactoryField("commonAvatarEnvironmentInterface");
    private final RequiredFactoryField<RobotInitialSetup<HumanoidFloatingRootJointRobot>> robotInitialSetup = new RequiredFactoryField("robotInitialSetup");
    private final RequiredFactoryField<DRCSCSInitialSetup> scsInitialSetup = new RequiredFactoryField("scsInitialSetup");
    private final RequiredFactoryField<DRCGuiInitialSetup> guiInitialSetup = new RequiredFactoryField("guiInitialSetup");
    private final RequiredFactoryField<RealtimeROS2Node> realtimeROS2Node = new RequiredFactoryField("realtimeROS2Node");
    private final OptionalFactoryField<Double> gravity = new OptionalFactoryField("gravity");
    private final OptionalFactoryField<Boolean> addActualCMPVisualization = new OptionalFactoryField("addActualCMPVisualization");
    private final OptionalFactoryField<Boolean> createCollisionMeshes = new OptionalFactoryField("createCollisionMeshes");
    private final OptionalFactoryField<Boolean> createYoVariableServer = new OptionalFactoryField("createYoVariableServer");
    private final OptionalFactoryField<Boolean> logToFile = new OptionalFactoryField("logToFile");
    private final OptionalFactoryField<PelvisPoseCorrectionCommunicatorInterface> externalPelvisCorrectorSubscriber = new OptionalFactoryField("externalPelvisCorrectorSubscriber");
    private final OptionalFactoryField<Consumer<HumanoidFloatingRootJointRobot>> robotGraphicsMutator = new OptionalFactoryField("robotGraphicsMutator");
    private final OptionalFactoryField<Boolean> useHeadingAndVelocityScript = new OptionalFactoryField("useHeadingAndVelocityScript");
    private final OptionalFactoryField<FootstepAdjustment> footstepAdjustment = new OptionalFactoryField("footstepAdjustment");
    private final OptionalFactoryField<HeadingAndVelocityEvaluationScriptParameters> headingAndVelocityEvaluationScriptParameters = new OptionalFactoryField("headingAndVelocityEvaluationScriptParameters");
    private HumanoidFloatingRootJointRobot humanoidFloatingRootJointRobot;
    private YoVariableServer yoVariableServer;
    private IntraprocessYoVariableLogger intraprocessYoVariableLogger;
    private SimulationConstructionSet simulationConstructionSet;
    private SensorReaderFactory sensorReaderFactory;
    private JointDesiredOutputWriter simulationOutputWriter;
    private DRCOutputProcessor simulationOutputProcessor;
    private AvatarEstimatorThread estimatorThread;
    private AvatarControllerThread controllerThread;
    private AvatarStepGeneratorThread stepGeneratorThread;
    private DisposableRobotController robotController;
    private SimulatedDRCRobotTimeProvider simulatedRobotTimeProvider;
    private ActualCMPComputer actualCMPComputer;
    private FullHumanoidRobotModel masterFullRobotModel;
    private HumanoidRobotContextData masterContext;
    private DRCRobotModelShapeCollisionSettings shapeCollisionSettings;

    private void createHumanoidFloatingRootJointRobot() {
        this.humanoidFloatingRootJointRobot = ((DRCRobotModel)this.robotModel.get()).createHumanoidFloatingRootJointRobot((Boolean)this.createCollisionMeshes.get());
        if (this.robotGraphicsMutator.hasValue()) {
            ((Consumer)this.robotGraphicsMutator.get()).accept(this.humanoidFloatingRootJointRobot);
        }
        ((RobotInitialSetup)this.robotInitialSetup.get()).initializeRobot(this.humanoidFloatingRootJointRobot);
    }

    private void initializeCollisionManager() {
        if (this.shapeCollisionSettings != null && this.shapeCollisionSettings.useShapeCollision()) {
            CollisionManager collisionManager;
            if (this.shapeCollisionSettings.useHybridImpulseHandler()) {
                HybridImpulseSpringDamperCollisionHandler collisionHandler = new HybridImpulseSpringDamperCollisionHandler(this.shapeCollisionSettings.getRestitutionCoefficient(), this.shapeCollisionSettings.getFrictionCoefficient(), this.simulationConstructionSet.getRootRegistry(), new YoGraphicsListRegistry());
                collisionHandler.setKp(this.shapeCollisionSettings.getHybridSpringCoefficient());
                collisionHandler.setKd(this.shapeCollisionSettings.getHybridDamperCoefficient());
                collisionManager = new CollisionManager(((CommonAvatarEnvironmentInterface)this.commonAvatarEnvironment.get()).getTerrainObject3D(), (CollisionHandler)collisionHandler);
            } else {
                DefaultCollisionHandler collisionHandler = new DefaultCollisionHandler(this.shapeCollisionSettings.getRestitutionCoefficient(), this.shapeCollisionSettings.getFrictionCoefficient());
                collisionManager = new CollisionManager(((CommonAvatarEnvironmentInterface)this.commonAvatarEnvironment.get()).getTerrainObject3D(), (CollisionHandler)collisionHandler);
            }
            this.simulationConstructionSet.initializeShapeCollision(collisionManager);
        }
    }

    private void setupYoVariableServer() {
        if (((Boolean)this.createYoVariableServer.get()).booleanValue()) {
            this.yoVariableServer = new YoVariableServer(this.getClass(), ((DRCRobotModel)this.robotModel.get()).getLogModelProvider(), ((DRCRobotModel)this.robotModel.get()).getLogSettings(), ((DRCRobotModel)this.robotModel.get()).getEstimatorDT());
        }
    }

    private void setupSimulationConstructionSet() {
        SimulationConstructionSetParameters simulationConstructionSetParameters = ((DRCGuiInitialSetup)this.guiInitialSetup.get()).getSimulationConstructionSetParameters();
        simulationConstructionSetParameters.setDataBufferSize(((DRCSCSInitialSetup)this.scsInitialSetup.get()).getSimulationDataBufferSize());
        ArrayList<HumanoidFloatingRootJointRobot> allSimulatedRobotList = new ArrayList<HumanoidFloatingRootJointRobot>();
        allSimulatedRobotList.add(this.humanoidFloatingRootJointRobot);
        if (this.commonAvatarEnvironment.get() != null && ((CommonAvatarEnvironmentInterface)this.commonAvatarEnvironment.get()).getEnvironmentRobots() != null) {
            allSimulatedRobotList.addAll(((CommonAvatarEnvironmentInterface)this.commonAvatarEnvironment.get()).getEnvironmentRobots());
            ((CommonAvatarEnvironmentInterface)this.commonAvatarEnvironment.get()).addContactPoints(this.humanoidFloatingRootJointRobot.getAllGroundContactPoints());
            ((CommonAvatarEnvironmentInterface)this.commonAvatarEnvironment.get()).createAndSetContactControllerToARobot();
        }
        this.simulationConstructionSet = new SimulationConstructionSet(allSimulatedRobotList.toArray(new Robot[0]), ((DRCGuiInitialSetup)this.guiInitialSetup.get()).getGraphics3DAdapter(), simulationConstructionSetParameters);
        if (simulationConstructionSetParameters.getCreateGUI()) {
            FrameIndexMap.FrameIndexFinder frameIndexMap = new FrameIndexMap.FrameIndexFinder(ReferenceFrame.getWorldFrame());
            AdditionalPanelTools.setupFrameView((SimulationConstructionSet)this.simulationConstructionSet, arg_0 -> ((FrameIndexMap.FrameIndexFinder)frameIndexMap).getReferenceFrame(arg_0), (Predicate)SCSVisualizer.createFrameFilter());
        }
        this.simulationConstructionSet.setDT(((DRCRobotModel)this.robotModel.get()).getSimulateDT(), 1);
        try {
            if (!SystemUtils.IS_OS_WINDOWS) {
                this.simulationConstructionSet.getGUI().getFrame().setSize(AWTTools.getDimensionOfSmallestScreenScaled((double)0.6666666666666666));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void setupSensorReaderFactory() {
        StateEstimatorParameters stateEstimatorParameters = ((DRCRobotModel)this.robotModel.get()).getStateEstimatorParameters();
        if (((DRCSCSInitialSetup)this.scsInitialSetup.get()).usePerfectSensors()) {
            double estimatorDT = stateEstimatorParameters.getEstimatorDT();
            this.sensorReaderFactory = new DRCPerfectSensorReaderFactory((FloatingRootJointRobot)this.humanoidFloatingRootJointRobot, estimatorDT);
        } else {
            this.sensorReaderFactory = new SimulatedSensorHolderAndReaderFromRobotFactory((Robot)this.humanoidFloatingRootJointRobot, (SensorProcessingConfiguration)stateEstimatorParameters);
        }
    }

    private void setupSimulationOutputWriter() {
        this.simulationOutputWriter = ((DRCRobotModel)this.robotModel.get()).getCustomSimulationOutputWriter(this.humanoidFloatingRootJointRobot, this.masterContext);
    }

    private void setupSimulationOutputProcessor() {
        this.simulationOutputProcessor = ((DRCRobotModel)this.robotModel.get()).getCustomSimulationOutputProcessor(this.humanoidFloatingRootJointRobot);
    }

    private void setupStateEstimationThread() {
        PelvisPoseCorrectionCommunicatorInterface pelvisPoseCorrectionCommunicator;
        String robotName = ((DRCRobotModel)this.robotModel.get()).getSimpleRobotName();
        if (this.externalPelvisCorrectorSubscriber.hasValue()) {
            pelvisPoseCorrectionCommunicator = (PelvisPoseCorrectionCommunicatorInterface)this.externalPelvisCorrectorSubscriber.get();
        } else {
            pelvisPoseCorrectionCommunicator = new PelvisPoseCorrectionCommunicator((RealtimeROS2Node)this.realtimeROS2Node.get(), robotName);
            ((RealtimeROS2Node)this.realtimeROS2Node.get()).createSubscription(StateEstimatorAPI.getTopic(StampedPosePacket.class, (String)robotName), s -> pelvisPoseCorrectionCommunicator.receivedPacket((Packet)((StampedPosePacket)s.takeNextData())));
        }
        HumanoidRobotContextDataFactory contextDataFactory = new HumanoidRobotContextDataFactory();
        AvatarEstimatorThreadFactory avatarEstimatorThreadFactory = new AvatarEstimatorThreadFactory();
        avatarEstimatorThreadFactory.setROS2Info((RealtimeROS2Node)this.realtimeROS2Node.get(), robotName);
        avatarEstimatorThreadFactory.configureWithDRCRobotModel((DRCRobotModel)this.robotModel.get(), (RobotInitialSetup)this.robotInitialSetup.get());
        avatarEstimatorThreadFactory.setSensorReaderFactory(this.sensorReaderFactory);
        avatarEstimatorThreadFactory.setHumanoidRobotContextDataFactory(contextDataFactory);
        avatarEstimatorThreadFactory.setExternalPelvisCorrectorSubscriber(pelvisPoseCorrectionCommunicator);
        avatarEstimatorThreadFactory.setJointDesiredOutputWriter(this.simulationOutputWriter);
        avatarEstimatorThreadFactory.setGravity((Double)this.gravity.get());
        this.estimatorThread = avatarEstimatorThreadFactory.createAvatarEstimatorThread();
    }

    private void setupControllerThread() {
        String robotName = ((DRCRobotModel)this.robotModel.get()).getSimpleRobotName();
        HumanoidRobotContextDataFactory contextDataFactory = new HumanoidRobotContextDataFactory();
        this.controllerThread = new AvatarControllerThread(robotName, (DRCRobotModel)this.robotModel.get(), (RobotInitialSetup)this.robotInitialSetup.get(), ((DRCRobotModel)this.robotModel.get()).getSensorInformation(), (HighLevelHumanoidControllerFactory)this.highLevelHumanoidControllerFactory.get(), contextDataFactory, this.simulationOutputProcessor, (RealtimeROS2Node)this.realtimeROS2Node.get(), (Double)this.gravity.get(), false);
    }

    private void setupStepGeneratorThread() {
        JoystickBasedSteppingPluginFactory steppingFactory;
        boolean useHeadingAndVelocityScript;
        HumanoidRobotContextDataFactory contextDataFactory = new HumanoidRobotContextDataFactory();
        HumanoidSteppingPluginEnvironmentalConstraints stepSnapperUpdatable = null;
        boolean bl = useHeadingAndVelocityScript = this.useHeadingAndVelocityScript.hasValue() ? (Boolean)this.useHeadingAndVelocityScript.get() : false;
        if (useHeadingAndVelocityScript || this.headingAndVelocityEvaluationScriptParameters.hasValue()) {
            ComponentBasedFootstepDataMessageGeneratorFactory componentBasedFootstepDataMessageGeneratorFactory = new ComponentBasedFootstepDataMessageGeneratorFactory();
            componentBasedFootstepDataMessageGeneratorFactory.setRegistry();
            if (useHeadingAndVelocityScript) {
                componentBasedFootstepDataMessageGeneratorFactory.setUseHeadingAndVelocityScript(useHeadingAndVelocityScript);
            } else {
                componentBasedFootstepDataMessageGeneratorFactory.setUseHeadingAndVelocityScript(false);
            }
            if (this.headingAndVelocityEvaluationScriptParameters.hasValue()) {
                componentBasedFootstepDataMessageGeneratorFactory.setHeadingAndVelocityEvaluationScriptParameters((HeadingAndVelocityEvaluationScriptParameters)this.headingAndVelocityEvaluationScriptParameters.get());
            }
            if (this.footstepAdjustment.hasValue()) {
                componentBasedFootstepDataMessageGeneratorFactory.setFootStepAdjustment((FootstepAdjustment)this.footstepAdjustment.get());
            }
            steppingFactory = componentBasedFootstepDataMessageGeneratorFactory;
        } else {
            JoystickBasedSteppingPluginFactory joystickPluginFactory = new JoystickBasedSteppingPluginFactory();
            if (this.footstepAdjustment.hasValue()) {
                joystickPluginFactory.setFootStepAdjustment((FootstepAdjustment)this.footstepAdjustment.get());
            } else {
                stepSnapperUpdatable = new HumanoidSteppingPluginEnvironmentalConstraints((RobotContactPointParameters<RobotSide>)((DRCRobotModel)this.robotModel.get()).getContactPointParameters(), ((DRCRobotModel)this.robotModel.get()).getWalkingControllerParameters().getSteppingParameters(), ((DRCRobotModel)this.robotModel.get()).getSteppingEnvironmentalConstraintParameters());
                stepSnapperUpdatable.setShouldSnapToRegions(true);
            }
            steppingFactory = joystickPluginFactory;
        }
        this.stepGeneratorThread = new AvatarStepGeneratorThread((HumanoidSteppingPluginFactory)steppingFactory, contextDataFactory, ((HighLevelHumanoidControllerFactory)this.highLevelHumanoidControllerFactory.get()).getStatusOutputManager(), ((HighLevelHumanoidControllerFactory)this.highLevelHumanoidControllerFactory.get()).getCommandInputManager(), (DRCRobotModel)this.robotModel.get(), stepSnapperUpdatable, (RealtimeROS2Node)this.realtimeROS2Node.get());
    }

    private void createMasterContext() {
        this.masterFullRobotModel = ((DRCRobotModel)this.robotModel.get()).createFullRobotModel();
        ((RobotInitialSetup)this.robotInitialSetup.get()).initializeFullRobotModel(this.masterFullRobotModel);
        this.masterContext = new HumanoidRobotContextData(this.masterFullRobotModel);
    }

    private void setupMultiThreadedRobotController() {
        DRCRobotModel robotModel = (DRCRobotModel)this.robotModel.get();
        int estimatorDivisor = (int)Math.round(robotModel.getEstimatorDT() / robotModel.getSimulateDT());
        int controllerDivisor = (int)Math.round(robotModel.getControllerDT() / robotModel.getSimulateDT());
        int stepGeneratorDivisor = (int)Math.round(robotModel.getStepGeneratorDT() / robotModel.getSimulateDT());
        int handControlDivisor = (int)Math.round(robotModel.getSimulatedHandControlDT() / robotModel.getSimulateDT());
        EstimatorTask estimatorTask = new EstimatorTask(this.estimatorThread, estimatorDivisor, robotModel.getSimulateDT(), this.masterFullRobotModel);
        ControllerTask controllerTask = new ControllerTask("Controller", this.controllerThread, controllerDivisor, robotModel.getSimulateDT(), this.masterFullRobotModel);
        StepGeneratorTask stepGeneratorTask = new StepGeneratorTask("StepGenerator", this.stepGeneratorThread, stepGeneratorDivisor, robotModel.getSimulateDT(), this.masterFullRobotModel);
        AvatarSimulatedHandControlThread handControlThread = robotModel.createSimulatedHandController((RealtimeROS2Node)this.realtimeROS2Node.get(), false);
        SimulatedHandControlTask handControlTask = null;
        if (handControlThread != null) {
            List<String> fingerJointNames = handControlThread.getControlledOneDoFJoints().stream().map(JointReadOnly::getName).collect(Collectors.toList());
            SimulatedHandSensorReader handSensorReader = robotModel.createSimulatedHandSensorReader((OneDegreeOfFreedomJointHolder)this.humanoidFloatingRootJointRobot, fingerJointNames);
            SimulatedHandOutputWriter handOutputWriter = robotModel.createSimulatedHandOutputWriter((OneDegreeOfFreedomJointHolder)this.humanoidFloatingRootJointRobot);
            handControlTask = new SimulatedHandControlTask(handSensorReader, handControlThread, handOutputWriter, handControlDivisor, robotModel.getSimulateDT());
        }
        if (this.simulationOutputWriter != null) {
            ((HumanoidRobotControlTask)estimatorTask).addRunnableOnSchedulerThread(() -> {
                if (this.estimatorThread.getHumanoidRobotContextData().getControllerRan()) {
                    this.simulationOutputWriter.writeAfter();
                }
            });
        }
        SensorReader sensorReader = this.estimatorThread.getSensorReader();
        ((HumanoidRobotControlTask)estimatorTask).addRunnableOnSchedulerThread(() -> {
            long newTimestamp = sensorReader.read(this.masterContext.getSensorDataContext());
            this.masterContext.setTimestamp(newTimestamp);
        });
        if (this.simulationOutputWriter != null) {
            ((HumanoidRobotControlTask)estimatorTask).addRunnableOnSchedulerThread(() -> {
                if (this.estimatorThread.getHumanoidRobotContextData().getControllerRan()) {
                    this.simulationOutputWriter.writeBefore(this.estimatorThread.getHumanoidRobotContextData().getTimestamp());
                }
            });
        }
        if (this.simulationOutputProcessor != null) {
            ((HumanoidRobotControlTask)controllerTask).addRunnableOnSchedulerThread(BarrierSchedulerTools.createProcessorUpdater(this.simulationOutputProcessor, this.controllerThread));
        }
        ArrayList<HumanoidRobotControlTask> tasks = new ArrayList<HumanoidRobotControlTask>();
        tasks.add(estimatorTask);
        tasks.add(controllerTask);
        tasks.add(stepGeneratorTask);
        if (handControlTask != null) {
            tasks.add(handControlTask);
        }
        String controllerName = "DRCSimulation";
        if (!((DRCSCSInitialSetup)this.scsInitialSetup.get()).getRunMultiThreaded()) {
            LogTools.warn((String)"Running simulation in single threaded mode");
            this.robotController = new SingleThreadedRobotController<HumanoidRobotContextData>(controllerName, tasks, this.masterContext);
        } else {
            BarrierScheduler.TaskOverrunBehavior overrunBehavior = BarrierScheduler.TaskOverrunBehavior.BUSY_WAIT;
            this.robotController = new BarrierScheduledRobotController(controllerName, tasks, this.masterContext, overrunBehavior, robotModel.getSimulateDT());
            tasks.forEach(task -> new Thread((Runnable)((Object)task), ((Object)task).getClass().getSimpleName() + "Thread").start());
        }
        if (this.logToFile.hasValue() && ((Boolean)this.logToFile.get()).booleanValue()) {
            ArrayList<RegistrySendBufferBuilder> builders = new ArrayList<RegistrySendBufferBuilder>();
            builders.add(new RegistrySendBufferBuilder(this.estimatorThread.getYoRegistry(), this.estimatorThread.getFullRobotModel().getElevator(), null));
            builders.add(new RegistrySendBufferBuilder(this.controllerThread.getYoVariableRegistry(), this.controllerThread.getSCS1YoGraphicsListRegistry()));
            builders.add(new RegistrySendBufferBuilder(this.stepGeneratorThread.getYoVariableRegistry(), this.stepGeneratorThread.getSCS1YoGraphicsListRegistry()));
            this.intraprocessYoVariableLogger = new IntraprocessYoVariableLogger(this.getClass().getSimpleName(), robotModel.getLogModelProvider(), builders, 100000, robotModel.getEstimatorDT());
            ((HumanoidRobotControlTask)estimatorTask).addCallbackPostTask(() -> this.intraprocessYoVariableLogger.update(this.estimatorThread.getHumanoidRobotContextData().getTimestamp()));
        }
        if (this.yoVariableServer != null) {
            this.yoVariableServer.setMainRegistry(this.estimatorThread.getYoRegistry(), AvatarSimulationFactory.createYoVariableServerJointList(this.estimatorThread.getFullRobotModel().getElevator()), this.estimatorThread.getSCS1YoGraphicsListRegistry());
            ((HumanoidRobotControlTask)estimatorTask).addCallbackPostTask(() -> this.yoVariableServer.update(this.estimatorThread.getHumanoidRobotContextData().getTimestamp(), this.estimatorThread.getYoRegistry()));
            this.yoVariableServer.addRegistry(this.controllerThread.getYoVariableRegistry(), this.controllerThread.getSCS1YoGraphicsListRegistry());
            ((HumanoidRobotControlTask)controllerTask).addCallbackPostTask(() -> this.yoVariableServer.update(this.controllerThread.getHumanoidRobotContextData().getTimestamp(), this.controllerThread.getYoVariableRegistry()));
            this.yoVariableServer.addRegistry(this.stepGeneratorThread.getYoVariableRegistry(), this.stepGeneratorThread.getSCS1YoGraphicsListRegistry());
            ((HumanoidRobotControlTask)stepGeneratorTask).addCallbackPostTask(() -> this.yoVariableServer.update(this.stepGeneratorThread.getHumanoidRobotContextData().getTimestamp(), this.stepGeneratorThread.getYoVariableRegistry()));
        }
        SimulationRobotVisualizer estimatorRobotVisualizer = new SimulationRobotVisualizer(this.estimatorThread.getYoRegistry(), this.estimatorThread.getSCS1YoGraphicsListRegistry());
        SimulationRobotVisualizer controllerRobotVisualizer = new SimulationRobotVisualizer(this.controllerThread.getYoVariableRegistry(), this.controllerThread.getSCS1YoGraphicsListRegistry());
        SimulationRobotVisualizer stepGeneratorRobotVisualizer = new SimulationRobotVisualizer(this.stepGeneratorThread.getYoVariableRegistry(), this.stepGeneratorThread.getSCS1YoGraphicsListRegistry());
        ((HumanoidRobotControlTask)estimatorTask).addRunnableOnSchedulerThread(() -> estimatorRobotVisualizer.update());
        ((HumanoidRobotControlTask)controllerTask).addRunnableOnSchedulerThread(() -> controllerRobotVisualizer.update());
        ((HumanoidRobotControlTask)stepGeneratorTask).addRunnableOnSchedulerThread(() -> stepGeneratorRobotVisualizer.update());
        AvatarSimulationFactory.addRegistryAndGraphics(estimatorRobotVisualizer, this.robotController.getYoRegistry(), this.simulationConstructionSet);
        AvatarSimulationFactory.addRegistryAndGraphics(controllerRobotVisualizer, this.robotController.getYoRegistry(), this.simulationConstructionSet);
        AvatarSimulationFactory.addRegistryAndGraphics(stepGeneratorRobotVisualizer, this.robotController.getYoRegistry(), this.simulationConstructionSet);
        if (handControlTask != null) {
            SimulationRobotVisualizer handControlVisualizer = new SimulationRobotVisualizer(handControlThread.getYoVariableRegistry(), null);
            handControlTask.addRunnableOnSchedulerThread(() -> handControlVisualizer.update());
            AvatarSimulationFactory.addRegistryAndGraphics(handControlVisualizer, this.robotController.getYoRegistry(), this.simulationConstructionSet);
        }
    }

    public static List<JointBasics> createYoVariableServerJointList(RigidBodyBasics rootBody) {
        ArrayList<JointBasics> joints = new ArrayList<JointBasics>();
        for (JointBasics joint : rootBody.childrenSubtreeIterable()) {
            if (joint instanceof CrossFourBarJoint) {
                joints.addAll(((CrossFourBarJoint)joint).getFourBarFunction().getLoopJoints());
                continue;
            }
            joints.add(joint);
        }
        return joints;
    }

    private static void addRegistryAndGraphics(SimulationRobotVisualizer visualizer, YoRegistry registry, SimulationConstructionSet scs) {
        registry.addChild(visualizer.getRegistry());
        if (visualizer.getGraphicsListRegistry() != null) {
            scs.attachSimulationRewoundListener(() -> visualizer.updateGraphics());
            scs.attachPlayCycleListener(tick -> visualizer.updateGraphics());
            scs.addYoGraphicsListRegistry(visualizer.getGraphicsListRegistry(), false);
        }
    }

    private void initializeStateEstimatorToActual() {
        if (((DRCSCSInitialSetup)this.scsInitialSetup.get()).getInitializeEstimatorToActual()) {
            LogTools.info((String)"Initializing estimator to actual");
            ((RobotInitialSetup)this.robotInitialSetup.get()).initializeRobot(this.humanoidFloatingRootJointRobot);
            try {
                this.humanoidFloatingRootJointRobot.update();
                this.humanoidFloatingRootJointRobot.doDynamicsButDoNotIntegrate();
                this.humanoidFloatingRootJointRobot.update();
            }
            catch (UnreasonableAccelerationException e) {
                throw new RuntimeException("UnreasonableAccelerationException");
            }
            Point3D initialCoMPosition = new Point3D();
            this.humanoidFloatingRootJointRobot.computeCenterOfMass((Point3DBasics)initialCoMPosition);
            AvatarSimulationFactory.initializeEstimator(this.humanoidFloatingRootJointRobot, this.estimatorThread);
        }
    }

    public static void initializeEstimator(HumanoidFloatingRootJointRobot humanoidFloatingRootJointRobot, AvatarEstimatorThread estimatorThread) {
        RigidBodyTransform rootJointTransform = humanoidFloatingRootJointRobot.getRootJoint().getJointTransform3D();
        TObjectDoubleHashMap jointPositions = new TObjectDoubleHashMap();
        for (OneDegreeOfFreedomJoint joint : humanoidFloatingRootJointRobot.getOneDegreeOfFreedomJoints()) {
            jointPositions.put((Object)joint.getName(), joint.getQ());
        }
        estimatorThread.initializeStateEstimators(rootJointTransform, (TObjectDoubleMap<String>)jointPositions);
    }

    private void setupThreadedRobotController() {
        this.humanoidFloatingRootJointRobot.setController((RobotController)this.robotController);
    }

    private void setupLidarController() {
        AvatarRobotLidarParameters lidarParameters = ((DRCRobotModel)this.robotModel.get()).getSensorInformation().getLidarParameters(0);
        if (lidarParameters != null && lidarParameters.getLidarSpindleJointName() != null) {
            PIDLidarTorqueController pidLidarTorqueController = new PIDLidarTorqueController((FloatingRootJointRobot)this.humanoidFloatingRootJointRobot, lidarParameters.getLidarSpindleJointName(), lidarParameters.getLidarSpindleVelocity(), ((DRCRobotModel)this.robotModel.get()).getSimulateDT());
            this.humanoidFloatingRootJointRobot.setController((RobotController)pidLidarTorqueController);
        }
    }

    private void setupPositionControlledJointsForSimulation() {
        RobotController lowLevelController = ((DRCRobotModel)this.robotModel.get()).getSimulationLowLevelControllerFactory().createLowLevelController((FullRobotModel)this.controllerThread.getFullRobotModel(), (Robot)this.humanoidFloatingRootJointRobot, (JointDesiredOutputListReadOnly)this.controllerThread.getDesiredJointDataHolder());
        if (lowLevelController != null) {
            this.humanoidFloatingRootJointRobot.setController(lowLevelController);
        }
    }

    private void setupPassiveJoints() {
        YoRegistry robotsYoVariableRegistry = this.humanoidFloatingRootJointRobot.getRobotsYoRegistry();
        List passiveJointNameWithGains = ((DRCRobotModel)this.robotModel.get()).getJointMap().getPassiveJointNameWithGains(robotsYoVariableRegistry);
        if (passiveJointNameWithGains != null) {
            for (int i = 0; i < passiveJointNameWithGains.size(); ++i) {
                String jointName = (String)((ImmutablePair)passiveJointNameWithGains.get(i)).getLeft();
                OneDegreeOfFreedomJoint simulatedJoint = this.humanoidFloatingRootJointRobot.getOneDegreeOfFreedomJoint(jointName);
                YoPDGains gains = (YoPDGains)((ImmutablePair)passiveJointNameWithGains.get(i)).getRight();
                PassiveJointController passiveJointController = new PassiveJointController(simulatedJoint, gains);
                this.humanoidFloatingRootJointRobot.setController((RobotController)passiveJointController);
            }
        }
    }

    private void setupSimulatedRobotTimeProvider() {
        this.simulatedRobotTimeProvider = new SimulatedDRCRobotTimeProvider(((DRCRobotModel)this.robotModel.get()).getSimulateDT());
        this.humanoidFloatingRootJointRobot.setController((RobotController)this.simulatedRobotTimeProvider);
    }

    private void setupCMPVisualization() {
        this.actualCMPComputer = new ActualCMPComputer(((Boolean)this.addActualCMPVisualization.get()).booleanValue(), this.simulationConstructionSet, (FloatingRootJointRobot)this.humanoidFloatingRootJointRobot);
        if (((Boolean)this.addActualCMPVisualization.get()).booleanValue()) {
            this.humanoidFloatingRootJointRobot.setController((RobotController)this.actualCMPComputer);
        }
    }

    private void setupCOMVisualization() {
        SimulatedRobotCenterOfMassVisualizer simulatedRobotCenterOfMassVisualizer = new SimulatedRobotCenterOfMassVisualizer((Robot)this.humanoidFloatingRootJointRobot, ((DRCRobotModel)this.robotModel.get()).getSimulateDT());
        this.humanoidFloatingRootJointRobot.setController((RobotController)simulatedRobotCenterOfMassVisualizer);
    }

    private void initializeSimulationConstructionSet() {
        this.simulationConstructionSet.setParameterRootPath(this.robotController.getYoRegistry());
        this.humanoidFloatingRootJointRobot.setDynamicIntegrationMethod(((DRCSCSInitialSetup)this.scsInitialSetup.get()).getDynamicIntegrationMethod());
        ((DRCSCSInitialSetup)this.scsInitialSetup.get()).initializeSimulation(this.simulationConstructionSet);
        if (((DRCGuiInitialSetup)this.guiInitialSetup.get()).isGuiShown()) {
            SimulationOverheadPlotterFactory simulationOverheadPlotterFactory = this.simulationConstructionSet.createSimulationOverheadPlotterFactory();
            simulationOverheadPlotterFactory.setShowOnStart(((DRCGuiInitialSetup)this.guiInitialSetup.get()).isShowOverheadView());
            simulationOverheadPlotterFactory.setVariableNameToTrack("centerOfMass");
            simulationOverheadPlotterFactory.addYoGraphicsListRegistries(this.controllerThread.getSCS1YoGraphicsListRegistry());
            simulationOverheadPlotterFactory.addYoGraphicsListRegistries(this.estimatorThread.getSCS1YoGraphicsListRegistry());
            simulationOverheadPlotterFactory.addYoGraphicsListRegistries(this.actualCMPComputer.getYoGraphicsListRegistry());
            simulationOverheadPlotterFactory.createOverheadPlotter();
            ((DRCGuiInitialSetup)this.guiInitialSetup.get()).initializeGUI(this.simulationConstructionSet, (Robot)this.humanoidFloatingRootJointRobot, (DRCRobotModel)this.robotModel.get());
        }
        if (this.commonAvatarEnvironment.get() != null && ((CommonAvatarEnvironmentInterface)this.commonAvatarEnvironment.get()).getTerrainObject3D() != null) {
            this.simulationConstructionSet.addStaticLinkGraphics(((CommonAvatarEnvironmentInterface)this.commonAvatarEnvironment.get()).getTerrainObject3D().getLinkGraphics());
        }
        ((DRCSCSInitialSetup)this.scsInitialSetup.get()).initializeRobot((Robot)this.humanoidFloatingRootJointRobot, (DRCRobotModel)this.robotModel.get(), null);
        ((RobotInitialSetup)this.robotInitialSetup.get()).initializeRobot(this.humanoidFloatingRootJointRobot);
        this.humanoidFloatingRootJointRobot.update();
    }

    public AvatarSimulation createAvatarSimulation() {
        this.gravity.setDefaultValue((Object)-9.81);
        this.addActualCMPVisualization.setDefaultValue((Object)true);
        this.createCollisionMeshes.setDefaultValue((Object)false);
        this.createYoVariableServer.setDefaultValue((Object)false);
        FactoryTools.checkAllFactoryFieldsAreSet((Object)this);
        this.createHumanoidFloatingRootJointRobot();
        this.createMasterContext();
        this.setupYoVariableServer();
        this.setupSimulationConstructionSet();
        this.setupSensorReaderFactory();
        this.setupSimulationOutputWriter();
        this.setupSimulationOutputProcessor();
        this.setupStateEstimationThread();
        this.setupControllerThread();
        this.setupStepGeneratorThread();
        this.setupMultiThreadedRobotController();
        this.initializeStateEstimatorToActual();
        this.setupThreadedRobotController();
        this.setupLidarController();
        this.setupPositionControlledJointsForSimulation();
        this.setupPassiveJoints();
        this.setupSimulatedRobotTimeProvider();
        this.setupCMPVisualization();
        this.setupCOMVisualization();
        this.initializeCollisionManager();
        this.initializeSimulationConstructionSet();
        AvatarSimulation avatarSimulation = new AvatarSimulation();
        avatarSimulation.setRobotInitialSetup((RobotInitialSetup)this.robotInitialSetup.get());
        avatarSimulation.setRobotModel((DRCRobotModel)this.robotModel.get());
        avatarSimulation.setSimulationConstructionSet(this.simulationConstructionSet);
        avatarSimulation.setHighLevelHumanoidControllerFactory((HighLevelHumanoidControllerFactory)this.highLevelHumanoidControllerFactory.get());
        avatarSimulation.setYoVariableServer(this.yoVariableServer);
        avatarSimulation.setIntraprocessYoVariableLogger(this.intraprocessYoVariableLogger);
        avatarSimulation.setControllerThread(this.controllerThread);
        avatarSimulation.setStateEstimationThread(this.estimatorThread);
        avatarSimulation.setStepGeneratorThread(this.stepGeneratorThread);
        avatarSimulation.setRobotController(this.robotController);
        avatarSimulation.setHumanoidFloatingRootJointRobot(this.humanoidFloatingRootJointRobot);
        avatarSimulation.setSimulatedRobotTimeProvider(this.simulatedRobotTimeProvider);
        avatarSimulation.setFullHumanoidRobotModel(this.controllerThread.getFullRobotModel());
        avatarSimulation.setMasterContext(this.masterContext);
        FactoryTools.disposeFactory((Object)this);
        return avatarSimulation;
    }

    public void setRobotModel(DRCRobotModel robotModel) {
        this.robotModel.set((Object)robotModel);
    }

    public void setHighLevelHumanoidControllerFactory(HighLevelHumanoidControllerFactory highLevelHumanoidControllerFactory) {
        this.highLevelHumanoidControllerFactory.set((Object)highLevelHumanoidControllerFactory);
    }

    public void setCommonAvatarEnvironment(CommonAvatarEnvironmentInterface commonAvatarEnvironment) {
        this.commonAvatarEnvironment.set((Object)commonAvatarEnvironment);
    }

    public void setRobotInitialSetup(RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup) {
        this.robotInitialSetup.set(robotInitialSetup);
    }

    public void setSCSInitialSetup(DRCSCSInitialSetup scsInitialSetup) {
        this.scsInitialSetup.set((Object)scsInitialSetup);
    }

    public void setGuiInitialSetup(DRCGuiInitialSetup guiInitialSetup) {
        this.guiInitialSetup.set((Object)guiInitialSetup);
    }

    public void setRealtimeROS2Node(RealtimeROS2Node realtimeROS2Node) {
        this.realtimeROS2Node.set((Object)realtimeROS2Node);
    }

    public void setAddActualCMPVisualization(boolean addActualCMPVisualization) {
        this.addActualCMPVisualization.set((Object)addActualCMPVisualization);
    }

    public void setCreateCollisionMeshes(boolean createCollisionMeshes) {
        this.createCollisionMeshes.set((Object)createCollisionMeshes);
    }

    public void setCreateYoVariableServer(boolean createYoVariableServer) {
        this.createYoVariableServer.set((Object)createYoVariableServer);
    }

    public void setLogToFile(boolean logToFile) {
        this.logToFile.set((Object)logToFile);
    }

    public void setGravity(double gravity) {
        this.gravity.set((Object)gravity);
    }

    public void setShapeCollisionSettings(DRCRobotModelShapeCollisionSettings shapeCollisionSettings) {
        this.shapeCollisionSettings = shapeCollisionSettings;
    }

    public void setExternalPelvisCorrectorSubscriber(PelvisPoseCorrectionCommunicatorInterface externalPelvisCorrectorSubscriber) {
        this.externalPelvisCorrectorSubscriber.set((Object)externalPelvisCorrectorSubscriber);
    }

    public void setRobotGraphicsMutator(Consumer<HumanoidFloatingRootJointRobot> robotGraphicsMutator) {
        this.robotGraphicsMutator.set(robotGraphicsMutator);
    }

    public void setComponentBasedFootstepDataMessageGeneratorParameters(boolean useHeadingAndVelocityScript, HeadingAndVelocityEvaluationScriptParameters headingAndVelocityEvaluationScriptParameters) {
        this.setComponentBasedFootstepDataMessageGeneratorParameters(useHeadingAndVelocityScript, null, headingAndVelocityEvaluationScriptParameters);
    }

    public void setComponentBasedFootstepDataMessageGeneratorParameters(boolean useHeadingAndVelocityScript, FootstepAdjustment footstepAdjustment, HeadingAndVelocityEvaluationScriptParameters headingAndVelocityEvaluationScriptParameters) {
        this.useHeadingAndVelocityScript.set((Object)useHeadingAndVelocityScript);
        this.footstepAdjustment.set((Object)footstepAdjustment);
        this.headingAndVelocityEvaluationScriptParameters.set((Object)headingAndVelocityEvaluationScriptParameters);
    }
}

