/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.environments;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.robotics.geometry.PlanarRegionsListBuilder;

public class RealisticLabTerrainBuilder
extends PlanarRegionsListBuilder {
    public static final double PALLET_WIDTH = 1.0;
    public static final double PALLET_LENGTH = 1.0;
    public static final double PALLET_HEIGHT = 0.15;
    public static final double LARGE_CINDER_BLOCK_LENGTH = 0.4;
    public static final double LARGE_CINDER_BLOCK_WIDTH = 0.2;
    public static final double LARGE_CINDER_BLOCK_HEIGHT = 0.22;
    public static final double MEDIUM_CINDER_BLOCK_LENGTH = 0.4;
    public static final double MEDIUM_CINDER_BLOCK_WIDTH = 0.2;
    public static final double MEDIUM_CINDER_BLOCK_HEIGHT = 0.15;
    public static final double MEDIUM_CINDER_BLOCK_ANGLE = Math.toRadians(-18.0);
    public static final double SMALL_CINDER_BLOCK_LENGTH = 0.4;
    public static final double SMALL_CINDER_BLOCK_WIDTH = 0.2;
    public static final double SMALL_CINDER_BLOCK_HEIGHT = 0.08;
    public static final double SMALL_CINDER_BLOCK_ANGLE = Math.toRadians(-13.0);
    private final boolean removeCracks;

    public RealisticLabTerrainBuilder(boolean removeCracks) {
        this.removeCracks = removeCracks;
    }

    public void addGround(double size) {
        this.addXYPlaneSquareReferencedAtCenter(size, size);
    }

    public void addPalletStackReferencedAtNegativeXY(int stackHeight, Runnable placementOntoPallet) {
        this.addPalletStackReferencedAtNegativeXY(stackHeight);
        this.pushOffset(0.0, 0.0, 0.15);
        placementOntoPallet.run();
        this.popOffset();
    }

    public void addPalletStackReferencedAtNegativeXY(int stackHeight) {
        if (this.removeCracks) {
            this.addBoxReferencedAtNegativeXYZCorner(new Box3D(1.0, 1.0, (double)stackHeight * 0.15));
        } else {
            for (int i = 0; i < stackHeight; ++i) {
                this.addPalletReferencedAtNegativeXY(i);
            }
        }
    }

    private void addPalletReferencedAtNegativeXY(int stackIndex) {
        this.placeWithOffset(0.0, 0.0, (double)stackIndex * 0.15, () -> this.addBoxReferencedAtNegativeXYZCorner(new Box3D(1.0, 1.0, 0.15)));
    }

    public void addLargeCinderBlockGroup(int groupSize) {
        if (this.removeCracks) {
            this.addBoxReferencedAtNegativeXYZCorner(0.4, (double)groupSize * 0.2, 0.22);
        } else {
            for (int i = 0; i < groupSize; ++i) {
                this.placeWithOffset(0.0, 0.2 * (double)i, () -> this.addBoxReferencedAtNegativeXYZCorner(0.4, 0.2, 0.22));
            }
        }
    }

    public void addMediumCinderBlockGroup(int groupSize) {
        if (this.removeCracks) {
            this.addBoxReferencedAtNegativeXYZCorner(0.4, 0.2 * (double)groupSize, 0.15);
        } else {
            for (int i = 0; i < groupSize; ++i) {
                this.placeWithOffset(0.0, 0.2 * (double)i, () -> this.addBoxReferencedAtNegativeXYZCorner(0.4, 0.2, 0.15));
            }
        }
    }

    public void addMediumAngledCinderBlockGroup(int groupSize) {
        if (this.removeCracks) {
            this.placeWithOffset(0.0, 0.0, 0.0, Axis3D.Y, MEDIUM_CINDER_BLOCK_ANGLE, () -> this.addBoxReferencedAtNegativeXYZCorner(0.4, (double)groupSize * 0.2, 0.15));
        } else {
            for (int i = 0; i < groupSize; ++i) {
                this.placeWithOffset(0.0, 0.2 * (double)i, 0.0, Axis3D.Y, MEDIUM_CINDER_BLOCK_ANGLE, () -> this.addBoxReferencedAtNegativeXYZCorner(0.4, 0.2, 0.15));
            }
        }
    }

    public void addMediumAngledCinderBlockGroup(int groupSize, double zRotation) {
        this.placeWithOffset(0.2, 0.1, 0.075, () -> this.placeWithOffset(0.0, 0.0, 0.0, Axis3D.Z, zRotation, () -> {
            if (this.removeCracks) {
                double centroidZOffset = -0.2 * Math.tan(MEDIUM_CINDER_BLOCK_ANGLE);
                this.placeWithOffset(0.0, 0.0, centroidZOffset, Axis3D.Y, MEDIUM_CINDER_BLOCK_ANGLE, () -> this.addBoxReferencedAtCenter(0.4, (double)groupSize * 0.2, 0.15));
            } else {
                for (int i = 0; i < groupSize; ++i) {
                    double centroidZOffset = -0.2 * Math.tan(MEDIUM_CINDER_BLOCK_ANGLE);
                    this.placeWithOffset(0.0, 0.2 * (double)i, centroidZOffset, Axis3D.Y, MEDIUM_CINDER_BLOCK_ANGLE, () -> this.addBoxReferencedAtCenter(0.4, 0.2, 0.15));
                }
            }
        }));
    }

    public void addSmallAngledCinderBlockGroup(int groupSize, double zRotation) {
        this.placeWithOffset(0.2, 0.1, 0.04, () -> this.placeWithOffset(0.0, 0.0, 0.0, Axis3D.Z, zRotation, () -> {
            if (this.removeCracks) {
                double centroidZOffset = -0.2 * Math.tan(SMALL_CINDER_BLOCK_ANGLE);
                this.placeWithOffset(0.0, 0.0, centroidZOffset, Axis3D.Y, SMALL_CINDER_BLOCK_ANGLE, () -> this.addBoxReferencedAtCenter(0.4, (double)groupSize * 0.2, 0.08));
            } else {
                for (int i = 0; i < groupSize; ++i) {
                    double centroidZOffset = -0.2 * Math.tan(SMALL_CINDER_BLOCK_ANGLE);
                    this.placeWithOffset(0.0, 0.2 * (double)i, centroidZOffset, Axis3D.Y, SMALL_CINDER_BLOCK_ANGLE, () -> this.addBoxReferencedAtCenter(0.4, 0.2, 0.08));
                }
            }
        }));
    }

    public void addSmallCinderBlockGroup(int groupSize) {
        if (this.removeCracks) {
            this.addBoxReferencedAtNegativeXYZCorner(0.4, 0.2 * (double)groupSize, 0.08);
        } else {
            for (int i = 0; i < groupSize; ++i) {
                this.placeWithOffset(0.0, 0.2 * (double)i, () -> this.addBoxReferencedAtNegativeXYZCorner(0.4, 0.2, 0.08));
            }
        }
    }

    public void placeSmallCinderBlockGroup(double x, double y, double yaw, int groupSize) {
        this.pushOffset(x, y, 0.0, Axis3D.Z, yaw);
        this.addSmallCinderBlockGroup(groupSize);
        this.popOffset();
    }

    public void placeMediumCinderBlockGroup(double x, double y, double yaw, int groupSize) {
        this.pushOffset(x, y, 0.0, Axis3D.Z, yaw);
        this.addMediumCinderBlockGroup(groupSize);
        this.popOffset();
    }

    public void placeLargeCinderBlockGroup(double x, double y, double yaw, int groupSize) {
        this.pushOffset(x, y, 0.0, Axis3D.Z, yaw);
        this.addLargeCinderBlockGroup(groupSize);
        this.popOffset();
    }

    public void placeMediumAngledCinderBlockGroup(double x, double y, double yaw, int groupSize) {
        this.pushOffset(x, y, 0.0, Axis3D.Z, yaw);
        this.addMediumAngledCinderBlockGroup(groupSize);
        this.popOffset();
    }
}

