/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.drcRobot.collisions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.log.LogTools;
import us.ihmc.modelFileLoaders.ModelFileLoaderConversionsHelper;
import us.ihmc.modelFileLoaders.SdfLoader.GeneralizedSDFRobotModel;
import us.ihmc.modelFileLoaders.SdfLoader.JaxbSDFLoader;
import us.ihmc.modelFileLoaders.SdfLoader.SDFJointHolder;
import us.ihmc.modelFileLoaders.SdfLoader.SDFLinkHolder;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.Collision;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFGeometry;
import us.ihmc.perception.depthData.CollisionBoxProvider;
import us.ihmc.perception.depthData.collisionShapes.CollisionBox;
import us.ihmc.perception.depthData.collisionShapes.CollisionCylinder;
import us.ihmc.perception.depthData.collisionShapes.CollisionShape;
import us.ihmc.perception.depthData.collisionShapes.CollisionSphere;

public class SDFCollisionBoxProvider
implements CollisionBoxProvider {
    private final HashMap<String, List<CollisionShape>> collissionMeshes = new HashMap();
    protected final float extent = 0.04f;

    public SDFCollisionBoxProvider(JaxbSDFLoader loader, String modelName) {
        GeneralizedSDFRobotModel model = loader.getGeneralizedSDFRobotModel(modelName);
        SDFLinkHolder rootLink = (SDFLinkHolder)model.getRootLinks().get(0);
        this.recursivelyAddLinks(rootLink.getName(), rootLink);
    }

    public void addCollisionShape(String jointName, CollisionShape mesh) {
        List<CollisionShape> meshes = this.collissionMeshes.get(jointName);
        if (meshes == null) {
            meshes = new ArrayList<CollisionShape>();
            this.collissionMeshes.put(jointName, meshes);
        }
        meshes.add(mesh);
    }

    private void recursivelyAddLinks(String jointName, SDFLinkHolder holder) {
        ArrayList<CollisionSphere> meshes = new ArrayList<CollisionSphere>();
        for (Collision collision : holder.getCollisions()) {
            CollisionSphere mesh;
            SDFGeometry collisionGeometry = collision.getGeometry();
            RigidBodyTransform visualPose = ModelFileLoaderConversionsHelper.poseToTransform((String)collision.getPose());
            if (collisionGeometry.getBox() != null) {
                String[] boxDimensions = collisionGeometry.getBox().getSize().split(" ");
                float bx = Float.parseFloat(boxDimensions[0]) / 2.0f + 0.04f;
                float by = Float.parseFloat(boxDimensions[1]) / 2.0f + 0.04f;
                float bz = Float.parseFloat(boxDimensions[2]) / 2.0f + 0.04f;
                mesh = new CollisionBox(visualPose, (double)bx, (double)by, (double)bz);
            } else if (collisionGeometry.getCylinder() != null) {
                float length = Float.parseFloat(collisionGeometry.getCylinder().getLength()) + 0.08f;
                float radius = Float.parseFloat(collisionGeometry.getCylinder().getRadius()) + 0.08f;
                mesh = new CollisionCylinder(visualPose, (double)radius, (double)length);
            } else if (collisionGeometry.getSphere() != null) {
                float radius = Float.parseFloat(collisionGeometry.getSphere().getRadius()) * 2.0f * 0.04f;
                mesh = new CollisionSphere(visualPose, (double)radius);
            } else {
                LogTools.debug((String)("Cannot create collision box for " + String.valueOf(holder)));
                continue;
            }
            meshes.add(mesh);
        }
        this.collissionMeshes.put(jointName, meshes);
        for (SDFJointHolder joint : holder.getChildren()) {
            this.recursivelyAddLinks(joint.getName(), joint.getChildLinkHolder());
        }
    }

    public List<CollisionShape> getCollisionMesh(String jointName) {
        return this.collissionMeshes.get(jointName);
    }
}

