/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.drcRobot;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.HandJointAnglePacket;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.function.Consumer;
import us.ihmc.avatar.drcRobot.CommunicationsSyncedRobotModel;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.sakeGripper.ROS2SakeHandStatus;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.StateEstimatorAPI;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Input;
import us.ihmc.ros2.ROS2Node;

public class ROS2SyncedRobotModel
extends CommunicationsSyncedRobotModel {
    private final ROS2Input<RobotConfigurationData> robotConfigurationDataInput;
    private final ROS2Input<CapturabilityBasedStatus> capturabilityBasedStatusInput;
    private final SideDependentList<ROS2Input<HandJointAnglePacket>> handJointAnglePacketInputs = new SideDependentList();
    private final SideDependentList<ROS2SakeHandStatus> sakeHandStatus = new SideDependentList();

    public ROS2SyncedRobotModel(DRCRobotModel robotModel, ROS2Node ros2Node) {
        this(robotModel, ros2Node, robotModel.createFullRobotModel());
    }

    public ROS2SyncedRobotModel(DRCRobotModel robotModel, ROS2Node ros2Node, boolean enforceUniqueReferenceFrames) {
        this(robotModel, ros2Node, robotModel.createFullRobotModel(enforceUniqueReferenceFrames));
    }

    public ROS2SyncedRobotModel(DRCRobotModel robotModel, ROS2Node ros2Node, FullHumanoidRobotModel fullRobotModel) {
        super(robotModel, fullRobotModel, robotModel.getHandModels(), robotModel.getSensorInformation());
        this.robotConfigurationDataInput = new ROS2Input(ros2Node, StateEstimatorAPI.getRobotConfigurationDataTopic((String)robotModel.getSimpleRobotName()), (Object)this.robotConfigurationData, message -> {
            FullRobotModelUtils.checkJointNameHash((int)this.jointNameHash, (int)message.getJointNameHash());
            return true;
        });
        this.robotConfigurationDataInput.addCallback(message -> this.resetDataReceptionTimer());
        this.capturabilityBasedStatusInput = new ROS2Input(ros2Node, CapturabilityBasedStatus.class, HumanoidControllerAPI.getTopic(CapturabilityBasedStatus.class, (String)robotModel.getSimpleRobotName()));
        for (RobotSide robotSide : RobotSide.values) {
            this.handJointAnglePacketInputs.set((Enum)robotSide, (Object)new ROS2Input(ros2Node, StateEstimatorAPI.getHandJointAnglesTopic((String)robotModel.getSimpleRobotName()), null, message -> robotSide.toByte() == message.getRobotSide()));
            this.sakeHandStatus.put((Enum)robotSide, (Object)new ROS2SakeHandStatus(ros2Node, robotModel.getSimpleRobotName(), robotSide));
        }
    }

    @Override
    public RobotConfigurationData getLatestRobotConfigurationData() {
        return (RobotConfigurationData)this.robotConfigurationDataInput.getLatest();
    }

    public CapturabilityBasedStatus getLatestCapturabilityBasedStatus() {
        return (CapturabilityBasedStatus)this.capturabilityBasedStatusInput.getLatest();
    }

    @Override
    public HandJointAnglePacket getLatestHandJointAnglePacket(RobotSide robotSide) {
        return (HandJointAnglePacket)((ROS2Input)this.handJointAnglePacketInputs.get((Enum)robotSide)).getLatest();
    }

    public SideDependentList<ROS2SakeHandStatus> getSakeHandStatus() {
        return this.sakeHandStatus;
    }

    public boolean hasReceivedFirstMessage() {
        return this.robotConfigurationDataInput.hasReceivedFirstMessage();
    }

    public void addRobotConfigurationDataReceivedCallback(Runnable callback) {
        this.robotConfigurationDataInput.addCallback(message -> callback.run());
    }

    public void addRobotConfigurationDataReceivedCallback(Consumer<RobotConfigurationData> callback) {
        this.robotConfigurationDataInput.addCallback(callback);
    }

    public void destroy() {
    }
}

