/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.drcRobot;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.avatar.drcRobot.RobotVersion;
import us.ihmc.communication.ros2.tf2.ROS2FollowingFrame;
import us.ihmc.communication.ros2.tf2.ROS2Frame;
import us.ihmc.communication.ros2.tf2.ROS2MutableFrame;
import us.ihmc.communication.ros2.tf2.ROS2StaticFrame;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Node;

public class ROS2HumanoidFrames {
    private static final SideDependentList<String> SIDE_PREFIXES = new SideDependentList((Object)"l_", (Object)"r_");
    private final ROS2Node ros2Node;
    private final HumanoidReferenceFrames humanoidFrames;
    private final FullHumanoidRobotModel fullRobotModel;
    private final RobotVersion robotVersion;
    private final ROS2Frame mapFrame;
    private final ROS2Frame odomFrame;
    private ROS2Frame baseLinkFrame;
    private final ROS2MutableFrame baseFootprintFrame;
    private ROS2Frame torsoFrame;
    private ROS2Frame gazeFrame;
    private final SideDependentList<ROS2Frame> wristFrames = new SideDependentList();
    private final SideDependentList<ROS2Frame> gripperFrames = new SideDependentList();
    private final SideDependentList<ROS2Frame> ankleFrames = new SideDependentList();
    private final SideDependentList<ROS2Frame> soleFrames = new SideDependentList();
    private final SideDependentList<ROS2Frame> toeFrames = new SideDependentList();
    private final Map<ReferenceFrame, ROS2Frame> ros2FrameCopyMap = new HashMap<ReferenceFrame, ROS2Frame>();
    private final Set<ROS2Frame> allROS2Frames = new LinkedHashSet<ROS2Frame>();

    public ROS2HumanoidFrames(ROS2Node ros2Node, ROS2SyncedRobotModel syncedRobotModel) {
        this.ros2Node = ros2Node;
        this.humanoidFrames = syncedRobotModel.getReferenceFrames();
        this.fullRobotModel = syncedRobotModel.getFullRobotModel();
        this.robotVersion = syncedRobotModel.getRobotModel().getRobotVersion();
        this.mapFrame = new ROS2StaticFrame(ros2Node, "map", ReferenceFrameTools.getWorldFrame(), (RigidBodyTransformReadOnly)new RigidBodyTransform(), true, true);
        this.allROS2Frames.add(this.mapFrame);
        this.odomFrame = new ROS2MutableFrame(ros2Node, "odom", (ReferenceFrame)this.mapFrame, (RigidBodyTransformReadOnly)new RigidBodyTransform(), true);
        this.allROS2Frames.add(this.odomFrame);
        this.fillTree((ReferenceFrame)this.fullRobotModel.getRootJoint().getFrameAfterJoint());
        this.baseFootprintFrame = new ROS2MutableFrame(ros2Node, "base_footprint", (ReferenceFrame)this.baseLinkFrame, (RigidBodyTransformReadOnly)this.computeBaseFootprintToBaseLinkTransform(new RigidBodyTransform()));
        this.allROS2Frames.add((ROS2Frame)this.baseFootprintFrame);
        for (RobotSide side : RobotSide.values) {
            ROS2StaticFrame toeFrame = new ROS2StaticFrame(ros2Node, (String)SIDE_PREFIXES.get((Enum)side) + "toe", (ReferenceFrame)this.ankleFrames.get((Enum)side), (RigidBodyTransformReadOnly)new RigidBodyTransform());
            this.toeFrames.put((Enum)side, (Object)toeFrame);
            this.allROS2Frames.add((ROS2Frame)toeFrame);
        }
    }

    private void fillTree(ReferenceFrame start) {
        this.createFrameCopy(start);
        int childrenCount = start.getNumberOfChildren();
        for (int i = 0; i < childrenCount; ++i) {
            ReferenceFrame childFrame = start.getChild(i);
            if (childFrame == null) continue;
            this.fillTree(childFrame);
        }
    }

    private void createFrameCopy(ReferenceFrame frameToCopy) {
        ROS2Frame parentFrame;
        ROS2Frame ros2FrameCopy = null;
        if (frameToCopy.equals((Object)this.fullRobotModel.getRootJoint().getFrameAfterJoint())) {
            ros2FrameCopy = this.baseLinkFrame = this.createFrameCopy(frameToCopy, "base_link", this.odomFrame);
        } else if (frameToCopy.equals((Object)this.humanoidFrames.getChestFrame())) {
            parentFrame = this.ros2FrameCopyMap.getOrDefault(frameToCopy.getParent(), this.baseLinkFrame);
            ros2FrameCopy = this.torsoFrame = this.createFrameCopy(frameToCopy, "torso", parentFrame);
        } else if (frameToCopy.equals((Object)this.humanoidFrames.getHeadFrame())) {
            parentFrame = this.ros2FrameCopyMap.getOrDefault(frameToCopy.getParent(), this.torsoFrame);
            ros2FrameCopy = this.gazeFrame = this.createFrameCopy(frameToCopy, "gaze", parentFrame);
        } else {
            for (ROS2Frame side : RobotSide.values) {
                ROS2Frame parentFrame2;
                if (ros2FrameCopy != null) break;
                String sidePrefix = (String)SIDE_PREFIXES.get((Enum)side);
                if (this.robotVersion.hasArm((RobotSide)side)) {
                    if (frameToCopy.equals((Object)this.fullRobotModel.getHand((RobotSide)side).getParentJoint().getFrameAfterJoint())) {
                        parentFrame2 = this.ros2FrameCopyMap.getOrDefault(frameToCopy.getParent(), this.torsoFrame);
                        ROS2Frame wristFrame = this.createFrameCopy(frameToCopy, sidePrefix + "wrist", parentFrame2);
                        this.wristFrames.put((Enum)side, (Object)wristFrame);
                        ros2FrameCopy = wristFrame;
                    } else if (frameToCopy.equals((Object)this.fullRobotModel.getHandControlFrame((RobotSide)side))) {
                        parentFrame2 = this.ros2FrameCopyMap.getOrDefault(frameToCopy.getParent(), (ROS2Frame)this.wristFrames.get((Enum)side));
                        ROS2Frame gripperFrame = this.createFrameCopy(frameToCopy, sidePrefix + "gripper", parentFrame2);
                        this.gripperFrames.put((Enum)side, (Object)gripperFrame);
                        ros2FrameCopy = gripperFrame;
                    }
                }
                if (frameToCopy.equals((Object)this.humanoidFrames.getFootFrame((RobotSide)side))) {
                    parentFrame2 = this.ros2FrameCopyMap.getOrDefault(frameToCopy.getParent(), this.baseLinkFrame);
                    ROS2Frame ankleFrame = this.createFrameCopy(frameToCopy, sidePrefix + "ankle", parentFrame2);
                    this.ankleFrames.put((Enum)side, (Object)ankleFrame);
                    ros2FrameCopy = ankleFrame;
                    continue;
                }
                if (!frameToCopy.equals((Object)this.humanoidFrames.getSoleFrame((RobotSide)side))) continue;
                parentFrame2 = this.ros2FrameCopyMap.getOrDefault(frameToCopy.getParent(), (ROS2Frame)this.ankleFrames.get((Enum)side));
                ROS2Frame soleFrame = this.createFrameCopy(frameToCopy, sidePrefix + "sole", parentFrame2);
                this.soleFrames.put((Enum)side, (Object)soleFrame);
                ros2FrameCopy = soleFrame;
            }
        }
        if (ros2FrameCopy == null) {
            parentFrame = this.ros2FrameCopyMap.getOrDefault(frameToCopy.getParent(), this.baseLinkFrame);
            ros2FrameCopy = this.createFrameCopy(frameToCopy, "ros2_" + frameToCopy.getName(), parentFrame);
        }
        this.ros2FrameCopyMap.put(frameToCopy, ros2FrameCopy);
        this.allROS2Frames.add(ros2FrameCopy);
    }

    private ROS2Frame createFrameCopy(ReferenceFrame frameToCopy, String id, ROS2Frame parentFrame) {
        if (frameToCopy.isFixedInParent() && parentFrame.equals((Object)this.ros2FrameCopyMap.get(frameToCopy.getParent()))) {
            return new ROS2StaticFrame(this.ros2Node, id, (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)frameToCopy.getTransformToParent());
        }
        return new ROS2FollowingFrame(this.ros2Node, id, (ReferenceFrame)parentFrame, frameToCopy);
    }

    private RigidBodyTransform computeBaseFootprintToBaseLinkTransform(RigidBodyTransform transformToPack) {
        this.humanoidFrames.getMidFootZUpGroundFrame().getTransformToDesiredFrame(transformToPack, (ReferenceFrame)this.baseLinkFrame);
        RotationMatrixBasics rotation = transformToPack.getRotation();
        rotation.setYawPitchRoll(0.0, rotation.getPitch(), rotation.getRoll());
        return transformToPack;
    }

    public void update() {
        this.baseFootprintFrame.setNewTransformToParent(this::computeBaseFootprintToBaseLinkTransform);
        this.allROS2Frames.forEach(ReferenceFrame::update);
    }

    public ROS2Frame getMapFrame() {
        return this.mapFrame;
    }

    public ROS2Frame getOdomFrame() {
        return this.odomFrame;
    }

    public ROS2Frame getBaseLinkFrame() {
        return this.baseLinkFrame;
    }

    public ROS2Frame getBaseFootprintFrame() {
        return this.baseFootprintFrame;
    }

    public ROS2Frame getTorsoFrame() {
        return this.torsoFrame;
    }

    public ROS2Frame getGazeFrame() {
        return this.gazeFrame;
    }

    public ROS2Frame getWristFrame(RobotSide side) {
        return (ROS2Frame)this.getWristFrames().get((Enum)side);
    }

    public SideDependentList<ROS2Frame> getWristFrames() {
        return this.wristFrames;
    }

    public ROS2Frame getGripperFrame(RobotSide side) {
        return (ROS2Frame)this.getGripperFrames().get((Enum)side);
    }

    public SideDependentList<ROS2Frame> getGripperFrames() {
        return this.gripperFrames;
    }

    public ROS2Frame getAnkleFrame(RobotSide side) {
        return (ROS2Frame)this.getAnkleFrames().get((Enum)side);
    }

    public SideDependentList<ROS2Frame> getAnkleFrames() {
        return this.ankleFrames;
    }

    public ROS2Frame getSoleFrame(RobotSide side) {
        return (ROS2Frame)this.getSoleFrames().get((Enum)side);
    }

    public SideDependentList<ROS2Frame> getSoleFrames() {
        return this.soleFrames;
    }

    public ROS2Frame getToeFrame(RobotSide side) {
        return (ROS2Frame)this.getToeFrames().get((Enum)side);
    }

    public SideDependentList<ROS2Frame> getToeFrames() {
        return this.toeFrames;
    }

    public ROS2Frame getROS2FrameCopy(ReferenceFrame referenceFrame) {
        return this.ros2FrameCopyMap.get(referenceFrame);
    }

    public void remove() {
        this.allROS2Frames.forEach(ReferenceFrame::remove);
    }
}

