/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.drcRobot;

import controller_msgs.msg.dds.HandJointAnglePacket;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import us.ihmc.avatar.drcRobot.CommunicationsSyncedRobotModel;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;

public class MessagerSyncedRobotModel
extends CommunicationsSyncedRobotModel {
    private volatile RobotConfigurationData latestRobotConfigurationData;
    private boolean hasReceivedFirstMessage = false;
    private final List<Consumer<RobotConfigurationData>> userCallbacks = new ArrayList<Consumer<RobotConfigurationData>>();

    public MessagerSyncedRobotModel(Messager messager, MessagerAPIFactory.Topic<RobotConfigurationData> topic, DRCRobotModel robotModel, FullHumanoidRobotModel fullRobotModel, HumanoidRobotSensorInformation sensorInformation) {
        super(robotModel, fullRobotModel, null, sensorInformation);
        messager.addTopicListener(topic, robotConfigurationData -> {
            FullRobotModelUtils.checkJointNameHash((int)this.jointNameHash, (int)robotConfigurationData.getJointNameHash());
            this.latestRobotConfigurationData = robotConfigurationData;
            this.resetDataReceptionTimer();
            this.hasReceivedFirstMessage = true;
            for (Consumer<RobotConfigurationData> userCallback : this.userCallbacks) {
                userCallback.accept((RobotConfigurationData)robotConfigurationData);
            }
        });
    }

    @Override
    public RobotConfigurationData getLatestRobotConfigurationData() {
        return this.latestRobotConfigurationData;
    }

    @Override
    public HandJointAnglePacket getLatestHandJointAnglePacket(RobotSide robotSide) {
        return null;
    }

    public boolean hasReceivedFirstMessage() {
        return this.hasReceivedFirstMessage;
    }

    public void addRobotConfigurationDataReceivedCallback(Runnable callback) {
        this.addRobotConfigurationDataReceivedCallback((RobotConfigurationData message) -> callback.run());
    }

    public void addRobotConfigurationDataReceivedCallback(Consumer<RobotConfigurationData> callback) {
        this.userCallbacks.add(callback);
    }
}

