/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.drcRobot;

import controller_msgs.msg.dds.HandJointAnglePacket;
import java.util.HashMap;
import us.ihmc.avatar.handControl.packetsAndConsumers.HandModel;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.HandJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class HandModelUtils {
    public static void getHandJoints(SideDependentList<HandModel> handModels, FullHumanoidRobotModel fullRobotModel, SideDependentList<HashMap<HandJointName, OneDoFJointBasics>> handJoints) {
        for (RobotSide side : handModels.sides()) {
            HashMap<HandJointName, OneDoFJointBasics> joints = new HashMap<HandJointName, OneDoFJointBasics>();
            for (HandJointName jointName : ((HandModel)handModels.get((Enum)side)).getHandJointNames()) {
                joints.put(jointName, fullRobotModel.getOneDoFJointByName(jointName.getJointName(side)));
            }
            handJoints.put((Enum)side, joints);
        }
    }

    public static void copyHandJointAnglesFromMessagesToOneDoFJoints(SideDependentList<HandModel> handModels, SideDependentList<HashMap<HandJointName, OneDoFJointBasics>> handJoints, SideDependentList<HandJointAnglePacket> handJointAnglePackets) {
        for (RobotSide robotSide : handModels.sides()) {
            HandJointAnglePacket handJointAnglePacket = (HandJointAnglePacket)handJointAnglePackets.get((Enum)robotSide);
            if (handJointAnglePacket == null) continue;
            for (HandJointName jointName : ((HandModel)handModels.get((Enum)robotSide)).getHandJointNames()) {
                double jointAngle = HumanoidMessageTools.unpackJointAngle((HandJointAnglePacket)handJointAnglePacket, (HandJointName)jointName);
                OneDoFJointBasics oneDoFJoint = (OneDoFJointBasics)((HashMap)handJoints.get((Enum)robotSide)).get(jointName);
                oneDoFJoint.setQ(jointAngle);
            }
        }
    }
}

