/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import us.ihmc.avatar.SimulatedLowLevelOutputWriter;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotics.MultiBodySystemMissingTools;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.CenterOfMassDataHolder;
import us.ihmc.robotics.sensors.FootSwitchFactory;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.robotics.sensors.ForceSensorData;
import us.ihmc.robotics.sensors.ForceSensorDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDataReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.frames.CommonLeggedReferenceFrames;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.sensorProcessing.model.RobotMotionStatusHolder;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputWriter;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.sensorProcessing.sensorProcessors.SensorOutputMapReadOnly;
import us.ihmc.sensorProcessing.simulatedSensors.SensorDataContext;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReader;
import us.ihmc.sensorProcessing.simulatedSensors.SimulatedSensorHolderAndReaderFromRobotFactory;
import us.ihmc.sensorProcessing.stateEstimation.SensorProcessingConfiguration;
import us.ihmc.sensorProcessing.stateEstimation.StateEstimatorParameters;
import us.ihmc.sensorProcessing.stateEstimation.evaluation.FullInverseDynamicsStructure;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.stateEstimation.humanoid.StateEstimatorController;
import us.ihmc.stateEstimation.humanoid.kinematicsBasedStateEstimation.DRCKinematicsBasedStateEstimator;
import us.ihmc.stateEstimation.humanoid.kinematicsBasedStateEstimation.KinematicsBasedStateEstimatorFactory;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.wholeBodyController.diagnostics.AutomatedDiagnosticAnalysisController;
import us.ihmc.wholeBodyController.diagnostics.DiagnosticControllerToolbox;
import us.ihmc.wholeBodyController.diagnostics.DiagnosticParameters;
import us.ihmc.wholeBodyController.diagnostics.DiagnosticSensorProcessingConfiguration;
import us.ihmc.wholeBodyController.diagnostics.logging.DiagnosticLoggerConfiguration;
import us.ihmc.yoVariables.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.parameters.DefaultParameterReader;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AutomatedDiagnosticSimulationFactory
implements RobotController {
    private final DRCRobotModel robotModel;
    private RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup;
    private final YoRegistry simulationRegistry = new YoRegistry("AutomatedDiagnosticSimulation");
    private final YoDouble controllerTime = new YoDouble("controllerTime", this.simulationRegistry);
    private final AlphaFilteredYoVariable averageControllerTime = new AlphaFilteredYoVariable("averageControllerTime", this.simulationRegistry, 0.99, this.controllerTime);
    private SensorReader sensorReader;
    private AutomatedDiagnosticAnalysisController automatedDiagnosticAnalysisController;
    private JointDesiredOutputWriter lowLevelOutputWriter;
    private final Point3D scsCameraPosition = new Point3D(0.0, -8.0, 1.8);
    private final Point3D scsCameraFix = new Point3D(0.0, 0.0, 1.35);
    private HumanoidFloatingRootJointRobot simulatedRobot;
    private HumanoidReferenceFrames humanoidReferenceFrames;
    private StateEstimatorController stateEstimator;
    private final SensorDataContext sensorDataContext = new SensorDataContext();
    private boolean firstControlTick = true;

    public AutomatedDiagnosticSimulationFactory(DRCRobotModel robotModel) {
        this.robotModel = robotModel;
    }

    public void startSimulation() {
        SimulationConstructionSetParameters simulationParameters = new SimulationConstructionSetParameters(true, 16000);
        SimulationConstructionSet scs = new SimulationConstructionSet((Robot)this.simulatedRobot, simulationParameters);
        scs.setDT(this.robotModel.getSimulateDT(), 10);
        scs.setCameraPosition(this.scsCameraPosition.getX(), this.scsCameraPosition.getY(), this.scsCameraPosition.getZ());
        scs.setCameraFix(this.scsCameraFix.getX(), this.scsCameraFix.getY(), this.scsCameraFix.getZ());
        new DefaultParameterReader().readParametersInRegistry(scs.getRootRegistry());
        scs.startOnAThread();
    }

    public void createDiagnosticController(boolean startWithRobotAlive) {
        this.simulatedRobot = this.robotModel.createHumanoidFloatingRootJointRobot(false);
        DiagnosticLoggerConfiguration.setupLogging((YoDouble)this.simulatedRobot.getYoTime(), this.getClass(), (String)this.robotModel.getSimpleRobotName());
        if (this.robotInitialSetup == null) {
            this.robotInitialSetup = this.robotModel.getDefaultRobotInitialSetup(0.0, 0.0);
        }
        this.robotInitialSetup.initializeRobot(this.simulatedRobot);
        FullHumanoidRobotModel fullRobotModel = this.robotModel.createFullRobotModel();
        YoDouble yoTime = this.simulatedRobot.getYoTime();
        StateEstimatorParameters stateEstimatorParameters = this.robotModel.getStateEstimatorParameters();
        DiagnosticParameters diagnosticParameters = this.robotModel.getDiagnoticParameters();
        JointDesiredOutputList lowLevelOutput = new JointDesiredOutputList((OneDoFJointReadOnly[])fullRobotModel.getOneDoFJoints());
        DiagnosticSensorProcessingConfiguration sensorProcessingConfiguration = diagnosticParameters.getOrCreateSensorProcessingConfiguration((SensorProcessingConfiguration)stateEstimatorParameters, (JointDesiredOutputListReadOnly)lowLevelOutput);
        SensorOutputMapReadOnly sensorOutputMap = this.createStateEstimator(fullRobotModel, stateEstimatorParameters, sensorProcessingConfiguration);
        DiagnosticControllerToolbox diagnosticControllerToolbox = new DiagnosticControllerToolbox(fullRobotModel.getElevator(), fullRobotModel.getRootJoint(), (JointDesiredOutputListBasics)lowLevelOutput, sensorOutputMap, diagnosticParameters, yoTime, this.simulationRegistry);
        this.automatedDiagnosticAnalysisController = new AutomatedDiagnosticAnalysisController(diagnosticControllerToolbox);
        this.automatedDiagnosticAnalysisController.setRobotIsAlive(startWithRobotAlive);
        this.lowLevelOutputWriter = new SimulatedLowLevelOutputWriter((FloatingRootJointRobot)this.simulatedRobot, false);
        this.lowLevelOutputWriter.setJointDesiredOutputList((JointDesiredOutputListBasics)lowLevelOutput);
        int simulationTicksPerControlTick = (int)(this.robotModel.getEstimatorDT() / this.robotModel.getSimulateDT());
        this.simulatedRobot.setController((RobotController)this, simulationTicksPerControlTick);
    }

    private SensorOutputMapReadOnly createStateEstimator(FullHumanoidRobotModel fullRobotModel, StateEstimatorParameters stateEstimatorParameters, DiagnosticSensorProcessingConfiguration sensorProcessingConfiguration) {
        FloatingJointBasics rootJoint = fullRobotModel.getRootJoint();
        IMUDefinition[] imuDefinitions = fullRobotModel.getIMUDefinitions();
        ForceSensorDefinition[] forceSensorDefinitions = fullRobotModel.getForceSensorDefinitions();
        JointDesiredOutputListBasics estimatorDesiredJointDataHolder = null;
        ForceSensorDataHolder forceSensorDataHolderToUpdate = new ForceSensorDataHolder(Arrays.asList(forceSensorDefinitions));
        CenterOfMassDataHolder centerOfMassDataHolderToUpdate = new CenterOfMassDataHolder();
        SimulatedSensorHolderAndReaderFromRobotFactory sensorReaderFactory = new SimulatedSensorHolderAndReaderFromRobotFactory((Robot)this.simulatedRobot, (SensorProcessingConfiguration)sensorProcessingConfiguration);
        sensorReaderFactory.build(rootJoint, imuDefinitions, forceSensorDefinitions, estimatorDesiredJointDataHolder, this.simulationRegistry);
        this.sensorReader = sensorReaderFactory.getSensorReader();
        FullInverseDynamicsStructure inverseDynamicsStructure = KinematicsBasedStateEstimatorFactory.createFullInverseDynamicsStructure((FullHumanoidRobotModel)fullRobotModel);
        SensorOutputMapReadOnly processedSensorOutputMap = this.sensorReader.getProcessedSensorOutputMap();
        HumanoidRobotSensorInformation sensorInformation = this.robotModel.getSensorInformation();
        String[] imuSensorsToUseInStateEstimator = sensorInformation.getIMUSensorsToUseInStateEstimator();
        double gravitationalAcceleration = 9.81;
        double totalRobotWeight = MultiBodySystemMissingTools.computeSubTreeMass((RigidBodyReadOnly)fullRobotModel.getElevator()) * gravitationalAcceleration;
        this.humanoidReferenceFrames = new HumanoidReferenceFrames(fullRobotModel);
        RobotContactPointParameters contactPointParameters = this.robotModel.getContactPointParameters();
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
        contactableBodiesFactory.setFullRobotModel((FullLeggedRobotModel)fullRobotModel);
        contactableBodiesFactory.setReferenceFrames((CommonLeggedReferenceFrames)this.humanoidReferenceFrames);
        SideDependentList bipedFeet = new SideDependentList(contactableBodiesFactory.createFootContactableFeet());
        contactableBodiesFactory.disposeFactory();
        LinkedHashMap<RigidBodyBasics, FootSwitchInterface> footSwitchMap = new LinkedHashMap<RigidBodyBasics, FootSwitchInterface>();
        LinkedHashMap<RigidBodyBasics, ContactablePlaneBody> bipedFeetMap = new LinkedHashMap<RigidBodyBasics, ContactablePlaneBody>();
        SideDependentList footSwitchFactories = stateEstimatorParameters.getFootSwitchFactories();
        for (RobotSide robotSide : RobotSide.values) {
            ContactablePlaneBody contactablePlaneBody = (ContactablePlaneBody)bipedFeet.get((Enum)robotSide);
            RigidBodyBasics rigidBody = contactablePlaneBody.getRigidBody();
            bipedFeetMap.put(rigidBody, contactablePlaneBody);
            String footForceSensorName = (String)sensorInformation.getFeetForceSensorNames().get((Enum)robotSide);
            ForceSensorData footForceSensorForEstimator = forceSensorDataHolderToUpdate.getData(footForceSensorName);
            String namePrefix = ((ContactableFoot)bipedFeet.get((Enum)robotSide)).getName() + "StateEstimator";
            FootSwitchFactory footSwitchFactory = (FootSwitchFactory)footSwitchFactories.get((Enum)robotSide);
            FootSwitchInterface footSwitchInterface = footSwitchFactory.newFootSwitch(namePrefix, contactablePlaneBody, Collections.singleton((ContactableFoot)bipedFeet.get((Enum)robotSide.getOppositeSide())), fullRobotModel.getRootBody(), (ForceSensorDataReadOnly)footForceSensorForEstimator, totalRobotWeight, null, this.simulationRegistry);
            footSwitchMap.put(rigidBody, footSwitchInterface);
        }
        RobotMotionStatusHolder robotMotionStatusHolder = new RobotMotionStatusHolder();
        robotMotionStatusHolder.setCurrentRobotMotionStatus(RobotMotionStatus.UNKNOWN);
        this.stateEstimator = new DRCKinematicsBasedStateEstimator(inverseDynamicsStructure, stateEstimatorParameters, processedSensorOutputMap, centerOfMassDataHolderToUpdate, imuSensorsToUseInStateEstimator, gravitationalAcceleration, footSwitchMap, null, robotMotionStatusHolder, bipedFeetMap, forceSensorDataHolderToUpdate, null);
        this.simulationRegistry.addChild(this.stateEstimator.getYoRegistry());
        return this.sensorReader.getProcessedSensorOutputMap();
    }

    public void setRobotInitialSetup(RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup) {
        this.robotInitialSetup = robotInitialSetup;
    }

    public void setRobotInitialSetup(double groundHeight, double initialYaw) {
        this.robotInitialSetup = this.robotModel.getDefaultRobotInitialSetup(groundHeight, initialYaw);
    }

    public void setSCSCameraPosition(double positionX, double positionY, double positionZ) {
        this.scsCameraPosition.set(positionX, positionY, positionZ);
    }

    public void setSCSCameraFix(double fixX, double fixY, double fixZ) {
        this.scsCameraFix.set(fixX, fixY, fixZ);
    }

    public void initialize() {
    }

    public void doControl() {
        long startTime = System.nanoTime();
        this.lowLevelOutputWriter.writeBefore(startTime);
        long timestamp = this.sensorReader.read(this.sensorDataContext);
        this.sensorReader.compute(timestamp, this.sensorDataContext);
        this.humanoidReferenceFrames.updateFrames();
        if (this.firstControlTick) {
            this.stateEstimator.initialize();
            this.automatedDiagnosticAnalysisController.initialize();
            this.firstControlTick = false;
        } else {
            this.stateEstimator.doControl();
            this.automatedDiagnosticAnalysisController.doControl();
        }
        this.lowLevelOutputWriter.writeAfter();
        long endTime = System.nanoTime();
        this.controllerTime.set(Conversions.nanosecondsToSeconds((long)(endTime - startTime)));
        this.averageControllerTime.update();
    }

    public YoRegistry getYoRegistry() {
        return this.simulationRegistry;
    }

    public String getName() {
        return this.simulationRegistry.getName();
    }

    public String getDescription() {
        return this.getName();
    }
}

