/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.colorVision.stereo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.spinnaker.Spinnaker_C.spinImage;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.perception.spinnaker.BlackflyModelProperties;
import us.ihmc.perception.spinnaker.SpinnakerBlackfly;
import us.ihmc.perception.spinnaker.SpinnakerBlackflyManager;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.tools.IHMCCommonPaths;
import us.ihmc.tools.time.FrequencyStatisticPrinter;

public class DualBlackflyUDPSender {
    private static final String LEFT_SERIAL_NUMBER = "17372478";
    private static final String RIGHT_SERIAL_NUMBER = "17403057";
    private static final BlackflyModelProperties BLACKFLY_MODEL = BlackflyModelProperties.BFLY_U3_23S6C;
    private static final String LEFT_DESTINATION_IP_ADDRESS = System.getProperty("blackfly.left.udp.dest.address", "127.0.0.1");
    private static final String RIGHT_DESTINATION_IP_ADDRESS = System.getProperty("blackfly.right.udp.dest.address", "127.0.0.1");
    public static final int LEFT_UDP_PORT = 9200;
    public static final int RIGHT_UDP_PORT = 9201;
    public static final int IPV4_HEADER_LENGTH = 28;
    public static final int DATAGRAM_MAX_LENGTH = (int)(Math.pow(2.0, 16.0) - 1.0) - 28;
    private final SideDependentList<Thread> publishThreads = new SideDependentList();
    private volatile boolean running;
    private final File propertiesFile = IHMCCommonPaths.VR_DIRECTORY.resolve(this.getClass().getSimpleName() + ".properties").toFile();

    public void start() {
        double originalHeight;
        this.running = true;
        SpinnakerBlackflyManager spinnakerBlackflyManager = new SpinnakerBlackflyManager();
        double originalWidth = BLACKFLY_MODEL.getImageWidthPixels();
        double croppedHeight = originalHeight = BLACKFLY_MODEL.getImageHeightPixels();
        double xOffset = 0.0;
        double yOffset = 0.0;
        float exposureTimeUs = 6000.0f;
        if (this.propertiesFile.exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(this.propertiesFile));
            }
            catch (IOException e) {
                LogTools.error((Object)e);
            }
            try {
                croppedHeight = Integer.parseInt(properties.getProperty("croppedHeight"));
                xOffset = Double.parseDouble(properties.getProperty("xOffset"));
                yOffset = Double.parseDouble(properties.getProperty("yOffset"));
                exposureTimeUs = Float.parseFloat(properties.getProperty("exposureTimeUs"));
            }
            catch (NumberFormatException e) {
                LogTools.error((Object)e);
            }
        }
        LogTools.info((String)("originalWidth " + originalWidth));
        LogTools.info((String)("originalHeight " + originalHeight));
        LogTools.info((String)("croppedHeight " + croppedHeight));
        LogTools.info((String)("exposureTimeUs " + exposureTimeUs));
        LogTools.info((String)("xOffset " + xOffset));
        LogTools.info((String)("yOffset " + yOffset));
        for (RobotSide side : RobotSide.values()) {
            double finalCroppedHeight = croppedHeight;
            double finalXOffset = xOffset;
            double finalYOffset = yOffset;
            float finalExposureTimeUs = exposureTimeUs;
            Thread publishThread = new Thread(() -> {
                InetAddress address;
                DatagramSocket socket;
                SpinnakerBlackfly spinnakerBlackfly = spinnakerBlackflyManager.createSpinnakerBlackfly(side == RobotSide.LEFT ? LEFT_SERIAL_NUMBER : RIGHT_SERIAL_NUMBER, (int)originalWidth, (int)finalCroppedHeight, (int)finalXOffset, (int)finalYOffset, finalExposureTimeUs);
                try {
                    socket = new DatagramSocket();
                }
                catch (SocketException e) {
                    LogTools.error((Object)e);
                    return;
                }
                try {
                    address = InetAddress.getByName(side == RobotSide.LEFT ? LEFT_DESTINATION_IP_ADDRESS : RIGHT_DESTINATION_IP_ADDRESS);
                }
                catch (UnknownHostException e) {
                    LogTools.error((Object)e);
                    return;
                }
                FrequencyStatisticPrinter frequencyStatisticPrinter = new FrequencyStatisticPrinter();
                int frameNumber = 0;
                while (this.running) {
                    spinImage spinImage2 = new spinImage();
                    spinnakerBlackfly.getNextImage(spinImage2);
                    int width = spinnakerBlackfly.getWidth(spinImage2);
                    int height = spinnakerBlackfly.getHeight(spinImage2);
                    int imageFrameSize = width * height;
                    BytePointer spinImageData = new BytePointer((long)imageFrameSize);
                    spinnakerBlackfly.setPointerToSpinImageData(spinImage2, (Pointer)spinImageData);
                    int latestImageDataLength = (int)spinImageData.limit();
                    byte[] imageData = new byte[latestImageDataLength];
                    spinImageData.get(imageData, 0, latestImageDataLength);
                    int imageFrameSizeWithPadding = (int)((double)width * originalHeight);
                    byte[] imageDataWithPadding = new byte[imageFrameSizeWithPadding];
                    int paddingOffset = imageFrameSizeWithPadding - imageFrameSize;
                    for (int i = 0; i < imageDataWithPadding.length; ++i) {
                        imageDataWithPadding[i] = i < paddingOffset ? (byte)0 : imageData[i - paddingOffset];
                    }
                    int numberOfDatagramFragments = (int)Math.ceil((double)imageFrameSizeWithPadding / (double)DATAGRAM_MAX_LENGTH);
                    for (int fragment = 0; fragment < numberOfDatagramFragments; ++fragment) {
                        int fragmentHeaderLength = 25;
                        int maxFragmentDataLength = DATAGRAM_MAX_LENGTH - fragmentHeaderLength;
                        int fragmentDataOffset = fragment * maxFragmentDataLength;
                        int fragmentDataLength = Math.min(maxFragmentDataLength, imageFrameSizeWithPadding - fragmentDataOffset);
                        int datagramLength = fragmentHeaderLength + fragmentDataLength;
                        byte[] datagramData = new byte[DATAGRAM_MAX_LENGTH];
                        ByteBuffer datagramBuffer = ByteBuffer.wrap(datagramData);
                        if (datagramLength > DATAGRAM_MAX_LENGTH) {
                            throw new RuntimeException("Too many bytes");
                        }
                        datagramBuffer.put(side.toByte());
                        datagramBuffer.putInt(width);
                        datagramBuffer.putInt(height);
                        datagramBuffer.putInt(imageFrameSizeWithPadding);
                        datagramBuffer.putInt(frameNumber);
                        datagramBuffer.putInt(fragment);
                        datagramBuffer.putInt(fragmentDataLength);
                        for (int i = 0; i < fragmentDataLength; ++i) {
                            datagramBuffer.put(imageDataWithPadding[fragmentDataOffset + i]);
                        }
                        DatagramPacket packet = new DatagramPacket(datagramData, datagramLength, address, side == RobotSide.LEFT ? 9200 : 9201);
                        try {
                            socket.send(packet);
                            continue;
                        }
                        catch (IOException e) {
                            LogTools.error((Object)e);
                        }
                    }
                    spinnakerBlackfly.releaseImage(spinImage2);
                    ++frameNumber;
                    frequencyStatisticPrinter.ping();
                }
                spinnakerBlackfly.stopAcquiringImages();
                socket.close();
            });
            this.publishThreads.put((Enum)side, (Object)publishThread);
            publishThread.start();
        }
    }

    public void stop() {
        this.running = false;
        for (Thread publishThread : this.publishThreads) {
            try {
                publishThread.join();
            }
            catch (InterruptedException e) {
                LogTools.error((Object)e);
            }
        }
    }

    public static void main(String[] args) {
        DualBlackflyUDPSender dualBlackflyUDPSender = new DualBlackflyUDPSender();
        dualBlackflyUDPSender.start();
        Runtime.getRuntime().addShutdownHook(new Thread(dualBlackflyUDPSender::stop));
        ThreadTools.sleepForever();
    }
}

