/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.colorVision.stereo;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import us.ihmc.avatar.colorVision.stereo.DualBlackflyUDPSender;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.FrequencyCalculator;
import us.ihmc.log.LogTools;
import us.ihmc.perception.ImageDimensions;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class DualBlackflyUDPReceiver {
    private final SideDependentList<Thread> receiveThreads = new SideDependentList();
    private volatile boolean running = false;
    private volatile boolean connected = false;
    private final SideDependentList<String> addresses = new SideDependentList();
    private final SideDependentList<byte[]> imageBuffers = new SideDependentList();
    private final SideDependentList<ImageDimensions> imageDimensions = new SideDependentList(ImageDimensions::new);
    private final SideDependentList<FrequencyCalculator> frequencyCalculators = new SideDependentList();

    public DualBlackflyUDPReceiver() {
        this.frequencyCalculators.put((Enum)RobotSide.LEFT, (Object)new FrequencyCalculator());
        this.frequencyCalculators.put((Enum)RobotSide.RIGHT, (Object)new FrequencyCalculator());
        this.addresses.put((Enum)RobotSide.LEFT, (Object)"172.16.66.230");
        this.addresses.put((Enum)RobotSide.RIGHT, (Object)"172.16.66.230");
    }

    public boolean connected() {
        return this.connected;
    }

    public void start() {
        this.running = true;
        for (RobotSide side : RobotSide.values) {
            Thread receiveThread = new Thread(() -> {
                DatagramSocket socket;
                InetSocketAddress socketAddress = new InetSocketAddress((String)this.addresses.get((Enum)side), side == RobotSide.LEFT ? 9200 : 9201);
                try {
                    socket = new DatagramSocket(socketAddress);
                }
                catch (SocketException e) {
                    e.printStackTrace();
                    LogTools.error((String)("Unable to bind to address for Blackfly UDP streaming: " + String.valueOf(socketAddress)));
                    return;
                }
                LogTools.info((String)("Connecting to: " + String.valueOf(socketAddress)));
                byte[] buffer = new byte[(int)(Math.pow(2.0, 16.0) - 1.0)];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                while (this.running) {
                    try {
                        socket.setSoTimeout(1000);
                        socket.receive(packet);
                        this.connected = true;
                    }
                    catch (IOException e) {
                        LogTools.error((Object)e);
                        this.connected = false;
                        this.running = false;
                        break;
                    }
                    ByteBuffer datagramBuffer = ByteBuffer.wrap(buffer);
                    int fragmentHeaderLength = 25;
                    RobotSide sideFromDatagram = RobotSide.fromByte((byte)datagramBuffer.get());
                    int width = datagramBuffer.getInt();
                    int height = datagramBuffer.getInt();
                    int imageBytes = datagramBuffer.getInt();
                    int frameNumber = datagramBuffer.getInt();
                    int fragment = datagramBuffer.getInt();
                    int fragmentDataLength = datagramBuffer.getInt();
                    byte[] fragmentDataBytes = new byte[fragmentDataLength];
                    int maxFragmentDataLength = DualBlackflyUDPSender.DATAGRAM_MAX_LENGTH - fragmentHeaderLength;
                    int fragmentDataOffset = fragment * maxFragmentDataLength;
                    byte[] imageBuffer = (byte[])this.imageBuffers.get((Enum)sideFromDatagram);
                    if (imageBuffer == null || imageBuffer.length != imageBytes) {
                        imageBuffer = new byte[imageBytes];
                        this.imageBuffers.put((Enum)sideFromDatagram, (Object)imageBuffer);
                    }
                    ((ImageDimensions)this.imageDimensions.get((Enum)sideFromDatagram)).setImageWidth(width);
                    ((ImageDimensions)this.imageDimensions.get((Enum)sideFromDatagram)).setImageHeight(height);
                    for (int i = 0; i < fragmentDataLength; ++i) {
                        imageBuffer[fragmentDataOffset + i] = datagramBuffer.get(fragmentHeaderLength + i);
                    }
                    ((FrequencyCalculator)this.frequencyCalculators.get((Enum)side)).ping();
                }
                socket.disconnect();
                socket.close();
                this.connected = false;
            });
            this.receiveThreads.put((Enum)side, (Object)receiveThread);
            receiveThread.start();
        }
    }

    public void stop() {
        this.running = false;
        for (Thread receiveThread : this.receiveThreads) {
            if (receiveThread == null) continue;
            try {
                receiveThread.join();
            }
            catch (InterruptedException e) {
                LogTools.error((Object)e);
            }
        }
    }

    public void setAddress(RobotSide side, String address) {
        this.addresses.put((Enum)side, (Object)address);
    }

    public SideDependentList<String> getAddresses() {
        return this.addresses;
    }

    public SideDependentList<byte[]> getImageBuffers() {
        return this.imageBuffers;
    }

    public SideDependentList<ImageDimensions> getImageDimensions() {
        return this.imageDimensions;
    }

    public SideDependentList<FrequencyCalculator> getFrequencyCalculators() {
        return this.frequencyCalculators;
    }

    public static void main(String[] args) {
        DualBlackflyUDPReceiver dualBlackflyUDPReceiver = new DualBlackflyUDPReceiver();
        dualBlackflyUDPReceiver.start();
        Runtime.getRuntime().addShutdownHook(new Thread(dualBlackflyUDPReceiver::stop));
        ThreadTools.sleepForever();
    }
}

