/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.colorVision;

import java.time.Instant;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_cudaimgproc;
import org.bytedeco.opencv.opencv_core.GpuMat;
import org.bytedeco.spinnaker.Spinnaker_C.spinImage;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ros2.ROS2DemandGraphNode;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.perception.BytedecoImage;
import us.ihmc.perception.CameraModel;
import us.ihmc.perception.RawImage;
import us.ihmc.perception.camera.CameraIntrinsics;
import us.ihmc.perception.parameters.IntrinsicCameraMatrixProperties;
import us.ihmc.perception.sensorHead.BlackflyLensProperties;
import us.ihmc.perception.sensorHead.SensorHeadParameters;
import us.ihmc.perception.spinnaker.SpinnakerBlackfly;
import us.ihmc.perception.spinnaker.SpinnakerBlackflyManager;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.tools.thread.RestartableThrottledThread;

public class BlackflyImageRetriever {
    private static final double BLACKFLY_FPS = 30.0;
    private final String blackflySerialNumber;
    private SpinnakerBlackflyManager blackflyManager;
    private SpinnakerBlackfly blackfly;
    private final IntrinsicCameraMatrixProperties ousterFisheyeColoringIntrinsics;
    private CameraIntrinsics ousterFisheyeColorCameraIntrinsics;
    private final Supplier<ReferenceFrame> cameraFrameSupplier;
    private final FramePose3D cameraPose = new FramePose3D();
    private long sequenceNumber = 0L;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private RawImage distortedImage = null;
    private final ROS2DemandGraphNode demandGraphNode;
    private final RestartableThrottledThread imageGrabThread;
    private int numberOfFailedReads = 0;
    private final Lock newImageLock = new ReentrantLock();
    private final Condition newImageAvailable = this.newImageLock.newCondition();
    private long lastSequenceNumber = -1L;

    public BlackflyImageRetriever(String blackflySerialNumber, BlackflyLensProperties lensProperties, RobotSide side, Supplier<ReferenceFrame> cameraFrameSupplier, ROS2DemandGraphNode blackflyDemandNode) {
        this.blackflySerialNumber = blackflySerialNumber;
        this.ousterFisheyeColoringIntrinsics = SensorHeadParameters.loadOusterFisheyeColoringIntrinsicsOnRobot((BlackflyLensProperties)lensProperties);
        this.cameraFrameSupplier = cameraFrameSupplier;
        this.demandGraphNode = blackflyDemandNode;
        this.imageGrabThread = new RestartableThrottledThread(side.getCamelCaseName() + "BlackflyImageGrabber", 30.0, this::grabImage);
        this.imageGrabThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabImage() {
        if (this.demandGraphNode.isDemanded()) {
            if (this.blackfly == null || this.numberOfFailedReads > 30) {
                if (!this.initializeBlackfly()) {
                    ThreadTools.sleep((long)3000L);
                }
            } else {
                spinImage spinImage2 = new spinImage();
                if (this.blackfly.getNextImage(spinImage2)) {
                    Instant acquisitionTime = Instant.now();
                    this.cameraPose.setToZero(this.cameraFrameSupplier.get());
                    this.cameraPose.changeFrame(ReferenceFrame.getWorldFrame());
                    if (this.imageWidth == 0 || this.imageHeight == 0) {
                        this.imageWidth = this.blackfly.getWidth(spinImage2);
                        this.imageHeight = this.blackfly.getHeight(spinImage2);
                        this.ousterFisheyeColorCameraIntrinsics = new CameraIntrinsics(this.imageHeight, this.imageWidth, this.ousterFisheyeColoringIntrinsics.getFocalLengthX(), this.ousterFisheyeColoringIntrinsics.getFocalLengthY(), this.ousterFisheyeColoringIntrinsics.getPrinciplePointX(), this.ousterFisheyeColoringIntrinsics.getPrinciplePointY());
                    }
                    BytePointer spinImageData = new BytePointer((long)this.imageWidth * (long)this.imageHeight);
                    this.blackfly.setPointerToSpinImageData(spinImage2, (Pointer)spinImageData);
                    BytedecoImage sourceByedecoImage = new BytedecoImage(this.imageWidth, this.imageHeight, opencv_core.CV_8UC1);
                    sourceByedecoImage.changeAddress(spinImageData.address());
                    GpuMat deviceSourceImage = new GpuMat(this.imageHeight, this.imageWidth, opencv_core.CV_8UC1);
                    deviceSourceImage.upload(sourceByedecoImage.getBytedecoOpenCVMat());
                    GpuMat sourceImageBGR = new GpuMat(this.imageHeight, this.imageWidth, opencv_core.CV_8UC3);
                    opencv_cudaimgproc.cvtColor((GpuMat)deviceSourceImage, (GpuMat)sourceImageBGR, (int)46);
                    this.newImageLock.lock();
                    try {
                        if (this.distortedImage != null) {
                            this.distortedImage.release();
                        }
                        this.distortedImage = RawImage.createWithBGRImage((Pointer)sourceImageBGR.clone(), (CameraIntrinsics)this.ousterFisheyeColorCameraIntrinsics, (CameraModel)CameraModel.EQUIDISTANT_FISHEYE, (RigidBodyTransformReadOnly)this.cameraPose, (Instant)acquisitionTime, (long)this.sequenceNumber++);
                        this.newImageAvailable.signal();
                    }
                    finally {
                        this.newImageLock.unlock();
                    }
                    spinImageData.close();
                    deviceSourceImage.close();
                    sourceImageBGR.close();
                } else {
                    ++this.numberOfFailedReads;
                }
                this.blackfly.releaseImage(spinImage2);
            }
        } else {
            ThreadTools.sleep((long)500L);
        }
    }

    public RawImage getLatestRawImage() {
        this.newImageLock.lock();
        try {
            while (this.distortedImage == null || this.distortedImage.isEmpty() || this.distortedImage.getSequenceNumber() == this.lastSequenceNumber) {
                this.newImageAvailable.await();
            }
            this.lastSequenceNumber = this.distortedImage.getSequenceNumber();
        }
        catch (InterruptedException interruptedException) {
            LogTools.error((String)interruptedException.getMessage());
        }
        finally {
            this.newImageLock.unlock();
        }
        return this.distortedImage.get();
    }

    public void start() {
        this.imageGrabThread.start();
    }

    public void stop() {
        this.imageGrabThread.stop();
    }

    public void destroy() {
        System.out.println("Destroying " + this.getClass().getSimpleName());
        this.imageGrabThread.blockingStop();
        if (this.blackfly != null) {
            this.blackfly.stopAcquiringImages();
        }
        if (this.blackflyManager != null) {
            this.blackflyManager.destroy();
        }
        System.out.println("Destroyed " + this.getClass().getSimpleName());
    }

    private boolean initializeBlackfly() {
        LogTools.info((String)("Initializing Blackfly: " + this.blackflySerialNumber));
        if (this.blackfly != null) {
            this.blackfly.stopAcquiringImages();
        }
        if (this.blackflyManager != null) {
            this.blackflyManager.destroy();
        }
        this.blackflyManager = new SpinnakerBlackflyManager();
        this.blackfly = this.blackflyManager.createSpinnakerBlackfly(this.blackflySerialNumber);
        if (this.blackfly == null) {
            LogTools.error((String)("Failed to initialize Blackfly: " + this.blackflySerialNumber));
        } else {
            LogTools.info((String)("Initialized Blackfly: " + this.blackflySerialNumber));
            this.numberOfFailedReads = 0;
        }
        return this.blackfly != null;
    }
}

