/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.colorVision;

import ihmc_common_msgs.msg.dds.InstantMessage;
import java.time.Instant;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.opencv.global.opencv_cudawarping;
import org.bytedeco.opencv.opencv_core.GpuMat;
import org.bytedeco.opencv.opencv_core.Size;
import perception_msgs.msg.dds.ImageMessage;
import us.ihmc.avatar.colorVision.BlackflyComms;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.property.ROS2StoredPropertySet;
import us.ihmc.perception.CameraModel;
import us.ihmc.perception.RawImage;
import us.ihmc.perception.cuda.CUDAJPEGProcessor;
import us.ihmc.perception.imageMessage.CompressionType;
import us.ihmc.perception.imageMessage.ImageMessageDataPacker;
import us.ihmc.perception.imageMessage.PixelFormat;
import us.ihmc.perception.parameters.IntrinsicCameraMatrixProperties;
import us.ihmc.perception.sensorHead.BlackflyLensProperties;
import us.ihmc.perception.sensorHead.SensorHeadParameters;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.property.StoredPropertySetBasics;
import us.ihmc.tools.thread.RestartableThread;

public class BlackflyImagePublisher {
    private final ROS2Node ros2Node;
    private final ROS2StoredPropertySet<IntrinsicCameraMatrixProperties> ousterFisheyeColoringIntrinsicsROS2;
    private final ROS2Publisher<ImageMessage> ros2DistoredImagePublisher;
    private final CUDAJPEGProcessor imageEncoder = new CUDAJPEGProcessor();
    private long lastImageSequenceNumber = -1L;
    private RawImage nextGpuDistortedImage;
    private final RestartableThread publishDistoredColorThread;
    private final Lock imagePublishLock = new ReentrantLock();
    private final Condition newImageAvailable = this.imagePublishLock.newCondition();
    private float publishedImageScaleFactor = 1.0f;

    public BlackflyImagePublisher(BlackflyLensProperties lensProperties, ROS2Topic<ImageMessage> distortedImageTopic, float publishedImageScaleFactor) {
        IntrinsicCameraMatrixProperties ousterFisheyeColoringIntrinsics = SensorHeadParameters.loadOusterFisheyeColoringIntrinsicsOnRobot((BlackflyLensProperties)lensProperties);
        this.ros2Node = new ROS2NodeBuilder().build("blackfly_publisher");
        this.ros2DistoredImagePublisher = this.ros2Node.createPublisher(distortedImageTopic);
        this.ousterFisheyeColoringIntrinsicsROS2 = new ROS2StoredPropertySet(this.ros2Node, BlackflyComms.OUSTER_FISHEYE_COLORING_INTRINSICS, (StoredPropertySetBasics)ousterFisheyeColoringIntrinsics);
        this.publishedImageScaleFactor = publishedImageScaleFactor;
        this.publishDistoredColorThread = new RestartableThread("BlackflyDistortedImagePublisher", this::distortedImagePublisherThreadFunction);
        this.publishDistoredColorThread.start();
    }

    private void distortedImagePublisherThreadFunction() {
        this.imagePublishLock.lock();
        try {
            while ((this.nextGpuDistortedImage == null || this.nextGpuDistortedImage.isEmpty() || this.nextGpuDistortedImage.getSequenceNumber() == this.lastImageSequenceNumber) && this.publishDistoredColorThread.isRunning()) {
                this.newImageAvailable.await();
            }
            this.publishDistortedColor(this.nextGpuDistortedImage);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.imagePublishLock.unlock();
        }
    }

    private void publishDistortedColor(RawImage distortedImageToPublish) {
        RawImage imageToPublish = null;
        if (distortedImageToPublish != null) {
            imageToPublish = new RawImage(distortedImageToPublish);
        }
        this.imagePublishLock.unlock();
        if (imageToPublish != null && !imageToPublish.isEmpty() && imageToPublish.getSequenceNumber() != this.lastImageSequenceNumber) {
            GpuMat scaledImageMat = new GpuMat();
            int scaledWidth = Math.round((float)imageToPublish.getWidth() * this.publishedImageScaleFactor);
            int scaledHeight = Math.round((float)imageToPublish.getHeight() * this.publishedImageScaleFactor);
            opencv_cudawarping.resize((GpuMat)imageToPublish.getGpuImageMat(), (GpuMat)scaledImageMat, (Size)new Size(scaledWidth, scaledHeight));
            BytePointer distortedImageJPEGPointer = new BytePointer((long)scaledImageMat.rows() * (long)scaledImageMat.cols());
            this.imageEncoder.encodeBGR(scaledImageMat, distortedImageJPEGPointer);
            this.ousterFisheyeColoringIntrinsicsROS2.updateAndPublishThrottledStatus();
            ImageMessage distortedImageMessage = new ImageMessage();
            ImageMessageDataPacker imageMessageDataPacker = new ImageMessageDataPacker(distortedImageJPEGPointer.limit());
            imageMessageDataPacker.pack(distortedImageMessage, distortedImageJPEGPointer);
            MessageTools.toMessage((Instant)imageToPublish.getAcquisitionTime(), (InstantMessage)distortedImageMessage.getAcquisitionTime());
            distortedImageMessage.setFocalLengthXPixels(imageToPublish.getFocalLengthX() * this.publishedImageScaleFactor);
            distortedImageMessage.setFocalLengthYPixels(imageToPublish.getFocalLengthY() * this.publishedImageScaleFactor);
            distortedImageMessage.setPrincipalPointXPixels(imageToPublish.getPrincipalPointX() * this.publishedImageScaleFactor);
            distortedImageMessage.setPrincipalPointYPixels(imageToPublish.getPrincipalPointY() * this.publishedImageScaleFactor);
            distortedImageMessage.setImageWidth(scaledWidth);
            distortedImageMessage.setImageHeight(scaledHeight);
            distortedImageMessage.getPosition().set(imageToPublish.getTranslation());
            distortedImageMessage.getOrientation().set(imageToPublish.getRotation());
            distortedImageMessage.setSequenceNumber(imageToPublish.getSequenceNumber());
            distortedImageMessage.setCameraModel(CameraModel.EQUIDISTANT_FISHEYE.toByte());
            distortedImageMessage.setPixelFormat(PixelFormat.BGR8.toByte());
            distortedImageMessage.setCompressionType(CompressionType.NVJPEG.toByte());
            this.ros2DistoredImagePublisher.publish((Object)distortedImageMessage);
            this.lastImageSequenceNumber = imageToPublish.getSequenceNumber();
            distortedImageJPEGPointer.close();
            scaledImageMat.close();
            imageToPublish.release();
        }
    }

    public void startImagePublishing() {
        this.publishDistoredColorThread.start();
    }

    public void startAll() {
        this.startImagePublishing();
    }

    public void stopImagePublishing() {
        this.publishDistoredColorThread.stop();
        this.imagePublishLock.lock();
        try {
            this.newImageAvailable.signal();
        }
        finally {
            this.imagePublishLock.unlock();
        }
    }

    public void stopAll() {
        this.stopImagePublishing();
    }

    public void destroy() {
        System.out.println("Destroying " + this.getClass().getSimpleName());
        this.publishDistoredColorThread.stop();
        this.imagePublishLock.lock();
        try {
            this.newImageAvailable.signal();
        }
        finally {
            this.imagePublishLock.unlock();
        }
        if (this.nextGpuDistortedImage != null) {
            this.nextGpuDistortedImage.release();
        }
        this.imageEncoder.destroy();
        this.ros2DistoredImagePublisher.remove();
        this.ros2Node.destroy();
        System.out.println("Destroyed " + this.getClass().getSimpleName());
    }

    public void setNextDistortedImage(RawImage distortedImage) {
        this.imagePublishLock.lock();
        try {
            if (this.nextGpuDistortedImage != null) {
                this.nextGpuDistortedImage.release();
            }
            this.nextGpuDistortedImage = distortedImage;
            this.newImageAvailable.signal();
        }
        finally {
            this.imagePublishLock.unlock();
        }
    }
}

