/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commons.lists.PairList;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputWriter;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SimulatedLowLevelOutputWriter
implements JointDesiredOutputWriter {
    protected final FloatingRootJointRobot robot;
    protected final boolean writeBeforeEstimatorTick;
    protected final PairList<OneDegreeOfFreedomJoint, JointDesiredOutputReadOnly> revoluteJoints = new PairList();

    public SimulatedLowLevelOutputWriter(FloatingRootJointRobot robot, boolean writeBeforeEstimatorTick) {
        this.robot = robot;
        this.writeBeforeEstimatorTick = writeBeforeEstimatorTick;
    }

    public void setJointDesiredOutputList(JointDesiredOutputListBasics lowLevelDataHolder) {
        this.revoluteJoints.clear();
        for (int i = 0; i < lowLevelDataHolder.getNumberOfJointsWithDesiredOutput(); ++i) {
            OneDoFJointReadOnly revoluteJoint = lowLevelDataHolder.getOneDoFJoint(i);
            JointDesiredOutputBasics data = lowLevelDataHolder.getJointDesiredOutput(i);
            String name = revoluteJoint.getName();
            OneDegreeOfFreedomJoint oneDoFJoint = this.robot.getOneDegreeOfFreedomJoint(name);
            ImmutablePair jointPair = new ImmutablePair((Object)oneDoFJoint, (Object)data);
            this.revoluteJoints.add((Object)jointPair);
        }
    }

    protected void write() {
        for (int i = 0; i < this.revoluteJoints.size(); ++i) {
            OneDegreeOfFreedomJoint pinJoint = (OneDegreeOfFreedomJoint)this.revoluteJoints.first(i);
            if (pinJoint == null) continue;
            JointDesiredOutputReadOnly data = (JointDesiredOutputReadOnly)this.revoluteJoints.second(i);
            if (data.hasDesiredTorque()) {
                pinJoint.setTau(data.getDesiredTorque());
            }
            if (data.hasStiffness()) {
                pinJoint.setKp(data.getStiffness());
            }
            if (data.hasDamping()) {
                pinJoint.setKd(data.getDamping());
            }
            if (data.hasDesiredPosition()) {
                pinJoint.setqDesired(data.getDesiredPosition());
            }
            if (!data.hasDesiredVelocity()) continue;
            pinJoint.setQdDesired(data.getDesiredVelocity());
        }
    }

    public void writeBefore(long timestamp) {
        if (this.writeBeforeEstimatorTick) {
            this.write();
        }
    }

    public YoRegistry getYoVariableRegistry() {
        return null;
    }

    public void writeAfter() {
        if (!this.writeBeforeEstimatorTick) {
            this.write();
        }
    }
}

