/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.stage.FileChooser;
import org.apache.commons.io.FilenameUtils;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.conversion.VisualsConversionTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.SimulationConstructionSet2;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.simulationConstructionSetTools.util.ground.MeshTerrainObject;
import us.ihmc.simulationConstructionSetTools.util.ground.MeshTerrainObjectParameters;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class MeshTerrainObjectViewer {
    private final YoInteger maximumNumberOfHulls;
    private final YoInteger maximumNumberOfVerticesPerHull;
    private final YoInteger maximumVoxelResolution;
    private final YoDouble maximumVolumetricPercentError;
    private final YoBoolean showRawMeshGraphics;
    private final YoBoolean showDecomposedMeshGraphics;
    private final YoBoolean doConvexDecomposition;
    private final YoBoolean updateVisuals;
    private MeshTerrainObjectParameters parameters;
    private MeshTerrainObject meshTerrainObject;
    private static SimulationConstructionSet2 scs = null;
    private final YoRegistry registry = new YoRegistry("DecomopsitionParameters");
    private List<VisualDefinition> visuals = null;
    private File currentMeshFile = null;

    public MeshTerrainObjectViewer() {
        MeshTerrainObjectParameters parameters = new MeshTerrainObjectParameters();
        this.maximumNumberOfHulls = new YoInteger("maximumNumberOfHulls", this.registry);
        this.maximumNumberOfHulls.setVariableBounds(0.0, 0.0);
        this.maximumNumberOfVerticesPerHull = new YoInteger("maximumNumberOfVerticesPerHull", this.registry);
        this.maximumNumberOfVerticesPerHull.setVariableBounds(0.0, 0.0);
        this.maximumVoxelResolution = new YoInteger("maximumVoxelResolution", this.registry);
        this.maximumNumberOfVerticesPerHull.setVariableBounds(100000.0, 1.0E7);
        this.maximumVolumetricPercentError = new YoDouble("maximumVolumetricPercentError", this.registry);
        this.maximumNumberOfVerticesPerHull.setVariableBounds(0.0, 0.0);
        this.showRawMeshGraphics = new YoBoolean("showRawMeshGraphics", this.registry);
        this.showDecomposedMeshGraphics = new YoBoolean("showDecomposedMeshGraphics", this.registry);
        this.doConvexDecomposition = new YoBoolean("doConvexDecomposition", this.registry);
        this.updateVisuals = new YoBoolean("UpdateVisuals", this.registry);
        this.updateVisuals.set(false);
        this.maximumNumberOfHulls.set(parameters.getMaxNoOfHulls());
        this.maximumNumberOfVerticesPerHull.set(parameters.getMaxNoOfVertices());
        this.maximumVoxelResolution.set(parameters.getVoxelResolution());
        this.maximumVolumetricPercentError.set(parameters.getMaxVolumePercentError());
        this.showRawMeshGraphics.set(parameters.isShowUndecomposedMeshGraphics());
        this.showDecomposedMeshGraphics.set(parameters.isShowDecomposedMeshGraphics());
        this.doConvexDecomposition.set(parameters.isDoConvexDecomposition());
        scs = new SimulationConstructionSet2("MeshTerrainObjectViewer");
        scs.addRegistry(this.registry);
        this.parameters = new MeshTerrainObjectParameters();
        scs.startSimulationThread();
        scs.waitUntilVisualizerFullyUp();
        Platform.runLater(() -> {
            Button loadTerrainMeshButton = new Button("Load Terrain Mesh");
            loadTerrainMeshButton.setOnAction(e -> this.loadMeshTerrain());
            scs.addCustomGUIControl((Node)loadTerrainMeshButton);
            Button saveTerrainMeshParams = new Button("Save terrain mesh params");
            saveTerrainMeshParams.setOnAction(e -> this.saveTerrainMeshParameters());
            scs.addCustomGUIControl((Node)saveTerrainMeshParams);
        });
    }

    private void loadMeshTerrain() {
        File result;
        FileChooser fileChooser = new FileChooser();
        File defaultFilePath = SessionVisualizerIOTools.getDefaultFilePath((String)"MeshTerrain");
        if (defaultFilePath != null) {
            fileChooser.setInitialDirectory(defaultFilePath);
        }
        if ((result = fileChooser.showOpenDialog(scs.getPrimaryGUIWindow())) == null) {
            return;
        }
        SessionVisualizerIOTools.setDefaultFilePath((String)"MeshTerrain", (File)result);
        this.makeMeshTerrainObject(result.getAbsolutePath());
        this.parameters = this.meshTerrainObject.getParameters();
        this.updateYoVariables();
        this.updateGraphics();
        this.currentMeshFile = result;
    }

    private void saveTerrainMeshParameters() {
        if (this.currentMeshFile == null) {
            LogTools.error((String)"Couldn't save parameters");
            return;
        }
        File parentFile = this.currentMeshFile.getParentFile();
        String meshName = FilenameUtils.removeExtension((String)this.currentMeshFile.getName());
        File parameterFile = new File(parentFile, meshName + "_VHACDParameters.json");
        try {
            if (parameterFile.exists()) {
                parameterFile.delete();
            }
            parameterFile.createNewFile();
            JsonFactory jsonFactory = new JsonFactory();
            JsonGenerator generator = jsonFactory.createGenerator((OutputStream)new FileOutputStream(parameterFile));
            generator.useDefaultPrettyPrinter();
            generator.writeStartObject();
            generator.writeNumberField(this.maximumNumberOfHulls.getName(), this.maximumNumberOfHulls.getValue());
            generator.writeNumberField(this.maximumNumberOfVerticesPerHull.getName(), this.maximumNumberOfVerticesPerHull.getValue());
            generator.writeNumberField(this.maximumVolumetricPercentError.getName(), this.maximumVolumetricPercentError.getValue());
            generator.writeNumberField(this.maximumVoxelResolution.getName(), this.maximumVoxelResolution.getValue());
            generator.writeBooleanField(this.showDecomposedMeshGraphics.getName(), this.showDecomposedMeshGraphics.getValue());
            generator.writeBooleanField(this.showRawMeshGraphics.getName(), this.showRawMeshGraphics.getValue());
            generator.writeBooleanField(this.doConvexDecomposition.getName(), this.doConvexDecomposition.getValue());
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void makeMeshTerrainObject(String pathToMesh) {
        if (pathToMesh == null) {
            return;
        }
        this.meshTerrainObject = new MeshTerrainObject(pathToMesh);
    }

    private void makeMeshTerrainObject(MeshTerrainObjectParameters parameters) {
        if (parameters == null || parameters.getModelDirectory() == null) {
            return;
        }
        this.meshTerrainObject = new MeshTerrainObject(parameters);
    }

    private void updateGraphics() {
        if (this.visuals != null) {
            scs.removeStaticVisuals(this.visuals);
        }
        this.visuals = VisualsConversionTools.toVisualDefinitions((Graphics3DObject)this.meshTerrainObject.getLinkGraphics());
        scs.addStaticVisuals(this.visuals);
    }

    private MeshTerrainObjectParameters getParameters() {
        return this.parameters;
    }

    private void updateParameters() {
        this.parameters.setMaxNoOfHulls(this.maximumNumberOfHulls.getValue());
        this.parameters.setMaxNoOfVertices(this.maximumNumberOfVerticesPerHull.getValue());
        this.parameters.setVoxelResolution(this.maximumVoxelResolution.getValue());
        this.parameters.setMaxVolumePercentError(this.maximumVolumetricPercentError.getValue());
        this.parameters.setShowDecomposedMeshGraphics(this.showDecomposedMeshGraphics.getValue());
        this.parameters.setShowUndecomposedMeshGraphics(this.showRawMeshGraphics.getValue());
        this.parameters.setDoConvexDecomposition(this.doConvexDecomposition.getValue());
    }

    private void updateYoVariables() {
        this.maximumNumberOfHulls.set(this.parameters.getMaxNoOfHulls());
        this.maximumNumberOfVerticesPerHull.set(this.parameters.getMaxNoOfVertices());
        this.maximumVoxelResolution.set(this.parameters.getVoxelResolution());
        this.maximumVolumetricPercentError.set(this.parameters.getMaxVolumePercentError());
        this.showDecomposedMeshGraphics.set(this.parameters.isShowDecomposedMeshGraphics());
        this.showRawMeshGraphics.set(this.parameters.isShowUndecomposedMeshGraphics());
        this.doConvexDecomposition.set(this.parameters.isDoConvexDecomposition());
    }

    public static void main(String[] args) {
        MeshTerrainObjectViewer viewer = new MeshTerrainObjectViewer();
        scs.addAfterPhysicsCallback(time -> {
            if (viewer.updateVisuals.getValue()) {
                viewer.updateVisuals.set(false);
                viewer.updateParameters();
                viewer.makeMeshTerrainObject(viewer.getParameters());
                viewer.updateGraphics();
            }
        });
        scs.initializeBufferSize(1000);
        scs.setRealTimeRateSimulation(true);
        scs.start(true, false, false);
        scs.simulate();
    }
}

