/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.AvatarEstimatorThread;
import us.ihmc.avatar.factory.HumanoidRobotControlTask;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.controllerCore.command.CrossRobotCommandResolver;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.time.ThreadTimer;
import us.ihmc.yoVariables.variable.YoLong;

public class EstimatorTask
extends HumanoidRobotControlTask {
    private final CrossRobotCommandResolver estimatorResolver;
    private final CrossRobotCommandResolver masterResolver;
    private final AvatarEstimatorThread estimatorThread;
    private final long divisor;
    private final ThreadTimer timer;
    private final YoLong ticksBehindScheduled;
    private final List<Runnable> preEstimatorCallbacks = new ArrayList<Runnable>();
    private final List<Runnable> postEstimatorCallbacks = new ArrayList<Runnable>();
    private final List<Runnable> schedulerThreadRunnables = new ArrayList<Runnable>();
    private boolean masterContextUpdated = false;

    public EstimatorTask(AvatarEstimatorThread estimatorThread, long divisor, double schedulerDt, FullHumanoidRobotModel masterFullRobotModel) {
        super(divisor);
        this.divisor = divisor;
        this.estimatorThread = estimatorThread;
        this.estimatorResolver = new CrossRobotCommandResolver(estimatorThread.getFullRobotModel());
        this.masterResolver = new CrossRobotCommandResolver(masterFullRobotModel);
        String prefix = "Estimator";
        this.timer = new ThreadTimer(prefix, schedulerDt * (double)divisor, estimatorThread.getYoRegistry());
        this.ticksBehindScheduled = new YoLong(prefix + "TicksBehindScheduled", estimatorThread.getYoRegistry());
    }

    @Override
    protected boolean initialize() {
        this.timer.reset();
        this.ticksBehindScheduled.set(0L);
        return super.initialize();
    }

    protected void execute() {
        this.timer.start();
        if (this.masterContextUpdated) {
            long schedulerTick = this.estimatorThread.getHumanoidRobotContextData().getSchedulerTick();
            this.ticksBehindScheduled.set(schedulerTick - this.timer.getTickCount() * this.divisor);
            EstimatorTask.runAll(this.preEstimatorCallbacks);
            this.estimatorThread.run();
            EstimatorTask.runAll(this.postEstimatorCallbacks);
        }
        this.timer.stop();
    }

    protected void updateMasterContext(HumanoidRobotContextData masterContext) {
        EstimatorTask.runAll(this.schedulerThreadRunnables);
        this.masterResolver.resolveHumanoidRobotContextDataEstimator(this.estimatorThread.getHumanoidRobotContextData(), masterContext);
        this.masterContextUpdated = true;
    }

    protected void updateLocalContext(HumanoidRobotContextData masterContext) {
        this.estimatorResolver.resolveHumanoidRobotContextDataScheduler(masterContext, this.estimatorThread.getHumanoidRobotContextData());
        this.estimatorResolver.resolveHumanoidRobotContextDataController(masterContext, this.estimatorThread.getHumanoidRobotContextData());
    }

    @Override
    public void addCallbackPreTask(Runnable callback) {
        this.preEstimatorCallbacks.add(callback);
    }

    @Override
    public void addCallbackPostTask(Runnable runnable) {
        this.postEstimatorCallbacks.add(runnable);
    }

    @Override
    public void addRunnableOnSchedulerThread(Runnable runnable) {
        this.schedulerThreadRunnables.add(runnable);
    }
}

