/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.factory.AvatarSimulation;
import us.ihmc.avatar.factory.AvatarSimulationFactory;
import us.ihmc.avatar.initialSetup.DRCGuiInitialSetup;
import us.ihmc.avatar.initialSetup.DRCSCSInitialSetup;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionCalculatorParametersReadOnly;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepAdjustment;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.HeadingAndVelocityEvaluationScriptParameters;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.HeightMapBasedFootstepAdjustment;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.WalkingProvider;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.humanoidRobotics.communication.subscribers.PelvisPoseCorrectionCommunicatorInterface;
import us.ihmc.robotics.controllers.ControllerFailureListener;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.yoVariables.variable.YoBoolean;

public class DRCFlatGroundWalkingTrack {
    private final AvatarSimulation avatarSimulation;
    private final RealtimeROS2Node realtimeROS2Node = new ROS2NodeBuilder().buildRealtime("flat_ground_walking_track_simulation");
    private static boolean createYoVariableServer = System.getProperty("create.yovariable.server") != null && Boolean.parseBoolean(System.getProperty("create.yovariable.server"));

    public DRCFlatGroundWalkingTrack(RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup, DRCGuiInitialSetup guiInitialSetup, DRCSCSInitialSetup scsInitialSetup, boolean useVelocityAndHeadingScript, boolean cheatWithGroundHeightAtForFootstep, DRCRobotModel model) {
        this(robotInitialSetup, guiInitialSetup, scsInitialSetup, useVelocityAndHeadingScript, cheatWithGroundHeightAtForFootstep, model, WalkingProvider.VELOCITY_HEADING_COMPONENT, new HeadingAndVelocityEvaluationScriptParameters(), null, null);
    }

    public DRCFlatGroundWalkingTrack(RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup, DRCGuiInitialSetup guiInitialSetup, DRCSCSInitialSetup scsInitialSetup, boolean useVelocityAndHeadingScript, boolean cheatWithGroundHeightAtForFootstep, DRCRobotModel model, HeadingAndVelocityEvaluationScriptParameters walkingScriptParameters, HighLevelControllerStateFactory customControllerState) {
        this(robotInitialSetup, guiInitialSetup, scsInitialSetup, useVelocityAndHeadingScript, cheatWithGroundHeightAtForFootstep, model, WalkingProvider.VELOCITY_HEADING_COMPONENT, walkingScriptParameters, null, customControllerState);
    }

    public DRCFlatGroundWalkingTrack(RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup, DRCGuiInitialSetup guiInitialSetup, DRCSCSInitialSetup scsInitialSetup, boolean useVelocityAndHeadingScript, boolean cheatWithGroundHeightAtForFootstep, DRCRobotModel model, PelvisPoseCorrectionCommunicatorInterface externalPelvisCorrectorSubscriber) {
        this(robotInitialSetup, guiInitialSetup, scsInitialSetup, useVelocityAndHeadingScript, cheatWithGroundHeightAtForFootstep, model, WalkingProvider.VELOCITY_HEADING_COMPONENT, new HeadingAndVelocityEvaluationScriptParameters(), externalPelvisCorrectorSubscriber, null);
    }

    public DRCFlatGroundWalkingTrack(RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup, DRCGuiInitialSetup guiInitialSetup, DRCSCSInitialSetup scsInitialSetup, boolean useVelocityAndHeadingScript, boolean cheatWithGroundHeightAtForFootstep, DRCRobotModel model, WalkingProvider walkingProvider, HeadingAndVelocityEvaluationScriptParameters walkingScriptParameters) {
        this(robotInitialSetup, guiInitialSetup, scsInitialSetup, useVelocityAndHeadingScript, cheatWithGroundHeightAtForFootstep, model, walkingProvider, walkingScriptParameters, null, null);
    }

    private DRCFlatGroundWalkingTrack(RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup, DRCGuiInitialSetup guiInitialSetup, DRCSCSInitialSetup scsInitialSetup, boolean useVelocityAndHeadingScript, boolean cheatWithGroundHeightAtForFootstep, DRCRobotModel model, WalkingProvider walkingProvider, HeadingAndVelocityEvaluationScriptParameters walkingScriptParameters, PelvisPoseCorrectionCommunicatorInterface externalPelvisCorrectorSubscriber, HighLevelControllerStateFactory customControllerStateFactory) {
        double dt = scsInitialSetup.getDT();
        int recordFrequency = (int)Math.round(model.getControllerDT() / dt);
        if (recordFrequency < 1) {
            recordFrequency = 1;
        }
        scsInitialSetup.setRecordFrequency(recordFrequency);
        HighLevelControllerParameters highLevelControllerParameters = model.getHighLevelControllerParameters();
        WalkingControllerParameters walkingControllerParameters = model.getWalkingControllerParameters();
        CoPTrajectoryParameters copTrajectoryParameters = model.getCoPTrajectoryParameters();
        SplitFractionCalculatorParametersReadOnly splitFractionParameters = model.getSplitFractionCalculatorParameters();
        HumanoidRobotSensorInformation sensorInformation = model.getSensorInformation();
        SideDependentList feetForceSensorNames = sensorInformation.getFeetForceSensorNames();
        SideDependentList wristForceSensorNames = sensorInformation.getWristForceSensorNames();
        RobotContactPointParameters contactPointParameters = model.getContactPointParameters();
        ArrayList additionalContactRigidBodyNames = contactPointParameters.getAdditionalContactRigidBodyNames();
        ArrayList additionalContactNames = contactPointParameters.getAdditionalContactNames();
        ArrayList additionalContactTransforms = contactPointParameters.getAdditionalContactTransforms();
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
        for (int i = 0; i < contactPointParameters.getAdditionalContactNames().size(); ++i) {
            contactableBodiesFactory.addAdditionalContactPoint((String)additionalContactRigidBodyNames.get(i), (String)additionalContactNames.get(i), (RigidBodyTransform)additionalContactTransforms.get(i));
        }
        HighLevelHumanoidControllerFactory controllerFactory = new HighLevelHumanoidControllerFactory(contactableBodiesFactory, feetForceSensorNames, wristForceSensorNames, highLevelControllerParameters, walkingControllerParameters, copTrajectoryParameters, splitFractionParameters);
        this.setupHighLevelStates(controllerFactory, (SideDependentList<String>)feetForceSensorNames, highLevelControllerParameters.getFallbackControllerState());
        controllerFactory.createControllerNetworkSubscriber(model.getSimpleRobotName(), this.realtimeROS2Node);
        if (customControllerStateFactory != null) {
            controllerFactory.addCustomControlState(customControllerStateFactory);
        }
        HeightMapBasedFootstepAdjustment footstepAdjustment = null;
        if (cheatWithGroundHeightAtForFootstep) {
            footstepAdjustment = new HeightMapBasedFootstepAdjustment(scsInitialSetup.getHeightMap());
        }
        AvatarSimulationFactory avatarSimulationFactory = new AvatarSimulationFactory();
        avatarSimulationFactory.setRobotModel(model);
        avatarSimulationFactory.setShapeCollisionSettings(model.getShapeCollisionSettings());
        avatarSimulationFactory.setHighLevelHumanoidControllerFactory(controllerFactory);
        avatarSimulationFactory.setCommonAvatarEnvironment(null);
        avatarSimulationFactory.setRobotInitialSetup(robotInitialSetup);
        avatarSimulationFactory.setSCSInitialSetup(scsInitialSetup);
        avatarSimulationFactory.setGuiInitialSetup(guiInitialSetup);
        avatarSimulationFactory.setRealtimeROS2Node(this.realtimeROS2Node);
        avatarSimulationFactory.setCreateYoVariableServer(createYoVariableServer);
        avatarSimulationFactory.setComponentBasedFootstepDataMessageGeneratorParameters(useVelocityAndHeadingScript, (FootstepAdjustment)footstepAdjustment, walkingScriptParameters);
        if (externalPelvisCorrectorSubscriber != null) {
            avatarSimulationFactory.setExternalPelvisCorrectorSubscriber(externalPelvisCorrectorSubscriber);
        }
        this.avatarSimulation = avatarSimulationFactory.createAvatarSimulation();
        this.initialize();
        if (robotInitialSetup.supportsReset()) {
            JButton resetButton = new JButton("Reset Robot");
            resetButton.addActionListener(e -> this.avatarSimulation.resetRobot());
            this.avatarSimulation.getSimulationConstructionSet().addButton((AbstractButton)resetButton);
        }
        ((YoBoolean)this.avatarSimulation.getSimulationConstructionSet().getRootRegistry().findVariable("ignoreWalkInputProviderCSG")).set(true);
        this.avatarSimulation.start();
    }

    public void initialize() {
    }

    public void setupHighLevelStates(HighLevelHumanoidControllerFactory controllerFactory, SideDependentList<String> feetForceSensorNames, HighLevelControllerName fallbackControllerState) {
        controllerFactory.useDefaultDoNothingControlState();
        controllerFactory.useDefaultWalkingControlState();
        controllerFactory.addRequestableTransition(HighLevelControllerName.DO_NOTHING_BEHAVIOR, HighLevelControllerName.WALKING);
        controllerFactory.addRequestableTransition(HighLevelControllerName.WALKING, HighLevelControllerName.DO_NOTHING_BEHAVIOR);
        controllerFactory.addControllerFailureTransition(HighLevelControllerName.DO_NOTHING_BEHAVIOR, fallbackControllerState);
        controllerFactory.addControllerFailureTransition(HighLevelControllerName.WALKING, fallbackControllerState);
        controllerFactory.setInitialState(HighLevelControllerName.WALKING);
    }

    public void attachControllerFailureListener(ControllerFailureListener listener) {
        this.avatarSimulation.getHighLevelHumanoidControllerFactory().attachControllerFailureListener(listener);
    }

    public SimulationConstructionSet getSimulationConstructionSet() {
        return this.avatarSimulation.getSimulationConstructionSet();
    }

    public AvatarSimulation getAvatarSimulation() {
        return this.avatarSimulation;
    }

    public void destroySimulation() {
        if (this.avatarSimulation != null) {
            this.avatarSimulation.dispose();
        }
    }
}

