/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;
import us.ihmc.simulationConstructionSetTools.util.environments.CTTSOObstacleCourseEnvironment;
import us.ihmc.simulationconstructionset.DynamicIntegrationMethod;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.LinearGroundContactModel;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;

public class CTTSOEnvironmentViewer {
    private final boolean SHOW_GRAPHICS = true;
    private final boolean SHOW_COLLISION_TERRAIN = false;
    private final double[] CAMFIX = new double[]{0.0, 0.0, 0.0};
    private final double[] CAMPOS = new double[]{-14.0, -7.0, 12.0};
    Robot robot = new Robot("NotARobot");
    private double gravity = -9.81;

    CTTSOEnvironmentViewer() {
        double simulateDT = 0.001;
        int initialBufferSize = 16342;
        CTTSOObstacleCourseEnvironment commonAvatarEnvironmentInterface = new CTTSOObstacleCourseEnvironment();
        TerrainObject3D groundProfile3D = commonAvatarEnvironmentInterface.getTerrainObject3D();
        this.robot.setGravity(this.gravity);
        double groundKz = 500.0;
        double groundBz = 300.0;
        double groundKxy = 50000.0;
        double groundBxy = 2000.0;
        LinearGroundContactModel groundContactModel = new LinearGroundContactModel(this.robot, groundKxy, groundBxy, groundKz, groundBz, this.robot.getRobotsYoRegistry());
        groundContactModel.setGroundProfile3D((GroundProfile3D)groundProfile3D);
        this.robot.setGroundContactModel((GroundContactModel)groundContactModel);
        this.robot.setDynamicIntegrationMethod(DynamicIntegrationMethod.EULER_DOUBLE_STEPS);
        JMEGraphics3DAdapter graphicsAdapter = new JMEGraphics3DAdapter();
        SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters();
        parameters.setDataBufferSize(initialBufferSize);
        SimulationConstructionSet scs = new SimulationConstructionSet(this.robot, (Graphics3DAdapter)graphicsAdapter, parameters);
        scs.setDT(simulateDT, 16342);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(0.3);
        scs.addStaticLinkGraphics(linkGraphics);
        scs.setCameraFix(this.CAMFIX[0], this.CAMFIX[1], this.CAMFIX[2]);
        scs.setCameraPosition(this.CAMPOS[0], this.CAMPOS[1], this.CAMPOS[2]);
        scs.setGroundVisible(false);
        TerrainObject3D environmentTerrain3D = commonAvatarEnvironmentInterface.getTerrainObject3D();
        if (environmentTerrain3D != null) {
            scs.addStaticLinkGraphics(environmentTerrain3D.getLinkGraphics());
        }
        Thread simThread = new Thread((Runnable)scs, "SCS simulation thread");
        simThread.start();
    }

    public static void main(String[] args) {
        new CTTSOEnvironmentViewer();
    }
}

