/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import controller_msgs.msg.dds.ControllerCrashNotificationPacket;
import controller_msgs.msg.dds.RequestWristForceSensorCalibrationPacket;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import us.ihmc.avatar.AvatarEstimatorThread;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextDataFactory;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextJointData;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.lists.PairList;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.controllerAPI.ControllerAPI;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.subscribers.PelvisPoseCorrectionCommunicatorInterface;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.robotController.RawOutputWriter;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SegmentDependentList;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.CenterOfMassDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataPublisher;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataPublisherFactory;
import us.ihmc.sensorProcessing.model.RobotMotionStatusHolder;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputWriter;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.sensorProcessing.sensorProcessors.RobotJointLimitWatcher;
import us.ihmc.sensorProcessing.sensorProcessors.SensorOutputMapReadOnly;
import us.ihmc.sensorProcessing.simulatedSensors.SensorDataContext;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReader;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReaderFactory;
import us.ihmc.sensorProcessing.stateEstimation.StateEstimatorParameters;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.stateEstimation.ekf.HumanoidRobotEKFWithSimpleJoints;
import us.ihmc.stateEstimation.ekf.LeggedRobotEKF;
import us.ihmc.stateEstimation.humanoid.StateEstimatorController;
import us.ihmc.stateEstimation.humanoid.StateEstimatorControllerFactory;
import us.ihmc.stateEstimation.humanoid.kinematicsBasedStateEstimation.DRCKinematicsBasedStateEstimator;
import us.ihmc.stateEstimation.humanoid.kinematicsBasedStateEstimation.ForceSensorStateUpdater;
import us.ihmc.stateEstimation.humanoid.kinematicsBasedStateEstimation.KinematicsBasedStateEstimatorFactory;
import us.ihmc.tools.factories.FactoryTools;
import us.ihmc.tools.factories.OptionalFactoryField;
import us.ihmc.tools.factories.RequiredFactoryField;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.wholeBodyController.WholeBodyControllerParameters;
import us.ihmc.wholeBodyController.parameters.ParameterLoaderHelper;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class AvatarEstimatorThreadFactory {
    private final YoRegistry estimatorRegistry = new YoRegistry("DRCEstimatorThread");
    private final RequiredFactoryField<Double> gravityField = new RequiredFactoryField("gravity");
    private final RequiredFactoryField<HumanoidRobotContextDataFactory> humanoidRobotContextDataFactoryField = new RequiredFactoryField("humanoidRobotContextDataFactory");
    private final RequiredFactoryField<FullHumanoidRobotModel> estimatorFullRobotModelField = new RequiredFactoryField("estimatorFullRobotModel");
    private final RequiredFactoryField<StateEstimatorParameters> stateEstimatorParametersField = new RequiredFactoryField("stateEstimatorParameters");
    private final RequiredFactoryField<SensorReaderFactory> sensorReaderFactoryField = new RequiredFactoryField("sensorReaderFactory");
    private final RequiredFactoryField<RobotContactPointParameters<RobotSide>> contactPointParametersField = new RequiredFactoryField("contactPointParameters");
    private final RequiredFactoryField<HumanoidRobotSensorInformation> sensorInformationField = new RequiredFactoryField("sensorInformation");
    private final RequiredFactoryField<WholeBodyControllerParameters<RobotSide>> controllerParametersField = new RequiredFactoryField("controllerParameters");
    private final OptionalFactoryField<YoGraphicsListRegistry> yoGraphicsListRegistryField = new OptionalFactoryField("yoGraphicsListRegistry");
    private final OptionalFactoryField<StateEstimatorController> mainStateEstimatorField = new OptionalFactoryField("mainEstimatorController");
    private final OptionalFactoryField<PairList<BooleanSupplier, StateEstimatorController>> secondaryStateEstimatorsField = new OptionalFactoryField("secondaryEstimatorControllers");
    private final OptionalFactoryField<List<StateEstimatorControllerFactory>> secondaryStateEstimatorFactoriesField = new OptionalFactoryField("secondaryEstimatorControllerFactories");
    private final OptionalFactoryField<RobotConfigurationDataPublisher> robotConfigurationDataPublisherField = new OptionalFactoryField("robotConfigurationDataPublisher");
    private final OptionalFactoryField<PelvisPoseCorrectionCommunicatorInterface> externalPelvisPoseSubscriberField = new OptionalFactoryField("externalPelvisPoseSubscriberField");
    private final OptionalFactoryField<RealtimeROS2Node> realtimeROS2NodeField = new OptionalFactoryField("realtimeROS2Node");
    private final OptionalFactoryField<ROS2Topic<?>> outputTopicField = new OptionalFactoryField("outputTopic");
    private final OptionalFactoryField<ROS2Topic<?>> inputTopicField = new OptionalFactoryField("inputTopic");
    private final OptionalFactoryField<SensorDataContext> sensorDataContextField = new OptionalFactoryField("sensorDataContext");
    private final OptionalFactoryField<HumanoidRobotContextData> humanoidRobotContextDataField = new OptionalFactoryField("humanoidRobotContextData");
    private final OptionalFactoryField<HumanoidRobotContextJointData> humanoidRobotContextJointDataField = new OptionalFactoryField("humanoidRobotContextJointData");
    private final OptionalFactoryField<LowLevelOneDoFJointDesiredDataHolder> desiredJointDataHolderField = new OptionalFactoryField("desiredJointDataHolder");
    private final OptionalFactoryField<FloatingJointBasics> rootJointField = new OptionalFactoryField("rootJoint");
    private final OptionalFactoryField<OneDoFJointBasics[]> oneDoFJointsField = new OptionalFactoryField("oneDoFJoints");
    private final OptionalFactoryField<OneDoFJointBasics[]> controllableOneDoFJointsField = new OptionalFactoryField("controllableOneDoFJoints");
    private final OptionalFactoryField<RobotMotionStatusHolder> robotMotionStatusFromControllerField = new OptionalFactoryField("robotMotionStatusFromController");
    private final OptionalFactoryField<CenterOfPressureDataHolder> centerOfPressureDataHolderFromControllerField = new OptionalFactoryField("centerOfPressureDataHolderFromController");
    private final OptionalFactoryField<ForceSensorDataHolder> forceSensorDataHolderField = new OptionalFactoryField("forceSensorDataHolder");
    private final OptionalFactoryField<CenterOfMassDataHolder> centerOfMassDataHolderField = new OptionalFactoryField("centerOfMassDataHolder");
    private final OptionalFactoryField<ForceSensorDefinition[]> forceSensorDefinitionsField = new OptionalFactoryField("forceSensorDefinitionsField");
    private final OptionalFactoryField<IMUDefinition[]> imuDefinitionsField = new OptionalFactoryField("imuDefinitions");
    private final OptionalFactoryField<ContactableBodiesFactory<RobotSide>> contactableBodiesFactoryField = new OptionalFactoryField("contactableBodiesFactory");
    private final OptionalFactoryField<SensorReader> sensorReaderField = new OptionalFactoryField("sensorReader");
    private final OptionalFactoryField<SensorOutputMapReadOnly> rawSensorOutputMapField = new OptionalFactoryField("rawSensorOutputMap");
    private final OptionalFactoryField<SensorOutputMapReadOnly> processedSensorOutputMapField = new OptionalFactoryField("processedSensorOutputMap");
    private final OptionalFactoryField<JointDesiredOutputWriter> jointDesiredOutputWriterField = new OptionalFactoryField("jointDesiredOutputWriter");

    public void setGravity(double gravity) {
        this.gravityField.set((Object)gravity);
    }

    public void configureWithDRCRobotModel(DRCRobotModel robotModel) {
        this.configureWithDRCRobotModel(robotModel, null);
    }

    public void configureWithDRCRobotModel(DRCRobotModel robotModel, RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup) {
        this.configureWithWholeBodyControllerParameters(robotModel);
        FullHumanoidRobotModel fullRobotModel = robotModel.createFullRobotModel();
        if (robotInitialSetup != null) {
            robotInitialSetup.initializeFullRobotModel(fullRobotModel);
        }
        this.setEstimatorFullRobotModel(fullRobotModel);
    }

    public void configureWithWholeBodyControllerParameters(WholeBodyControllerParameters<RobotSide> wholeBodyControllerParameters) {
        this.setConrollerParameters(wholeBodyControllerParameters);
        this.setStateEstimatorParamters(wholeBodyControllerParameters.getStateEstimatorParameters());
        this.setSensorInformation(wholeBodyControllerParameters.getSensorInformation());
        this.setContactPointParameters((RobotContactPointParameters<RobotSide>)wholeBodyControllerParameters.getContactPointParameters());
    }

    public void setROS2Info(RealtimeROS2Node ros2Node, String robotName) {
        this.setROS2Info(ros2Node, HumanoidControllerAPI.getOutputTopic((String)robotName), HumanoidControllerAPI.getInputTopic((String)robotName));
    }

    public void setROS2Info(RealtimeROS2Node ros2Node, ROS2Topic<?> outputTopic, ROS2Topic<?> inputTopic) {
        this.realtimeROS2NodeField.set((Object)ros2Node);
        this.outputTopicField.set(outputTopic);
        this.inputTopicField.set(inputTopic);
    }

    public void setEstimatorFullRobotModel(FullHumanoidRobotModel estimatorFullRobotModel) {
        this.estimatorFullRobotModelField.set((Object)estimatorFullRobotModel);
    }

    public void setSensorInformation(HumanoidRobotSensorInformation sensorInformation) {
        this.sensorInformationField.set((Object)sensorInformation);
    }

    public void setContactPointParameters(RobotContactPointParameters<RobotSide> contactPointParameters) {
        this.contactPointParametersField.set(contactPointParameters);
    }

    public void setStateEstimatorParamters(StateEstimatorParameters stateEstimatorParameters) {
        this.stateEstimatorParametersField.set((Object)stateEstimatorParameters);
    }

    public void setConrollerParameters(WholeBodyControllerParameters<RobotSide> controllerParameters) {
        this.controllerParametersField.set(controllerParameters);
    }

    public void setSensorReaderFactory(SensorReaderFactory sensorReaderFactory) {
        this.sensorReaderFactoryField.set((Object)sensorReaderFactory);
    }

    public void setHumanoidRobotContextDataFactory(HumanoidRobotContextDataFactory contextDataFactory) {
        this.humanoidRobotContextDataFactoryField.set((Object)contextDataFactory);
    }

    public void setExternalPelvisCorrectorSubscriber(PelvisPoseCorrectionCommunicatorInterface externalPelvisPoseSubscriber) {
        this.externalPelvisPoseSubscriberField.set((Object)externalPelvisPoseSubscriber);
    }

    public void setJointDesiredOutputWriter(JointDesiredOutputWriter jointDesiredOutputWriter) {
        if (jointDesiredOutputWriter != null) {
            this.jointDesiredOutputWriterField.set((Object)jointDesiredOutputWriter);
        }
    }

    public void setRobotConfigurationDataPublisher(RobotConfigurationDataPublisher publisher) {
        if (publisher != null) {
            this.robotConfigurationDataPublisherField.set((Object)publisher);
        }
    }

    public void setMainStateEstimator(StateEstimatorController mainStateEstimator) {
        if (this.mainStateEstimatorField.hasValue()) {
            throw new IllegalOperationException("The main state estimator has already been set.");
        }
        this.mainStateEstimatorField.set((Object)mainStateEstimator);
    }

    public void addSecondaryStateEstimator(StateEstimatorController secondaryStateEstimator) {
        this.addSecondaryStateEstimators(() -> false, secondaryStateEstimator);
    }

    public void addSecondaryStateEstimatorFactory(StateEstimatorControllerFactory secondaryStateEstimator) {
        this.getSecondaryStateEstimatorFactories().add(secondaryStateEstimator);
    }

    public void addSecondaryStateEstimator(String reinitializeVariableName, StateEstimatorController secondaryStateEstimator) {
        YoBoolean reinitialize = new YoBoolean(reinitializeVariableName, this.getEstimatorRegistry());
        BooleanSupplier reinitilizeSupplier = () -> {
            boolean ret = reinitialize.getValue();
            reinitialize.set(false);
            return ret;
        };
        this.addSecondaryStateEstimators(reinitilizeSupplier, secondaryStateEstimator);
    }

    public void addSecondaryStateEstimators(BooleanSupplier reinitilizeSupplier, StateEstimatorController secondaryStateEstimator) {
        if (!this.useStateEstimator()) {
            throw new IllegalOperationException("Cannot add state estimator because SensorReaderFactory.useStateEstimator() is false.");
        }
        this.getSecondaryStateEstimators().add((Object)reinitilizeSupplier, (Object)secondaryStateEstimator);
    }

    public void setYoGraphicsListRegistry(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.yoGraphicsListRegistryField.set((Object)yoGraphicsListRegistry);
    }

    public AvatarEstimatorThread createAvatarEstimatorThread() {
        if (this.jointDesiredOutputWriterField.hasValue()) {
            ((JointDesiredOutputWriter)this.jointDesiredOutputWriterField.get()).setJointDesiredOutputList((JointDesiredOutputListBasics)this.getDesiredJointDataHolder());
            this.getEstimatorRegistry().addChild(((JointDesiredOutputWriter)this.jointDesiredOutputWriterField.get()).getYoVariableRegistry());
        }
        if (this.secondaryStateEstimatorFactoriesField.hasValue()) {
            for (StateEstimatorControllerFactory stateEstimatorControllerFactory : (List)this.secondaryStateEstimatorFactoriesField.get()) {
                this.addSecondaryStateEstimator(stateEstimatorControllerFactory.createStateEstimator(this.getEstimatorFullRobotModel(), this.getSensorReader()));
            }
        }
        AvatarEstimatorThread avatarEstimatorThread = new AvatarEstimatorThread(this.getSensorReader(), this.getEstimatorFullRobotModel(), this.getHumanoidRobotContextData(), this.getMainStateEstimator(), this.getSecondaryStateEstimators(), this.createControllerCrashPublisher(), this.getEstimatorRegistry(), this.getYoGraphicsListRegistry());
        avatarEstimatorThread.addRobotController((RobotController)new RobotJointLimitWatcher(this.getEstimatorFullRobotModel().getOneDoFJoints(), this.getRawSensorOutputMap()));
        RobotConfigurationDataPublisher robotConfigurationDataPublisher = this.getRobotConfigurationDataPublisher();
        if (robotConfigurationDataPublisher != null) {
            avatarEstimatorThread.setRawOutputWriter((RawOutputWriter)robotConfigurationDataPublisher);
        }
        ParameterLoaderHelper.loadParameters((Object)this, this.getControllerParameters(), (YoRegistry)this.getEstimatorRegistry());
        FactoryTools.disposeFactory((Object)this);
        return avatarEstimatorThread;
    }

    public StateEstimatorController createDRCKinematicsStateEstimator() {
        if (!this.useStateEstimator()) {
            return null;
        }
        KinematicsBasedStateEstimatorFactory estimatorFactory = new KinematicsBasedStateEstimatorFactory();
        estimatorFactory.setEstimatorFullRobotModel(this.getEstimatorFullRobotModel());
        estimatorFactory.setSensorInformation(this.getSensorInformation());
        estimatorFactory.setSensorOutputMapReadOnly(this.getProcessedSensorOutputMap());
        estimatorFactory.setGravity(this.getGravity());
        estimatorFactory.setStateEstimatorParameters(this.getStateEstimatorParameters());
        estimatorFactory.setContactableBodiesFactory(this.getContactableBodiesFactory());
        estimatorFactory.setEstimatorForceSensorDataHolder(this.getForceSensorDataHolder());
        estimatorFactory.setEstimatorCenterOfMassDataHolderToUpdate(this.getCenterOfMassDataHolder());
        estimatorFactory.setCenterOfPressureDataHolderFromController(this.getCenterOfPressureDataHolderFromController());
        estimatorFactory.setRobotMotionStatusFromController(this.getRobotMotionStatusFromController());
        estimatorFactory.setExternalPelvisCorrectorSubscriber(this.getExternalPelvisPoseSubscriberField());
        DRCKinematicsBasedStateEstimator stateEstimator = estimatorFactory.createStateEstimator(this.getEstimatorRegistry(), this.getYoGraphicsListRegistry());
        if (this.realtimeROS2NodeField.hasValue()) {
            ForceSensorStateUpdater forceSensorStateUpdater = stateEstimator.getForceSensorStateUpdater();
            ((RealtimeROS2Node)this.realtimeROS2NodeField.get()).createSubscription(((ROS2Topic)this.inputTopicField.get()).withTypeName(RequestWristForceSensorCalibrationPacket.class), subscriber -> forceSensorStateUpdater.requestWristForceSensorCalibrationAtomic());
        }
        return stateEstimator;
    }

    public StateEstimatorController createEKFStateEstimator() {
        if (!this.useStateEstimator()) {
            return null;
        }
        double estimatorDT = this.getStateEstimatorParameters().getEstimatorDT();
        HumanoidRobotSensorInformation sensorInformation = this.getSensorInformation();
        SideDependentList footForceSensorNames = sensorInformation.getFeetForceSensorNames();
        String primaryImuName = sensorInformation.getPrimaryBodyImu();
        List<String> imuSensorNames = Arrays.asList(sensorInformation.getIMUSensorsToUseInStateEstimator());
        HumanoidRobotEKFWithSimpleJoints ekfStateEstimator = new HumanoidRobotEKFWithSimpleJoints(this.getEstimatorFullRobotModel(), primaryImuName, imuSensorNames, footForceSensorNames, this.getRawSensorOutputMap(), estimatorDT, this.getGravity().doubleValue(), this.getProcessedSensorOutputMap(), this.getYoGraphicsListRegistry(), this.getEstimatorFullRobotModel());
        InputStream ekfParameterStream = LeggedRobotEKF.class.getResourceAsStream("/ekf.xml");
        if (ekfParameterStream == null) {
            throw new RuntimeException("Did not find parameter file for EKF.");
        }
        ParameterLoaderHelper.loadParameters((Object)this, (InputStream)ekfParameterStream, (YoRegistry)ekfStateEstimator.getYoRegistry());
        return ekfStateEstimator;
    }

    public RealtimeROS2Node getRealtimeROS2Node() {
        if (this.realtimeROS2NodeField.hasValue()) {
            return (RealtimeROS2Node)this.realtimeROS2NodeField.get();
        }
        return null;
    }

    public ROS2Topic<?> getOutputTopic() {
        if (this.outputTopicField.hasValue()) {
            return (ROS2Topic)this.outputTopicField.get();
        }
        return null;
    }

    public ROS2Topic<?> getInputTopic() {
        if (this.inputTopicField.hasValue()) {
            return (ROS2Topic)this.inputTopicField.get();
        }
        return null;
    }

    private ROS2Publisher<ControllerCrashNotificationPacket> createControllerCrashPublisher() {
        if (this.realtimeROS2NodeField.hasValue()) {
            return ((RealtimeROS2Node)this.realtimeROS2NodeField.get()).createPublisher(ControllerAPI.getTopic((ROS2Topic)((ROS2Topic)this.outputTopicField.get()), ControllerCrashNotificationPacket.class));
        }
        return null;
    }

    public Double getGravity() {
        return (Double)this.gravityField.get();
    }

    public HumanoidRobotContextDataFactory getHumanoidRobotContextDataFactory() {
        return (HumanoidRobotContextDataFactory)this.humanoidRobotContextDataFactoryField.get();
    }

    public HumanoidRobotContextJointData getHumanoidRobotContextJointData() {
        if (!this.humanoidRobotContextJointDataField.hasValue()) {
            this.humanoidRobotContextJointDataField.set((Object)new HumanoidRobotContextJointData(this.getOneDoFJoints().length));
        }
        return (HumanoidRobotContextJointData)this.humanoidRobotContextJointDataField.get();
    }

    public SensorDataContext getSensorDataContext() {
        if (!this.sensorDataContextField.hasValue()) {
            this.sensorDataContextField.set((Object)new SensorDataContext((FullRobotModel)this.getEstimatorFullRobotModel()));
        }
        return (SensorDataContext)this.sensorDataContextField.get();
    }

    public HumanoidRobotContextData getHumanoidRobotContextData() {
        if (!this.humanoidRobotContextDataField.hasValue()) {
            HumanoidRobotContextDataFactory contextDataFactory = this.getHumanoidRobotContextDataFactory();
            contextDataFactory.setForceSensorDataHolder(this.getForceSensorDataHolder());
            contextDataFactory.setCenterOfMassDataHolder(this.getCenterOfMassDataHolder());
            contextDataFactory.setCenterOfPressureDataHolder(this.getCenterOfPressureDataHolderFromController());
            contextDataFactory.setRobotMotionStatusHolder(this.getRobotMotionStatusFromController());
            contextDataFactory.setJointDesiredOutputList(this.getDesiredJointDataHolder());
            contextDataFactory.setProcessedJointData(this.getHumanoidRobotContextJointData());
            contextDataFactory.setSensorDataContext(this.getSensorDataContext());
            this.humanoidRobotContextDataField.set((Object)contextDataFactory.createHumanoidRobotContextData());
        }
        return (HumanoidRobotContextData)this.humanoidRobotContextDataField.get();
    }

    public LowLevelOneDoFJointDesiredDataHolder getDesiredJointDataHolder() {
        if (!this.desiredJointDataHolderField.hasValue()) {
            this.desiredJointDataHolderField.set((Object)new LowLevelOneDoFJointDesiredDataHolder((OneDoFJointReadOnly[])this.getControllableOneDoFJoints()));
        }
        return (LowLevelOneDoFJointDesiredDataHolder)this.desiredJointDataHolderField.get();
    }

    public RobotMotionStatusHolder getRobotMotionStatusFromController() {
        if (!this.robotMotionStatusFromControllerField.hasValue()) {
            this.robotMotionStatusFromControllerField.set((Object)new RobotMotionStatusHolder());
        }
        return (RobotMotionStatusHolder)this.robotMotionStatusFromControllerField.get();
    }

    public CenterOfPressureDataHolder getCenterOfPressureDataHolderFromController() {
        if (!this.centerOfPressureDataHolderFromControllerField.hasValue()) {
            this.centerOfPressureDataHolderFromControllerField.set((Object)new CenterOfPressureDataHolder(this.getEstimatorFullRobotModel()));
        }
        return (CenterOfPressureDataHolder)this.centerOfPressureDataHolderFromControllerField.get();
    }

    public ForceSensorDataHolder getForceSensorDataHolder() {
        if (!this.forceSensorDataHolderField.hasValue()) {
            this.forceSensorDataHolderField.set((Object)new ForceSensorDataHolder(this.getForceSensorDefinitions()));
        }
        return (ForceSensorDataHolder)this.forceSensorDataHolderField.get();
    }

    public CenterOfMassDataHolder getCenterOfMassDataHolder() {
        if (!this.centerOfMassDataHolderField.hasValue()) {
            this.centerOfMassDataHolderField.set((Object)new CenterOfMassDataHolder());
        }
        return (CenterOfMassDataHolder)this.centerOfMassDataHolderField.get();
    }

    public ForceSensorDefinition[] getForceSensorDefinitions() {
        if (!this.forceSensorDefinitionsField.hasValue()) {
            this.forceSensorDefinitionsField.set((Object)this.getEstimatorFullRobotModel().getForceSensorDefinitions());
        }
        return (ForceSensorDefinition[])this.forceSensorDefinitionsField.get();
    }

    public IMUDefinition[] getIMUDefinitions() {
        if (!this.imuDefinitionsField.hasValue()) {
            this.imuDefinitionsField.set((Object)this.getEstimatorFullRobotModel().getIMUDefinitions());
        }
        return (IMUDefinition[])this.imuDefinitionsField.get();
    }

    public SensorReaderFactory getSensorReaderFactory() {
        return (SensorReaderFactory)this.sensorReaderFactoryField.get();
    }

    public boolean useStateEstimator() {
        return this.getSensorReaderFactory().useStateEstimator();
    }

    public SensorReader getSensorReader() {
        if (!this.sensorReaderField.hasValue()) {
            this.getSensorReaderFactory().setForceSensorDataHolder(this.getForceSensorDataHolder());
            this.getSensorReaderFactory().build(this.getRootJoint(), this.getIMUDefinitions(), this.getForceSensorDefinitions(), (JointDesiredOutputListBasics)this.getDesiredJointDataHolder(), this.getEstimatorRegistry());
            this.sensorReaderField.set((Object)this.getSensorReaderFactory().getSensorReader());
        }
        return (SensorReader)this.sensorReaderField.get();
    }

    public SensorOutputMapReadOnly getRawSensorOutputMap() {
        if (!this.rawSensorOutputMapField.hasValue()) {
            this.rawSensorOutputMapField.set((Object)this.getSensorReader().getRawSensorOutputMap());
        }
        return (SensorOutputMapReadOnly)this.rawSensorOutputMapField.get();
    }

    public SensorOutputMapReadOnly getProcessedSensorOutputMap() {
        if (!this.processedSensorOutputMapField.hasValue()) {
            this.processedSensorOutputMapField.set((Object)this.getSensorReader().getProcessedSensorOutputMap());
        }
        return (SensorOutputMapReadOnly)this.processedSensorOutputMapField.get();
    }

    public FullHumanoidRobotModel getEstimatorFullRobotModel() {
        return (FullHumanoidRobotModel)this.estimatorFullRobotModelField.get();
    }

    public FloatingJointBasics getRootJoint() {
        if (!this.rootJointField.hasValue()) {
            this.rootJointField.set((Object)this.getEstimatorFullRobotModel().getRootJoint());
        }
        return (FloatingJointBasics)this.rootJointField.get();
    }

    public OneDoFJointBasics[] getOneDoFJoints() {
        if (!this.oneDoFJointsField.hasValue()) {
            this.oneDoFJointsField.set((Object)this.getEstimatorFullRobotModel().getOneDoFJoints());
        }
        return (OneDoFJointBasics[])this.oneDoFJointsField.get();
    }

    public OneDoFJointBasics[] getControllableOneDoFJoints() {
        if (!this.controllableOneDoFJointsField.hasValue()) {
            this.controllableOneDoFJointsField.set((Object)this.getEstimatorFullRobotModel().getControllableOneDoFJoints());
        }
        return (OneDoFJointBasics[])this.controllableOneDoFJointsField.get();
    }

    public ContactableBodiesFactory<RobotSide> getContactableBodiesFactory() {
        if (!this.contactableBodiesFactoryField.hasValue()) {
            RobotContactPointParameters<RobotSide> contactPointParameters = this.getContactPointParameters();
            ArrayList additionalContactRigidBodyNames = contactPointParameters.getAdditionalContactRigidBodyNames();
            ArrayList additionalContactNames = contactPointParameters.getAdditionalContactNames();
            ArrayList additionalContactTransforms = contactPointParameters.getAdditionalContactTransforms();
            SegmentDependentList footContactPoints = contactPointParameters.getFootContactPoints();
            SegmentDependentList toeContactPoints = contactPointParameters.getControllerToeContactPoints();
            SegmentDependentList toeContactLines = contactPointParameters.getControllerToeContactLines();
            ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
            contactableBodiesFactory.setFootContactPoints(footContactPoints);
            contactableBodiesFactory.setToeContactParameters(toeContactPoints, toeContactLines);
            for (int i = 0; i < contactPointParameters.getAdditionalContactNames().size(); ++i) {
                contactableBodiesFactory.addAdditionalContactPoint((String)additionalContactRigidBodyNames.get(i), (String)additionalContactNames.get(i), (RigidBodyTransform)additionalContactTransforms.get(i));
            }
            this.contactableBodiesFactoryField.set((Object)contactableBodiesFactory);
        }
        return (ContactableBodiesFactory)this.contactableBodiesFactoryField.get();
    }

    public RobotContactPointParameters<RobotSide> getContactPointParameters() {
        return (RobotContactPointParameters)this.contactPointParametersField.get();
    }

    public StateEstimatorParameters getStateEstimatorParameters() {
        return (StateEstimatorParameters)this.stateEstimatorParametersField.get();
    }

    public WholeBodyControllerParameters<RobotSide> getControllerParameters() {
        return (WholeBodyControllerParameters)this.controllerParametersField.get();
    }

    public HumanoidRobotSensorInformation getSensorInformation() {
        return (HumanoidRobotSensorInformation)this.sensorInformationField.get();
    }

    public PelvisPoseCorrectionCommunicatorInterface getExternalPelvisPoseSubscriberField() {
        if (this.externalPelvisPoseSubscriberField.hasValue()) {
            return (PelvisPoseCorrectionCommunicatorInterface)this.externalPelvisPoseSubscriberField.get();
        }
        return null;
    }

    public StateEstimatorController getMainStateEstimator() {
        if (!this.mainStateEstimatorField.hasValue()) {
            this.mainStateEstimatorField.set((Object)this.createDRCKinematicsStateEstimator());
        }
        return (StateEstimatorController)this.mainStateEstimatorField.get();
    }

    public PairList<BooleanSupplier, StateEstimatorController> getSecondaryStateEstimators() {
        if (!this.secondaryStateEstimatorsField.hasValue()) {
            this.secondaryStateEstimatorsField.set((Object)new PairList());
        }
        return (PairList)this.secondaryStateEstimatorsField.get();
    }

    public List<StateEstimatorControllerFactory> getSecondaryStateEstimatorFactories() {
        if (!this.secondaryStateEstimatorFactoriesField.hasValue()) {
            this.secondaryStateEstimatorFactoriesField.set(new ArrayList());
        }
        return (List)this.secondaryStateEstimatorFactoriesField.get();
    }

    public RobotConfigurationDataPublisher getRobotConfigurationDataPublisher() {
        if (!this.realtimeROS2NodeField.hasValue()) {
            return null;
        }
        if (!this.robotConfigurationDataPublisherField.hasValue()) {
            ForceSensorDataHolder forceSensorDataHolderToSend = this.getForceSensorDataHolder();
            if (this.getMainStateEstimator() != null && this.getMainStateEstimator().getForceSensorOutputWithGravityCancelled() != null) {
                forceSensorDataHolderToSend = this.getMainStateEstimator().getForceSensorOutputWithGravityCancelled();
            }
            RobotConfigurationDataPublisherFactory factory = new RobotConfigurationDataPublisherFactory();
            factory.setDefinitionsToPublish(this.getEstimatorFullRobotModel());
            factory.setSensorSource((FullRobotModel)this.getEstimatorFullRobotModel(), (ForceSensorDataHolderReadOnly)forceSensorDataHolderToSend, this.getRawSensorOutputMap());
            factory.setRobotMotionStatusHolder(this.getRobotMotionStatusFromController());
            factory.setROS2Info((RealtimeROS2Node)this.realtimeROS2NodeField.get(), (ROS2Topic)this.outputTopicField.get());
            factory.setPublishPeriod(Conversions.secondsToNanoseconds((double)StateEstimatorParameters.ROBOT_CONFIGURATION_DATA_PUBLISH_DT));
            this.robotConfigurationDataPublisherField.set((Object)factory.createRobotConfigurationDataPublisher());
        }
        return (RobotConfigurationDataPublisher)this.robotConfigurationDataPublisherField.get();
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        if (!this.yoGraphicsListRegistryField.hasValue()) {
            this.yoGraphicsListRegistryField.set((Object)new YoGraphicsListRegistry());
        }
        return (YoGraphicsListRegistry)this.yoGraphicsListRegistryField.get();
    }

    public YoRegistry getEstimatorRegistry() {
        return this.estimatorRegistry;
    }
}

