/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import controller_msgs.msg.dds.ControllerCrashNotificationPacket;
import gnu.trove.map.TObjectDoubleMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextJointData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextTools;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.commons.lists.PairList;
import us.ihmc.communication.packets.ControllerCrashLocation;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.humanoidRobotics.communication.packets.sensing.StateEstimatorMode;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.SCS2YoGraphicHolder;
import us.ihmc.robotics.controllers.ControllerStateChangedListener;
import us.ihmc.robotics.robotController.ModularRobotController;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReader;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.stateEstimation.humanoid.StateEstimatorController;
import us.ihmc.stateEstimation.humanoid.kinematicsBasedStateEstimation.ForceSensorCalibrationModule;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class AvatarEstimatorThread
extends ModularRobotController
implements SCS2YoGraphicHolder {
    private final YoRegistry estimatorRegistry;
    private final YoBoolean firstTick;
    private final SensorReader sensorReader;
    private final FullHumanoidRobotModel estimatorFullRobotModel;
    private final StateEstimatorController mainStateEstimator;
    private final PairList<BooleanSupplier, StateEstimatorController> secondaryStateEstimators;
    private final RigidBodyTransform rootToWorldTransform = new RigidBodyTransform();
    private final HumanoidRobotContextData humanoidRobotContextData;
    private final List<Runnable> runnables = new ArrayList<Runnable>();
    private final ROS2Publisher<ControllerCrashNotificationPacket> controllerCrashPublisher;
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private final ExecutionTimer estimatorThreadTimer;

    public AvatarEstimatorThread(SensorReader sensorReader, FullHumanoidRobotModel estimatorFullRobotModel, HumanoidRobotContextData humanoidRobotContextData, StateEstimatorController mainStateEstimator, PairList<BooleanSupplier, StateEstimatorController> secondaryStateEstimators, ROS2Publisher<ControllerCrashNotificationPacket> controllerCrashPublisher, YoRegistry estimatorRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        super("EstimatorController");
        this.sensorReader = sensorReader;
        this.estimatorFullRobotModel = estimatorFullRobotModel;
        this.humanoidRobotContextData = humanoidRobotContextData;
        this.mainStateEstimator = mainStateEstimator;
        this.secondaryStateEstimators = secondaryStateEstimators;
        this.controllerCrashPublisher = controllerCrashPublisher;
        this.estimatorRegistry = estimatorRegistry;
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        estimatorRegistry.addChild(super.getYoRegistry());
        if (mainStateEstimator != null) {
            this.addRobotController((RobotController)mainStateEstimator);
        }
        for (int i = 0; i < secondaryStateEstimators.size(); ++i) {
            this.addRobotController((RobotController)((ImmutablePair)secondaryStateEstimators.get(i)).getRight());
        }
        this.estimatorThreadTimer = new ExecutionTimer("estimatorThreadTimer", super.getYoRegistry());
        this.firstTick = new YoBoolean("firstTick", estimatorRegistry);
        this.firstTick.set(true);
    }

    public void run() {
        this.estimatorThreadTimer.startMeasurement();
        try {
            int i;
            this.sensorReader.compute(this.humanoidRobotContextData.getTimestamp(), this.humanoidRobotContextData.getSensorDataContext());
            if (this.firstTick.getBooleanValue()) {
                this.initialize();
                this.firstTick.set(false);
            }
            for (i = 0; i < this.secondaryStateEstimators.size(); ++i) {
                this.estimatorFullRobotModel.getRootJoint().getJointConfiguration(this.rootToWorldTransform);
                if (!((BooleanSupplier)((ImmutablePair)this.secondaryStateEstimators.get(i)).getLeft()).getAsBoolean()) continue;
                ((StateEstimatorController)((ImmutablePair)this.secondaryStateEstimators.get(i)).getRight()).initializeEstimator((RigidBodyTransformReadOnly)this.rootToWorldTransform);
            }
            this.doControl();
            for (i = 0; i < this.runnables.size(); ++i) {
                this.runnables.get(i).run();
            }
            HumanoidRobotContextTools.updateContext((FullRobotModel)this.estimatorFullRobotModel, (HumanoidRobotContextJointData)this.humanoidRobotContextData.getProcessedJointData());
            this.humanoidRobotContextData.setEstimatorRan(!this.firstTick.getValue());
        }
        catch (Throwable e) {
            if (this.controllerCrashPublisher != null) {
                this.controllerCrashPublisher.publish((Object)MessageTools.createControllerCrashNotificationPacket((ControllerCrashLocation)ControllerCrashLocation.ESTIMATOR_RUN, (Throwable)e));
            }
            throw new RuntimeException(e);
        }
        this.estimatorThreadTimer.stopMeasurement();
    }

    public void initializeStateEstimators(RigidBodyTransform rootJointTransform, TObjectDoubleMap<String> jointPositions) {
        this.sensorReader.initialize();
        if (this.mainStateEstimator != null) {
            this.mainStateEstimator.initializeEstimator((RigidBodyTransformReadOnly)rootJointTransform, jointPositions);
        }
        for (int i = 0; i < this.secondaryStateEstimators.size(); ++i) {
            ((StateEstimatorController)((ImmutablePair)this.secondaryStateEstimators.get(i)).getRight()).initializeEstimator((RigidBodyTransformReadOnly)rootJointTransform, jointPositions);
        }
        this.firstTick.set(true);
        this.humanoidRobotContextData.setControllerRan(false);
        this.humanoidRobotContextData.setEstimatorRan(false);
        LowLevelOneDoFJointDesiredDataHolder jointDesiredOutputList = this.humanoidRobotContextData.getJointDesiredOutputList();
        for (int i = 0; i < jointDesiredOutputList.getNumberOfJointsWithDesiredOutput(); ++i) {
            jointDesiredOutputList.getJointDesiredOutput(i).clear();
        }
    }

    public void setupHighLevelControllerCallback(HighLevelHumanoidControllerFactory controllerFactory, final Map<HighLevelControllerName, StateEstimatorMode> stateModeMap) {
        controllerFactory.attachControllerStateChangedListener(new ControllerStateChangedListener(){

            public void controllerStateHasChanged(Enum<?> oldState, Enum<?> newState) {
                StateEstimatorMode requestedMode = (StateEstimatorMode)stateModeMap.get(newState);
                if (requestedMode != null) {
                    AvatarEstimatorThread.this.mainStateEstimator.requestStateEstimatorMode(requestedMode);
                }
            }
        });
    }

    public void addEstimatorRunnable(Runnable runnable) {
        this.runnables.add(runnable);
    }

    @Deprecated
    public SensorReader getSensorReader() {
        return this.sensorReader;
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.estimatorFullRobotModel;
    }

    public YoRegistry getYoRegistry() {
        return this.estimatorRegistry;
    }

    public YoGraphicsListRegistry getSCS1YoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public YoGraphicGroupDefinition getSCS2YoGraphics() {
        YoGraphicGroupDefinition group = new YoGraphicGroupDefinition(((Object)((Object)this)).getClass().getSimpleName());
        if (this.mainStateEstimator != null) {
            group.addChild(this.mainStateEstimator.getSCS2YoGraphics());
        }
        for (ImmutablePair entry : this.secondaryStateEstimators) {
            group.addChild(((StateEstimatorController)entry.getRight()).getSCS2YoGraphics());
        }
        return group;
    }

    public HumanoidRobotContextData getHumanoidRobotContextData() {
        return this.humanoidRobotContextData;
    }

    public ForceSensorCalibrationModule getForceSensorCalibrationModule() {
        return this.mainStateEstimator.getForceSensorCalibrationModule();
    }
}

