/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.warmup;

import controller_msgs.msg.dds.ArmTrajectoryMessage;
import controller_msgs.msg.dds.ChestTrajectoryMessage;
import controller_msgs.msg.dds.FootTrajectoryMessage;
import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import controller_msgs.msg.dds.OneDoFJointTrajectoryMessage;
import ihmc_common_msgs.msg.dds.SE3TrajectoryPointMessage;
import ihmc_common_msgs.msg.dds.SO3TrajectoryMessage;
import ihmc_common_msgs.msg.dds.SO3TrajectoryPointMessage;
import ihmc_common_msgs.msg.dds.TrajectoryPoint1DMessage;
import us.ihmc.avatar.warmup.HumanoidControllerWarmup;
import us.ihmc.commons.MathTools;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;

public class HumanoidControllerWarumupTools {
    public static void warmup(HumanoidControllerWarmup controllerWarmup) {
        LogTools.info((String)"Starting to warm up...");
        long startTime = System.currentTimeMillis();
        try {
            controllerWarmup.runWarmup();
        }
        catch (Exception e) {
            LogTools.info((String)"Warmup failed with an exception.");
            e.printStackTrace();
        }
        double duration = 0.001 * (double)(System.currentTimeMillis() - startTime);
        LogTools.info((String)("Warmup took " + duration + "s."));
    }

    public static FootstepDataListMessage createStepsInPlace(HumanoidReferenceFrames referenceFrames) {
        FootstepDataListMessage message = new FootstepDataListMessage();
        double z = referenceFrames.getSoleFrame(RobotSide.LEFT).getTransformToWorldFrame().getTranslationZ();
        for (RobotSide side : RobotSide.values) {
            FootstepDataMessage step = (FootstepDataMessage)message.getFootstepDataList().add();
            step.setRobotSide(side.toByte());
            FramePose3D footPose = new FramePose3D((ReferenceFrame)referenceFrames.getSoleFrame(side));
            footPose.changeFrame((ReferenceFrame)referenceFrames.getSoleFrame(RobotSide.LEFT));
            footPose.setX(0.1);
            footPose.changeFrame(ReferenceFrame.getWorldFrame());
            double yaw = footPose.getYaw();
            footPose.getOrientation().setYawPitchRoll(yaw, 0.0, 0.0);
            footPose.setZ(z);
            step.getLocation().set((Tuple3DReadOnly)footPose.getPosition());
            step.getOrientation().set((QuaternionReadOnly)footPose.getOrientation());
            step.setSwingDuration(0.4);
            step.setTransferDuration(0.2);
        }
        message.setFinalTransferDuration(0.2);
        message.setAreFootstepsAdjustable(true);
        return message;
    }

    public static FootTrajectoryMessage createPickUpFootMessage(RobotSide side, HumanoidReferenceFrames referenceFrames) {
        FootTrajectoryMessage message = new FootTrajectoryMessage();
        message.setRobotSide(side.toByte());
        FramePose3D footPose = new FramePose3D((ReferenceFrame)referenceFrames.getSoleFrame(side));
        footPose.changeFrame((ReferenceFrame)referenceFrames.getSoleFrame(side.getOppositeSide()));
        footPose.setX(0.0);
        footPose.changeFrame(ReferenceFrame.getWorldFrame());
        double z = referenceFrames.getSoleFrame(side.getOppositeSide()).getTransformToWorldFrame().getTranslationZ();
        footPose.setZ(z + 0.05);
        SE3TrajectoryPointMessage trajectoryPoint = (SE3TrajectoryPointMessage)message.getSe3Trajectory().getTaskspaceTrajectoryPoints().add();
        trajectoryPoint.getPosition().set((Tuple3DReadOnly)footPose.getPosition());
        trajectoryPoint.getOrientation().set((QuaternionReadOnly)footPose.getOrientation());
        trajectoryPoint.setTime(0.1);
        return message;
    }

    public static FootTrajectoryMessage createPutDownFootMessage(RobotSide side, HumanoidReferenceFrames referenceFrames) {
        FootTrajectoryMessage message = new FootTrajectoryMessage();
        message.setRobotSide(side.toByte());
        FramePose3D footPose = new FramePose3D((ReferenceFrame)referenceFrames.getSoleFrame(side));
        footPose.changeFrame((ReferenceFrame)referenceFrames.getSoleFrame(side.getOppositeSide()));
        footPose.setX(0.0);
        footPose.changeFrame(ReferenceFrame.getWorldFrame());
        double z = referenceFrames.getSoleFrame(side.getOppositeSide()).getTransformToWorldFrame().getTranslationZ();
        footPose.setZ(z);
        SE3TrajectoryPointMessage trajectoryPoint = (SE3TrajectoryPointMessage)message.getSe3Trajectory().getTaskspaceTrajectoryPoints().add();
        trajectoryPoint.getPosition().set((Tuple3DReadOnly)footPose.getPosition());
        trajectoryPoint.getOrientation().set((QuaternionReadOnly)footPose.getOrientation());
        trajectoryPoint.setTime(0.1);
        return message;
    }

    public static ChestTrajectoryMessage createChestMessage(HumanoidReferenceFrames referenceFrames) {
        ChestTrajectoryMessage message = new ChestTrajectoryMessage();
        Quaternion orientation = new Quaternion();
        orientation.appendYawRotation(Math.toRadians(-10.0));
        orientation.appendRollRotation(Math.toRadians(10.0));
        SO3TrajectoryMessage so3Trajectory = message.getSo3Trajectory();
        so3Trajectory.getFrameInformation().setTrajectoryReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)referenceFrames.getPelvisZUpFrame()));
        SO3TrajectoryPointMessage trajectoryPoint = (SO3TrajectoryPointMessage)so3Trajectory.getTaskspaceTrajectoryPoints().add();
        trajectoryPoint.setTime(0.2);
        trajectoryPoint.getOrientation().set(orientation);
        trajectoryPoint.getAngularVelocity().set(new Vector3D());
        trajectoryPoint = (SO3TrajectoryPointMessage)so3Trajectory.getTaskspaceTrajectoryPoints().add();
        trajectoryPoint.setTime(0.4);
        trajectoryPoint.getOrientation().set(new Quaternion());
        trajectoryPoint.getAngularVelocity().set(new Vector3D());
        return message;
    }

    public static ArmTrajectoryMessage createArmMessage(FullHumanoidRobotModel fullRobotModel, RobotSide side) {
        RigidBodyBasics chest = fullRobotModel.getChest();
        RigidBodyBasics hand = fullRobotModel.getHand(side);
        OneDoFJointBasics[] joints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)chest, (RigidBodyBasics)hand);
        ArmTrajectoryMessage message = HumanoidMessageTools.createArmTrajectoryMessage((RobotSide)side);
        for (int jointIdx = 0; jointIdx < joints.length; ++jointIdx) {
            OneDoFJointBasics joint = joints[jointIdx];
            double angle1 = MathTools.clamp((double)Math.toRadians(45.0), (double)(joint.getJointLimitLower() + 0.05), (double)(joint.getJointLimitUpper() - 0.05));
            double angle2 = MathTools.clamp((double)0.0, (double)(joint.getJointLimitLower() + 0.05), (double)(joint.getJointLimitUpper() - 0.05));
            OneDoFJointTrajectoryMessage jointTrajectoryMessage = (OneDoFJointTrajectoryMessage)message.getJointspaceTrajectory().getJointTrajectoryMessages().add();
            ((TrajectoryPoint1DMessage)jointTrajectoryMessage.getTrajectoryPoints().add()).set(HumanoidMessageTools.createTrajectoryPoint1DMessage((double)0.2, (double)angle1, (double)0.0));
            ((TrajectoryPoint1DMessage)jointTrajectoryMessage.getTrajectoryPoints().add()).set(HumanoidMessageTools.createTrajectoryPoint1DMessage((double)0.4, (double)angle2, (double)0.0));
        }
        return message;
    }
}

