/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.stepAdjustment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintListConverter;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintRegion;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.Cluster;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.ExtrusionHull;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.ObstacleExtrusionDistanceCalculator;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.ObstacleRegionFilter;
import us.ihmc.pathPlanning.visibilityGraphs.tools.ClusterTools;
import us.ihmc.robotics.RegionInWorldInterface;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2D;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DBasics;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DReadOnly;
import us.ihmc.robotics.geometry.concavePolygon2D.GeometryPolygonTools;
import us.ihmc.robotics.geometry.concavePolygon2D.clippingAndMerging.PolygonClippingAndMerging;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class SteppableRegionsCalculator {
    private static final double POPPING_MULTILINE_POINTS_THRESHOLD = MathTools.square((double)0.1);
    private static final double maxNormalAngleFromVertical = 0.4;
    private static final double minimumAreaToConsider = 0.01;
    private static final double defaultCanDuckUnderHeight = 2.0;
    private static final double defaultCanEasilyStepOverHeight = 0.03;
    private static final double defaultOrthogonalAngle = Math.toRadians(75.0);
    private static final double defaultMinimumDistanceFromCliffBottoms = 0.1;
    private static final Vector3D verticalAxis = new Vector3D(0.0, 0.0, 1.0);
    private final YoDouble maxAngleForSteppable;
    private final YoDouble minimumAreaForSteppable;
    private final YoDouble maximumStepReach;
    private final YoDouble canDuckUnderHeight;
    private final YoDouble canEasilyStepOverHeight;
    private final YoDouble orthogonalAngle;
    private final YoDouble minimumDistanceFromCliffBottoms;
    private final YoBoolean removeSteppableAreaCloseToObstacles;
    private HashMap<RegionInWorldInterface<?>, List<ConcavePolygon2DBasics>> obstacleExtrusionsMap = new HashMap();
    private List<StepConstraintRegion> steppableRegions = new ArrayList<StepConstraintRegion>();
    private List<PlanarRegion> allPlanarRegions = new ArrayList<PlanarRegion>();
    private List<PlanarRegion> tooSmallRegions = new ArrayList<PlanarRegion>();
    private List<PlanarRegion> tooSteepRegions = new ArrayList<PlanarRegion>();
    private List<PlanarRegion> maskedRegions = new ArrayList<PlanarRegion>();
    private HashMap<RegionInWorldInterface<?>, List<ConcavePolygon2DBasics>> maskedRegionsExtrusions = new HashMap();
    private final FramePoint2D stanceFootPosition = new FramePoint2D();
    private final Random random = new Random(1738L);
    private final ObstacleRegionFilter obstacleRegionFilter = new ObstacleRegionFilter(){

        public boolean isRegionValidObstacle(PlanarRegion potentialObstacleRegion, PlanarRegion navigableRegion) {
            boolean isCeiling;
            if (potentialObstacleRegion == navigableRegion) {
                return false;
            }
            if (!PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)potentialObstacleRegion, (PlanarRegion)navigableRegion, (double)SteppableRegionsCalculator.this.minimumDistanceFromCliffBottoms.getDoubleValue())) {
                return false;
            }
            boolean bl = isCeiling = potentialObstacleRegion.getBoundingBox3dInWorld().getMinZ() > navigableRegion.getBoundingBox3dInWorld().getMaxZ() + SteppableRegionsCalculator.this.canDuckUnderHeight.getDoubleValue();
            if (isCeiling) {
                return false;
            }
            return PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)potentialObstacleRegion, (PlanarRegion)navigableRegion, (double)SteppableRegionsCalculator.this.canEasilyStepOverHeight.getDoubleValue());
        }
    };
    private final ObstacleExtrusionDistanceCalculator obstacleExtrusionDistanceCalculator = new ObstacleExtrusionDistanceCalculator(){

        public double computeExtrusionDistance(Point2DReadOnly pointToExtrude, double obstacleHeight) {
            if (obstacleHeight < 0.0) {
                return 0.0;
            }
            if (obstacleHeight < SteppableRegionsCalculator.this.canEasilyStepOverHeight.getDoubleValue()) {
                double alpha = obstacleHeight / SteppableRegionsCalculator.this.canEasilyStepOverHeight.getDoubleValue();
                return InterpolationTools.linearInterpolate((double)0.0, (double)SteppableRegionsCalculator.this.minimumDistanceFromCliffBottoms.getDoubleValue(), (double)alpha);
            }
            return SteppableRegionsCalculator.this.minimumDistanceFromCliffBottoms.getDoubleValue();
        }
    };

    public SteppableRegionsCalculator(double maximumReach, YoRegistry registry) {
        this.maxAngleForSteppable = new YoDouble("maxAngleForSteppable", registry);
        this.minimumAreaForSteppable = new YoDouble("minimumAreaForSteppable", registry);
        this.maximumStepReach = new YoDouble("maximumStepReach", registry);
        this.canDuckUnderHeight = new YoDouble("canDuckUnderHeight", registry);
        this.canEasilyStepOverHeight = new YoDouble("canEasyStepOverHeight", registry);
        this.orthogonalAngle = new YoDouble("orthogonalAngle", registry);
        this.minimumDistanceFromCliffBottoms = new YoDouble("tooHighToStepDistance", registry);
        this.removeSteppableAreaCloseToObstacles = new YoBoolean("removeSteppableAreaCloseToObstacles", registry);
        this.removeSteppableAreaCloseToObstacles.set(false);
        this.maxAngleForSteppable.set(0.4);
        this.minimumAreaForSteppable.set(0.01);
        this.maximumStepReach.set(maximumReach);
        this.canDuckUnderHeight.set(2.0);
        this.canEasilyStepOverHeight.set(0.03);
        this.orthogonalAngle.set(defaultOrthogonalAngle);
        this.minimumDistanceFromCliffBottoms.set(0.1);
    }

    public void setPlanarRegions(List<PlanarRegion> planarRegions) {
        this.allPlanarRegions = planarRegions;
    }

    public void setStanceFootPosition(FramePoint3DReadOnly stanceFootPosition) {
        this.stanceFootPosition.set((FrameTuple3DReadOnly)stanceFootPosition);
    }

    public void setCanEasilyStepOverHeight(double canEasilyStepOverHeight) {
        this.canEasilyStepOverHeight.set(canEasilyStepOverHeight);
    }

    public void setMinimumDistanceFromCliffBottoms(double minimumDistanceFromCliffBottoms) {
        this.minimumDistanceFromCliffBottoms.set(minimumDistanceFromCliffBottoms);
    }

    public void setOrthogonalAngle(double orthogonalAngle) {
        this.orthogonalAngle.set(orthogonalAngle);
    }

    public void setRemoveSteppableAreaCloseToObstacles(boolean removeSteppableAreaCloseToObstacles) {
        this.removeSteppableAreaCloseToObstacles.set(removeSteppableAreaCloseToObstacles);
    }

    public List<StepConstraintRegion> computeSteppableRegions() {
        this.tooSmallRegions = new ArrayList<PlanarRegion>();
        this.tooSteepRegions = new ArrayList<PlanarRegion>();
        this.maskedRegions = new ArrayList<PlanarRegion>();
        List candidateRegions = this.allPlanarRegions.stream().filter(this::isRegionValidForStepping).collect(Collectors.toList());
        this.obstacleExtrusionsMap = new HashMap();
        this.maskedRegionsExtrusions = new HashMap();
        if (this.removeSteppableAreaCloseToObstacles.getBooleanValue()) {
            this.steppableRegions = new ArrayList<StepConstraintRegion>();
            for (PlanarRegion candidateRegion : candidateRegions) {
                List<StepConstraintRegion> regions = this.createSteppableRegionsFromPlanarRegion(candidateRegion, this.allPlanarRegions);
                if (regions == null) continue;
                for (StepConstraintRegion region : regions) {
                    if (candidateRegion.getRegionId() != -1) {
                        region.setRegionId(candidateRegion.getRegionId());
                    }
                    this.steppableRegions.add(region);
                }
            }
            for (StepConstraintRegion stepConstraintRegion : this.steppableRegions) {
                if (stepConstraintRegion.getRegionId() != -1) continue;
                stepConstraintRegion.setRegionId(this.random.nextInt());
            }
        } else {
            this.steppableRegions = StepConstraintListConverter.convertPlanarRegionListToStepConstraintRegion(candidateRegions);
        }
        return this.steppableRegions;
    }

    public HashMap<RegionInWorldInterface<?>, List<ConcavePolygon2DBasics>> getObstacleExtrusions() {
        return this.obstacleExtrusionsMap;
    }

    public List<PlanarRegion> getTooSmallRegions() {
        return this.tooSmallRegions;
    }

    public List<PlanarRegion> getTooSteepRegions() {
        return this.tooSteepRegions;
    }

    public List<PlanarRegion> getMaskedRegions() {
        return this.maskedRegions;
    }

    public HashMap<RegionInWorldInterface<?>, List<ConcavePolygon2DBasics>> getMaskedRegionsObstacleExtrusions() {
        return this.maskedRegionsExtrusions;
    }

    private boolean isRegionValidForStepping(PlanarRegion planarRegion) {
        double angle = planarRegion.getNormal().angle((Vector3DReadOnly)verticalAxis);
        if (angle > this.maxAngleForSteppable.getValue()) {
            this.tooSteepRegions.add(planarRegion);
            return false;
        }
        if (PlanarRegionTools.computePlanarRegionArea((PlanarRegion)planarRegion) < this.minimumAreaForSteppable.getValue()) {
            this.tooSmallRegions.add(planarRegion);
            return false;
        }
        if (this.stanceFootPosition.containsNaN()) {
            return true;
        }
        return SteppableRegionsCalculator.isRegionWithinReach((Point2DReadOnly)this.stanceFootPosition, this.maximumStepReach.getDoubleValue(), planarRegion);
    }

    private static boolean isRegionWithinReach(Point2DReadOnly point, double reach, PlanarRegion planarRegion) {
        Point2D pointInRegion = new Point2D((Tuple2DReadOnly)point);
        planarRegion.getTransformToLocal().transform((Point2DBasics)pointInRegion, false);
        if (planarRegion.getConvexHull().distance((Point2DReadOnly)pointInRegion) > reach) {
            return false;
        }
        boolean closeEnough = false;
        for (ConvexPolygon2DReadOnly convexPolygon : planarRegion.getConvexPolygons()) {
            if (!(convexPolygon.distance((Point2DReadOnly)pointInRegion) < reach)) continue;
            closeEnough = true;
            break;
        }
        return closeEnough;
    }

    private List<StepConstraintRegion> createSteppableRegionsFromPlanarRegion(PlanarRegion candidateRegion, List<PlanarRegion> allOtherRegions) {
        List<StepConstraintRegion> stepConstraintRegions;
        if (this.removeSteppableAreaCloseToObstacles.getBooleanValue()) {
            List<PlanarRegion> obstacleRegions = allOtherRegions.stream().filter(candidate -> this.obstacleRegionFilter.isRegionValidObstacle(candidate, candidateRegion)).collect(Collectors.toList());
            List<ConcavePolygon2DBasics> obstacleExtrusions = this.createObstacleExtrusions(candidateRegion, obstacleRegions);
            ConcavePolygon2D candidateConstraintRegion = new ConcavePolygon2D();
            candidateConstraintRegion.addVertices(Vertex2DSupplier.asVertex2DSupplier((List)candidateRegion.getConcaveHull()));
            candidateConstraintRegion.update();
            if (obstacleExtrusions.stream().anyMatch(region -> SteppableRegionsCalculator.isRegionMasked((ConcavePolygon2DBasics)candidateConstraintRegion, (ConcavePolygon2DReadOnly)region))) {
                this.maskedRegions.add(candidateRegion);
                this.maskedRegionsExtrusions.put((RegionInWorldInterface<?>)candidateRegion, obstacleExtrusions);
                return null;
            }
            stepConstraintRegions = this.createSteppableRegionsByRemovingAreaThatsTooCloseToObstacles(candidateRegion.getTransformToWorld(), (ConcavePolygon2DBasics)candidateConstraintRegion, obstacleExtrusions);
            for (StepConstraintRegion stepConstraintRegion : stepConstraintRegions) {
                this.obstacleExtrusionsMap.put((RegionInWorldInterface<?>)stepConstraintRegion, obstacleExtrusions);
            }
        } else {
            stepConstraintRegions = new ArrayList<StepConstraintRegion>();
            stepConstraintRegions.add(StepConstraintListConverter.convertPlanarRegionToStepConstraintRegion((PlanarRegion)candidateRegion));
        }
        return stepConstraintRegions;
    }

    private List<StepConstraintRegion> createSteppableRegionsByRemovingAreaThatsTooCloseToObstacles(RigidBodyTransformReadOnly transformToWorld, ConcavePolygon2DBasics uncroppedPolygon, List<ConcavePolygon2DBasics> obstacleExtrusions) {
        ArrayList<ConcavePolygon2DBasics> obstacleExtrusionCopy = new ArrayList<ConcavePolygon2DBasics>(obstacleExtrusions);
        ArrayList<ConcavePolygon2DBasics> croppedPolygons = new ArrayList<ConcavePolygon2DBasics>();
        croppedPolygons.add(uncroppedPolygon);
        int i = 0;
        while (i < obstacleExtrusionCopy.size()) {
            if (this.applyExtrusionClip((ConcavePolygon2DReadOnly)obstacleExtrusionCopy.get(i), croppedPolygons)) {
                obstacleExtrusionCopy.remove(i);
                i = 0;
                continue;
            }
            ++i;
        }
        List listOfHoles = obstacleExtrusionCopy.stream().filter(region -> GeometryPolygonTools.isPolygonInsideOtherPolygon((Vertex2DSupplier)region, (ConcavePolygon2DReadOnly)uncroppedPolygon)).collect(Collectors.toList());
        ArrayList<StepConstraintRegion> constraintRegions = new ArrayList<StepConstraintRegion>();
        for (ConcavePolygon2DBasics croppedPolygon : croppedPolygons) {
            ArrayList<ConcavePolygon2DBasics> holesInRegion = new ArrayList<ConcavePolygon2DBasics>();
            i = 0;
            while (i < listOfHoles.size()) {
                ConcavePolygon2DBasics holeCandidate = (ConcavePolygon2DBasics)listOfHoles.get(i);
                if (SteppableRegionsCalculator.isObstacleAHole(croppedPolygon, (ConcavePolygon2DReadOnly)holeCandidate)) {
                    holesInRegion.add(holeCandidate);
                    listOfHoles.remove(i);
                    continue;
                }
                ++i;
            }
            constraintRegions.add(new StepConstraintRegion(transformToWorld, (Vertex2DSupplier)croppedPolygon, holesInRegion));
        }
        return constraintRegions;
    }

    private boolean applyExtrusionClip(ConcavePolygon2DReadOnly clippingPolygon, List<ConcavePolygon2DBasics> polygonsToModify) {
        boolean doesNotIntersect = polygonsToModify.stream().noneMatch(region -> GeometryPolygonTools.doPolygonsIntersect((ConcavePolygon2DReadOnly)clippingPolygon, (ConcavePolygon2DReadOnly)region));
        if (doesNotIntersect) {
            return polygonsToModify.stream().noneMatch(region -> GeometryPolygonTools.isPolygonInsideOtherPolygon((Vertex2DSupplier)clippingPolygon, (ConcavePolygon2DReadOnly)region));
        }
        ArrayList clippedPolygons = new ArrayList();
        for (ConcavePolygon2DBasics polygonToClip : polygonsToModify) {
            clippedPolygons.addAll(PolygonClippingAndMerging.removeAreaInsideClip((ConcavePolygon2DReadOnly)clippingPolygon, (ConcavePolygon2DReadOnly)polygonToClip));
        }
        polygonsToModify.clear();
        polygonsToModify.addAll(clippedPolygons);
        return true;
    }

    private static boolean isObstacleAHole(ConcavePolygon2DBasics constraintArea, ConcavePolygon2DReadOnly obstacleConcaveHull) {
        return GeometryPolygonTools.isPolygonInsideOtherPolygon((Vertex2DSupplier)obstacleConcaveHull, (ConcavePolygon2DReadOnly)constraintArea);
    }

    private static boolean isRegionMasked(ConcavePolygon2DBasics region, ConcavePolygon2DReadOnly candidateMask) {
        return GeometryPolygonTools.isPolygonInsideOtherPolygon((Vertex2DSupplier)region, (ConcavePolygon2DReadOnly)candidateMask);
    }

    private List<ConcavePolygon2DBasics> createObstacleExtrusions(PlanarRegion candidateRegion, List<PlanarRegion> obstacleRegions) {
        double zThresholdBeforeOrthogonal = Math.cos(this.orthogonalAngle.getDoubleValue());
        List<ConcavePolygon2DBasics> obstacleExtrusions = obstacleRegions.stream().map(region -> SteppableRegionsCalculator.extrudePlanarRegionToCreateObstacleExtrusion(candidateRegion, region, this.obstacleExtrusionDistanceCalculator, zThresholdBeforeOrthogonal)).collect(Collectors.toList());
        PolygonClippingAndMerging.removeHolesFromList(obstacleExtrusions);
        return obstacleExtrusions;
    }

    static ConcavePolygon2D extrudePlanarRegionToCreateObstacleExtrusion(PlanarRegion homeRegion, PlanarRegion obstacleRegion, ObstacleExtrusionDistanceCalculator extrusionDistanceCalculator, double zThresholdBeforeOrthogonal) {
        Cluster.ClusterType obstacleClusterType;
        UnitVector3DReadOnly obstacleNormal;
        List concaveHull = obstacleRegion.getConcaveHull();
        RigidBodyTransformReadOnly transformFromObstacleToWorld = obstacleRegion.getTransformToWorld();
        List obstacleClustersInWorld = new ArrayList();
        ClusterTools.calculatePointsInWorldAtRegionHeight((List)concaveHull, (RigidBodyTransformReadOnly)transformFromObstacleToWorld, (PlanarRegion)homeRegion, null, obstacleClustersInWorld);
        if (!GeometryPolygonTools.isClockwiseOrdered3DZUp(obstacleClustersInWorld, (int)obstacleClustersInWorld.size())) {
            Collections.reverse(obstacleClustersInWorld);
        }
        boolean isObstacleWall = Math.abs((obstacleNormal = obstacleRegion.getNormal()).getZ()) < zThresholdBeforeOrthogonal;
        Cluster.ClusterType clusterType = obstacleClusterType = isObstacleWall ? Cluster.ClusterType.MULTI_LINE : Cluster.ClusterType.POLYGON;
        if (isObstacleWall) {
            obstacleClustersInWorld = ClusterTools.filterVerticalPolygonForMultiLineExtrusion(obstacleClustersInWorld, (double)POPPING_MULTILINE_POINTS_THRESHOLD);
        }
        List extrusionInFlatWorld = ClusterTools.computeObstacleNavigableExtrusionsInLocal((Cluster.ClusterType)obstacleClusterType, obstacleClustersInWorld, (ObstacleExtrusionDistanceCalculator)extrusionDistanceCalculator, (boolean)true);
        RigidBodyTransformReadOnly transformFromWorldToHome = homeRegion.getTransformToLocal();
        ExtrusionHull extrusionsInHomeRegion = ClusterTools.projectPointsVerticallyToPlanarRegionLocal((PlanarRegion)homeRegion, (List)extrusionInFlatWorld, (RigidBodyTransformReadOnly)transformFromWorldToHome);
        SteppableRegionsCalculator.removeDuplicatedPoints(extrusionsInHomeRegion, 1.0E-5);
        return new ConcavePolygon2D(Vertex2DSupplier.asVertex2DSupplier((List)extrusionsInHomeRegion.getPoints()));
    }

    private static void removeDuplicatedPoints(ExtrusionHull hullToFilter, double distanceEpsilon) {
        double epsilonSquared = distanceEpsilon * distanceEpsilon;
        for (int i = 0; i < hullToFilter.getPoints().size(); ++i) {
            Point2DReadOnly point = hullToFilter.get(i);
            int j = i + 1;
            while (j < hullToFilter.getPoints().size()) {
                Point2DReadOnly otherPoint = hullToFilter.get(j);
                if (point.distanceSquared(otherPoint) < epsilonSquared) {
                    hullToFilter.getPoints().remove(j);
                    continue;
                }
                ++j;
            }
        }
    }
}

