/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.stepAdjustment;

import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import us.ihmc.avatar.stepAdjustment.PlanarRegionFootstepSnapper;
import us.ihmc.avatar.stepAdjustment.PlanarRegionSnapVisualizer;
import us.ihmc.avatar.stepAdjustment.SteppableRegionsProvider;
import us.ihmc.commonWalkingControlModules.configurations.SteppingEnvironmentalConstraintParameters;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepPlanAdjustment;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;

public class PlanarRegionFootstepPlanSnapper
implements FootstepPlanAdjustment {
    private final PlanarRegionFootstepSnapper snapper;
    private PlanarRegionSnapVisualizer planarRegionSnapVisualizer;
    private final FramePose2D unsnappedPose = new FramePose2D();
    private final FramePose3D snappedPose = new FramePose3D();

    public PlanarRegionFootstepPlanSnapper(SideDependentList<ConvexPolygon2D> footPolygons, SteppableRegionsProvider steppableRegionsProvider, SteppingEnvironmentalConstraintParameters constraintOptimizerParameters, YoRegistry parentRegistry) {
        this.snapper = new PlanarRegionFootstepSnapper(footPolygons, steppableRegionsProvider, constraintOptimizerParameters, parentRegistry);
    }

    public void attachPlanarRegionSnapVisualizer(PlanarRegionSnapVisualizer planarRegionSnapperCallback) {
        this.planarRegionSnapVisualizer = planarRegionSnapperCallback;
        this.snapper.attachPlanarRegionSnapVisualizer(planarRegionSnapperCallback);
    }

    public void adjustFootstepPlan(FramePose3DReadOnly stanceFootPose, int footstepIndexToStart, FootstepDataListMessage footstepDataListMessageToAdjust) {
        for (int index = footstepIndexToStart; index < footstepDataListMessageToAdjust.getFootstepDataList().size(); ++index) {
            if (this.planarRegionSnapVisualizer != null) {
                this.planarRegionSnapVisualizer.setFootIndex(index);
            }
            FootstepDataMessage dataMessage = (FootstepDataMessage)footstepDataListMessageToAdjust.getFootstepDataList().get(index);
            this.unsnappedPose.getPosition().set((Tuple3DReadOnly)dataMessage.getLocation());
            this.unsnappedPose.getOrientation().set((Orientation3DReadOnly)dataMessage.getOrientation());
            RobotSide side = RobotSide.fromByte((byte)dataMessage.getRobotSide());
            this.snapper.adjustFootstep(stanceFootPose, (FramePose2DReadOnly)this.unsnappedPose, side, dataMessage);
        }
    }
}

