/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.simulationStarter;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import us.ihmc.avatar.simulationStarter.DRCSimulationTools;

public class SimulationSelectorStageController {
    private static final String STARTING_LOCATION_PROPERTY_NAME = "startingLocation";
    @FXML
    private Stage stage;
    @FXML
    private GridPane checkBoxesPane;
    @FXML
    private ComboBox<String> startingLocationComboBox;
    @FXML
    private Button okButton;
    @FXML
    private Button cancelButton;
    private final List<DRCSimulationTools.Modules> modulesToStart = new ArrayList<DRCSimulationTools.Modules>();

    public <T> T showAndWait(T ... possibleStartingLocations) {
        String configFile = System.getProperty("user.home") + "/.ihmc/drcSimulationDefaultOptions.config";
        Properties properties = new Properties();
        try {
            FileInputStream lastConfigInputStream = new FileInputStream(configFile);
            properties.load(lastConfigInputStream);
            lastConfigInputStream.close();
        }
        catch (IOException lastConfigInputStream) {
            // empty catch block
        }
        int nCols = 3;
        int row = 0;
        int col = 0;
        final EnumMap<DRCSimulationTools.Modules, CheckBox> moduleCheckBoxes = new EnumMap<DRCSimulationTools.Modules, CheckBox>(DRCSimulationTools.Modules.class);
        for (DRCSimulationTools.Modules module : DRCSimulationTools.Modules.values()) {
            boolean enabled = module.isAlwaysEnabled() ? true : Boolean.parseBoolean(properties.getProperty(module.getPropertyNameForEnable(), Boolean.toString(module.getDefaultValueForEnable())));
            boolean selected = Boolean.parseBoolean(properties.getProperty(module.getPropertyNameForSelected(), Boolean.toString(module.getDefaultValueForSelected())));
            CheckBox checkBox = new CheckBox(module.getName());
            checkBox.setSelected(selected);
            checkBox.setDisable(!enabled);
            this.checkBoxesPane.add((Node)checkBox, col, row);
            moduleCheckBoxes.put(module, checkBox);
            if (++col < nCols) continue;
            col = 0;
            ++row;
        }
        ChangeListener<Boolean> networkProcessorCheckBoxChangeListener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                boolean isNetworkProcessorSelected = ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.NETWORK_PROCESSOR)).isSelected();
                boolean isNetworkProcessorDisabled = ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.NETWORK_PROCESSOR)).isDisabled();
                ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.BEHAVIOR_MODULE)).setDisable(!isNetworkProcessorSelected || isNetworkProcessorDisabled);
                ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.SENSOR_MODULE)).setDisable(!isNetworkProcessorSelected || isNetworkProcessorDisabled);
                ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.ZERO_POSE_PRODUCER)).setDisable(!isNetworkProcessorSelected || isNetworkProcessorDisabled);
                ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.ROS_MODULE)).setDisable(!isNetworkProcessorSelected || isNetworkProcessorDisabled);
                ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.REA_MODULE)).setDisable(!isNetworkProcessorSelected || isNetworkProcessorDisabled);
                ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.REA_UI)).setDisable(!isNetworkProcessorSelected || isNetworkProcessorDisabled);
                ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.DIRECTIONAL_CONTROL_TOOLBOX)).setDisable(!isNetworkProcessorSelected || isNetworkProcessorDisabled);
            }
        };
        ChangeListener<Boolean> simulationCheckBoxChangeListener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                boolean isSimulationSelected = ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.SIMULATION)).isSelected();
                ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.NETWORK_PROCESSOR)).setDisable(!isSimulationSelected);
            }
        };
        ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.NETWORK_PROCESSOR)).selectedProperty().addListener((ChangeListener)networkProcessorCheckBoxChangeListener);
        ((CheckBox)moduleCheckBoxes.get((Object)DRCSimulationTools.Modules.SIMULATION)).selectedProperty().addListener((ChangeListener)simulationCheckBoxChangeListener);
        simulationCheckBoxChangeListener.changed(null, null, null);
        networkProcessorCheckBoxChangeListener.changed(null, null, null);
        HashMap<String, T> possibleStartingLocationMap = new HashMap<String, T>();
        if (possibleStartingLocations != null && possibleStartingLocations.length > 0) {
            DRCSimulationTools.Modules[] comboBoxItems = FXCollections.observableArrayList();
            T[] TArray = possibleStartingLocations;
            int n = TArray.length;
            for (int checkBox = 0; checkBox < n; ++checkBox) {
                T possibleStartingLocation = TArray[checkBox];
                possibleStartingLocationMap.put(possibleStartingLocation.toString(), possibleStartingLocation);
                comboBoxItems.add((Object)possibleStartingLocation.toString());
            }
            this.startingLocationComboBox.setItems((ObservableList)comboBoxItems);
            this.startingLocationComboBox.getSelectionModel().select((Object)properties.getProperty(STARTING_LOCATION_PROPERTY_NAME, possibleStartingLocations[0].toString()));
        } else {
            this.startingLocationComboBox.setDisable(true);
        }
        this.stage.getIcons().add((Object)new Image(DRCSimulationTools.class.getClassLoader().getResourceAsStream("running-man-32x32-Launch.png")));
        this.okButton.setOnAction(e -> this.stage.close());
        this.cancelButton.setOnAction(e -> System.exit(-1));
        this.stage.addEventFilter(KeyEvent.KEY_RELEASED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.cancelButton.fire();
            } else if (e.getCode() == KeyCode.ENTER) {
                this.okButton.fire();
            }
        });
        this.stage.sizeToScene();
        this.stage.showAndWait();
        properties = new Properties();
        for (DRCSimulationTools.Modules module : DRCSimulationTools.Modules.values()) {
            boolean enabled;
            boolean selected = ((CheckBox)moduleCheckBoxes.get((Object)module)).isSelected();
            boolean bl = enabled = !((CheckBox)moduleCheckBoxes.get((Object)module)).isDisable();
            if (selected && enabled) {
                this.modulesToStart.add(module);
            }
            properties.setProperty(module.getPropertyNameForEnable(), String.valueOf(enabled));
            properties.setProperty(module.getPropertyNameForSelected(), String.valueOf(selected));
        }
        if (!this.startingLocationComboBox.isDisabled() && this.startingLocationComboBox.getSelectionModel().getSelectedItem() != null) {
            properties.setProperty(STARTING_LOCATION_PROPERTY_NAME, (String)this.startingLocationComboBox.getSelectionModel().getSelectedItem());
        }
        try {
            FileOutputStream newConfigOutputStream = new FileOutputStream(configFile);
            properties.store(newConfigOutputStream, "Default configuration for the graphic selector of the DRCSimulationTools");
            newConfigOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.startingLocationComboBox.isDisabled()) {
            return null;
        }
        return (T)possibleStartingLocationMap.get(this.startingLocationComboBox.getSelectionModel().getSelectedItem());
    }

    public List<DRCSimulationTools.Modules> getModulesToStart() {
        return this.modulesToStart;
    }
}

