/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.simulationStarter;

import boofcv.struct.calib.CameraPinholeBrown;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.DRCStartingLocation;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessor;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessorParameters;
import us.ihmc.avatar.scs2.SCS2AvatarSimulation;
import us.ihmc.avatar.scs2.SCS2AvatarSimulationFactory;
import us.ihmc.avatar.simulationStarter.DRCSimulationTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.net.LocalObjectCommunicator;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.LocalVideoPacket;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotDataVisualizer.logger.BehaviorVisualizer;
import us.ihmc.robotEnvironmentAwareness.LidarBasedREAStandaloneLauncher;
import us.ihmc.robotEnvironmentAwareness.RemoteLidarBasedREAUILauncher;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.sensors.SimCameraSensor;
import us.ihmc.sensorProcessing.parameters.AvatarRobotCameraParameters;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.tools.processManagement.JavaProcessSpawner;

public class AvatarSimulationToolsSCS2 {
    public static <T extends DRCStartingLocation, Enum> AvatarSimulationEnvironment setupSimulationEnvironmentWithGraphicSelector(DRCRobotModel robotModel, CommonAvatarEnvironmentInterface environment, Class<?> operatorInterfaceClass, String[] operatorInterfaceArgs, T ... possibleStartingLocations) {
        ArrayList<DRCSimulationTools.Modules> modulesToStart = new ArrayList<DRCSimulationTools.Modules>();
        DRCStartingLocation startingLocation = DRCSimulationTools.showSelectorWithStartingLocation(modulesToStart, possibleStartingLocations);
        return AvatarSimulationToolsSCS2.setupSimulationEnvironment(robotModel, environment, operatorInterfaceClass, operatorInterfaceArgs, startingLocation, modulesToStart);
    }

    public static <T extends DRCStartingLocation, Enum> AvatarSimulationEnvironment setupSimulationEnvironment(DRCRobotModel robotModel, CommonAvatarEnvironmentInterface environment, Class<?> operatorInterfaceClass, String[] operatorInterfaceArgs, DRCStartingLocation startingLocation, List<DRCSimulationTools.Modules> modulesToStart) {
        AvatarSimulationEnvironment avatarSimulationEnvironment = null;
        if (modulesToStart.isEmpty()) {
            return null;
        }
        if (modulesToStart.contains((Object)DRCSimulationTools.Modules.SIMULATION)) {
            avatarSimulationEnvironment = new AvatarSimulationEnvironment(robotModel);
            boolean automaticallyStartSimulation = true;
            avatarSimulationEnvironment.avatarSimulationFactory = new SCS2AvatarSimulationFactory();
            avatarSimulationEnvironment.avatarSimulationFactory.setRobotModel(robotModel);
            avatarSimulationEnvironment.avatarSimulationFactory.setRealtimeROS2Node(ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"ihmc_simulation"));
            avatarSimulationEnvironment.avatarSimulationFactory.setDefaultHighLevelHumanoidControllerFactory();
            avatarSimulationEnvironment.avatarSimulationFactory.setCommonAvatarEnvrionmentInterface(environment);
            avatarSimulationEnvironment.avatarSimulationFactory.setSimulationDataRecordTimePeriod(robotModel.getControllerDT());
            avatarSimulationEnvironment.avatarSimulationFactory.setStartingLocationOffset(startingLocation.getStartingLocationOffset());
            avatarSimulationEnvironment.avatarSimulationFactory.setAutomaticallyStartSimulation(automaticallyStartSimulation);
        }
        if (modulesToStart.contains((Object)DRCSimulationTools.Modules.NETWORK_PROCESSOR)) {
            if (avatarSimulationEnvironment == null) {
                avatarSimulationEnvironment = new AvatarSimulationEnvironment(robotModel);
            }
            avatarSimulationEnvironment.networkProcessorParameters = DRCSimulationTools.createNetworkProcessorParameters(modulesToStart);
        }
        if (modulesToStart.contains((Object)DRCSimulationTools.Modules.OPERATOR_INTERFACE)) {
            if (modulesToStart.contains((Object)DRCSimulationTools.Modules.SIMULATION)) {
                DRCSimulationTools.startOpertorInterfaceUsingProcessSpawner(operatorInterfaceClass, operatorInterfaceArgs);
            } else {
                DRCSimulationTools.startOpertorInterface(operatorInterfaceClass, operatorInterfaceArgs);
            }
        }
        if (modulesToStart.contains((Object)DRCSimulationTools.Modules.BEHAVIOR_VISUALIZER)) {
            JavaProcessSpawner spawner = new JavaProcessSpawner(true, true);
            spawner.spawn(BehaviorVisualizer.class);
        }
        boolean startREAModule = modulesToStart.contains((Object)DRCSimulationTools.Modules.REA_MODULE);
        boolean startREAUI = modulesToStart.contains((Object)DRCSimulationTools.Modules.REA_UI);
        if (startREAModule && startREAUI) {
            new JavaProcessSpawner(true, true).spawn(LidarBasedREAStandaloneLauncher.class);
        } else if (startREAUI) {
            new JavaProcessSpawner(true, true).spawn(RemoteLidarBasedREAUILauncher.class);
        }
        return avatarSimulationEnvironment;
    }

    public static class AvatarSimulationEnvironment {
        private final DRCRobotModel robotModel;
        private SCS2AvatarSimulationFactory avatarSimulationFactory;
        private HumanoidNetworkProcessorParameters networkProcessorParameters;
        private SCS2AvatarSimulation avatarSimulation;
        private HumanoidNetworkProcessor networkProcessor;

        public AvatarSimulationEnvironment(DRCRobotModel robotModel) {
            this.robotModel = robotModel;
        }

        public void build() {
            if (this.avatarSimulationFactory == null) {
                return;
            }
            this.avatarSimulation = this.avatarSimulationFactory.createAvatarSimulation();
            if (this.networkProcessorParameters != null) {
                if (this.networkProcessorParameters.isUseROSModule() || this.networkProcessorParameters.isUseSensorModule()) {
                    this.networkProcessorParameters.setSimulatedSensorCommunicator(this.createSimulatedSensorsPacketCommunicator());
                }
                this.networkProcessor = HumanoidNetworkProcessor.newFromParameters(this.robotModel, DomainFactory.PubSubImplementation.FAST_RTPS, this.networkProcessorParameters);
            }
        }

        private LocalObjectCommunicator createSimulatedSensorsPacketCommunicator() {
            LocalObjectCommunicator simulatedSensorCommunicator = new LocalObjectCommunicator();
            HumanoidRobotSensorInformation sensorInformation = this.robotModel.getSensorInformation();
            Robot robot = this.avatarSimulation.getRobot();
            AvatarRobotCameraParameters cameraParameters = sensorInformation.getCameraParameters(0);
            if (cameraParameters != null) {
                String cameraName = cameraParameters.getSensorNameInSdf();
                SimCameraSensor cameraSensor = robot.getAllJoints().stream().flatMap(joint -> joint.getAuxialiryData().getCameraSensors().stream()).filter(camera -> camera.getName().equals(cameraName)).findFirst().get();
                cameraSensor.setEnable(true);
                int width = cameraSensor.getImageWidth().getValue();
                int height = cameraSensor.getImageHeight().getValue();
                double fov = cameraSensor.getFieldOfView().getValue();
                double f = (double)(width / 2) / Math.tan(fov / 2.0);
                CameraPinholeBrown intrinsicParameters = new CameraPinholeBrown(f, f, 0.0, (double)((float)(width - 1) / 2.0f), (double)((float)(height - 1) / 2.0f), width, height);
                cameraSensor.addCameraFrameConsumer((timestamp, frame) -> {
                    LocalVideoPacket videoPacket = HumanoidMessageTools.createLocalVideoPacket((long)timestamp, (BufferedImage)frame, (CameraPinholeBrown)intrinsicParameters);
                    simulatedSensorCommunicator.consumeObject((Object)videoPacket);
                });
            }
            if (sensorInformation.getLidarParameters() != null) {
                // empty if block
            }
            return simulatedSensorCommunicator;
        }

        public void start() {
            if (this.avatarSimulation != null) {
                this.avatarSimulation.start();
            }
            if (this.networkProcessor != null) {
                this.networkProcessor.start();
                if (this.avatarSimulation.getSimulationConstructionSet() != null) {
                    this.avatarSimulation.getSimulationConstructionSet().addVisualizerShutdownListener(() -> this.networkProcessor.closeAndDispose());
                }
            }
        }

        public SCS2AvatarSimulationFactory getAvatarSimulationFactory() {
            return this.avatarSimulationFactory;
        }

        public SCS2AvatarSimulation getAvatarSimulation() {
            return this.avatarSimulation;
        }

        public HumanoidNetworkProcessor getNetworkProcessor() {
            return this.networkProcessor;
        }
    }
}

