/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.multisense;

import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.avatar.sensors.multisense.MultiSenseParamaterSetter;
import us.ihmc.communication.producers.CompressedVideoHandler;
import us.ihmc.communication.producers.VideoControlSettings;
import us.ihmc.log.LogTools;
import us.ihmc.perception.ros1.camera.CameraDataReceiver;
import us.ihmc.perception.ros1.camera.CameraLogger;
import us.ihmc.perception.ros1.camera.RosCameraCompressedImageReceiver;
import us.ihmc.perception.ros1.camera.VideoPacketHandler;
import us.ihmc.robotModels.FullRobotModelFactory;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataBuffer;
import us.ihmc.sensorProcessing.parameters.AvatarRobotCameraParameters;
import us.ihmc.sensorProcessing.parameters.AvatarRobotLidarParameters;
import us.ihmc.sensorProcessing.parameters.AvatarRobotPointCloudParameters;
import us.ihmc.utilities.ros.RosMainNode;

public class MultiSenseSensorManager {
    public static boolean LOG_PRIMARY_CAMERA_IMAGES = false;
    private final RosMainNode rosMainNode;
    private final ROS2NodeInterface ros2Node;
    private final AvatarRobotCameraParameters cameraParameters;
    private final AvatarRobotLidarParameters lidarParameters;
    private boolean setROSParameters;
    private CameraDataReceiver cameraReceiver;
    private MultiSenseParamaterSetter multiSenseParameterSetter;
    private RosCameraCompressedImageReceiver cameraImageReceiver;
    private VideoPacketHandler compressedVideoHandler;
    private boolean initializeParameterListenersRequested = false;

    public MultiSenseSensorManager(FullRobotModelFactory fullRobotModelFactory, RobotConfigurationDataBuffer robotConfigurationDataBuffer, RosMainNode rosMainNode, ROS2NodeInterface ros2Node, RobotROSClockCalculator rosClockCalculator, AvatarRobotCameraParameters cameraParameters, AvatarRobotLidarParameters lidarParameters, AvatarRobotPointCloudParameters stereoParameters, boolean setROSParameters) {
        this(fullRobotModelFactory, robotConfigurationDataBuffer, rosMainNode, ros2Node, ROS2QosProfile.DEFAULT(), rosClockCalculator, cameraParameters, lidarParameters, stereoParameters, setROSParameters);
    }

    public MultiSenseSensorManager(FullRobotModelFactory fullRobotModelFactory, RobotConfigurationDataBuffer robotConfigurationDataBuffer, RosMainNode rosMainNode, ROS2NodeInterface ros2Node, ROS2QosProfile qosProfile, RobotROSClockCalculator rosClockCalculator, AvatarRobotCameraParameters cameraParameters, AvatarRobotLidarParameters lidarParameters, AvatarRobotPointCloudParameters stereoParameters, boolean setROSParameters) {
        this.ros2Node = ros2Node;
        this.cameraParameters = cameraParameters;
        this.rosMainNode = rosMainNode;
        this.lidarParameters = lidarParameters;
        this.setROSParameters = setROSParameters;
        this.compressedVideoHandler = new VideoPacketHandler(ros2Node, qosProfile);
        this.cameraReceiver = new CameraDataReceiver(fullRobotModelFactory, cameraParameters.getPoseFrameForSdf(), robotConfigurationDataBuffer, (CompressedVideoHandler)this.compressedVideoHandler, rosClockCalculator::computeRobotMonotonicTime);
    }

    public void initializeParameterListeners() {
        if (this.multiSenseParameterSetter != null) {
            this.multiSenseParameterSetter.initializeParameterListeners();
            this.initializeParameterListenersRequested = false;
        } else {
            this.initializeParameterListenersRequested = true;
        }
    }

    private boolean setMultiseSenseParams(double lidarSpindleVelocity) {
        if (this.multiSenseParameterSetter != null) {
            this.multiSenseParameterSetter.setMultisenseResolution(this.rosMainNode);
            return this.multiSenseParameterSetter.setupNativeROSCommunicator(lidarSpindleVelocity);
        }
        return true;
    }

    public void start() {
        boolean rosOnline = false;
        while (!rosOnline) {
            CameraLogger logger = LOG_PRIMARY_CAMERA_IMAGES ? new CameraLogger("left") : null;
            this.cameraImageReceiver = new RosCameraCompressedImageReceiver(this.cameraParameters, this.rosMainNode, logger, this.cameraReceiver);
            if (this.setROSParameters) {
                this.multiSenseParameterSetter = new MultiSenseParamaterSetter(this.rosMainNode, this.ros2Node);
                rosOnline = this.setMultiseSenseParams(this.lidarParameters.getLidarSpindleVelocity());
            } else {
                this.multiSenseParameterSetter = null;
                rosOnline = true;
            }
            if (rosOnline && this.initializeParameterListenersRequested) {
                this.initializeParameterListeners();
            }
            try {
                if (rosOnline) continue;
                LogTools.info((String)"Wainting for ROS to come online.");
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.closeAndDispose();
                return;
            }
        }
        this.cameraReceiver.start();
    }

    public void setVideoSettings(VideoControlSettings settings) {
        this.cameraReceiver.setVideoSettings(settings);
    }

    public void closeAndDispose() {
        if (this.compressedVideoHandler != null) {
            this.compressedVideoHandler.closeAndDispose();
        }
        if (this.cameraReceiver != null) {
            this.cameraReceiver.closeAndDispose();
        }
        if (this.cameraImageReceiver != null) {
            this.cameraImageReceiver.closeAndDispose();
        }
    }
}

