/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.microphone;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JLabel;
import org.jtransforms.fft.DoubleFFT_1D;
import perception_msgs.msg.dds.DrillDetectionPacket;
import us.ihmc.avatar.sensors.microphone.AudioFFTPlotter;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.configuration.NetworkParameterKeys;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.Packet;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;

public class SoundDetector
implements Runnable {
    private static final float sampleRate = 44100.0f;
    private static final int sampleSizeInBits = 16;
    private static final int channels = 1;
    private static final boolean signed = true;
    private static final boolean bigEndian = false;
    private static final AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, false);
    private static final int bufferSizeDesired = 131072;
    private static final int checkForRotozipFrequencyHz = 2;
    private JLabel statusIndicator = null;
    private final ArrayList<Double[]> peakCriteriaArrayList = new ArrayList();
    private static final String COMMA_DELIMITER = ",";
    private static final String NEW_LINE_SEPARATOR = "\n";
    public static AudioInputStream audioInputStream = null;
    Thread thread = null;
    TargetDataLine line = null;
    String errStr;
    double duration;
    double seconds;
    private PacketCommunicator client = null;
    private boolean runningTheRealSchebang = false;

    public static void main(String[] args) {
        SoundDetector soundDetector = new SoundDetector();
        Thread processThread = new Thread(soundDetector);
        processThread.setName("main");
        processThread.start();
    }

    private void setDetectionParams() {
        this.peakCriteriaArrayList.add(new Double[]{420.0, 480.0, 250.0, 550.0, 9.0});
        this.peakCriteriaArrayList.add(new Double[]{5000.0, 6000.0, 4500.0, 6500.0, 7.0});
    }

    public SoundDetector(JLabel statusIndicator) {
        this.setDetectionParams();
        this.runningTheRealSchebang = false;
        this.statusIndicator = statusIndicator;
    }

    public SoundDetector() {
        this.setDetectionParams();
        this.runningTheRealSchebang = true;
        String networkManagerHost = NetworkParameters.getHost((NetworkParameterKeys)NetworkParameterKeys.networkManager);
        this.client = PacketCommunicator.createTCPPacketCommunicatorClient((String)networkManagerHost, (NetworkPorts)NetworkPorts.DRILL_DETECTOR, (NetClassList)new IHMCCommunicationKryoNetClassList());
        try {
            System.out.println(this.getClass().getSimpleName() + ": Connecting to " + networkManagerHost);
            this.client.connect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void shutDown(String errorMessage) {
        System.err.println(this.getClass().getSimpleName() + errorMessage);
        this.thread = null;
    }

    @Override
    public void run() {
        this.thread = new Thread("run");
        this.thread.start();
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        if (!AudioSystem.isLineSupported(info)) {
            this.shutDown(": Audio line not supported");
        }
        try {
            this.line = (TargetDataLine)AudioSystem.getLine(info);
            this.line.open(format, 131072);
        }
        catch (LineUnavailableException ex) {
            this.shutDown("Unable to open the line: " + ex);
            System.out.println("Mixers available:");
            for (Mixer.Info infos : AudioSystem.getMixerInfo()) {
                System.out.println(infos.toString());
            }
            return;
        }
        catch (SecurityException ex) {
            this.shutDown(ex.toString());
            return;
        }
        catch (Exception ex) {
            this.shutDown(ex.toString());
            return;
        }
        this.line.start();
        int frameSizeInBytes = format.getFrameSize();
        int bufferLengthInFrames = 16384;
        int bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
        byte[] data = new byte[bufferLengthInBytes];
        while (this.thread != null) {
            if (this.runningTheRealSchebang && !this.client.isConnected()) {
                System.out.println("SoundDetector not connected to NP!");
                continue;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int numBytesRead = this.line.read(data, 0, bufferLengthInBytes);
            if (numBytesRead == -1) break;
            out.write(data, 0, numBytesRead);
            try {
                out.flush();
            }
            catch (IOException e) {
                this.shutDown("ByteArrayOutputStream.flush IOException");
            }
            byte[] audioBytes = out.toByteArray();
            if (this.runningTheRealSchebang) {
                DrillDetectionPacket drillDetectionPacket = new DrillDetectionPacket();
                drillDetectionPacket.setIsDrillOn(this.detectDrillFrequency(audioBytes));
                if (drillDetectionPacket.getIsDrillOn()) {
                    System.out.println("isDrillOn = true");
                }
                this.client.send((Packet)drillDetectionPacket);
            } else if (this.detectDrillFrequency(audioBytes) & this.statusIndicator != null) {
                this.statusIndicator.setText("ROTOZIP DETECTED!!!");
            } else if (this.statusIndicator != null) {
                this.statusIndicator.setText("Listening...");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException drillDetectionPacket) {
                // empty catch block
            }
            try {
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.line.stop();
        this.line.close();
        this.line = null;
    }

    private boolean detectDrillFrequency(byte[] audioBytes) {
        boolean isDrillOn = false;
        boolean arePeaksThere = false;
        FileWriter fileWriter = null;
        FileWriter fileWriterBode = null;
        if (audioBytes != null) {
            int[] audioData = null;
            if (format.getSampleSizeInBits() == 16) {
                int nlengthInSamples = audioBytes.length / 2;
                audioData = new int[nlengthInSamples];
                for (int i = 0; i < nlengthInSamples; ++i) {
                    int LSB = audioBytes[2 * i];
                    int MSB = audioBytes[2 * i + 1];
                    audioData[i] = MSB << 8 | 0xFF & LSB;
                }
                if (!this.runningTheRealSchebang) {
                    try {
                        fileWriter = new FileWriter("buffercsv.csv");
                        for (int intToWrite : audioData) {
                            fileWriter.append(intToWrite + COMMA_DELIMITER);
                            fileWriter.append(NEW_LINE_SEPARATOR);
                        }
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                double[] input = new double[audioData.length];
                double[] time = new double[audioData.length];
                int i = 0;
                for (int intToCast : audioData) {
                    input[i] = intToCast;
                    time[i] = (float)(i * 1) / format.getSampleRate();
                    ++i;
                }
                double[][] fftData = SoundDetector.computeFreqMagPhase(time, input);
                double[] frequency = fftData[0];
                double[] magnitude = new double[fftData[1].length];
                for (int j = 0; j < fftData[1].length; ++j) {
                    magnitude[j] = Conversions.amplitudeToDecibels((double)fftData[1][j]);
                }
                if (!this.runningTheRealSchebang) {
                    try {
                        fileWriterBode = new FileWriter("freq_mag.csv");
                        for (int i1 = 0; i1 < frequency.length; ++i1) {
                            fileWriterBode.append(frequency[i1] + ", " + magnitude[i1] + COMMA_DELIMITER);
                            fileWriterBode.append(NEW_LINE_SEPARATOR);
                        }
                        fileWriterBode.flush();
                        fileWriterBode.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    AudioFFTPlotter plot = new AudioFFTPlotter(frequency, magnitude, "Magnitude Plot", "(Hz)", "(dB)");
                    plot.packAndDisplayFrame(0, 0);
                }
                for (Double[] peakCriteria : this.peakCriteriaArrayList) {
                    if (!this.scanBandForPeak(frequency, magnitude, peakCriteria)) {
                        arePeaksThere = false;
                        isDrillOn = false;
                        break;
                    }
                    arePeaksThere = true;
                    isDrillOn = true;
                }
                isDrillOn = this.isFourHundredPeakLoudEnough(frequency, magnitude, this.peakCriteriaArrayList) & arePeaksThere;
            }
        }
        return isDrillOn;
    }

    public static double[][] computeFreqMagPhase(double[] time, double[] data) {
        int n = time.length;
        if (data.length != n) {
            throw new RuntimeException("input.length != n");
        }
        DoubleFFT_1D fft = new DoubleFFT_1D((long)n);
        double T = time[n - 1] - time[0];
        double[] fftInput = SoundDetector.copyDoubleArray(data);
        fft.realForward(fftInput);
        double[] magnitude = SoundDetector.extractMagnitude(fftInput);
        double[] phase = SoundDetector.extractPhaseRadians(fftInput);
        double[] frequency = new double[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            frequency[i] = (double)i / T;
        }
        return new double[][]{frequency, magnitude, phase};
    }

    private static double[] copyDoubleArray(double[] in) {
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i];
        }
        return ret;
    }

    private static double[] extractMagnitude(double[] fftInput) {
        int n = fftInput.length;
        double[] magnitude = new double[n / 2];
        for (int k = 0; k < n / 2; ++k) {
            double mag;
            double real = fftInput[2 * k];
            double imag = fftInput[2 * k + 1];
            if (k == 0) {
                imag = 0.0;
            }
            magnitude[k] = mag = Math.sqrt(real * real + imag * imag);
        }
        return magnitude;
    }

    private static double[] extractPhaseRadians(double[] fftInput) {
        int n = fftInput.length;
        double[] phase = new double[n / 2];
        for (int k = 0; k < n / 2; ++k) {
            double real = fftInput[2 * k];
            double imag = fftInput[2 * k + 1];
            if (k == 0) {
                imag = 0.0;
            }
            phase[k] = Math.atan2(imag, real);
        }
        return phase;
    }

    private boolean isFourHundredPeakLoudEnough(double[] frequency, double[] magnitude, ArrayList<Double[]> peakCriteriaArrayList) {
        int index;
        boolean peakLoudEnough = false;
        double peakFourThirty = -100.0;
        double lowerBoundFreq = peakCriteriaArrayList.get(0)[0];
        double upperBoundFreq = peakCriteriaArrayList.get(0)[1];
        int lowerBoundIndex = 0;
        int upperBoundIndex = 0;
        for (index = 0; index < frequency.length; ++index) {
            if (frequency[index] < lowerBoundFreq) {
                lowerBoundIndex = index;
            }
            if (!(frequency[index] < upperBoundFreq)) continue;
            upperBoundIndex = index;
        }
        for (index = lowerBoundIndex; index < upperBoundIndex; ++index) {
            peakFourThirty = magnitude[index] > peakFourThirty ? magnitude[index] : peakFourThirty;
        }
        if (peakFourThirty > 135.0) {
            peakLoudEnough = true;
        }
        return peakLoudEnough;
    }

    private boolean scanBandForPeak(double[] frequency, double[] magnitude, Double[] peakCriteria) {
        int index;
        boolean peakDetected = false;
        int peakIndexSpread = 4;
        int dominantFrequencyBandLowerBoundIndex = 0;
        int dominantFrequencyBandUpperBoundIndex = 0;
        int relevantFrequencyBandLowerBoundIndex = 0;
        int relevantFrequencyBandUpperBoundIndex = 0;
        double dominantBandLowerBound = peakCriteria[0];
        double dominantBandUpperBound = peakCriteria[1];
        double relevantBandLowerBound = peakCriteria[2];
        double relevantBandUpperBand = peakCriteria[3];
        double decibelsToTrip = peakCriteria[4];
        int index2 = 0;
        while (frequency[index2] < dominantBandLowerBound) {
            dominantFrequencyBandLowerBoundIndex = index2++;
        }
        index2 = 0;
        while (frequency[index2] < dominantBandUpperBound) {
            dominantFrequencyBandUpperBoundIndex = index2++;
        }
        index2 = 0;
        while (frequency[index2] < relevantBandLowerBound) {
            relevantFrequencyBandLowerBoundIndex = index2++;
        }
        index2 = 0;
        while (frequency[index2] < relevantBandUpperBand) {
            relevantFrequencyBandUpperBoundIndex = index2++;
        }
        double dominantBandPeakMag = 0.0;
        double relevantBandAverageMag = 0.0;
        int dominantBandPeakIndex = 0;
        for (index = dominantFrequencyBandLowerBoundIndex; index < dominantFrequencyBandUpperBoundIndex; ++index) {
            if (!(magnitude[index] > dominantBandPeakMag)) continue;
            dominantBandPeakMag = magnitude[index];
            dominantBandPeakIndex = index;
        }
        dominantFrequencyBandLowerBoundIndex = dominantBandPeakIndex - peakIndexSpread;
        dominantFrequencyBandUpperBoundIndex = dominantBandPeakIndex + peakIndexSpread;
        if (dominantFrequencyBandLowerBoundIndex <= relevantFrequencyBandLowerBoundIndex) {
            dominantFrequencyBandLowerBoundIndex = relevantFrequencyBandLowerBoundIndex + 1;
            System.out.println("WARNING: SoundDetector dominant band range may need to be extended lower for the " + dominantFrequencyBandLowerBoundIndex + " Hz peak detection.");
        }
        for (index = relevantFrequencyBandLowerBoundIndex; index < dominantFrequencyBandLowerBoundIndex; ++index) {
            relevantBandAverageMag += magnitude[index];
        }
        if (relevantFrequencyBandUpperBoundIndex <= dominantFrequencyBandUpperBoundIndex) {
            dominantFrequencyBandUpperBoundIndex = relevantFrequencyBandUpperBoundIndex - 1;
            System.out.println("WARNING: SoundDetector dominant band range may need to be extended higher for the " + dominantFrequencyBandUpperBoundIndex + " Hz peak detection.");
        }
        for (index = dominantFrequencyBandUpperBoundIndex; index < relevantFrequencyBandUpperBoundIndex; ++index) {
            relevantBandAverageMag += magnitude[index];
        }
        if (dominantBandPeakMag - (relevantBandAverageMag /= (double)(relevantFrequencyBandUpperBoundIndex - dominantFrequencyBandUpperBoundIndex + (dominantFrequencyBandLowerBoundIndex - relevantFrequencyBandLowerBoundIndex))) > decibelsToTrip) {
            peakDetected = true;
        }
        return peakDetected;
    }

    public void stop() {
        this.thread = null;
    }
}

