/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.microphone;

import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import us.ihmc.avatar.sensors.microphone.DrillDetectionAlgorithm;
import us.ihmc.avatar.sensors.microphone.DrillDetectionResult;
import us.ihmc.commons.thread.ThreadTools;

public abstract class DrillDetectionThread
extends Thread {
    private static final int reconnectPeriodSeconds = 30;
    private static final double checkForDrillFrequencyHz = 5.0;
    private static final int iterationsCount = 150;
    private static final long iterationSleep = 200L;
    private DrillDetectionAlgorithm algorithm = null;
    private boolean isRunning = false;

    public DrillDetectionThread(DrillDetectionAlgorithm algorithm) {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("admin", "unknownpw".toCharArray());
            }
        });
        this.isRunning = true;
        this.algorithm = algorithm;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void shutdown() {
        this.isRunning = false;
    }

    private InputStream connectToStream() {
        try {
            URL url = new URL("http://10.6.100.57:80/audio.cgi");
            return url.openStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void run() {
        System.out.println("Starting drill detection thread...");
        while (this.isRunning) {
            InputStream inputStream = this.connectToStream();
            if (inputStream == null) {
                ThreadTools.sleep((long)200L);
                continue;
            }
            System.out.println("Connected to the webcam. Opening the stream...");
            Clip clip = null;
            try {
                clip = AudioSystem.getClip();
                clip.open(AudioSystem.getAudioInputStream(inputStream));
                clip.start();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            for (int i = 0; i < 150; ++i) {
                ThreadTools.sleep((long)200L);
                DrillDetectionResult result = this.algorithm.isDrillOn(inputStream);
                if (result != null) {
                    this.onDrillDetectionResult(result);
                }
                if (!this.isRunning) break;
            }
            System.out.println("Closing the stream...");
            if (clip != null) {
                clip.stop();
                clip.close();
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Waiting for reconnect...");
        }
        System.out.println("Stopping drill detection thread...");
    }

    public abstract void onDrillDetectionResult(DrillDetectionResult var1);
}

