/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.microphone;

import us.ihmc.avatar.sensors.microphone.DrillDetectionAlgorithm;
import us.ihmc.avatar.sensors.microphone.DrillDetectionResult;
import us.ihmc.commons.Conversions;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.simulationconstructionset.gui.BodePlotConstructor;
import us.ihmc.yoVariables.registry.YoRegistry;

public class DrillDetectionAlgorithmOriginal
extends DrillDetectionAlgorithm {
    private static final double decibelsDeltaToTripDetection = -5.8;
    private static final double dominantFrequencyBandLowerBound = 6900.0;
    private static final double dominantFrequencyBandUpperBound = 7900.0;
    private static final double relevantFrequencyBandLowerBound = 1000.0;
    private static final double relevantFrequencyBandUpperBound = 4900.0;
    private YoRegistry registry = new YoRegistry("DrillRegistry");
    private AlphaFilteredYoVariable filteredRelevantMagnitude = new AlphaFilteredYoVariable("FilteredRelevantMagnitude", this.registry, 0.9);
    private AlphaFilteredYoVariable filteredDominantMagnitude = new AlphaFilteredYoVariable("FilteredDominantMagnitude", this.registry, 0.9);

    @Override
    public DrillDetectionResult isDrillOn(byte[] audioBytes, int size) {
        int index;
        int nlengthInSamples = size / 2;
        int[] audioData = new int[nlengthInSamples];
        for (int i = 0; i < nlengthInSamples; ++i) {
            byte LSB = audioBytes[2 * i];
            byte MSB = audioBytes[2 * i + 1];
            audioData[i] = MSB << 8 | LSB & 0xFF;
        }
        double[] input = new double[audioData.length];
        double[] time = new double[audioData.length];
        for (int i = 0; i < audioData.length; ++i) {
            input[i] = audioData[i];
            time[i] = (double)i / (double)this.getSampleRate();
        }
        double[][] fftData = BodePlotConstructor.computeFreqMagPhase((double[])time, (double[])input);
        double[] frequency = fftData[0];
        double[] magnitude = new double[fftData[1].length];
        for (int i = 0; i < fftData[1].length; ++i) {
            magnitude[i] = Conversions.amplitudeToDecibels((double)fftData[1][i]);
        }
        int dominantFrequencyBandLowerBoundIndex = 0;
        int dominantFrequencyBandUpperBoundIndex = 0;
        int relevantFrequencyBandLowerBoundIndex = 0;
        int relevantFrequencyBandUpperBoundIndex = 0;
        for (int index2 = 0; index2 < frequency.length; ++index2) {
            if (frequency[index2] <= 6900.0) {
                dominantFrequencyBandLowerBoundIndex = index2;
            }
            if (frequency[index2] <= 7900.0) {
                dominantFrequencyBandUpperBoundIndex = index2;
            }
            if (frequency[index2] <= 1000.0) {
                relevantFrequencyBandLowerBoundIndex = index2;
            }
            if (!(frequency[index2] <= 4900.0)) continue;
            relevantFrequencyBandUpperBoundIndex = index2;
        }
        double dominantBandAverageMag = 0.0;
        double relevantBandAverageMag = 0.0;
        int dominantRangeSize = dominantFrequencyBandUpperBoundIndex - dominantFrequencyBandLowerBoundIndex;
        int relevantRangeSize = relevantFrequencyBandUpperBoundIndex - relevantFrequencyBandLowerBoundIndex;
        for (index = 0; index < relevantRangeSize; ++index) {
            relevantBandAverageMag += magnitude[relevantFrequencyBandLowerBoundIndex + index];
        }
        this.filteredRelevantMagnitude.update(relevantBandAverageMag /= (double)relevantRangeSize);
        for (index = 0; index < dominantRangeSize; ++index) {
            dominantBandAverageMag += magnitude[dominantFrequencyBandLowerBoundIndex + index];
        }
        this.filteredDominantMagnitude.update(dominantBandAverageMag /= (double)dominantRangeSize);
        DrillDetectionResult result = new DrillDetectionResult();
        result.isOn = this.filteredDominantMagnitude.getDoubleValue() - this.filteredRelevantMagnitude.getDoubleValue() > -5.8;
        result.averageValues = new double[]{this.filteredRelevantMagnitude.getDoubleValue(), this.filteredDominantMagnitude.getDoubleValue()};
        result.bodeData = this.getBodeData(time, input);
        return result;
    }

    @Override
    public int getNumReturnedBands() {
        return 2;
    }
}

