/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scs2;

import java.util.concurrent.TimeUnit;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.algorithms.CenterOfMassCalculator;
import us.ihmc.mecano.algorithms.CentroidalMomentumCalculator;
import us.ihmc.mecano.spatial.interfaces.MomentumReadOnly;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameVector;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameVector2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.scs2.definition.controller.ControllerInput;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.session.YoFixedReferenceFrameUsingYawPitchRoll;
import us.ihmc.scs2.session.YoTimer;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SCS2StateEstimatorDebugVariables
implements Controller {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoTimer timer = new YoTimer(this.getClass().getSimpleName(), TimeUnit.MILLISECONDS, this.registry);
    private final CenterOfMassCalculator centerOfMassCalculator;
    private final YoFramePoint3D centerOfMassPosition;
    private final YoFrameVector3D centerOfMassVelocity;
    private final YoFrameVector3D centerOfMassAcceleration;
    private final YoFrameVector3D linearMomentum;
    private final YoFrameVector3D angularMomentum;
    private final YoFrameVector3D linearMomentumPrevious;
    private final YoFrameVector3D angularMomentumPrevious;
    private final YoFrameVector3D linearMomentumRate;
    private final YoFrameVector3D angularMomentumRate;
    private final YoFrameVector2D centroidalMomentPivot;
    private final YoDouble actualAccelerationFilterBreakFrequency;
    private final AlphaFilteredYoFrameVector centerOfMassAccelerationFiltered;
    private final AlphaFilteredYoFrameVector linearMomentumRateFiltered;
    private final AlphaFilteredYoFrameVector angularMomentumRateFiltered;
    private final AlphaFilteredYoFrameVector2d centroidalMomentPivotFiltered;
    private final AlphaFilteredYoFrameVector centerOfMassAccelerationFiltered2;
    private final AlphaFilteredYoFrameVector linearMomentumRateFiltered2;
    private final AlphaFilteredYoFrameVector angularMomentumRateFiltered2;
    private final AlphaFilteredYoFrameVector2d centroidalMomentPivotFiltered2;
    private final YoFixedReferenceFrameUsingYawPitchRoll centerOfMassFrame;
    private final CentroidalMomentumCalculator centroidalMomentumCalculator;
    private final double mass;
    private final double gravity;
    private final double dt;

    public SCS2StateEstimatorDebugVariables(ReferenceFrame inertialFrame, double gravity, double dt, ControllerInput controllerInput) {
        this.gravity = gravity;
        this.dt = dt;
        this.centerOfMassCalculator = new CenterOfMassCalculator(controllerInput.getInput().getRootBody(), inertialFrame);
        this.mass = this.centerOfMassCalculator.getTotalMass();
        this.centerOfMassFrame = new YoFixedReferenceFrameUsingYawPitchRoll("centerOfMassFrame", "actualCenterOfMass", inertialFrame, this.registry);
        this.centroidalMomentumCalculator = new CentroidalMomentumCalculator(controllerInput.getInput(), (ReferenceFrame)this.centerOfMassFrame);
        this.centerOfMassPosition = this.centerOfMassFrame.getOffset().getPosition();
        this.centerOfMassVelocity = new YoFrameVector3D("actualCenterOfMassVelocity", inertialFrame, this.registry);
        this.centerOfMassAcceleration = new YoFrameVector3D("actualCenterOfMassAcceleration", inertialFrame, this.registry);
        this.linearMomentum = new YoFrameVector3D("actualLinearMomentum", inertialFrame, this.registry);
        this.angularMomentum = new YoFrameVector3D("actualAngularMomentum", inertialFrame, this.registry);
        this.linearMomentumPrevious = new YoFrameVector3D("actualLinearMomentumPrevious", inertialFrame, this.registry);
        this.angularMomentumPrevious = new YoFrameVector3D("actualAngularMomentumPrevious", inertialFrame, this.registry);
        this.linearMomentumRate = new YoFrameVector3D("actualLinearMomentumRate", inertialFrame, this.registry);
        this.angularMomentumRate = new YoFrameVector3D("actualAngularMomentumRate", inertialFrame, this.registry);
        this.centroidalMomentPivot = new YoFrameVector2D("actualCMP", inertialFrame, this.registry);
        this.actualAccelerationFilterBreakFrequency = new YoDouble("actualAccelerationFilterBreakFrequency", this.registry);
        this.actualAccelerationFilterBreakFrequency.set(0.05 / dt);
        DoubleProvider alphaProvider = () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.actualAccelerationFilterBreakFrequency.getValue(), (double)dt);
        this.centerOfMassAccelerationFiltered = new AlphaFilteredYoFrameVector("actualCenterOfMassAccelerationFiltered", "", this.registry, alphaProvider, (FrameTuple3DReadOnly)this.centerOfMassAcceleration);
        this.linearMomentumRateFiltered = new AlphaFilteredYoFrameVector("actualLinearMomentumRateFiltered", "", this.registry, alphaProvider, (FrameTuple3DReadOnly)this.linearMomentumRate);
        this.angularMomentumRateFiltered = new AlphaFilteredYoFrameVector("actualAngularMomentumRateFiltered", "", this.registry, alphaProvider, (FrameTuple3DReadOnly)this.angularMomentumRate);
        this.centroidalMomentPivotFiltered = new AlphaFilteredYoFrameVector2d("actualCMPFiltered", "", this.registry, alphaProvider, (FrameTuple2DReadOnly)this.centroidalMomentPivot);
        this.centerOfMassAccelerationFiltered2 = new AlphaFilteredYoFrameVector("actualCenterOfMassAccelerationFiltered2", "", this.registry, alphaProvider, (FrameTuple3DReadOnly)this.centerOfMassAccelerationFiltered);
        this.linearMomentumRateFiltered2 = new AlphaFilteredYoFrameVector("actualLinearMomentumRateFiltered2", "", this.registry, alphaProvider, (FrameTuple3DReadOnly)this.linearMomentumRateFiltered);
        this.angularMomentumRateFiltered2 = new AlphaFilteredYoFrameVector("actualAngularMomentumRateFiltered2", "", this.registry, alphaProvider, (FrameTuple3DReadOnly)this.angularMomentumRateFiltered);
        this.centroidalMomentPivotFiltered2 = new AlphaFilteredYoFrameVector2d("actualCMPFiltered2", "", this.registry, alphaProvider, (FrameTuple2DReadOnly)this.centroidalMomentPivotFiltered);
    }

    public void doControl() {
        this.timer.start();
        this.centerOfMassCalculator.reset();
        this.centerOfMassPosition.set((FrameTuple3DReadOnly)this.centerOfMassCalculator.getCenterOfMass());
        this.centerOfMassFrame.update();
        this.centroidalMomentumCalculator.reset();
        this.linearMomentumPrevious.set((FrameTuple3DReadOnly)this.linearMomentum);
        this.angularMomentumPrevious.set((FrameTuple3DReadOnly)this.angularMomentum);
        MomentumReadOnly momentum = this.centroidalMomentumCalculator.getMomentum();
        this.linearMomentum.setMatchingFrame((FrameTuple3DReadOnly)momentum.getLinearPart());
        this.angularMomentum.setMatchingFrame((FrameTuple3DReadOnly)momentum.getAngularPart());
        this.centerOfMassVelocity.setAndScale(1.0 / this.mass, (FrameTuple3DReadOnly)this.linearMomentum);
        this.linearMomentumRate.sub((FrameTuple3DReadOnly)this.linearMomentum, (FrameTuple3DReadOnly)this.linearMomentumPrevious);
        this.linearMomentumRate.scale(1.0 / this.dt);
        this.angularMomentumRate.sub((FrameTuple3DReadOnly)this.angularMomentum, (FrameTuple3DReadOnly)this.angularMomentumPrevious);
        this.angularMomentumRate.scale(1.0 / this.dt);
        this.centerOfMassAcceleration.setAndScale(1.0 / this.mass, (FrameTuple3DReadOnly)this.linearMomentumRate);
        this.centerOfMassAccelerationFiltered.update();
        this.linearMomentumRateFiltered.update();
        this.angularMomentumRateFiltered.update();
        this.centerOfMassAccelerationFiltered2.update();
        this.linearMomentumRateFiltered2.update();
        this.angularMomentumRateFiltered2.update();
        this.centroidalMomentPivot.set((FrameTuple3DReadOnly)this.centerOfMassAcceleration);
        double z = this.centerOfMassPosition.getZ();
        double normalizedFz = -this.gravity + this.centerOfMassAcceleration.getZ();
        if (EuclidCoreTools.isZero((double)normalizedFz, (double)1.0E-6)) {
            this.centroidalMomentPivot.setToNaN();
            this.centroidalMomentPivotFiltered.setToNaN();
            this.centroidalMomentPivotFiltered.reset();
            this.centroidalMomentPivotFiltered2.setToNaN();
            this.centroidalMomentPivotFiltered2.reset();
        } else {
            this.centroidalMomentPivot.scale(-z / normalizedFz);
            this.centroidalMomentPivot.addX(this.centerOfMassPosition.getX());
            this.centroidalMomentPivot.addY(this.centerOfMassPosition.getY());
            this.centroidalMomentPivotFiltered.update();
            this.centroidalMomentPivotFiltered2.update();
        }
        this.timer.stop();
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }
}

