/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scs2;

import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotics.controllers.PIDController;
import us.ihmc.scs2.definition.controller.ControllerInput;
import us.ihmc.scs2.definition.controller.ControllerOutput;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SCS2PIDLidarTorqueController
implements Controller {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final PIDController lidarJointController = new PIDController("lidar", this.registry);
    private final YoDouble desiredLidarAngle = new YoDouble("desiredLidarAngle", this.registry);
    private final YoDouble desiredLidarVelocity = new YoDouble("desiredLidarVelocity", this.registry);
    private final double controlDT;
    private final OneDoFJointReadOnly lidarJointState;
    private final OneDoFJointStateBasics lidarJointOutput;

    public SCS2PIDLidarTorqueController(ControllerInput controllerInput, ControllerOutput controllerOutput, String jointName, double desiredSpindleSpeed, double controlDT) {
        this.controlDT = controlDT;
        this.lidarJointState = (OneDoFJointReadOnly)controllerInput.getInput().findJoint(jointName);
        this.lidarJointOutput = controllerOutput.getOneDoFJointOutput(this.lidarJointState);
        this.desiredLidarVelocity.set(desiredSpindleSpeed);
        this.lidarJointController.setProportionalGain(10.0);
        this.lidarJointController.setDerivativeGain(1.0);
    }

    public void doControl() {
        this.desiredLidarAngle.add(this.desiredLidarVelocity.getDoubleValue() * this.controlDT);
        double lidarJointTau = this.lidarJointController.compute(this.lidarJointState.getQ(), this.desiredLidarAngle.getDoubleValue(), this.lidarJointState.getQd(), this.desiredLidarVelocity.getDoubleValue(), this.controlDT);
        this.lidarJointOutput.setEffort(lidarJointTau);
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }
}

